/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.oracle.webservices.internal.api.message.ContentType;
import com.oracle.webservices.internal.impl.encoding.StreamDecoderImpl;
import com.oracle.webservices.internal.impl.internalspi.encoding.StreamDecoder;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.developer.SerializationFeature;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.RootOnlyCodec;
import com.sun.xml.internal.ws.encoding.StreamSOAP11Codec;
import com.sun.xml.internal.ws.encoding.StreamSOAP12Codec;
import com.sun.xml.internal.ws.message.AttachmentSetImpl;
import com.sun.xml.internal.ws.message.stream.StreamMessage;
import com.sun.xml.internal.ws.protocol.soap.VersionMismatchException;
import com.sun.xml.internal.ws.server.UnsupportedMediaException;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;

public abstract class StreamSOAPCodec
implements com.sun.xml.internal.ws.api.pipe.StreamSOAPCodec,
RootOnlyCodec {
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private final SOAPVersion soapVersion;
    protected final SerializationFeature serializationFeature;
    private final StreamDecoder streamDecoder;
    private static final String DECODED_MESSAGE_CHARSET = "decodedMessageCharset";

    StreamSOAPCodec(SOAPVersion sOAPVersion) {
        this(sOAPVersion, null);
    }

    StreamSOAPCodec(WSBinding wSBinding) {
        this(wSBinding.getSOAPVersion(), wSBinding.getFeature(SerializationFeature.class));
    }

    StreamSOAPCodec(WSFeatureList wSFeatureList) {
        this(WebServiceFeatureList.getSoapVersion(wSFeatureList), wSFeatureList.get(SerializationFeature.class));
    }

    private StreamSOAPCodec(SOAPVersion sOAPVersion, @Nullable SerializationFeature serializationFeature) {
        this.soapVersion = sOAPVersion;
        this.serializationFeature = serializationFeature;
        this.streamDecoder = this.selectStreamDecoder();
    }

    private StreamDecoder selectStreamDecoder() {
        Iterator<StreamDecoder> iterator = ServiceFinder.find(StreamDecoder.class).iterator();
        if (iterator.hasNext()) {
            StreamDecoder streamDecoder = iterator.next();
            return streamDecoder;
        }
        return new StreamDecoderImpl();
    }

    @Override
    public com.sun.xml.internal.ws.api.pipe.ContentType getStaticContentType(Packet packet) {
        return this.getContentType(packet);
    }

    @Override
    public com.sun.xml.internal.ws.api.pipe.ContentType encode(Packet packet, OutputStream outputStream) {
        if (packet.getMessage() != null) {
            String string = this.getPacketEncoding(packet);
            packet.invocationProperties.remove(DECODED_MESSAGE_CHARSET);
            XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.create(outputStream, string);
            try {
                packet.getMessage().writeTo(xMLStreamWriter);
                xMLStreamWriter.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
            XMLStreamWriterFactory.recycle(xMLStreamWriter);
        }
        return this.getContentType(packet);
    }

    protected abstract com.sun.xml.internal.ws.api.pipe.ContentType getContentType(Packet var1);

    protected abstract String getDefaultContentType();

    @Override
    public com.sun.xml.internal.ws.api.pipe.ContentType encode(Packet packet, WritableByteChannel writableByteChannel) {
        throw new UnsupportedOperationException();
    }

    protected abstract List<String> getExpectedContentTypes();

    @Override
    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        this.decode(inputStream, string, packet, (AttachmentSet)new AttachmentSetImpl());
    }

    private static boolean isContentTypeSupported(String string, List<String> list) {
        for (String string2 : list) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public final Message decode(@NotNull XMLStreamReader xMLStreamReader) {
        return this.decode(xMLStreamReader, new AttachmentSetImpl());
    }

    @Override
    public final Message decode(XMLStreamReader xMLStreamReader, @NotNull AttachmentSet attachmentSet) {
        return StreamSOAPCodec.decode(this.soapVersion, xMLStreamReader, attachmentSet);
    }

    public static final Message decode(SOAPVersion sOAPVersion, XMLStreamReader xMLStreamReader, @NotNull AttachmentSet attachmentSet) {
        if (xMLStreamReader.getEventType() != 1) {
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        if (SOAP_ENVELOPE.equals(xMLStreamReader.getLocalName()) && !sOAPVersion.nsUri.equals(xMLStreamReader.getNamespaceURI())) {
            throw new VersionMismatchException(sOAPVersion, sOAPVersion.nsUri, xMLStreamReader.getNamespaceURI());
        }
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, sOAPVersion.nsUri, SOAP_ENVELOPE);
        return new StreamMessage(sOAPVersion, xMLStreamReader, attachmentSet);
    }

    @Override
    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final StreamSOAPCodec copy() {
        return this;
    }

    @Override
    public void decode(InputStream inputStream, String string, Packet packet, AttachmentSet attachmentSet) throws IOException {
        List<String> list = this.getExpectedContentTypes();
        if (string != null && !StreamSOAPCodec.isContentTypeSupported(string, list)) {
            throw new UnsupportedMediaException(string, list);
        }
        ContentType contentType = packet.getInternalContentType();
        ContentTypeImpl contentTypeImpl = contentType != null && contentType instanceof ContentTypeImpl ? (ContentTypeImpl)contentType : new ContentTypeImpl(string);
        String string2 = contentTypeImpl.getCharSet();
        if (string2 != null && !Charset.isSupported(string2)) {
            throw new UnsupportedMediaException(string2);
        }
        if (string2 != null) {
            packet.invocationProperties.put(DECODED_MESSAGE_CHARSET, string2);
        } else {
            packet.invocationProperties.remove(DECODED_MESSAGE_CHARSET);
        }
        packet.setMessage(this.streamDecoder.decode(inputStream, string2, attachmentSet, this.soapVersion));
    }

    @Override
    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet, AttachmentSet attachmentSet) {
        throw new UnsupportedOperationException();
    }

    public static StreamSOAPCodec create(SOAPVersion sOAPVersion) {
        if (sOAPVersion == null) {
            throw new IllegalArgumentException();
        }
        switch (sOAPVersion) {
            case SOAP_11: {
                return new StreamSOAP11Codec();
            }
            case SOAP_12: {
                return new StreamSOAP12Codec();
            }
        }
        throw new AssertionError();
    }

    public static StreamSOAPCodec create(WSFeatureList wSFeatureList) {
        SOAPVersion sOAPVersion = WebServiceFeatureList.getSoapVersion(wSFeatureList);
        if (sOAPVersion == null) {
            throw new IllegalArgumentException();
        }
        switch (sOAPVersion) {
            case SOAP_11: {
                return new StreamSOAP11Codec(wSFeatureList);
            }
            case SOAP_12: {
                return new StreamSOAP12Codec(wSFeatureList);
            }
        }
        throw new AssertionError();
    }

    public static StreamSOAPCodec create(WSBinding wSBinding) {
        SOAPVersion sOAPVersion = wSBinding.getSOAPVersion();
        if (sOAPVersion == null) {
            throw new IllegalArgumentException();
        }
        switch (sOAPVersion) {
            case SOAP_11: {
                return new StreamSOAP11Codec(wSBinding);
            }
            case SOAP_12: {
                return new StreamSOAP12Codec(wSBinding);
            }
        }
        throw new AssertionError();
    }

    private String getPacketEncoding(Packet packet) {
        if (this.serializationFeature != null && this.serializationFeature.getEncoding() != null) {
            return this.serializationFeature.getEncoding().equals("") ? "utf-8" : this.serializationFeature.getEncoding();
        }
        if (packet != null && packet.endpoint != null) {
            String string = (String)packet.invocationProperties.get(DECODED_MESSAGE_CHARSET);
            return string == null ? "utf-8" : string;
        }
        return "utf-8";
    }

    protected ContentTypeImpl.Builder getContenTypeBuilder(Packet packet) {
        ContentTypeImpl.Builder builder = new ContentTypeImpl.Builder();
        String string = this.getPacketEncoding(packet);
        if ("utf-8".equalsIgnoreCase(string)) {
            builder.contentType = this.getDefaultContentType();
            builder.charset = "utf-8";
            return builder;
        }
        builder.contentType = this.getMimeType() + " ;charset=" + string;
        builder.charset = string;
        return builder;
    }
}

