/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model;

import com.oracle.webservices.internal.api.EnvelopeStyle;
import com.oracle.webservices.internal.api.EnvelopeStyleFeature;
import com.oracle.webservices.internal.api.databinding.DatabindingMode;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.localization.Localizable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.databinding.DatabindingConfig;
import com.sun.xml.internal.ws.api.databinding.MetadataReader;
import com.sun.xml.internal.ws.api.model.ExceptionType;
import com.sun.xml.internal.ws.api.model.MEP;
import com.sun.xml.internal.ws.api.model.Parameter;
import com.sun.xml.internal.ws.api.model.ParameterBinding;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLInput;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPart;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.CheckedExceptionImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.ReflectAnnotationReader;
import com.sun.xml.internal.ws.model.RuntimeModelerException;
import com.sun.xml.internal.ws.model.SOAPSEIModel;
import com.sun.xml.internal.ws.model.Utils;
import com.sun.xml.internal.ws.model.WrapperBeanGenerator;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.model.soap.SOAPBindingImpl;
import com.sun.xml.internal.ws.resources.ModelerMessages;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.spi.db.BindingContext;
import com.sun.xml.internal.ws.spi.db.TypeInfo;
import com.sun.xml.internal.ws.spi.db.WrapperComposite;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.BindingType;
import javax.xml.ws.FaultAction;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.Response;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.soap.MTOMFeature;

public class RuntimeModeler {
    private final WebServiceFeatureList features;
    private BindingID bindingId;
    private WSBinding wsBinding;
    private final Class portClass;
    private AbstractSEIModelImpl model;
    private SOAPBindingImpl defaultBinding;
    private String packageName;
    private String targetNamespace;
    private boolean isWrapped = true;
    private ClassLoader classLoader;
    private final WSDLPort binding;
    private QName serviceName;
    private QName portName;
    private Set<Class> classUsesWebMethod;
    private DatabindingConfig config;
    private MetadataReader metadataReader;
    public static final String PD_JAXWS_PACKAGE_PD = ".jaxws.";
    public static final String JAXWS_PACKAGE_PD = "jaxws.";
    public static final String RESPONSE = "Response";
    public static final String RETURN = "return";
    public static final String BEAN = "Bean";
    public static final String SERVICE = "Service";
    public static final String PORT = "Port";
    public static final Class HOLDER_CLASS = Holder.class;
    public static final Class<RemoteException> REMOTE_EXCEPTION_CLASS = RemoteException.class;
    public static final Class<RuntimeException> RUNTIME_EXCEPTION_CLASS = RuntimeException.class;
    public static final Class<Exception> EXCEPTION_CLASS = Exception.class;
    public static final String DecapitalizeExceptionBeanProperties = "com.sun.xml.internal.ws.api.model.DecapitalizeExceptionBeanProperties";
    public static final String SuppressDocLitWrapperGeneration = "com.sun.xml.internal.ws.api.model.SuppressDocLitWrapperGeneration";
    public static final String DocWrappeeNamespapceQualified = "com.sun.xml.internal.ws.api.model.DocWrappeeNamespapceQualified";
    private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.server");

    public RuntimeModeler(@NotNull DatabindingConfig databindingConfig) {
        this.portClass = databindingConfig.getEndpointClass() != null ? databindingConfig.getEndpointClass() : databindingConfig.getContractClass();
        this.serviceName = databindingConfig.getMappingInfo().getServiceName();
        this.binding = databindingConfig.getWsdlPort();
        this.classLoader = databindingConfig.getClassLoader();
        this.portName = databindingConfig.getMappingInfo().getPortName();
        this.config = databindingConfig;
        this.wsBinding = databindingConfig.getWSBinding();
        this.metadataReader = databindingConfig.getMetadataReader();
        this.targetNamespace = databindingConfig.getMappingInfo().getTargetNamespace();
        if (this.metadataReader == null) {
            this.metadataReader = new ReflectAnnotationReader();
        }
        if (this.wsBinding != null) {
            this.bindingId = this.wsBinding.getBindingId();
            if (databindingConfig.getFeatures() != null) {
                this.wsBinding.getFeatures().mergeFeatures(databindingConfig.getFeatures(), false);
            }
            if (this.binding != null) {
                this.wsBinding.getFeatures().mergeFeatures(this.binding.getFeatures(), false);
            }
            this.features = WebServiceFeatureList.toList(this.wsBinding.getFeatures());
        } else {
            Annotation annotation;
            this.bindingId = databindingConfig.getMappingInfo().getBindingID();
            this.features = WebServiceFeatureList.toList(databindingConfig.getFeatures());
            if (this.binding != null) {
                this.bindingId = this.binding.getBinding().getBindingId();
            }
            if (this.bindingId == null) {
                this.bindingId = this.getDefaultBindingID();
            }
            if (!this.features.contains(MTOMFeature.class) && (annotation = this.getAnnotation(this.portClass, MTOM.class)) != null) {
                this.features.add(WebServiceFeatureList.getFeature(annotation));
            }
            if (!this.features.contains(EnvelopeStyleFeature.class) && (annotation = this.getAnnotation(this.portClass, EnvelopeStyle.class)) != null) {
                this.features.add(WebServiceFeatureList.getFeature(annotation));
            }
            this.wsBinding = this.bindingId.createBinding(this.features);
        }
    }

    private BindingID getDefaultBindingID() {
        BindingType bindingType = this.getAnnotation(this.portClass, BindingType.class);
        if (bindingType != null) {
            return BindingID.parse(bindingType.value());
        }
        SOAPVersion sOAPVersion = WebServiceFeatureList.getSoapVersion(this.features);
        boolean bl = this.features.isEnabled(MTOMFeature.class);
        if (SOAPVersion.SOAP_12.equals((Object)sOAPVersion)) {
            return bl ? BindingID.SOAP12_HTTP_MTOM : BindingID.SOAP12_HTTP;
        }
        return bl ? BindingID.SOAP11_HTTP_MTOM : BindingID.SOAP11_HTTP;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setPortName(QName qName) {
        this.portName = qName;
    }

    private <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> clazz2) {
        return this.metadataReader.getAnnotation(clazz2, clazz);
    }

    private <T extends Annotation> T getAnnotation(Method method, Class<T> clazz) {
        return this.metadataReader.getAnnotation(clazz, method);
    }

    private Annotation[] getAnnotations(Method method) {
        return this.metadataReader.getAnnotations(method);
    }

    private Annotation[] getAnnotations(Class<?> clazz) {
        return this.metadataReader.getAnnotations(clazz);
    }

    private Annotation[][] getParamAnnotations(Method method) {
        return this.metadataReader.getParameterAnnotations(method);
    }

    public AbstractSEIModelImpl buildRuntimeModel() {
        Annotation annotation;
        this.model = new SOAPSEIModel(this.features);
        this.model.contractClass = this.config.getContractClass();
        this.model.endpointClass = this.config.getEndpointClass();
        this.model.classLoader = this.classLoader;
        this.model.wsBinding = this.wsBinding;
        this.model.databindingInfo.setWsdlURL(this.config.getWsdlURL());
        this.model.databindingInfo.properties().putAll(this.config.properties());
        if (this.model.contractClass == null) {
            this.model.contractClass = this.portClass;
        }
        if (this.model.endpointClass == null && !this.portClass.isInterface()) {
            this.model.endpointClass = this.portClass;
        }
        Class clazz = this.portClass;
        this.metadataReader.getProperties(this.model.databindingInfo.properties(), this.portClass);
        WebService webService = this.getAnnotation(this.portClass, WebService.class);
        if (webService == null) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", this.portClass.getCanonicalName());
        }
        Class clazz2 = this.configEndpointInterface();
        if (webService.endpointInterface().length() > 0 || clazz2 != null) {
            clazz = clazz2 != null ? clazz2 : this.getClass(webService.endpointInterface(), ModelerMessages.localizableRUNTIME_MODELER_CLASS_NOT_FOUND(webService.endpointInterface()));
            this.model.contractClass = clazz;
            this.model.endpointClass = this.portClass;
            annotation = this.getAnnotation(clazz, WebService.class);
            if (annotation == null) {
                throw new RuntimeModelerException("runtime.modeler.endpoint.interface.no.webservice", webService.endpointInterface());
            }
            SOAPBinding sOAPBinding = this.getAnnotation(this.portClass, SOAPBinding.class);
            SOAPBinding sOAPBinding2 = this.getAnnotation(clazz, SOAPBinding.class);
            if (sOAPBinding != null && (sOAPBinding2 == null || sOAPBinding2.style() != sOAPBinding.style() || sOAPBinding2.use() != sOAPBinding.use())) {
                logger.warning(ServerMessages.RUNTIMEMODELER_INVALIDANNOTATION_ON_IMPL("@SOAPBinding", this.portClass.getName(), clazz.getName()));
            }
        }
        if (this.serviceName == null) {
            this.serviceName = RuntimeModeler.getServiceName(this.portClass, this.metadataReader);
        }
        this.model.setServiceQName(this.serviceName);
        if (this.portName == null) {
            this.portName = RuntimeModeler.getPortName(this.portClass, this.metadataReader, this.serviceName.getNamespaceURI());
        }
        this.model.setPortName(this.portName);
        annotation = this.getAnnotation(this.portClass, DatabindingMode.class);
        if (annotation != null) {
            this.model.databindingInfo.setDatabindingMode(annotation.value());
        }
        this.processClass(clazz);
        if (this.model.getJavaMethods().size() == 0) {
            throw new RuntimeModelerException("runtime.modeler.no.operations", this.portClass.getName());
        }
        this.model.postProcess();
        this.config.properties().put(BindingContext.class.getName(), this.model.bindingContext);
        if (this.binding != null) {
            this.model.freeze(this.binding);
        }
        return this.model;
    }

    private Class configEndpointInterface() {
        if (this.config.getEndpointClass() == null || this.config.getEndpointClass().isInterface()) {
            return null;
        }
        return this.config.getContractClass();
    }

    private Class getClass(String string, Localizable localizable) {
        try {
            if (this.classLoader == null) {
                return Thread.currentThread().getContextClassLoader().loadClass(string);
            }
            return this.classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeModelerException(localizable);
        }
    }

    private boolean noWrapperGen() {
        Object object = this.config.properties().get(SuppressDocLitWrapperGeneration);
        return object != null && object instanceof Boolean ? (Boolean)object : false;
    }

    private Class getRequestWrapperClass(String string, Method method, QName qName) {
        ClassLoader classLoader = this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader;
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.noWrapperGen()) {
                return WrapperComposite.class;
            }
            logger.fine("Dynamically creating request wrapper Class " + string);
            return WrapperBeanGenerator.createRequestWrapperBean(string, method, qName, classLoader);
        }
    }

    private Class getResponseWrapperClass(String string, Method method, QName qName) {
        ClassLoader classLoader = this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader;
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.noWrapperGen()) {
                return WrapperComposite.class;
            }
            logger.fine("Dynamically creating response wrapper bean Class " + string);
            return WrapperBeanGenerator.createResponseWrapperBean(string, method, qName, classLoader);
        }
    }

    private Class getExceptionBeanClass(String string, Class clazz, String string2, String string3) {
        boolean bl = true;
        Object object = this.config.properties().get(DecapitalizeExceptionBeanProperties);
        if (object != null && object instanceof Boolean) {
            bl = (Boolean)object;
        }
        ClassLoader classLoader = this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader;
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.fine("Dynamically creating exception bean Class " + string);
            return WrapperBeanGenerator.createExceptionBean(string, clazz, this.targetNamespace, string2, string3, classLoader, bl);
        }
    }

    protected void determineWebMethodUse(Class clazz) {
        if (clazz == null) {
            return;
        }
        if (!clazz.isInterface()) {
            if (clazz == Object.class) {
                return;
            }
            for (Method method : clazz.getMethods()) {
                WebMethod webMethod;
                if (method.getDeclaringClass() != clazz || (webMethod = this.getAnnotation(method, WebMethod.class)) == null || webMethod.exclude()) continue;
                this.classUsesWebMethod.add(clazz);
                break;
            }
        }
        this.determineWebMethodUse(clazz.getSuperclass());
    }

    void processClass(Class clazz) {
        this.classUsesWebMethod = new HashSet<Class>();
        this.determineWebMethodUse(clazz);
        WebService webService = this.getAnnotation(clazz, WebService.class);
        QName qName = RuntimeModeler.getPortTypeName(clazz, this.targetNamespace, this.metadataReader);
        this.packageName = "";
        if (clazz.getPackage() != null) {
            this.packageName = clazz.getPackage().getName();
        }
        this.targetNamespace = qName.getNamespaceURI();
        this.model.setPortTypeName(qName);
        this.model.setTargetNamespace(this.targetNamespace);
        this.model.defaultSchemaNamespaceSuffix = this.config.getMappingInfo().getDefaultSchemaNamespaceSuffix();
        this.model.setWSDLLocation(webService.wsdlLocation());
        SOAPBinding sOAPBinding = this.getAnnotation(clazz, SOAPBinding.class);
        if (sOAPBinding != null) {
            if (sOAPBinding.style() == SOAPBinding.Style.RPC && sOAPBinding.parameterStyle() == SOAPBinding.ParameterStyle.BARE) {
                throw new RuntimeModelerException("runtime.modeler.invalid.soapbinding.parameterstyle", sOAPBinding, clazz);
            }
            this.isWrapped = sOAPBinding.parameterStyle() == SOAPBinding.ParameterStyle.WRAPPED;
        }
        this.defaultBinding = this.createBinding(sOAPBinding);
        for (Method method : clazz.getMethods()) {
            if (!clazz.isInterface() && (method.getDeclaringClass() == Object.class || (RuntimeModeler.getBooleanSystemProperty("com.sun.xml.internal.ws.legacyWebMethod") == false ? !this.isWebMethodBySpec(method, clazz) : !this.isWebMethod(method)))) continue;
            this.processMethod(method);
        }
        XmlSeeAlso xmlSeeAlso = this.getAnnotation(clazz, XmlSeeAlso.class);
        if (xmlSeeAlso != null) {
            this.model.addAdditionalClasses(xmlSeeAlso.value());
        }
    }

    private boolean isWebMethodBySpec(Method method, Class clazz) {
        boolean bl;
        int n = method.getModifiers();
        boolean bl2 = bl = Modifier.isStatic(n) || Modifier.isFinal(n);
        assert (Modifier.isPublic(n));
        assert (!clazz.isInterface());
        WebMethod webMethod = this.getAnnotation(method, WebMethod.class);
        if (webMethod != null) {
            if (webMethod.exclude()) {
                return false;
            }
            if (bl) {
                throw new RuntimeModelerException(ModelerMessages.localizableRUNTIME_MODELER_WEBMETHOD_MUST_BE_NONSTATICFINAL(method));
            }
            return true;
        }
        if (bl) {
            return false;
        }
        Class<?> clazz2 = method.getDeclaringClass();
        return this.getAnnotation(clazz2, WebService.class) != null;
    }

    private boolean isWebMethod(Method method) {
        int n = method.getModifiers();
        if (Modifier.isStatic(n) || Modifier.isFinal(n)) {
            return false;
        }
        Class<?> clazz = method.getDeclaringClass();
        boolean bl = this.getAnnotation(clazz, WebService.class) != null;
        WebMethod webMethod = this.getAnnotation(method, WebMethod.class);
        if (webMethod != null && !webMethod.exclude() && bl) {
            return true;
        }
        return bl && !this.classUsesWebMethod.contains(clazz);
    }

    protected SOAPBindingImpl createBinding(SOAPBinding sOAPBinding) {
        SOAPBindingImpl sOAPBindingImpl = new SOAPBindingImpl();
        SOAPBinding.Style style = sOAPBinding != null ? sOAPBinding.style() : SOAPBinding.Style.DOCUMENT;
        sOAPBindingImpl.setStyle(style);
        assert (this.bindingId != null);
        this.model.bindingId = this.bindingId;
        SOAPVersion sOAPVersion = this.bindingId.getSOAPVersion();
        sOAPBindingImpl.setSOAPVersion(sOAPVersion);
        return sOAPBindingImpl;
    }

    public static String getNamespace(@NotNull String string) {
        String[] stringArray;
        if (string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() == 0) {
            stringArray = new String[]{};
        } else {
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = stringTokenizer.countTokens() - 1; i >= 0; --i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
        }
        StringBuilder stringBuilder = new StringBuilder("http://");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append('/');
        return stringBuilder.toString();
    }

    private boolean isServiceException(Class<?> clazz) {
        return EXCEPTION_CLASS.isAssignableFrom(clazz) && !RUNTIME_EXCEPTION_CLASS.isAssignableFrom(clazz) && !REMOTE_EXCEPTION_CLASS.isAssignableFrom(clazz);
    }

    private void processMethod(Method method) {
        Object object;
        Object object2;
        Object object3;
        Class<?> clazz2;
        boolean bl;
        WebMethod webMethod = this.getAnnotation(method, WebMethod.class);
        if (webMethod != null && webMethod.exclude()) {
            return;
        }
        String string = method.getName();
        boolean bl2 = bl = this.getAnnotation(method, Oneway.class) != null;
        if (bl) {
            for (Class<?> clazz2 : method.getExceptionTypes()) {
                if (!this.isServiceException(clazz2)) continue;
                throw new RuntimeModelerException("runtime.modeler.oneway.operation.no.checked.exceptions", this.portClass.getCanonicalName(), string, clazz2.getName());
            }
        }
        if (method.getDeclaringClass() == this.portClass) {
            object3 = new JavaMethodImpl(this.model, method, method, this.metadataReader);
        } else {
            try {
                Method method2 = this.portClass.getMethod(method.getName(), method.getParameterTypes());
                object3 = new JavaMethodImpl(this.model, method2, method, this.metadataReader);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeModelerException("runtime.modeler.method.not.found", method.getName(), this.portClass.getName());
            }
        }
        MEP mEP = this.getMEP(method);
        ((JavaMethodImpl)object3).setMEP(mEP);
        Object object4 = null;
        clazz2 = method.getName();
        if (webMethod != null) {
            object4 = webMethod.action();
            Class<?> clazz3 = clazz2 = webMethod.operationName().length() > 0 ? webMethod.operationName() : clazz2;
        }
        if (this.binding != null && (object2 = this.binding.getBinding().get(new QName(this.targetNamespace, (String)((Object)clazz2)))) != null) {
            WSDLInput wSDLInput = object2.getOperation().getInput();
            object = wSDLInput.getAction();
            object4 = object != null && !wSDLInput.isDefaultAction() ? object : object2.getSOAPAction();
        }
        ((JavaMethodImpl)object3).setOperationQName(new QName(this.targetNamespace, (String)((Object)clazz2)));
        object2 = this.getAnnotation(method, SOAPBinding.class);
        if (object2 != null && object2.style() == SOAPBinding.Style.RPC) {
            logger.warning(ModelerMessages.RUNTIMEMODELER_INVALID_SOAPBINDING_ON_METHOD(object2, method.getName(), method.getDeclaringClass().getName()));
        } else if (object2 == null && !method.getDeclaringClass().equals(this.portClass) && (object2 = this.getAnnotation(method.getDeclaringClass(), SOAPBinding.class)) != null && object2.style() == SOAPBinding.Style.RPC && object2.parameterStyle() == SOAPBinding.ParameterStyle.BARE) {
            throw new RuntimeModelerException("runtime.modeler.invalid.soapbinding.parameterstyle", object2, method.getDeclaringClass());
        }
        if (object2 != null && this.defaultBinding.getStyle() != object2.style()) {
            throw new RuntimeModelerException("runtime.modeler.soapbinding.conflict", new Object[]{object2.style(), method.getName(), this.defaultBinding.getStyle()});
        }
        boolean bl3 = this.isWrapped;
        object = this.defaultBinding.getStyle();
        if (object2 != null) {
            SOAPBindingImpl sOAPBindingImpl = this.createBinding((SOAPBinding)object2);
            object = sOAPBindingImpl.getStyle();
            if (object4 != null) {
                sOAPBindingImpl.setSOAPAction((String)object4);
            }
            bl3 = object2.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED);
            ((JavaMethodImpl)object3).setBinding(sOAPBindingImpl);
        } else {
            SOAPBindingImpl sOAPBindingImpl = new SOAPBindingImpl(this.defaultBinding);
            if (object4 != null) {
                sOAPBindingImpl.setSOAPAction((String)object4);
            } else {
                String string2 = SOAPVersion.SOAP_11 == sOAPBindingImpl.getSOAPVersion() ? "" : null;
                sOAPBindingImpl.setSOAPAction(string2);
            }
            ((JavaMethodImpl)object3).setBinding(sOAPBindingImpl);
        }
        if (!bl3) {
            this.processDocBareMethod((JavaMethodImpl)object3, (String)((Object)clazz2), method);
        } else if (((Enum)object).equals((Object)SOAPBinding.Style.DOCUMENT)) {
            this.processDocWrappedMethod((JavaMethodImpl)object3, string, (String)((Object)clazz2), method);
        } else {
            this.processRpcMethod((JavaMethodImpl)object3, string, (String)((Object)clazz2), method);
        }
        this.model.addJavaMethod((JavaMethodImpl)object3);
    }

    private MEP getMEP(Method method) {
        if (this.getAnnotation(method, Oneway.class) != null) {
            return MEP.ONE_WAY;
        }
        if (Response.class.isAssignableFrom(method.getReturnType())) {
            return MEP.ASYNC_POLL;
        }
        if (Future.class.isAssignableFrom(method.getReturnType())) {
            return MEP.ASYNC_CALLBACK;
        }
        return MEP.REQUEST_RESPONSE;
    }

    protected void processDocWrappedMethod(JavaMethodImpl javaMethodImpl, String string, String string2, Method method) {
        Object object;
        Object object2;
        Object[] objectArray;
        boolean bl = false;
        boolean bl2 = this.getAnnotation(method, Oneway.class) != null;
        RequestWrapper requestWrapper = this.getAnnotation(method, RequestWrapper.class);
        ResponseWrapper responseWrapper = this.getAnnotation(method, ResponseWrapper.class);
        String string3 = this.packageName + PD_JAXWS_PACKAGE_PD;
        if (this.packageName == null || this.packageName.length() == 0) {
            string3 = JAXWS_PACKAGE_PD;
        }
        String string4 = requestWrapper != null && requestWrapper.className().length() > 0 ? requestWrapper.className() : string3 + RuntimeModeler.capitalize(method.getName());
        String string5 = responseWrapper != null && responseWrapper.className().length() > 0 ? responseWrapper.className() : string3 + RuntimeModeler.capitalize(method.getName()) + RESPONSE;
        String string6 = string2;
        String string7 = this.targetNamespace;
        String string8 = "parameters";
        if (requestWrapper != null) {
            if (requestWrapper.targetNamespace().length() > 0) {
                string7 = requestWrapper.targetNamespace();
            }
            if (requestWrapper.localName().length() > 0) {
                string6 = requestWrapper.localName();
            }
            try {
                if (requestWrapper.partName().length() > 0) {
                    string8 = requestWrapper.partName();
                }
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        QName qName = new QName(string7, string6);
        javaMethodImpl.setRequestPayloadName(qName);
        Class clazz = this.getRequestWrapperClass(string4, method, qName);
        Class clazz2 = null;
        String string9 = string2 + RESPONSE;
        String string10 = this.targetNamespace;
        QName qName2 = null;
        String string11 = "parameters";
        if (!bl2) {
            if (responseWrapper != null) {
                if (responseWrapper.targetNamespace().length() > 0) {
                    string10 = responseWrapper.targetNamespace();
                }
                if (responseWrapper.localName().length() > 0) {
                    string9 = responseWrapper.localName();
                }
                try {
                    if (responseWrapper.partName().length() > 0) {
                        string11 = responseWrapper.partName();
                    }
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
            }
            qName2 = new QName(string10, string9);
            clazz2 = this.getResponseWrapperClass(string5, method, qName2);
        }
        TypeInfo typeInfo = new TypeInfo(qName, clazz, new Annotation[0]);
        typeInfo.setNillable(false);
        WrapperParameter wrapperParameter = new WrapperParameter(javaMethodImpl, typeInfo, WebParam.Mode.IN, 0);
        wrapperParameter.setPartName(string8);
        wrapperParameter.setBinding(ParameterBinding.BODY);
        javaMethodImpl.addParameter(wrapperParameter);
        WrapperParameter wrapperParameter2 = null;
        if (!bl2) {
            typeInfo = new TypeInfo(qName2, clazz2, new Annotation[0]);
            typeInfo.setNillable(false);
            wrapperParameter2 = new WrapperParameter(javaMethodImpl, typeInfo, WebParam.Mode.OUT, -1);
            javaMethodImpl.addParameter(wrapperParameter2);
            wrapperParameter2.setBinding(ParameterBinding.BODY);
        }
        WebResult webResult = this.getAnnotation(method, WebResult.class);
        XmlElement xmlElement = this.getAnnotation(method, XmlElement.class);
        QName qName3 = RuntimeModeler.getReturnQName(method, webResult, xmlElement);
        Class clazz3 = method.getReturnType();
        boolean bl3 = false;
        if (webResult != null) {
            bl3 = webResult.header();
            boolean bl4 = bl = bl3 || bl;
            if (bl3 && xmlElement != null) {
                throw new RuntimeModelerException("@XmlElement cannot be specified on method " + method + " as the return value is bound to header", new Object[0]);
            }
            if (qName3.getNamespaceURI().length() == 0 && webResult.header()) {
                qName3 = new QName(this.targetNamespace, qName3.getLocalPart());
            }
        }
        if (javaMethodImpl.isAsync()) {
            clazz3 = this.getAsyncReturnType(method, clazz3);
            qName3 = new QName(RETURN);
        }
        qName3 = this.qualifyWrappeeIfNeeded(qName3, string10);
        if (!bl2 && clazz3 != null && !clazz3.getName().equals("void")) {
            objectArray = this.getAnnotations(method);
            if (qName3.getLocalPart() != null) {
                object2 = new TypeInfo(qName3, clazz3, (Annotation[])objectArray);
                this.metadataReader.getProperties(((TypeInfo)object2).properties(), method);
                ((TypeInfo)object2).setGenericType(method.getGenericReturnType());
                object = new ParameterImpl(javaMethodImpl, (TypeInfo)object2, WebParam.Mode.OUT, -1);
                if (bl3) {
                    ((ParameterImpl)object).setBinding(ParameterBinding.HEADER);
                    javaMethodImpl.addParameter((ParameterImpl)object);
                } else {
                    ((ParameterImpl)object).setBinding(ParameterBinding.BODY);
                    wrapperParameter2.addWrapperChild((ParameterImpl)object);
                }
            }
        }
        objectArray = method.getParameterTypes();
        object2 = method.getGenericParameterTypes();
        object = this.getParamAnnotations(method);
        int n = 0;
        for (Object object3 : objectArray) {
            String string12 = null;
            String string13 = "arg" + n;
            boolean bl5 = false;
            if (javaMethodImpl.isAsync() && AsyncHandler.class.isAssignableFrom((Class<?>)object3)) continue;
            boolean bl6 = HOLDER_CLASS.isAssignableFrom((Class<?>)object3);
            if (bl6 && object3 == Holder.class) {
                object3 = (Class)Utils.REFLECTION_NAVIGATOR.erasure(((ParameterizedType)object2[n]).getActualTypeArguments()[0]);
            }
            WebParam.Mode mode = bl6 ? WebParam.Mode.INOUT : WebParam.Mode.IN;
            WebParam webParam = null;
            xmlElement = null;
            for (Object object4 : object[n]) {
                if (object4.annotationType() == WebParam.class) {
                    webParam = (WebParam)object4;
                    continue;
                }
                if (object4.annotationType() != XmlElement.class) continue;
                xmlElement = (XmlElement)object4;
            }
            Object object5 = RuntimeModeler.getParameterQName(method, webParam, xmlElement, string13);
            if (webParam != null) {
                bl5 = webParam.header();
                boolean bl7 = bl = bl5 || bl;
                if (bl5 && xmlElement != null) {
                    throw new RuntimeModelerException("@XmlElement cannot be specified on method " + method + " parameter that is bound to header", new Object[0]);
                }
                string12 = webParam.partName().length() > 0 ? webParam.partName() : ((QName)object5).getLocalPart();
                if (bl5 && ((QName)object5).getNamespaceURI().equals("")) {
                    object5 = new QName(this.targetNamespace, ((QName)object5).getLocalPart());
                }
                mode = webParam.mode();
                if (bl6 && mode == WebParam.Mode.IN) {
                    mode = WebParam.Mode.INOUT;
                }
            }
            object5 = this.qualifyWrappeeIfNeeded((QName)object5, string7);
            typeInfo = new TypeInfo((QName)object5, (Type)object3, (Annotation[])object[n]);
            this.metadataReader.getProperties(typeInfo.properties(), method, n);
            typeInfo.setGenericType((Type)object2[n]);
            ParameterImpl parameterImpl = new ParameterImpl(javaMethodImpl, typeInfo, mode, n++);
            if (bl5) {
                parameterImpl.setBinding(ParameterBinding.HEADER);
                javaMethodImpl.addParameter(parameterImpl);
                parameterImpl.setPartName(string12);
                continue;
            }
            parameterImpl.setBinding(ParameterBinding.BODY);
            if (mode != WebParam.Mode.OUT) {
                wrapperParameter.addWrapperChild(parameterImpl);
            }
            if (mode == WebParam.Mode.IN) continue;
            if (bl2) {
                throw new RuntimeModelerException("runtime.modeler.oneway.operation.no.out.parameters", this.portClass.getCanonicalName(), string);
            }
            wrapperParameter2.addWrapperChild(parameterImpl);
        }
        if (bl) {
            string11 = "result";
        }
        if (wrapperParameter2 != null) {
            wrapperParameter2.setPartName(string11);
        }
        this.processExceptions(javaMethodImpl, method);
    }

    private QName qualifyWrappeeIfNeeded(QName qName, String string) {
        boolean bl;
        Object object = this.config.properties().get(DocWrappeeNamespapceQualified);
        boolean bl2 = bl = object != null && object instanceof Boolean ? (Boolean)object : false;
        if (bl && (qName.getNamespaceURI() == null || "".equals(qName.getNamespaceURI()))) {
            return new QName(string, qName.getLocalPart());
        }
        return qName;
    }

    protected void processRpcMethod(JavaMethodImpl javaMethodImpl, String string, String string2, Method method) {
        Object object;
        Object object2;
        Object[] objectArray;
        Object object3;
        QName qName;
        boolean bl = this.getAnnotation(method, Oneway.class) != null;
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        TreeMap<Integer, ParameterImpl> treeMap2 = new TreeMap<Integer, ParameterImpl>();
        String string3 = this.targetNamespace;
        String string4 = this.targetNamespace;
        if (this.binding != null && SOAPBinding.Style.RPC.equals((Object)this.binding.getBinding().getStyle())) {
            qName = new QName(this.binding.getBinding().getPortTypeName().getNamespaceURI(), string2);
            object3 = this.binding.getBinding().get(qName);
            if (object3 != null) {
                if (object3.getRequestNamespace() != null) {
                    string3 = object3.getRequestNamespace();
                }
                if (object3.getResponseNamespace() != null) {
                    string4 = object3.getResponseNamespace();
                }
            }
        }
        qName = new QName(string3, string2);
        javaMethodImpl.setRequestPayloadName(qName);
        object3 = null;
        if (!bl) {
            object3 = new QName(string4, string2 + RESPONSE);
        }
        Class<WrapperComposite> clazz = WrapperComposite.class;
        TypeInfo typeInfo = new TypeInfo(qName, (Type)((Object)clazz), new Annotation[0]);
        WrapperParameter wrapperParameter = new WrapperParameter(javaMethodImpl, typeInfo, WebParam.Mode.IN, 0);
        wrapperParameter.setInBinding(ParameterBinding.BODY);
        javaMethodImpl.addParameter(wrapperParameter);
        WrapperParameter wrapperParameter2 = null;
        if (!bl) {
            typeInfo = new TypeInfo((QName)object3, (Type)((Object)clazz), new Annotation[0]);
            wrapperParameter2 = new WrapperParameter(javaMethodImpl, typeInfo, WebParam.Mode.OUT, -1);
            wrapperParameter2.setOutBinding(ParameterBinding.BODY);
            javaMethodImpl.addParameter(wrapperParameter2);
        }
        Class clazz2 = method.getReturnType();
        String string5 = RETURN;
        String string6 = this.targetNamespace;
        String string7 = string5;
        boolean bl2 = false;
        WebResult webResult = this.getAnnotation(method, WebResult.class);
        if (webResult != null) {
            bl2 = webResult.header();
            if (webResult.name().length() > 0) {
                string5 = webResult.name();
            }
            if (webResult.partName().length() > 0) {
                string7 = webResult.partName();
                if (!bl2) {
                    string5 = string7;
                }
            } else {
                string7 = string5;
            }
            if (webResult.targetNamespace().length() > 0) {
                string6 = webResult.targetNamespace();
            }
            bl2 = webResult.header();
        }
        QName qName2 = bl2 ? new QName(string6, string5) : new QName(string5);
        if (javaMethodImpl.isAsync()) {
            clazz2 = this.getAsyncReturnType(method, clazz2);
        }
        if (!bl && clazz2 != null && clazz2 != Void.TYPE) {
            objectArray = this.getAnnotations(method);
            object2 = new TypeInfo(qName2, clazz2, (Annotation[])objectArray);
            this.metadataReader.getProperties(((TypeInfo)object2).properties(), method);
            ((TypeInfo)object2).setGenericType(method.getGenericReturnType());
            object = new ParameterImpl(javaMethodImpl, (TypeInfo)object2, WebParam.Mode.OUT, -1);
            ((ParameterImpl)object).setPartName(string7);
            if (bl2) {
                ((ParameterImpl)object).setBinding(ParameterBinding.HEADER);
                javaMethodImpl.addParameter((ParameterImpl)object);
                ((TypeInfo)object2).setGlobalElement(true);
            } else {
                ParameterBinding parameterBinding = this.getBinding(string2, string7, false, WebParam.Mode.OUT);
                ((ParameterImpl)object).setBinding(parameterBinding);
                if (parameterBinding.isBody()) {
                    ((TypeInfo)object2).setGlobalElement(false);
                    WSDLPart wSDLPart = this.getPart(new QName(this.targetNamespace, string2), string7, WebParam.Mode.OUT);
                    if (wSDLPart == null) {
                        treeMap.put(treeMap.size() + 10000, object);
                    } else {
                        treeMap.put(wSDLPart.getIndex(), object);
                    }
                } else {
                    javaMethodImpl.addParameter((ParameterImpl)object);
                }
            }
        }
        objectArray = method.getParameterTypes();
        object2 = method.getGenericParameterTypes();
        object = this.getParamAnnotations(method);
        int n = 0;
        for (Object object4 : objectArray) {
            Object object5;
            String string8 = "";
            String string9 = "";
            String string10 = "";
            boolean bl3 = false;
            if (javaMethodImpl.isAsync() && AsyncHandler.class.isAssignableFrom((Class<?>)object4)) continue;
            boolean bl4 = HOLDER_CLASS.isAssignableFrom((Class<?>)object4);
            if (bl4 && object4 == Holder.class) {
                object4 = (Class)Utils.REFLECTION_NAVIGATOR.erasure(((ParameterizedType)object2[n]).getActualTypeArguments()[0]);
            }
            WebParam.Mode mode = bl4 ? WebParam.Mode.INOUT : WebParam.Mode.IN;
            for (Object object6 : object[n]) {
                if (object6.annotationType() != WebParam.class) continue;
                WebParam webParam = (WebParam)object6;
                string8 = webParam.name();
                string10 = webParam.partName();
                bl3 = webParam.header();
                WebParam.Mode mode2 = webParam.mode();
                string9 = webParam.targetNamespace();
                if (bl4 && mode2 == WebParam.Mode.IN) {
                    mode2 = WebParam.Mode.INOUT;
                }
                mode = mode2;
                break;
            }
            if (string8.length() == 0) {
                string8 = "arg" + n;
            }
            if (string10.length() == 0) {
                string10 = string8;
            } else if (!bl3) {
                string8 = string10;
            }
            if (string10.length() == 0) {
                string10 = string8;
            }
            if (!bl3) {
                object5 = new QName("", string8);
            } else {
                if (string9.length() == 0) {
                    string9 = this.targetNamespace;
                }
                object5 = new QName(string9, string8);
            }
            typeInfo = new TypeInfo((QName)object5, (Type)object4, (Annotation[])object[n]);
            this.metadataReader.getProperties(typeInfo.properties(), method, n);
            typeInfo.setGenericType((Type)object2[n]);
            ParameterImpl parameterImpl = new ParameterImpl(javaMethodImpl, typeInfo, mode, n++);
            parameterImpl.setPartName(string10);
            if (mode == WebParam.Mode.INOUT) {
                ParameterBinding parameterBinding = this.getBinding(string2, string10, bl3, WebParam.Mode.IN);
                parameterImpl.setInBinding(parameterBinding);
                parameterBinding = this.getBinding(string2, string10, bl3, WebParam.Mode.OUT);
                parameterImpl.setOutBinding(parameterBinding);
            } else if (bl3) {
                typeInfo.setGlobalElement(true);
                parameterImpl.setBinding(ParameterBinding.HEADER);
            } else {
                ParameterBinding parameterBinding = this.getBinding(string2, string10, false, mode);
                parameterImpl.setBinding(parameterBinding);
            }
            if (parameterImpl.getInBinding().isBody()) {
                typeInfo.setGlobalElement(false);
                if (!parameterImpl.isOUT()) {
                    WSDLPart wSDLPart = this.getPart(new QName(this.targetNamespace, string2), string10, WebParam.Mode.IN);
                    if (wSDLPart == null) {
                        treeMap2.put(treeMap2.size() + 10000, parameterImpl);
                    } else {
                        treeMap2.put(wSDLPart.getIndex(), parameterImpl);
                    }
                }
                if (parameterImpl.isIN()) continue;
                if (bl) {
                    throw new RuntimeModelerException("runtime.modeler.oneway.operation.no.out.parameters", this.portClass.getCanonicalName(), string);
                }
                WSDLPart wSDLPart = this.getPart(new QName(this.targetNamespace, string2), string10, WebParam.Mode.OUT);
                if (wSDLPart == null) {
                    treeMap.put(treeMap.size() + 10000, parameterImpl);
                    continue;
                }
                treeMap.put(wSDLPart.getIndex(), parameterImpl);
                continue;
            }
            javaMethodImpl.addParameter(parameterImpl);
        }
        for (ParameterImpl parameterImpl : treeMap2.values()) {
            wrapperParameter.addWrapperChild(parameterImpl);
        }
        for (ParameterImpl parameterImpl : treeMap.values()) {
            wrapperParameter2.addWrapperChild(parameterImpl);
        }
        this.processExceptions(javaMethodImpl, method);
    }

    protected void processExceptions(JavaMethodImpl javaMethodImpl, Method method) {
        Action action = this.getAnnotation(method, Action.class);
        FaultAction[] faultActionArray = new FaultAction[]{};
        if (action != null) {
            faultActionArray = action.fault();
        }
        for (Class<?> clazz : method.getExceptionTypes()) {
            Annotation[] annotationArray;
            Class clazz2;
            if (!EXCEPTION_CLASS.isAssignableFrom(clazz) || RUNTIME_EXCEPTION_CLASS.isAssignableFrom(clazz) || REMOTE_EXCEPTION_CLASS.isAssignableFrom(clazz)) continue;
            WebFault webFault = this.getAnnotation(clazz, WebFault.class);
            Method method2 = this.getWSDLExceptionFaultInfo(clazz);
            ExceptionType exceptionType = ExceptionType.WSDLException;
            String string = this.targetNamespace;
            String string2 = clazz.getSimpleName();
            String string3 = this.packageName + PD_JAXWS_PACKAGE_PD;
            if (this.packageName.length() == 0) {
                string3 = JAXWS_PACKAGE_PD;
            }
            String string4 = string3 + string2 + BEAN;
            String string5 = clazz.getSimpleName();
            if (webFault != null) {
                if (webFault.faultBean().length() > 0) {
                    string4 = webFault.faultBean();
                }
                if (webFault.name().length() > 0) {
                    string2 = webFault.name();
                }
                if (webFault.targetNamespace().length() > 0) {
                    string = webFault.targetNamespace();
                }
                if (webFault.messageName().length() > 0) {
                    string5 = webFault.messageName();
                }
            }
            if (method2 == null) {
                clazz2 = this.getExceptionBeanClass(string4, clazz, string2, string);
                exceptionType = ExceptionType.UserDefined;
                annotationArray = this.getAnnotations(clazz2);
            } else {
                clazz2 = method2.getReturnType();
                annotationArray = this.getAnnotations(method2);
            }
            QName qName = new QName(string, string2);
            TypeInfo typeInfo = new TypeInfo(qName, clazz2, annotationArray);
            CheckedExceptionImpl checkedExceptionImpl = new CheckedExceptionImpl(javaMethodImpl, clazz, typeInfo, exceptionType);
            checkedExceptionImpl.setMessageName(string5);
            for (FaultAction faultAction : faultActionArray) {
                if (!faultAction.className().equals(clazz) || faultAction.value().equals("")) continue;
                checkedExceptionImpl.setFaultAction(faultAction.value());
                break;
            }
            javaMethodImpl.addException(checkedExceptionImpl);
        }
    }

    protected Method getWSDLExceptionFaultInfo(Class clazz) {
        if (this.getAnnotation(clazz, WebFault.class) == null) {
            return null;
        }
        try {
            return clazz.getMethod("getFaultInfo", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected void processDocBareMethod(JavaMethodImpl javaMethodImpl, String string, Method method) {
        Object object;
        Object object2;
        Object[] objectArray;
        String string2 = string + RESPONSE;
        String string3 = this.targetNamespace;
        String string4 = null;
        boolean bl = false;
        WebResult webResult = this.getAnnotation(method, WebResult.class);
        if (webResult != null) {
            if (webResult.name().length() > 0) {
                string2 = webResult.name();
            }
            if (webResult.targetNamespace().length() > 0) {
                string3 = webResult.targetNamespace();
            }
            string4 = webResult.partName();
            bl = webResult.header();
        }
        Class clazz = method.getReturnType();
        Type type = method.getGenericReturnType();
        if (javaMethodImpl.isAsync()) {
            clazz = this.getAsyncReturnType(method, clazz);
        }
        if (clazz != null && !clazz.getName().equals("void")) {
            objectArray = this.getAnnotations(method);
            if (string2 != null) {
                object2 = new QName(string3, string2);
                object = new TypeInfo((QName)object2, clazz, (Annotation[])objectArray);
                ((TypeInfo)object).setGenericType(type);
                this.metadataReader.getProperties(((TypeInfo)object).properties(), method);
                ParameterImpl parameterImpl = new ParameterImpl(javaMethodImpl, (TypeInfo)object, WebParam.Mode.OUT, -1);
                if (string4 == null || string4.length() == 0) {
                    string4 = string2;
                }
                parameterImpl.setPartName(string4);
                if (bl) {
                    parameterImpl.setBinding(ParameterBinding.HEADER);
                } else {
                    ParameterBinding object3 = this.getBinding(string, string4, false, WebParam.Mode.OUT);
                    parameterImpl.setBinding(object3);
                }
                javaMethodImpl.addParameter(parameterImpl);
            }
        }
        objectArray = method.getParameterTypes();
        object2 = method.getGenericParameterTypes();
        object = this.getParamAnnotations(method);
        int n = 0;
        for (Object object3 : objectArray) {
            Object object42;
            String string5 = string;
            String string6 = null;
            String string7 = this.targetNamespace;
            boolean bl2 = false;
            if (javaMethodImpl.isAsync() && AsyncHandler.class.isAssignableFrom((Class<?>)object3)) continue;
            boolean bl3 = HOLDER_CLASS.isAssignableFrom((Class<?>)object3);
            if (bl3 && object3 == Holder.class) {
                object3 = (Class)Utils.REFLECTION_NAVIGATOR.erasure(((ParameterizedType)object2[n]).getActualTypeArguments()[0]);
            }
            WebParam.Mode mode = bl3 ? WebParam.Mode.INOUT : WebParam.Mode.IN;
            for (Object object42 : object[n]) {
                if (object42.annotationType() != WebParam.class) continue;
                WebParam webParam = (WebParam)object42;
                mode = webParam.mode();
                if (bl3 && mode == WebParam.Mode.IN) {
                    mode = WebParam.Mode.INOUT;
                }
                if (bl2 = webParam.header()) {
                    string5 = "arg" + n;
                }
                if (mode == WebParam.Mode.OUT && !bl2) {
                    string5 = string + RESPONSE;
                }
                if (webParam.name().length() > 0) {
                    string5 = webParam.name();
                }
                string6 = webParam.partName();
                if (webParam.targetNamespace().equals("")) break;
                string7 = webParam.targetNamespace();
                break;
            }
            QName qName = new QName(string7, string5);
            if (!bl2 && mode != WebParam.Mode.OUT) {
                javaMethodImpl.setRequestPayloadName(qName);
            }
            TypeInfo typeInfo = new TypeInfo(qName, (Type)object3, (Annotation[])object[n]);
            this.metadataReader.getProperties(typeInfo.properties(), method, n);
            typeInfo.setGenericType(object2[n]);
            ParameterImpl parameterImpl = new ParameterImpl(javaMethodImpl, typeInfo, mode, n++);
            if (string6 == null || string6.length() == 0) {
                string6 = string5;
            }
            parameterImpl.setPartName(string6);
            if (mode == WebParam.Mode.INOUT) {
                object42 = this.getBinding(string, string6, bl2, WebParam.Mode.IN);
                parameterImpl.setInBinding((ParameterBinding)object42);
                object42 = this.getBinding(string, string6, bl2, WebParam.Mode.OUT);
                parameterImpl.setOutBinding((ParameterBinding)object42);
            } else if (bl2) {
                parameterImpl.setBinding(ParameterBinding.HEADER);
            } else {
                object42 = this.getBinding(string, string6, false, mode);
                parameterImpl.setBinding((ParameterBinding)object42);
            }
            javaMethodImpl.addParameter(parameterImpl);
        }
        this.validateDocBare(javaMethodImpl);
        this.processExceptions(javaMethodImpl, method);
    }

    private void validateDocBare(JavaMethodImpl javaMethodImpl) {
        int n = 0;
        for (Parameter object : javaMethodImpl.getRequestParameters()) {
            if (object.getBinding().equals(ParameterBinding.BODY) && object.isIN()) {
                ++n;
            }
            if (n <= true) continue;
            throw new RuntimeModelerException(ModelerMessages.localizableNOT_A_VALID_BARE_METHOD(this.portClass.getName(), javaMethodImpl.getMethod().getName()));
        }
        int n2 = 0;
        for (Parameter parameter : javaMethodImpl.getResponseParameters()) {
            if (parameter.getBinding().equals(ParameterBinding.BODY) && parameter.isOUT()) {
                ++n2;
            }
            if (n2 <= true) continue;
            throw new RuntimeModelerException(ModelerMessages.localizableNOT_A_VALID_BARE_METHOD(this.portClass.getName(), javaMethodImpl.getMethod().getName()));
        }
    }

    private Class getAsyncReturnType(Method method, Class clazz) {
        if (Response.class.isAssignableFrom(clazz)) {
            Type type = method.getGenericReturnType();
            return (Class)Utils.REFLECTION_NAVIGATOR.erasure(((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        Type[] typeArray = method.getGenericParameterTypes();
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        for (Class<?> clazz2 : classArray) {
            if (AsyncHandler.class.isAssignableFrom(clazz2)) {
                return (Class)Utils.REFLECTION_NAVIGATOR.erasure(((ParameterizedType)typeArray[n]).getActualTypeArguments()[0]);
            }
            ++n;
        }
        return clazz;
    }

    public static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    public static QName getServiceName(Class<?> clazz) {
        return RuntimeModeler.getServiceName(clazz, null);
    }

    public static QName getServiceName(Class<?> clazz, boolean bl) {
        return RuntimeModeler.getServiceName(clazz, null, bl);
    }

    public static QName getServiceName(Class<?> clazz, MetadataReader metadataReader) {
        return RuntimeModeler.getServiceName(clazz, metadataReader, true);
    }

    public static QName getServiceName(Class<?> clazz, MetadataReader metadataReader, boolean bl) {
        if (clazz.isInterface()) {
            throw new RuntimeModelerException("runtime.modeler.cannot.get.serviceName.from.interface", clazz.getCanonicalName());
        }
        String string = clazz.getSimpleName() + SERVICE;
        String string2 = "";
        if (clazz.getPackage() != null) {
            string2 = clazz.getPackage().getName();
        }
        WebService webService = RuntimeModeler.getAnnotation(WebService.class, clazz, metadataReader);
        if (bl && webService == null) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", clazz.getCanonicalName());
        }
        if (webService != null && webService.serviceName().length() > 0) {
            string = webService.serviceName();
        }
        String string3 = RuntimeModeler.getNamespace(string2);
        if (webService != null && webService.targetNamespace().length() > 0) {
            string3 = webService.targetNamespace();
        } else if (string3 == null) {
            throw new RuntimeModelerException("runtime.modeler.no.package", clazz.getName());
        }
        return new QName(string3, string);
    }

    public static QName getPortName(Class<?> clazz, String string) {
        return RuntimeModeler.getPortName(clazz, null, string);
    }

    public static QName getPortName(Class<?> clazz, String string, boolean bl) {
        return RuntimeModeler.getPortName(clazz, null, string, bl);
    }

    public static QName getPortName(Class<?> clazz, MetadataReader metadataReader, String string) {
        return RuntimeModeler.getPortName(clazz, metadataReader, string, true);
    }

    public static QName getPortName(Class<?> clazz, MetadataReader metadataReader, String string, boolean bl) {
        WebService webService = RuntimeModeler.getAnnotation(WebService.class, clazz, metadataReader);
        if (bl && webService == null) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", clazz.getCanonicalName());
        }
        String string2 = webService != null && webService.portName().length() > 0 ? webService.portName() : (webService != null && webService.name().length() > 0 ? webService.name() + PORT : clazz.getSimpleName() + PORT);
        if (string == null) {
            if (webService != null && webService.targetNamespace().length() > 0) {
                string = webService.targetNamespace();
            } else {
                String string3 = null;
                if (clazz.getPackage() != null) {
                    string3 = clazz.getPackage().getName();
                }
                if (string3 != null) {
                    string = RuntimeModeler.getNamespace(string3);
                }
                if (string == null) {
                    throw new RuntimeModelerException("runtime.modeler.no.package", clazz.getName());
                }
            }
        }
        return new QName(string, string2);
    }

    static <A extends Annotation> A getAnnotation(Class<A> clazz, Class<?> clazz2, MetadataReader metadataReader) {
        return metadataReader == null ? clazz2.getAnnotation(clazz) : metadataReader.getAnnotation(clazz, clazz2);
    }

    public static QName getPortTypeName(Class<?> clazz) {
        return RuntimeModeler.getPortTypeName(clazz, null, null);
    }

    public static QName getPortTypeName(Class<?> clazz, MetadataReader metadataReader) {
        return RuntimeModeler.getPortTypeName(clazz, null, metadataReader);
    }

    public static QName getPortTypeName(Class<?> clazz, String string, MetadataReader metadataReader) {
        String string2;
        assert (clazz != null);
        WebService webService = RuntimeModeler.getAnnotation(WebService.class, clazz, metadataReader);
        Class<?> clazz2 = clazz;
        if (webService == null) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", clazz.getCanonicalName());
        }
        if (!clazz.isInterface() && (string2 = webService.endpointInterface()).length() > 0) {
            try {
                clazz2 = Thread.currentThread().getContextClassLoader().loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeModelerException("runtime.modeler.class.not.found", string2);
            }
            WebService webService2 = RuntimeModeler.getAnnotation(WebService.class, clazz2, metadataReader);
            if (webService2 == null) {
                throw new RuntimeModelerException("runtime.modeler.endpoint.interface.no.webservice", webService.endpointInterface());
            }
        }
        if ((string2 = (webService = RuntimeModeler.getAnnotation(WebService.class, clazz2, metadataReader)).name()).length() == 0) {
            string2 = clazz2.getSimpleName();
        }
        if (string == null || "".equals(string.trim())) {
            string = webService.targetNamespace();
        }
        if (string.length() == 0) {
            string = RuntimeModeler.getNamespace(clazz2.getPackage().getName());
        }
        if (string == null) {
            throw new RuntimeModelerException("runtime.modeler.no.package", clazz2.getName());
        }
        return new QName(string, string2);
    }

    private ParameterBinding getBinding(String string, String string2, boolean bl, WebParam.Mode mode) {
        if (this.binding == null) {
            if (bl) {
                return ParameterBinding.HEADER;
            }
            return ParameterBinding.BODY;
        }
        QName qName = new QName(this.binding.getBinding().getPortType().getName().getNamespaceURI(), string);
        return this.binding.getBinding().getBinding(qName, string2, mode);
    }

    private WSDLPart getPart(QName qName, String string, WebParam.Mode mode) {
        WSDLBoundOperation wSDLBoundOperation;
        if (this.binding != null && (wSDLBoundOperation = this.binding.getBinding().get(qName)) != null) {
            return wSDLBoundOperation.getPart(string, mode);
        }
        return null;
    }

    private static Boolean getBooleanSystemProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String string2 = System.getProperty(string);
                return string2 != null ? Boolean.valueOf(string2) : Boolean.FALSE;
            }
        });
    }

    private static QName getReturnQName(Method method, WebResult webResult, XmlElement xmlElement) {
        String string = null;
        if (webResult != null && webResult.name().length() > 0) {
            string = webResult.name();
        }
        String string2 = null;
        if (xmlElement != null && !xmlElement.name().equals("##default")) {
            string2 = xmlElement.name();
        }
        if (string2 != null && string != null && !string2.equals(string)) {
            throw new RuntimeModelerException("@XmlElement(name)=" + string2 + " and @WebResult(name)=" + string + " are different for method " + method, new Object[0]);
        }
        String string3 = RETURN;
        if (string != null) {
            string3 = string;
        } else if (string2 != null) {
            string3 = string2;
        }
        String string4 = null;
        if (webResult != null && webResult.targetNamespace().length() > 0) {
            string4 = webResult.targetNamespace();
        }
        String string5 = null;
        if (xmlElement != null && !xmlElement.namespace().equals("##default")) {
            string5 = xmlElement.namespace();
        }
        if (string5 != null && string4 != null && !string5.equals(string4)) {
            throw new RuntimeModelerException("@XmlElement(namespace)=" + string5 + " and @WebResult(targetNamespace)=" + string4 + " are different for method " + method, new Object[0]);
        }
        String string6 = "";
        if (string4 != null) {
            string6 = string4;
        } else if (string5 != null) {
            string6 = string5;
        }
        return new QName(string6, string3);
    }

    private static QName getParameterQName(Method method, WebParam webParam, XmlElement xmlElement, String string) {
        String string2 = null;
        if (webParam != null && webParam.name().length() > 0) {
            string2 = webParam.name();
        }
        String string3 = null;
        if (xmlElement != null && !xmlElement.name().equals("##default")) {
            string3 = xmlElement.name();
        }
        if (string3 != null && string2 != null && !string3.equals(string2)) {
            throw new RuntimeModelerException("@XmlElement(name)=" + string3 + " and @WebParam(name)=" + string2 + " are different for method " + method, new Object[0]);
        }
        String string4 = string;
        if (string2 != null) {
            string4 = string2;
        } else if (string3 != null) {
            string4 = string3;
        }
        String string5 = null;
        if (webParam != null && webParam.targetNamespace().length() > 0) {
            string5 = webParam.targetNamespace();
        }
        String string6 = null;
        if (xmlElement != null && !xmlElement.namespace().equals("##default")) {
            string6 = xmlElement.namespace();
        }
        if (string6 != null && string5 != null && !string6.equals(string5)) {
            throw new RuntimeModelerException("@XmlElement(namespace)=" + string6 + " and @WebParam(targetNamespace)=" + string5 + " are different for method " + method, new Object[0]);
        }
        String string7 = "";
        if (string5 != null) {
            string7 = string5;
        } else if (string6 != null) {
            string7 = string6;
        }
        return new QName(string7, string4);
    }
}

