/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.model.nav;

import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;

class ParameterizedTypeImpl
implements ParameterizedType {
    private Type[] actualTypeArguments;
    private Class<?> rawType;
    private Type ownerType;

    ParameterizedTypeImpl(Class<?> clazz, Type[] typeArray, Type type) {
        this.actualTypeArguments = typeArray;
        this.rawType = clazz;
        this.ownerType = type != null ? type : clazz.getDeclaringClass();
        this.validateConstructorArguments();
    }

    private void validateConstructorArguments() {
        TypeVariable<Class<?>>[] typeVariableArray = this.rawType.getTypeParameters();
        if (typeVariableArray.length != this.actualTypeArguments.length) {
            throw new MalformedParameterizedTypeException();
        }
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object object) {
        if (object instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)object;
            if (this == parameterizedType) {
                return true;
            }
            Type type = parameterizedType.getOwnerType();
            Type type2 = parameterizedType.getRawType();
            return (this.ownerType == null ? type == null : this.ownerType.equals(type)) && (this.rawType == null ? type2 == null : this.rawType.equals(type2)) && Arrays.equals(this.actualTypeArguments, parameterizedType.getActualTypeArguments());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ (this.ownerType == null ? 0 : this.ownerType.hashCode()) ^ (this.rawType == null ? 0 : this.rawType.hashCode());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.ownerType != null) {
            if (this.ownerType instanceof Class) {
                stringBuilder.append(((Class)this.ownerType).getName());
            } else {
                stringBuilder.append(this.ownerType.toString());
            }
            stringBuilder.append(".");
            if (this.ownerType instanceof ParameterizedTypeImpl) {
                stringBuilder.append(this.rawType.getName().replace(((ParameterizedTypeImpl)this.ownerType).rawType.getName() + "$", ""));
            } else {
                stringBuilder.append(this.rawType.getName());
            }
        } else {
            stringBuilder.append(this.rawType.getName());
        }
        if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
            stringBuilder.append("<");
            boolean bl = true;
            for (Type type : this.actualTypeArguments) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                if (type instanceof Class) {
                    stringBuilder.append(((Class)type).getName());
                } else {
                    stringBuilder.append(type.toString());
                }
                bl = false;
            }
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }
}

