/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverterImpl;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBPermission;
import javax.xml.bind.Messages;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public final class DatatypeConverter {
    private static volatile DatatypeConverterInterface theConverter = null;
    private static final JAXBPermission SET_DATATYPE_CONVERTER_PERMISSION = new JAXBPermission("setDatatypeConverter");

    private DatatypeConverter() {
    }

    public static void setDatatypeConverter(DatatypeConverterInterface datatypeConverterInterface) {
        if (datatypeConverterInterface == null) {
            throw new IllegalArgumentException(Messages.format("DatatypeConverter.ConverterMustNotBeNull"));
        }
        if (theConverter == null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(SET_DATATYPE_CONVERTER_PERMISSION);
            }
            theConverter = datatypeConverterInterface;
        }
    }

    private static synchronized void initConverter() {
        theConverter = new DatatypeConverterImpl();
    }

    public static String parseString(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseString(string);
    }

    public static BigInteger parseInteger(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseInteger(string);
    }

    public static int parseInt(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseInt(string);
    }

    public static long parseLong(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseLong(string);
    }

    public static short parseShort(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseShort(string);
    }

    public static BigDecimal parseDecimal(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseDecimal(string);
    }

    public static float parseFloat(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseFloat(string);
    }

    public static double parseDouble(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseDouble(string);
    }

    public static boolean parseBoolean(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseBoolean(string);
    }

    public static byte parseByte(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseByte(string);
    }

    public static QName parseQName(String string, NamespaceContext namespaceContext) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseQName(string, namespaceContext);
    }

    public static Calendar parseDateTime(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseDateTime(string);
    }

    public static byte[] parseBase64Binary(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseBase64Binary(string);
    }

    public static byte[] parseHexBinary(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseHexBinary(string);
    }

    public static long parseUnsignedInt(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseUnsignedInt(string);
    }

    public static int parseUnsignedShort(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseUnsignedShort(string);
    }

    public static Calendar parseTime(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseTime(string);
    }

    public static Calendar parseDate(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseDate(string);
    }

    public static String parseAnySimpleType(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseAnySimpleType(string);
    }

    public static String printString(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printString(string);
    }

    public static String printInteger(BigInteger bigInteger) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printInteger(bigInteger);
    }

    public static String printInt(int n) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printInt(n);
    }

    public static String printLong(long l) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printLong(l);
    }

    public static String printShort(short s) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printShort(s);
    }

    public static String printDecimal(BigDecimal bigDecimal) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printDecimal(bigDecimal);
    }

    public static String printFloat(float f) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printFloat(f);
    }

    public static String printDouble(double d) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printDouble(d);
    }

    public static String printBoolean(boolean bl) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printBoolean(bl);
    }

    public static String printByte(byte by) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printByte(by);
    }

    public static String printQName(QName qName, NamespaceContext namespaceContext) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printQName(qName, namespaceContext);
    }

    public static String printDateTime(Calendar calendar) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printDateTime(calendar);
    }

    public static String printBase64Binary(byte[] byArray) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printBase64Binary(byArray);
    }

    public static String printHexBinary(byte[] byArray) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printHexBinary(byArray);
    }

    public static String printUnsignedInt(long l) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printUnsignedInt(l);
    }

    public static String printUnsignedShort(int n) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printUnsignedShort(n);
    }

    public static String printTime(Calendar calendar) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printTime(calendar);
    }

    public static String printDate(Calendar calendar) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printDate(calendar);
    }

    public static String printAnySimpleType(String string) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printAnySimpleType(string);
    }
}

