/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.xml;

import com.sun.xml.internal.org.jvnet.staxex.NamespaceContextEx;
import com.sun.xml.internal.org.jvnet.staxex.XMLStreamReaderEx;
import com.sun.xml.internal.ws.encoding.TagInfoset;
import com.sun.xml.internal.ws.util.xml.NamespaceContextExAdaper;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLReaderComposite
implements XMLStreamReaderEx {
    protected State state = State.StartTag;
    protected ElemInfo elemInfo;
    protected TagInfoset tagInfo;
    protected XMLStreamReader[] children;
    protected int payloadIndex = -1;
    protected XMLStreamReader payloadReader;

    public XMLReaderComposite(ElemInfo elemInfo, XMLStreamReader[] xMLStreamReaderArray) {
        this.elemInfo = elemInfo;
        this.tagInfo = elemInfo.tagInfo;
        this.children = xMLStreamReaderArray;
        if (this.children != null && this.children.length > 0) {
            this.payloadIndex = 0;
            this.payloadReader = this.children[this.payloadIndex];
        }
    }

    @Override
    public int next() throws XMLStreamException {
        switch (this.state) {
            case StartTag: {
                if (this.payloadReader != null) {
                    this.state = State.Payload;
                    return this.payloadReader.getEventType();
                }
                this.state = State.EndTag;
                return 2;
            }
            case EndTag: {
                return 8;
            }
        }
        int n = 8;
        if (this.payloadReader != null && this.payloadReader.hasNext()) {
            n = this.payloadReader.next();
        }
        if (n != 8) {
            return n;
        }
        if (this.payloadIndex + 1 < this.children.length) {
            ++this.payloadIndex;
            this.payloadReader = this.children[this.payloadIndex];
            return this.payloadReader.getEventType();
        }
        this.state = State.EndTag;
        return 2;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        switch (this.state) {
            case EndTag: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        switch (this.state) {
            case StartTag: {
                if (this.payloadReader.isCharacters()) {
                    return this.payloadReader.getText();
                }
                return "";
            }
        }
        return this.payloadReader.getElementText();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int n = this.next();
        if (n == 8) {
            return n;
        }
        while (n != 8) {
            if (n == 1) {
                return n;
            }
            if (n == 2) {
                return n;
            }
            n = this.next();
        }
        return n;
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.payloadReader != null ? this.payloadReader.getProperty(string) : null;
    }

    @Override
    public void require(int n, String string, String string2) throws XMLStreamException {
        if (this.payloadReader != null) {
            this.payloadReader.require(n, string, string2);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        if (this.payloadReader != null) {
            this.payloadReader.close();
        }
    }

    @Override
    public String getNamespaceURI(String string) {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.elemInfo.getNamespaceURI(string);
            }
        }
        return this.payloadReader.getNamespaceURI(string);
    }

    @Override
    public boolean isStartElement() {
        switch (this.state) {
            case StartTag: {
                return true;
            }
            case EndTag: {
                return false;
            }
        }
        return this.payloadReader.isStartElement();
    }

    @Override
    public boolean isEndElement() {
        switch (this.state) {
            case StartTag: {
                return false;
            }
            case EndTag: {
                return true;
            }
        }
        return this.payloadReader.isEndElement();
    }

    @Override
    public boolean isCharacters() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return false;
            }
        }
        return this.payloadReader.isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return false;
            }
        }
        return this.payloadReader.isWhiteSpace();
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.atts.getValue(string, string2);
            }
        }
        return this.payloadReader.getAttributeValue(string, string2);
    }

    @Override
    public int getAttributeCount() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.atts.getLength();
            }
        }
        return this.payloadReader.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int n) {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return new QName(this.tagInfo.atts.getURI(n), this.tagInfo.atts.getLocalName(n), XMLReaderComposite.getPrfix(this.tagInfo.atts.getQName(n)));
            }
        }
        return this.payloadReader.getAttributeName(n);
    }

    @Override
    public String getAttributeNamespace(int n) {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.atts.getURI(n);
            }
        }
        return this.payloadReader.getAttributeNamespace(n);
    }

    @Override
    public String getAttributeLocalName(int n) {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.atts.getLocalName(n);
            }
        }
        return this.payloadReader.getAttributeLocalName(n);
    }

    @Override
    public String getAttributePrefix(int n) {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return XMLReaderComposite.getPrfix(this.tagInfo.atts.getQName(n));
            }
        }
        return this.payloadReader.getAttributePrefix(n);
    }

    private static String getPrfix(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        return n > 0 ? string.substring(0, n) : "";
    }

    @Override
    public String getAttributeType(int n) {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.atts.getType(n);
            }
        }
        return this.payloadReader.getAttributeType(n);
    }

    @Override
    public String getAttributeValue(int n) {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.atts.getValue(n);
            }
        }
        return this.payloadReader.getAttributeValue(n);
    }

    @Override
    public boolean isAttributeSpecified(int n) {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return n < this.tagInfo.atts.getLength() ? this.tagInfo.atts.getLocalName(n) != null : false;
            }
        }
        return this.payloadReader.isAttributeSpecified(n);
    }

    @Override
    public int getNamespaceCount() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.ns.length / 2;
            }
        }
        return this.payloadReader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int n) {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.ns[2 * n];
            }
        }
        return this.payloadReader.getNamespacePrefix(n);
    }

    @Override
    public String getNamespaceURI(int n) {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.ns[2 * n + 1];
            }
        }
        return this.payloadReader.getNamespaceURI(n);
    }

    @Override
    public NamespaceContextEx getNamespaceContext() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return new NamespaceContextExAdaper(this.elemInfo);
            }
        }
        return this.isPayloadReaderEx() ? this.payloadReaderEx().getNamespaceContext() : new NamespaceContextExAdaper(this.payloadReader.getNamespaceContext());
    }

    private boolean isPayloadReaderEx() {
        return this.payloadReader instanceof XMLStreamReaderEx;
    }

    private XMLStreamReaderEx payloadReaderEx() {
        return (XMLStreamReaderEx)this.payloadReader;
    }

    @Override
    public int getEventType() {
        switch (this.state) {
            case StartTag: {
                return 1;
            }
            case EndTag: {
                return 2;
            }
        }
        return this.payloadReader.getEventType();
    }

    @Override
    public String getText() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return null;
            }
        }
        return this.payloadReader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return null;
            }
        }
        return this.payloadReader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return -1;
            }
        }
        return this.payloadReader.getTextCharacters(n, cArray, n2, n3);
    }

    @Override
    public int getTextStart() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return 0;
            }
        }
        return this.payloadReader.getTextStart();
    }

    @Override
    public int getTextLength() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return 0;
            }
        }
        return this.payloadReader.getTextLength();
    }

    @Override
    public String getEncoding() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return null;
            }
        }
        return this.payloadReader.getEncoding();
    }

    @Override
    public boolean hasText() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return false;
            }
        }
        return this.payloadReader.hasText();
    }

    @Override
    public Location getLocation() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return new Location(){

                    @Override
                    public int getLineNumber() {
                        return 0;
                    }

                    @Override
                    public int getColumnNumber() {
                        return 0;
                    }

                    @Override
                    public int getCharacterOffset() {
                        return 0;
                    }

                    @Override
                    public String getPublicId() {
                        return null;
                    }

                    @Override
                    public String getSystemId() {
                        return null;
                    }
                };
            }
        }
        return this.payloadReader.getLocation();
    }

    @Override
    public QName getName() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return new QName(this.tagInfo.nsUri, this.tagInfo.localName, this.tagInfo.prefix);
            }
        }
        return this.payloadReader.getName();
    }

    @Override
    public String getLocalName() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.localName;
            }
        }
        return this.payloadReader.getLocalName();
    }

    @Override
    public boolean hasName() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return true;
            }
        }
        return this.payloadReader.hasName();
    }

    @Override
    public String getNamespaceURI() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.nsUri;
            }
        }
        return this.payloadReader.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return this.tagInfo.prefix;
            }
        }
        return this.payloadReader.getPrefix();
    }

    @Override
    public String getVersion() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return null;
            }
        }
        return this.payloadReader.getVersion();
    }

    @Override
    public boolean isStandalone() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return true;
            }
        }
        return this.payloadReader.isStandalone();
    }

    @Override
    public boolean standaloneSet() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return true;
            }
        }
        return this.payloadReader.standaloneSet();
    }

    @Override
    public String getCharacterEncodingScheme() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return null;
            }
        }
        return this.payloadReader.getCharacterEncodingScheme();
    }

    @Override
    public String getPITarget() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return null;
            }
        }
        return this.payloadReader.getPITarget();
    }

    @Override
    public String getPIData() {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return null;
            }
        }
        return this.payloadReader.getPIData();
    }

    @Override
    public String getElementTextTrim() throws XMLStreamException {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return null;
            }
        }
        return this.isPayloadReaderEx() ? this.payloadReaderEx().getElementTextTrim() : this.payloadReader.getElementText().trim();
    }

    @Override
    public CharSequence getPCDATA() throws XMLStreamException {
        switch (this.state) {
            case StartTag: 
            case EndTag: {
                return null;
            }
        }
        return this.isPayloadReaderEx() ? this.payloadReaderEx().getPCDATA() : this.payloadReader.getElementText();
    }

    public static class ElemInfo
    implements NamespaceContext {
        ElemInfo ancestor;
        TagInfoset tagInfo;

        public ElemInfo(TagInfoset tagInfoset, ElemInfo elemInfo) {
            this.tagInfo = tagInfoset;
            this.ancestor = elemInfo;
        }

        @Override
        public String getNamespaceURI(String string) {
            String string2 = this.tagInfo.getNamespaceURI(string);
            return string2 != null ? string2 : (this.ancestor != null ? this.ancestor.getNamespaceURI(string) : null);
        }

        @Override
        public String getPrefix(String string) {
            String string2 = this.tagInfo.getPrefix(string);
            return string2 != null ? string2 : (this.ancestor != null ? this.ancestor.getPrefix(string) : null);
        }

        public List<String> allPrefixes(String string) {
            List<String> list = this.tagInfo.allPrefixes(string);
            if (this.ancestor != null) {
                List<String> list2 = this.ancestor.allPrefixes(string);
                list2.addAll(list);
                return list2;
            }
            return list;
        }

        @Override
        public Iterator<String> getPrefixes(String string) {
            return this.allPrefixes(string).iterator();
        }
    }

    public static enum State {
        StartTag,
        Payload,
        EndTag;

    }
}

