/*
 * Decompiled with CFR 0.152.
 */
import com.eg.ConnectionThread;
import com.eg.EgInstallInfo;
import com.eg.EgManagerObject;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class EgCheckUpgradeThread {
    public static boolean upgradeThreadStarted = false;
    public static EgCheckUpgradeThread thread = null;
    public String installDir = "";
    public String errorLogLoc = "";
    public String egAgentAutoUpgradeOut = "";
    public String strManagerIniLoc = "";
    public String urlString = "";
    public String packageName = "";
    public String packageID = "";
    public String filePath = "";
    private boolean isAuthenticationRequired = false;
    private String proxyUserName = null;
    private String proxyPassword = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String sslFlag = null;
    private boolean highSecurity = false;
    private int targetCounter = 288;

    public EgCheckUpgradeThread(String string) {
        this.installDir = string;
        this.errorLogLoc = string + "/logs/error_log";
        this.egAgentAutoUpgradeOut = string + "/logs/VmAutoUpgradelog.log";
        this.strManagerIniLoc = string + "/lib/eg_manager.ini";
        File file = new File(this.strManagerIniLoc);
        if (!file.exists()) {
            this.strManagerIniLoc = string + "/lib/eg_managersetup.ini";
        }
    }

    public void checkUpgrade() {
        System.setProperty("https.protocols", "SSLv3,TLSv1,TLSv1.1,TLSv1.2");
        Properties properties = EgManagerObject.loadEgManagerIniFile(this.strManagerIniLoc);
        if (properties != null && properties.size() > 0) {
            Random random;
            String string = properties.getProperty("StartUpgradeProcessAt");
            String string2 = properties.getProperty("UpgradeCounter");
            int n = 0;
            int n2 = 0;
            String string3 = "0";
            if (string != null && string.length() > 0) {
                string3 = string;
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {}
            } else {
                random = new Random();
                string3 = new Integer(random.nextInt(this.targetCounter)).toString();
            }
            if (string2 != null && string2.length() > 0) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n == ++n2) {
                this.startUpgrade();
                random = new Random();
                string3 = new Integer(random.nextInt(this.targetCounter)).toString();
                properties = null;
            }
            if (n2 > this.targetCounter) {
                n2 = 0;
            }
            if (properties == null) {
                properties = EgManagerObject.loadEgManagerIniFile(this.strManagerIniLoc);
            }
            properties.setProperty("UpgradeCounter", n2 + "");
            properties.setProperty("StartUpgradeProcessAt", string3);
            EgManagerObject.storeEgManagerIniFile(properties, this.strManagerIniLoc);
            properties = null;
        }
    }

    public void startUpgrade() {
        Properties properties = EgManagerObject.loadEgManagerIniFile(this.strManagerIniLoc);
        if (properties != null && properties.size() > 0) {
            EgVmAgentPackageInstaller egVmAgentPackageInstaller;
            this.urlString = properties.getProperty("url");
            String string = properties.getProperty("IsAuthenticationRequired");
            this.isAuthenticationRequired = string != null && string.equalsIgnoreCase("true");
            String string2 = properties.getProperty("HighSecurity");
            this.highSecurity = string2 != null && string2.equalsIgnoreCase("true");
            this.sslFlag = properties.getProperty("isSSL");
            this.enableSSL();
            String string3 = properties.getProperty("IsProxySet");
            if (string3 != null && string3.equalsIgnoreCase("true")) {
                this.proxyHost = properties.getProperty("ProxyHost");
                this.proxyPort = properties.getProperty("ProxyPort");
                if (!(this.proxyHost == null || this.proxyPort == null || this.proxyHost.equalsIgnoreCase("none") || this.proxyHost.equalsIgnoreCase("null") || this.proxyPort.equalsIgnoreCase("null") || this.proxyPort.equalsIgnoreCase("none"))) {
                    boolean bl = this.setProxy(this.proxyHost, this.proxyPort);
                }
                if (this.isAuthenticationRequired) {
                    this.proxyUserName = properties.getProperty("ProxyUser");
                    this.proxyPassword = properties.getProperty("ProxyPassword");
                    if (this.proxyUserName != null && this.proxyPassword != null) {
                        Authenticator.setDefault(new Authenticator(){

                            protected PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(EgCheckUpgradeThread.this.proxyUserName, EgCheckUpgradeThread.this.proxyPassword.toCharArray());
                            }
                        });
                    }
                }
            }
            if (this.connectAndDownloadUpgradePack() && !(egVmAgentPackageInstaller = new EgVmAgentPackageInstaller(this.filePath, this.installDir, this.packageID)).installThePackage()) {
                egVmAgentPackageInstaller.writeToVmAgentAutoUpgradeLog("INFO ", "EgVmAgentPackageInstaller : Installation failed", "");
                egVmAgentPackageInstaller.logToErrorFile("ERROR", "EgVmAgentPackageInstaller", "Installation Failed");
            }
        }
    }

    public void threadSleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean connectAndDownloadUpgradePack() {
        URL uRL = null;
        Properties properties = EgManagerObject.loadEgManagerIniFile(this.strManagerIniLoc);
        String string = properties.getProperty("LastUpgradedID");
        properties = null;
        HttpURLConnection httpURLConnection = null;
        try {
            uRL = new URL(this.urlString + "/com.eg.VMUpgradeServlet");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        try {
            httpURLConnection = this.getConnection(uRL);
            if (httpURLConnection == null) {
                this.writeToVmAgentAutoUpgradeLog("EgCheckUpgradeThread : Unable to connect the eG manager...");
                return false;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("1");
            if (string == null || string.length() == 0 || string.equalsIgnoreCase("null")) {
                string = "NONE";
            }
            arrayList.add(string);
            arrayList.add(System.getProperty("os.name"));
            arrayList.add(EgInstallInfo.getAgentVersion());
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false, null, false, arrayList, null, 0);
            boolean bl = this.checkForTimeout(connectionThread, true);
            int n = 0;
            if (bl) {
                n = connectionThread.code;
            }
            if (n == 200) {
                if (this.getFile(httpURLConnection) == 0) {
                    httpURLConnection.disconnect();
                    return true;
                }
                httpURLConnection.disconnect();
                return false;
            }
            httpURLConnection.disconnect();
            return false;
        }
        catch (Exception exception) {
            this.writeToErrorLog("INFO", "Exception", exception.toString());
            exception.printStackTrace();
            return false;
        }
    }

    private int getFile(HttpURLConnection httpURLConnection) {
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            inputStream = httpURLConnection.getInputStream();
            if (inputStream == null) {
                return 1;
            }
            byte[] byArray = new byte[4];
            filterInputStream = new DataInputStream(inputStream);
            ((DataInputStream)filterInputStream).read(byArray);
            String string = new String(byArray);
            if (string.equals("RC02")) {
                this.writeToVmAgentAutoUpgradeLog("No package to upgrade");
                return 1;
            }
            if (string.equals("RC01")) {
                this.writeToVmAgentAutoUpgradeLog("Attempt to download upgrade package has resulted in an error code of " + string);
                return 1;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(new String(byArray));
            byArray = new byte[1];
            while (true) {
                ((DataInputStream)filterInputStream).read(byArray);
                if (new String(byArray).equals("$")) break;
                stringBuffer.append(new String(byArray));
            }
            this.packageName = stringBuffer.toString();
            StringBuffer stringBuffer2 = new StringBuffer();
            byte[] byArray2 = new byte[1];
            while (true) {
                ((DataInputStream)filterInputStream).read(byArray2);
                if (new String(byArray2).equals("$")) break;
                stringBuffer2.append(new String(byArray2));
            }
            this.packageID = stringBuffer2.toString();
            this.writeToVmAgentAutoUpgradeLog("Going to download " + this.packageName);
            File file = new File(this.installDir + System.getProperty("file.separator") + this.packageName);
            this.filePath = file.getAbsolutePath();
            fileOutputStream = new FileOutputStream(file);
            int n = 0;
            while ((n = filterInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileOutputStream.close();
            filterInputStream.close();
            this.writeToVmAgentAutoUpgradeLog("File has been downloaded and is available for install");
            return 0;
        }
        catch (Exception exception) {
            System.out.println(exception);
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            exception.printStackTrace();
            return 1;
        }
    }

    public boolean setProxy(String string, String string2) {
        boolean bl = false;
        if (this.sslFlag == null || this.sslFlag.equals("false")) {
            String string3 = null;
            String string4 = null;
            String string5 = null;
            try {
                string3 = (String)System.getProperties().get("proxySet");
                string4 = (String)System.getProperties().get("proxyHost");
                string5 = (String)System.getProperties().get("proxyPort");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                System.getProperties().put("proxySet", "true");
                System.getProperties().put("proxyHost", string);
                System.getProperties().put("proxyPort", string2);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
                exception.printStackTrace();
                System.getProperties().put("proxySet", string3);
                System.getProperties().put("proxyHost", string4);
                System.getProperties().put("proxyPort", string5);
            }
        } else {
            String string6 = null;
            String string7 = null;
            String string8 = null;
            try {
                string7 = (String)System.getProperties().get("https.proxyHost");
                string8 = (String)System.getProperties().get("https.proxyPort");
                string6 = (String)System.getProperties().get("https.proxySet");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                System.getProperties().put("https.proxySet", "true");
                System.getProperties().put("https.proxyHost", string);
                System.getProperties().put("https.proxyPort", string2);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
                exception.printStackTrace();
                System.getProperties().put("https.proxySet", string6);
                System.getProperties().put("https.proxyHost", string7);
                System.getProperties().put("https.proxyPort", string8);
            }
        }
        return bl;
    }

    private void enableSSL() {
        if (this.sslFlag != null && this.sslFlag.equalsIgnoreCase("true")) {
            EgVmagentSSL egVmagentSSL = EgVmagentSSL.getInstance();
            egVmagentSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var3_3 = null;
            if (!this.highSecurity) {
                try {
                    MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                    KeyManager[] keyManagerArray = null;
                    TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                    SSLContext sSLContext = SSLContext.getInstance("SSL");
                    sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                    SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                    HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                    HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeToErrorLog(String string, String string2, String string3) {
        PrintWriter printWriter = null;
        String string4 = "";
        File file = new File(this.errorLogLoc);
        if (file.exists() && file.length() >= 1000000L) {
            EgManagerObject.fileRename(this.errorLogLoc, this.errorLogLoc + ".1");
        }
        try {
            printWriter = new PrintWriter(new FileWriter(this.errorLogLoc, true));
            string4 = new String(new Date() + " " + string + " " + string2 + string3);
            printWriter.println(string4);
        }
        catch (Exception exception) {
            System.err.println("writeToErrorLog: Cannot open log file ");
            return;
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void writeToVmAgentAutoUpgradeLog(String string) {
        PrintWriter printWriter;
        String string2 = String.valueOf(new Date());
        File file = new File(this.egAgentAutoUpgradeOut);
        if (file.exists() && file.length() >= 1000000L) {
            EgManagerObject.fileRename(this.egAgentAutoUpgradeOut, this.egAgentAutoUpgradeOut + ".1");
        }
        try {
            printWriter = new PrintWriter(new FileWriter(this.egAgentAutoUpgradeOut, true));
        }
        catch (Exception exception) {
            System.err.println("writeToVmAgentAutoUpgradeLog: Cannot open log file ");
            return;
        }
        printWriter.println(string2 + " : " + string);
        printWriter.close();
    }

    private HttpURLConnection getConnection(URL uRL) {
        HttpURLConnection httpURLConnection = null;
        try {
            int n;
            if (this.proxyHost != null && this.proxyHost.length() > 0) {
                n = 0;
                try {
                    if (this.proxyPort != null) {
                        n = Integer.parseInt(this.proxyPort.trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.proxyHost, n);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            n = 0;
            httpURLConnection.setRequestProperty("Content-length", "" + n);
        }
        catch (Exception exception) {
            httpURLConnection = null;
            System.out.println("Exception occured while getting HTTP connection for the URL :" + uRL);
            this.writeToVmAgentAutoUpgradeLog("Exception occured while getting HTTP connection for the URL :" + uRL);
            exception.printStackTrace();
        }
        return httpURLConnection;
    }

    public boolean checkForTimeout(ConnectionThread connectionThread, boolean bl) {
        long l;
        long l2 = 60000L;
        long l3 = 1L * l2;
        long l4 = l3;
        long l5 = l2 * 3L;
        if (l4 < l5) {
            l4 = l5;
        }
        long l6 = 0L;
        long l7 = 250L;
        do {
            long l8 = System.currentTimeMillis();
            this.suspendForPeriod(l7);
            if (connectionThread.done) {
                return true;
            }
            long l9 = System.currentTimeMillis();
            long l10 = l9 - l8;
            if ((l6 += l10) >= l4 || l10 < 0L) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l7;
            if (l4 - l6 >= l) continue;
            l = l4 - l6;
        } while ((l7 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        EgCheckUpgradeThread egCheckUpgradeThread = new EgCheckUpgradeThread("C:\\eGVmAgent");
        egCheckUpgradeThread.checkUpgrade();
        egCheckUpgradeThread.writeToErrorLog("INFO", "eGVm Upgrade Thread has been started", "");
    }
}

