/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import java.util.ArrayList;

public class SystemInfo {
    public static String syncString = new String("SystemInfo");
    private static SystemInfo systemInfoObj = null;
    private static String object1 = "Memory";
    private static String object2 = "System";
    private static String object3 = "Processor";
    private static String object4 = "Process";
    private static String[] counters1 = new String[]{"Committed Bytes", "Available Bytes", "Pages/sec"};
    private static String[] counters2 = new String[]{"Processor Queue Length"};
    private static String[] counters3 = new String[]{"% Processor Time", "% User Time"};
    private static String[] counters4 = new String[]{"% Processor Time"};
    private ArrayList outputList = new ArrayList();
    private ArrayList outList = new ArrayList();
    private ArrayList errList = new ArrayList();
    private double[] values1 = null;
    private double[] values2 = null;
    private double[][] values3 = null;
    private double[][] values4 = null;
    private static String[] instances3 = null;
    private String[] instances4 = new String[]{"Idle", "System"};
    private EgPerfInstrumentation egPerfUtil1 = null;
    private EgPerfInstrumentation egPerfUtil2 = null;
    private EgPerfInstrumentation egPerfUtil3 = null;
    private EgPerfInstrumentation egPerfUtil4 = null;
    private static long nextDiscoverTime = -1L;
    private static long reDiscoverTime = 900000L;
    private static long lastRunTime = 0L;
    private static long cachePeriod = 10000L;
    private static ArrayList lastResults = new ArrayList();

    private SystemInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemInfo getInstance() {
        if (systemInfoObj == null) {
            String string = syncString;
            synchronized (string) {
                if (systemInfoObj == null) {
                    systemInfoObj = new SystemInfo();
                }
            }
        }
        return systemInfoObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getSystemInfoData() {
        String string = syncString;
        synchronized (string) {
            String string2;
            long l = System.currentTimeMillis();
            if (l - lastRunTime < cachePeriod && lastResults != null) {
                return lastResults;
            }
            this.outputList = new ArrayList();
            this.outList = new ArrayList();
            this.errList = new ArrayList();
            this.outputList.add(this.outList);
            this.outputList.add(this.errList);
            int n = this.getNoOfProcessors();
            this.outList.add("NumberOfProcessors##=" + n);
            if (this.egPerfUtil1 == null) {
                this.egPerfUtil1 = new EgPerfInstrumentation();
            }
            this.values1 = this.egPerfUtil1.getCounterValue(object1, counters1);
            if (this.values1 == null || this.values1.length < 3) {
                this.stopTest1();
            } else {
                string2 = "Memory##=" + this.values1[0] + "#" + this.values1[1] + "#" + this.values1[2];
                this.outList.add(string2);
            }
            if (this.egPerfUtil2 == null) {
                this.egPerfUtil2 = new EgPerfInstrumentation();
            }
            this.values2 = this.egPerfUtil2.getCounterValue(object2, counters2);
            if (this.values2 == null || this.values2.length == 0) {
                this.stopTest2();
            } else {
                string2 = "System##=" + this.values2[0];
                this.outList.add(string2);
            }
            long l2 = System.currentTimeMillis();
            if (nextDiscoverTime < 0L || instances3 == null || l2 - nextDiscoverTime >= reDiscoverTime) {
                instances3 = EgPerfInstrumentation.discoverInstances(object3);
                nextDiscoverTime = l2 + SystemInfo.getNextPeriod(reDiscoverTime);
            }
            if (instances3 != null && instances3.length > 0) {
                if (this.egPerfUtil3 == null) {
                    this.egPerfUtil3 = new EgPerfInstrumentation();
                }
                this.values3 = this.egPerfUtil3.getCounterValue(object3, instances3, counters3);
                if (this.values3 == null || this.values3.length == 0) {
                    this.stopTest3();
                    instances3 = null;
                } else {
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    int n2 = instances3.length;
                    for (int i = 0; i < n2; ++i) {
                        if (instances3[i].equalsIgnoreCase("_Total")) continue;
                        String string3 = "Processor##" + instances3[i] + "=" + this.values3[i][0] + "#" + this.values3[i][1];
                        this.outList.add(string3);
                        d += this.values3[i][0];
                        d2 += this.values3[i][1];
                        d3 += 1.0;
                    }
                    if (d3 > 0.0) {
                        String string4 = "Processor##_Total=" + (d /= d3) + "#" + (d2 /= d3);
                        this.outList.add(string4);
                    }
                }
            }
            if (this.egPerfUtil4 == null) {
                this.egPerfUtil4 = new EgPerfInstrumentation();
            }
            this.values4 = this.egPerfUtil4.getCounterValue(object4, this.instances4, counters4);
            if (this.values4 == null || this.values4.length == 0) {
                this.stopTest4();
            } else {
                int n3 = this.instances4.length;
                for (int i = 0; i < n3; ++i) {
                    String string5 = "Process##" + this.instances4[i] + "=" + this.values4[i][0];
                    this.outList.add(string5);
                }
            }
            this.outputList.set(0, this.outList);
            lastResults = this.outputList;
            lastRunTime = System.currentTimeMillis();
            return this.outputList;
        }
    }

    private int getNoOfProcessors() {
        int n = 1;
        try {
            String string = System.getenv("NUMBER_OF_PROCESSORS");
            if (string != null && string.trim().length() > 0) {
                n = Integer.parseInt(string.trim());
            }
        }
        catch (Exception exception) {
            n = 1;
        }
        return n;
    }

    public static double getRandom() {
        long l = System.currentTimeMillis();
        double d = (double)(l % 1000L) * 0.001;
        if (d < 0.1) {
            d = 0.1;
        }
        return d;
    }

    public static long getNextPeriod(long l) {
        double d = 2.0;
        double d2 = 0.5;
        double d3 = (double)l * d;
        double d4 = (double)l * d2;
        return (long)(d4 + SystemInfo.getRandom() * (d3 - d4));
    }

    private void stopTest1() {
        if (this.egPerfUtil1 != null) {
            this.egPerfUtil1.stop();
        }
        this.egPerfUtil1 = null;
    }

    private void stopTest2() {
        if (this.egPerfUtil2 != null) {
            this.egPerfUtil2.stop();
        }
        this.egPerfUtil2 = null;
    }

    private void stopTest3() {
        if (this.egPerfUtil3 != null) {
            this.egPerfUtil3.stop();
        }
        this.egPerfUtil3 = null;
    }

    private void stopTest4() {
        if (this.egPerfUtil4 != null) {
            this.egPerfUtil4.stop();
        }
        this.egPerfUtil4 = null;
    }

    public static void main(String[] stringArray) {
        Object object;
        SystemInfo systemInfo = SystemInfo.getInstance();
        if (stringArray.length == 0) {
            try {
                object = System.getenv("EGVMAGENT_INSTALL_DIR");
                if (object != null && ((String)object).trim().length() > 0) {
                    EgInstallInfo.setInstallDir((String)object);
                }
            }
            catch (Exception exception) {}
        } else {
            EgInstallInfo.setInstallDir(stringArray[0]);
        }
        object = systemInfo.getSystemInfoData();
        System.out.println(object);
    }
}

