/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import java.util.ArrayList;

public class WinNetworkTraffic {
    public static String syncString = new String("WinNetworkTraffic");
    private static WinNetworkTraffic winNetworkTrafficObj = null;
    private static String object = "Network Interface";
    private static String[] counters = new String[]{"Bytes Received/sec", "Bytes Sent/sec", "Bytes Total/sec", "Current Bandwidth", "Output Queue Length", "Packets Outbound Errors", "Packets Received Errors"};
    private ArrayList outputList = new ArrayList();
    private ArrayList outList = new ArrayList();
    private ArrayList errList = new ArrayList();
    private static String[] instances = null;
    private double[][] values = null;
    private EgPerfInstrumentation egPerfUtil = null;
    private static long nextDiscoverTime = -1L;
    private static long reDiscoverTime = 900000L;
    private static long lastRunTime = 0L;
    private static long cachePeriod = 10000L;
    private static ArrayList lastResults = new ArrayList();

    private WinNetworkTraffic() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WinNetworkTraffic getInstance() {
        if (winNetworkTrafficObj == null) {
            String string = syncString;
            synchronized (string) {
                if (winNetworkTrafficObj == null) {
                    winNetworkTrafficObj = new WinNetworkTraffic();
                }
            }
        }
        return winNetworkTrafficObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getWinNetworkTrafficData() {
        String string = syncString;
        synchronized (string) {
            long l = System.currentTimeMillis();
            if (l - lastRunTime < cachePeriod && lastResults != null) {
                return lastResults;
            }
            this.outputList = new ArrayList();
            this.outList = new ArrayList();
            this.errList = new ArrayList();
            this.outputList.add(this.outList);
            this.outputList.add(this.errList);
            long l2 = System.currentTimeMillis();
            if (nextDiscoverTime < 0L || instances == null || l2 - nextDiscoverTime >= reDiscoverTime) {
                instances = EgPerfInstrumentation.discoverInstances(object);
                nextDiscoverTime = l2 + WinNetworkTraffic.getNextPeriod(reDiscoverTime);
            }
            if (instances == null || instances.length == 0) {
                lastResults = this.outputList;
                lastRunTime = System.currentTimeMillis();
                return this.outputList;
            }
            if (this.egPerfUtil == null) {
                this.egPerfUtil = new EgPerfInstrumentation();
            }
            this.values = this.egPerfUtil.getCounterValue(object, instances, counters);
            if (this.values == null || this.values.length == 0) {
                this.stopTest();
                instances = null;
                lastResults = this.outputList;
                lastRunTime = System.currentTimeMillis();
                return this.outputList;
            }
            int n = instances.length;
            for (int i = 0; i < n; ++i) {
                String string2 = instances[i] + "=" + this.values[i][0] + "#" + this.values[i][1] + "#" + this.values[i][2] + "#" + this.values[i][3] + "#" + this.values[i][4] + "#" + this.values[i][5] + "#" + this.values[i][6];
                this.outList.add(string2);
            }
            this.outputList.set(0, this.outList);
            lastResults = this.outputList;
            lastRunTime = System.currentTimeMillis();
            return this.outputList;
        }
    }

    public static double getRandom() {
        long l = System.currentTimeMillis();
        double d = (double)(l % 1000L) * 0.001;
        if (d < 0.1) {
            d = 0.1;
        }
        return d;
    }

    public static long getNextPeriod(long l) {
        double d = 2.0;
        double d2 = 0.5;
        double d3 = (double)l * d;
        double d4 = (double)l * d2;
        return (long)(d4 + WinNetworkTraffic.getRandom() * (d3 - d4));
    }

    private void stopTest() {
        if (this.egPerfUtil != null) {
            this.egPerfUtil.stop();
        }
        this.egPerfUtil = null;
    }

    public static void main(String[] stringArray) {
        Object object;
        WinNetworkTraffic winNetworkTraffic = WinNetworkTraffic.getInstance();
        if (stringArray.length == 0) {
            try {
                object = System.getenv("EGVMAGENT_INSTALL_DIR");
                if (object != null && ((String)object).trim().length() > 0) {
                    EgInstallInfo.setInstallDir((String)object);
                }
            }
            catch (Exception exception) {}
        } else {
            EgInstallInfo.setInstallDir(stringArray[0]);
        }
        object = winNetworkTraffic.getWinNetworkTrafficData();
        System.out.println(object);
    }
}

