<%
/*******************************************************************************
*   Name                        :   getDataForMaintenanceAnalysis.jsp
*   Purpose                 :   To analyze maintenance periods
*   Version                     :   4.3
*   Created                 :   15.09.2008
*   Author                      :   Antony & Team
*   Design Changes  :   Jaiwin
*******************************************************************************/
%>

<%@	taglib prefix =	"egui" uri = "../../../WEB-INF/eg-taglib.tld"	%>
<%@ include file= "../../EgTrackerAJSON.jsp"%>
<%@ page import = "com.egurkha.admin.*" %>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page language="java" contentType="application/json;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import="java.text.SimpleDateFormat"%>
<%@ page import="net.sf.json.JSONArray"%>
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	String  param=request.getParameter("from");
	String  option=request.getParameter("option");
	if(session.getAttribute("paramForAnalysis")!=null)
	{
		session.removeAttribute("paramForAnalysis");
	}
	session.setAttribute("paramForAnalysis",request.getQueryString());
	session.setAttribute("paramforTab","Initial");
	String sessionIDStr = session.getId();
	String userID = (String)session.getAttribute("sess_userid");
	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionIDStr,userID);
	String  opt=request.getParameter("opt");
	String element=request.getParameter("element");
	String testElement=request.getParameter("testElement");
	String descElement=request.getParameter("descName");
	String day=request.getParameter("day");
	String startDate=request.getParameter("startDate");
	String endDate=request.getParameter("endDate");
	String  search=request.getParameter("searchStr");
    
	/*  Date and time start*/

	IniFile iniUI = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	String cDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");			
	User usr = UserRegistry.getInstance().getUser(session.getId());
	String userDtFormat = usr.getUserDateFormat();
	if(userDtFormat != null && userDtFormat.length() > 0)
	{
		if(userDtFormat.equalsIgnoreCase("default"))
			userDtFormat = cDateFormat;
	}
	String currentDateFormat_script=cDateFormat;
    String tmpStDate="";
	String tmpEndDate="";
	String tmpStartHr="";
	String tmpEndHr="";
    EgDateInfo date = new EgDateInfo();
	//String dateeee = date.egetDate().substring(0,10);
	String timeNow = date.egetDate().substring(11);
	TimelineServlet ahb = new TimelineServlet(request);
	String comFormat_new="";
	if(DateUtil.isDate(ahb.getEndDate(),"MM/dd/yyyy"))
	{
		comFormat_new = "MM/dd/yyyy";
	}
	else
	{
		comFormat_new = cDateFormat;
	}
	String dispDate = DateUtil.changeDateFormat(ahb.getEndDate(),comFormat_new,cDateFormat);
	com.egurkha.EgTimeZoneConverter egt = new com.egurkha.EgTimeZoneConverter(dispDate+" "+timeNow,_user);
	tmpStDate=egt.getDate(false).toString();
	tmpStartHr=egt.getHour().toString();
	//rootJson.put("startMin",egt.getMinute());
	if(DateUtil.isDate(ahb.getEndDate(),"MM/dd/yyyy"))
	{
		comFormat_new = "MM/dd/yyyy";
	}
	else
	{
		comFormat_new = cDateFormat;
	}
	long value=Long.parseLong("24");
	SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
	value = (24 * 3600);
	Date today = new Date();
	Date start = new Date();
	start.setTime(today.getTime() + (value * 1000));
	dispDate = sdf.format(start);
	dispDate = DateUtil.changeDateFormat(dispDate,comFormat_new,cDateFormat);

	egt = new com.egurkha.EgTimeZoneConverter(dispDate+" "+timeNow,_user);
	tmpEndDate=egt.getDate(false).toString();
	tmpEndHr=egt.getHour().toString();
	//rootJson.put("endMin",egt.getMinute());

   /* End */  

	if(startDate==null || startDate.equals("null"))
		startDate="";
	if(endDate==null || endDate.equals("null"))
		endDate="";
	String startHr=request.getParameter("startHr");
	String endHr=request.getParameter("endHr");
    
	if(startHr==null || startHr.equals("null"))
		startHr="";
	if(endHr==null || endHr.equals("null"))
		endHr="";

	if(search==null || search.equals("null"))
		search="";
	ErUtils erutils=new ErUtils();
	EgMaintenanceUtility egM=new EgMaintenanceUtility(session.getId(),usr.getLoginID());
	String[]  elements={"All","Host","Component","Test","Descriptor","Descriptor For Component","Test For Host","Test For Component","Policy","Time Constraints"};
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	boolean isLimitedAdmin = false;// Limited admin
	if (!roleInfo.hasAllComponentAccess())
	{
		isLimitedAdmin = true;
	}
	IniFile maintenanceIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_maintenance.ini",true);
	String showHostForLimitedAdmin = maintenanceIni.getValue("MISC_ARGS", "showHostForLimitedAdmin");
	boolean isHostEnableForLimitedAdmin = false;
	
	if(showHostForLimitedAdmin != null && showHostForLimitedAdmin.equalsIgnoreCase("yes")){
		isHostEnableForLimitedAdmin = true;
	}
	
	if (isLimitedAdmin) 
	{
		if(isHostEnableForLimitedAdmin){
			elements = new String[]{"All","Host","Component","Test","Descriptor","Test For Host","Test For Component","Descriptor For Component","Policy","Time Constraints"};
		} else {
			elements = new String[]{"All","Component","Test","Descriptor","Test For Host","Test For Component","Descriptor For Component","Policy","Time Constraints"};
		}
	}
	
	Vector limitedUserCompsWithoutType = new Vector();
	if (isLimitedAdmin) // Limited admin
	{
		limitedUserCompsWithoutType = roleInfo.getAllServersWithoutType();
	}
	List al=Arrays.asList(elements);
	Vector  options=new Vector();
	options.addAll(al);
	Vector analysisOptions=null;
	Vector timeVal=null;
	String selectLabel="";
	Vector testElements=new Vector();
	Vector descElements=new Vector();
	Vector mappedDescElements=new Vector();
	Vector compNameForUI = new Vector();
	String[]  daysDisplay={"Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"};
	List all=Arrays.asList(daysDisplay);
	Vector  display=new Vector();
	display.addAll(all);
	String[]  daysValue={"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
	List v_al=Arrays.asList(daysValue);
	Vector  values=new Vector();
	values.addAll(v_al);
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = ui.getDefaultLanguage();
	if (_user!=null) 
	{
		String userLang = _user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL")) 
		{
			thisLanguage = userLang;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	egM.setLanguage(thisLanguage);
	MappingNameSorter sorter = new MappingNameSorter(thisLanguage);
	String [] hours = {"0","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22","23"};
	List hrs=Arrays.asList(hours);
	Vector  hoursPeriod=new Vector();
	hoursPeriod.addAll(hrs);
	String paramForTab="";
	JSONObject rootJson=new JSONObject();
	if(option!=null && option.equals("Component"))
	{
		analysisOptions=new Vector();
//		analysisOptions.add("All Components");
		analysisOptions.addAll(egM.getAllAvailableComponents());
		if (isLimitedAdmin) // Limited admin
		{
			analysisOptions.retainAll(limitedUserCompsWithoutType);
		}
	}
	else if(option!=null && option.equals("Host")) 
	{
		analysisOptions=new Vector();
		analysisOptions.add(mappingInfo.getTextDescription("admin.mpolicy.All Hosts"));
		analysisOptions.addAll(egM.getAllAvailableHosts());

		if (isLimitedAdmin) // Limited admin
		{			
			Collections.sort(limitedUserCompsWithoutType);
			Vector v_server_host = new Vector();
			v_server_host.add(mappingInfo.getTextDescription("admin.mpolicy.All Hosts"));
			for (int i = 0;i < limitedUserCompsWithoutType.size();i++)
			{
				String s_temp = (String) limitedUserCompsWithoutType.get(i);
				s_temp = s_temp.substring(0, s_temp.indexOf(":"));
				if(!v_server_host.contains(s_temp))
				{
					v_server_host.add(s_temp);
				}
			}
			Collections.sort(v_server_host, String.CASE_INSENSITIVE_ORDER);
			analysisOptions.retainAll(v_server_host);
		}
	}
	else if(option!=null && option.equals("Test")) 
	{
		analysisOptions=new Vector();
		//analysisOptions.add(mappingInfo.getTextDescription("admin.mpolicy.All Tests"));		
		analysisOptions.addAll(egM.getAllAvailableTests());		
	}
	else if((option!=null && option.equals("Test For Component")) || (option!=null && option.equals("Test For Host"))) 
	{
		analysisOptions=new Vector();
//		analysisOptions.add(mappingInfo.getTextDescription("admin.mpolicy.All Tests"));
		if (option.equals("Test For Component"))
		{
			analysisOptions.addAll(egM.getAllAvailableComponentTests());
			selectLabel=mappingInfo.getTextDescription("admin.mpolicy.Components");
		}
		else if (option.equals("Test For Host"))
		{
			analysisOptions.addAll(egM.getAllAvailableHostTests());
			selectLabel=mappingInfo.getTextDescription("admin.mpolicy.Hosts");
		}
		testElements=egM.getAllAvailableComponentsForTest(element);
		if (isLimitedAdmin) // Limited admin
		{
			String[] usrServerTypes = roleInfo.getServerTypes();
			ArrayList userTests = new ArrayList();
			ArrayList userComps = new ArrayList();
			if (usrServerTypes != null)
			{			
				for (int s=0; s < usrServerTypes.length; s++)
				{
					String[] enabledTestsForServerType = specsInfo.getTestsForServer(usrServerTypes[s]);
					if (enabledTestsForServerType != null && enabledTestsForServerType.length > 0)
					{
						userTests.addAll(Arrays.asList(enabledTestsForServerType));
					}

					Vector tmpUserComps = roleInfo.getServersForTypeWithoutType(usrServerTypes[s]);
					if (tmpUserComps != null && tmpUserComps.size() > 0)
					{
						userComps.addAll(tmpUserComps);
					}				  
				}
			}
			analysisOptions.retainAll(userTests);
			testElements.retainAll(userComps);			
		}
		//Removal of NULL port from Comp display name
		if(testElements != null)
		{
			for(int u=0; u < testElements.size(); u++)
			{
				String tmpComp = (String)testElements.get(u);
				int  nullIndex = tmpComp.indexOf(":NULL");
				if (nullIndex > -1)
				{
					tmpComp = tmpComp.substring(0,nullIndex);
				}
				compNameForUI.add(tmpComp);
			}
		}		
	}
	else if(option!=null && option.equals("Policy")) 
	{
		analysisOptions=new Vector();
		analysisOptions.add(mappingInfo.getTextDescription("admin.mpolicy.Please Choose a Policy"));
		Vector AllPolicies=new Vector();
		
		if (isLimitedAdmin) 
		{
			Vector policyList = (Vector)egM.getAllUnplannedPoliciesWithLimitedUsers();			
			AllPolicies.addAll(policyList);
		}
		else
		{
			AllPolicies.addAll(egM.getAllPoliciesFromGroups());
			AllPolicies.addAll(egM.getAllAssociatedUnplannedPolicies());
		}
		Collections.sort(AllPolicies,String.CASE_INSENSITIVE_ORDER);
		analysisOptions.addAll(AllPolicies);		
	}
	else if(option!=null && option.equals("Time Constraints")) 
	{
		analysisOptions=new Vector();
		String[]  timeContraints={"First Day of Month","Last Day of Month","Daily","Day of Week","Date of Month","Date"};
		List aList=Arrays.asList(timeContraints);
		analysisOptions.addAll(aList);
		timeVal=new Vector();
		String[]  timeContraint={"FDM","LDM","*","Day of Week","Date of Month","Date"};
		List a_List=Arrays.asList(timeContraint);
		timeVal.addAll(a_List);
	}
	else if(option!=null && option.equals("Descriptor"))
	{
		analysisOptions=new Vector();
		String empty="";
		Vector componentInfo = new Vector();
		/*if (isLimitedAdmin) 
		{
			componentInfo = egM.getInfosForLimitedAdminUsers();
		}
		else*/
		{
			componentInfo = egM.getInfosForAllComponents(empty);
		}
		
		if(componentInfo != null)
		{
			analysisOptions.addAll(componentInfo);
		}
		Collections.sort(analysisOptions,String.CASE_INSENSITIVE_ORDER);
	}
	else if(option!=null && option.equals("Descriptor For Component"))
	{
		analysisOptions=new Vector();
		analysisOptions.addAll(egM.getAllAvailableComponents());
		if(element!=null && !element.equals("All Descriptor Comp"))
		{
			descElements.addAll(egM.getInfosForAllComponents(element));
			Collections.sort(descElements,String.CASE_INSENSITIVE_ORDER);
			for(int i=0;i<descElements.size();i++)
			{
				String testWithDesc=(String)descElements.get(i);
				String test=testWithDesc.substring(0,testWithDesc.indexOf(":"));
				String desc=testWithDesc.substring(testWithDesc.indexOf(":")+1);
				test=mappingInfo.getTestDescription(test);
				String addDesc=test+":"+desc;
				mappedDescElements.add(addDesc);
			}
		}

		if (isLimitedAdmin) // Limited admin
		{
			analysisOptions.retainAll(limitedUserCompsWithoutType);
		}
	}
	if(search!=null && !search.equals("")) 
	{
		Vector tmp=new Vector();
		analysisOptions.remove(0);

		if(option!=null && (option.equals("Test") || option.equals("Test For Host") || option.equals("Test For Component")))
		{
			String testStr="";
			String str="";
			for(int s=0;s<analysisOptions.size();s++) 
			{
				testStr = (String)analysisOptions.get(s);
				str = mappingInfo.getTestDescription(testStr);

				if(search!=null && search.length()>0)
				{
					StringTokenizer searchTokenizer=new StringTokenizer(search," ");
					while(searchTokenizer.hasMoreTokens())
					{
						String searchToken=searchTokenizer.nextToken();
						int cond = str.toUpperCase().indexOf(searchToken.toUpperCase());
						if(str.toUpperCase().indexOf(searchToken.toUpperCase())!=-1) 
						{
							tmp.add(testStr);
						}
					}
				}
				else if(search!=null)
				{
					tmp.add(testStr);
				}
			}
		}
		else
		{
			for(int s=0;s<analysisOptions.size();s++) 
			{
				String str=(String)analysisOptions.get(s);
				if(search!=null && search.length()>0)
				{
					StringTokenizer searchTokenizer=new StringTokenizer(search," ");
					while(searchTokenizer.hasMoreTokens())
					{
						String searchToken=searchTokenizer.nextToken();
						if(str.toUpperCase().indexOf(searchToken.toUpperCase())!=-1) 
						{
							tmp.add(str);
						}
					}
				}
				else if(search!=null)
				{
					tmp.add(str);
				}
			}
		}
		analysisOptions.clear();
		analysisOptions.addAll(tmp);
	}
	if(param!=null && param.equals("select1")) 
	{
		JSONArray analysisOptions1=new JSONArray();
		JSONObject analysisOptionsObj=null;
		for(int i=0;i< options.size();i++)
		{
			analysisOptionsObj=new JSONObject();
			analysisOptionsObj.put("displayField",mappingInfo.getTextDescription("admin.mpolicy."+options.get(i)));
			analysisOptionsObj.put("valueField",options.get(i));
			analysisOptions1.add(analysisOptionsObj);
		}
		rootJson.put("analysisOptions",analysisOptions1);
	}
	else    if(param!=null && param.equals("select2")) 
	{
		Vector map_analysisOptions = new Vector();
		Vector dispval=new Vector();
		Vector actualval=new Vector();
		if(option!=null && !option.equals("All") && !option.equals("Time Constraints")) 
		{
			egM.setUserLanguage(thisLanguage);
			if(option.equals("Test") || option.equals("Test For Host") || option.equals("Test For Component"))
			{
				map_analysisOptions.addAll(sorter.getSortedTestList(analysisOptions));//egM.getMappedValue(option,analysisOptions);
				dispval.add(mappingInfo.getTextDescription("admin.mpolicy.All Tests"));
				actualval.add("All Tests");
			}
			else if(option.equals("Component"))
			{
				dispval.add(mappingInfo.getTextDescription("admin.mpolicy.All Components"));
				actualval.add("All Components");
				dispval.addAll(egM.getMappedValue(option,analysisOptions));
				Vector tempDis = new Vector(dispval);
				for (int i = 0;i < tempDis.size();i++)
				{
					String s_temp = (String) tempDis.get(i);
					if(s_temp.endsWith(":NULL"))
					{
						dispval.remove(s_temp);
						s_temp = s_temp.substring(0, s_temp.indexOf(":NULL"));
						dispval.add(i,s_temp);
					}
				}
				actualval.addAll(egM.getMappedValue(option,analysisOptions));
			}
			else if(option.equals("Host") || option.equals("Policy"))
			{
				dispval.addAll(analysisOptions);
				actualval.addAll(analysisOptions);
				if (option.equals("Policy")) // Limited admin
				{
					List tmpList = new ArrayList();
					for(int i=0;i<dispval.size();i++)
					{
						String displayValue = dispval.get(i).toString();
						int index = displayValue.indexOf("|$|");
						if (index > -1) // PolicyName|$|UserName
						{
							/*if (isLimitedAdmin)
							{
								displayValue = displayValue.substring(0,index);
							}
							else*/
							{
								displayValue = displayValue.substring(0,index) + " ("+displayValue.substring(index+3)+")";
							}
							dispval.remove(i);
							dispval.add(i,displayValue);
						}						
					}
				}
			}
			else if(option.equalsIgnoreCase("Descriptor"))
			{
				Vector tempValue=new Vector();
				if(analysisOptions!=null && analysisOptions.size()>0)
				{
					for(int i=0;i<analysisOptions.size();i++)
					{
						String testWithDesc=(String)analysisOptions.get(i);
						if(testWithDesc.indexOf(":")>-1)
						{
							String test=mappingInfo.getTestDescription(testWithDesc.substring(0,testWithDesc.indexOf(":")));
							String info=testWithDesc.substring(testWithDesc.indexOf(":")+1);
							String disp=test+"("+info+")";
							tempValue.add(disp);
						}
					}
				}
				dispval.add(mappingInfo.getTextDescription("admin.mpolicy.All Descriptors"));
				actualval.add("All Descriptors");
				dispval.addAll(egM.getMappedValue(option,tempValue));
				actualval.addAll(egM.getMappedValue(option,analysisOptions));
			}
			else if(option.equalsIgnoreCase("Descriptor For Component"))
			{
				dispval.add(mappingInfo.getTextDescription("admin.mpolicy.All Descriptor Comp"));
				actualval.add("All Descriptor Comp");
				dispval.addAll(egM.getMappedValue(option,analysisOptions));
				actualval.addAll(egM.getMappedValue(option,analysisOptions));
				Vector tempDFC = new Vector(dispval);
				for (int i = 0;i < tempDFC.size();i++)
				{
					String s_temp = (String) tempDFC.get(i);
					if(s_temp.endsWith(":NULL"))
					{
						dispval.remove(s_temp);
						s_temp = s_temp.substring(0, s_temp.indexOf(":NULL"));
						dispval.add(i,s_temp);
					}
				}
			}
			if(option.equals("Test") || option.equals("Test For Host") || option.equals("Test For Component") || option.equals("Component") || option.equals("Descriptor") || option.equals("Descriptor For Component"))
			{
				for (int s=0;s<map_analysisOptions.size();s++)
				{
					EgName nameObj = (EgName)map_analysisOptions.get(s);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();
					dispval.add(tmpDis);
					actualval.add(tmpVal);
				}
			}
			JSONArray analysisElement=new JSONArray();
			JSONObject analysisElementObj=null;
			for(int i=0;i<actualval.size();i++)
			{
				analysisElementObj=new JSONObject();
				analysisElementObj.put("displayField",dispval.get(i));
				analysisElementObj.put("valueField",actualval.get(i));
				analysisElement.add(analysisElementObj);
			}				
			rootJson.put("analysisElement",analysisElement);
			rootJson.put("search",search);
			rootJson.put("option",mappingInfo.getTextDescription("admin.mpolicy."+option));
		}
		else if(option!=null && option.equals("Time Constraints")) 
		{
			JSONArray analysisElement=new JSONArray();
			JSONObject analysisElementObj=null;
			for(int i=0;i<timeVal.size();i++)
			{
				analysisElementObj=new JSONObject();
				analysisElementObj.put("displayField",analysisOptions.get(i));
				analysisElementObj.put("valueField",timeVal.get(i));
				analysisElement.add(analysisElementObj);
			}
			rootJson.put("analysisElement",analysisElement);
			rootJson.put("option",mappingInfo.getTextDescription("admin.mpolicy."+option));
		}
	}
	else if(param!=null && param.equals("select3")) 
	{
		if(option!=null && (option.equals("Test For Host") || option.equals("Test For Component"))) 
		{
			if(element!=null && !element.equals("All Tests")) 
			{
				JSONArray analysisSubElement=new JSONArray();
				JSONObject analysisSubElementObj=null;
				for(int i=0;i<testElements.size();i++)
				{
					analysisSubElementObj=new JSONObject();
					analysisSubElementObj.put("displayField",compNameForUI.get(i));
					analysisSubElementObj.put("valueField",testElements.get(i));
					analysisSubElement.add(analysisSubElementObj);
				}
				rootJson.put("analysisSubElement",analysisSubElement);
				rootJson.put("selectLabel",selectLabel);
				rootJson.put("option",mappingInfo.getTextDescription("admin.mpolicy."+option));
				if(option.equals("Test For Host"))
				{
					rootJson.put("suboption",mappingInfo.getTextDescription("admin.mpolicy.Host"));
				}
				else if(option.equals("Test For Component"))
				{
					rootJson.put("suboption",mappingInfo.getTextDescription("admin.mpolicy.Component"));
				}				
			}
		}
		if(option!=null && option.equals("Time Constraints") && element!=null && element.equals("Day of Week") ) 
		{
			JSONArray analysisSubElement=new JSONArray();
			JSONObject analysisSubElementObj=null;
			for(int i=0;i<values.size();i++)
			{
				analysisSubElementObj=new JSONObject();
				analysisSubElementObj.put("displayField",mappingInfo.getTextDescription("admin.common."+display.get(i)));
				analysisSubElementObj.put("valueField",values.get(i));
				analysisSubElement.add(analysisSubElementObj);
			}
			rootJson.put("analysisSubElement",analysisSubElement);
			rootJson.put("option",mappingInfo.getTextDescription("admin.mpolicy."+option));
			rootJson.put("suboption",mappingInfo.getTextDescription("admin.mpolicy.Days"));
		}
		if(option!=null && option.equals("Time Constraints") && element!=null && element.equals("Date of Month")) 
		{
			JSONArray analysisSubElement=new JSONArray();
			JSONObject analysisSubElementObj=null;

			for(int i=1;i<=31;i++)
			{
				analysisSubElementObj=new JSONObject();
				String suffix = "th";
				if(i==1 || i==21 || i==31)
				{
					suffix = "st";
				}
				else if(i==2 || i==22)
				{
					suffix = "nd";
				}
				else if(i==3 || i==23)
				{
					suffix = "rd";
				}
				analysisSubElementObj.put("displayField",i+suffix+" "+mappingInfo.getTextDescription("admin.mpolicy.day of the month"));
				analysisSubElementObj.put("valueField","Every_"+i);
				analysisSubElement.add(analysisSubElementObj);
			}
			rootJson.put("analysisSubElement",analysisSubElement);
			rootJson.put("option",mappingInfo.getTextDescription("admin.mpolicy."+option));
			rootJson.put("suboption",mappingInfo.getTextDescription("admin.mpolicy.Occurrence"));
		}
		if(option!=null && option.equals("Time Constraints") && element!=null && element.equals("Date") ) 
		{
			if(startDate.equalsIgnoreCase("")){
			    rootJson.put("startDate",tmpStDate);
			}else{
				rootJson.put("startDate",startDate);
			}
			if(endDate.equalsIgnoreCase("")){
			    rootJson.put("endDate",tmpEndDate);
			}else{
				rootJson.put("endDate",endDate);
			}
			if(startHr.equalsIgnoreCase("")){
			    rootJson.put("startHr",Integer.parseInt(tmpStartHr));
			}else{
				rootJson.put("startHr",Integer.parseInt(startHr));
			}
			if(endHr.equalsIgnoreCase("")){
			    rootJson.put("endHr",Integer.parseInt(tmpEndHr));
			}else{
				rootJson.put("endHr",Integer.parseInt(endHr));
			}			
			rootJson.put("option",mappingInfo.getTextDescription("admin.mpolicy."+option));;
		}
		if(option!=null && option.equals("Descriptor For Component"))
		{
			if(element!=null && !element.equals("All Descriptor Comp"))
			{
				JSONArray analysisSubElement=new JSONArray();
				JSONObject analysisSubElementObj=null;				
				
				for(int i=0;i<descElements.size();i++)
				{
					analysisSubElementObj=new JSONObject();
					analysisSubElementObj.put("displayField",mappedDescElements.get(i));
					analysisSubElementObj.put("valueField",descElements.get(i));
					analysisSubElement.add(analysisSubElementObj);
				}
				
				rootJson.put("analysisSubElement",analysisSubElement);
				rootJson.put("option",mappingInfo.getTextDescription("admin.mpolicy."+option));
				rootJson.put("suboption",mappingInfo.getTextDescription("admin.mpolicy.Descriptor"));
			}
		}
	}
	response.getWriter().write(rootJson.toString());
} 
catch(Throwable e) 
{
	e.printStackTrace();
}
%>