<%@ include file= "../../EgTrackerAJSON.jsp"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import="com.eg.EgServerList"%>
<%@ page import="com.eg.EgLicenseInfo"%>
<%@ page import="com.eg.EgRoleInfo"%>
<%@ page import="egurkha.UserBean" %>
<%@ page import = "com.eg.RemoteControlTaskHelper"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJson = new JSONObject();
	JSONObject logList = new JSONObject();
	JSONArray logListArray =new  JSONArray();
	JSONObject logDirList = new JSONObject();
	JSONArray logDirListArray =new  JSONArray();
	LinkedHashMap directoryMap = new LinkedHashMap();
	directoryMap.put("Select a log directory","-1");
	ArrayList logFileList = new ArrayList();

	String agentType = request.getParameter("agentType");
	if(agentType == null || agentType.trim().length() == 0)
	{
		agentType = "PremiumAgents";
	}
	
	String USER_COMP_AGENTS = "Agents for user licensed types";
	String[] agent_types = {"BasicAgents","PremiumAgents", "ExternalAgents", "RemoteAgents"};

	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionID,_user.getLoginID());
	EgLicenseInfo licInfo = new EgLicenseInfo();
	UserBean userBean = new UserBean();
	EgUsersInfo usersInfo = new EgUsersInfo();
	boolean hasAllCompAccess = roleInfo.hasAllComponentAccess();
	EgServerList serverList = new EgServerList();
	boolean isUserBasedCert = false;

	ArrayList agentTypes = new ArrayList(Arrays.asList(agent_types));
	if (usersInfo.getUserAllowedCount() > 0)
	{
		agentTypes.add(USER_COMP_AGENTS);
		isUserBasedCert = true;
	}
	
	JSONArray agentTypesArray = new JSONArray();
	for(int i=0;i<agentTypes.size();i++)
	{
		String agent_type = (String)agentTypes.get(i);
		JSONObject typeObj = new JSONObject();
		typeObj.put("valueField",agent_type);
		typeObj.put("displayField",_mapping.getTextDescription("admin.agents."+agent_type));
		agentTypesArray.add(typeObj);
	}
	rootJson.put("agentTypes",agentTypesArray);

	ArrayList agentList = new ArrayList();
	if(agentType.equalsIgnoreCase("ExternalAgents"))
		agentList = hasAllCompAccess ? licInfo.getExternalAgents() : roleInfo.getExternalAgents();
	else if(agentType.equalsIgnoreCase("BasicAgents"))
		agentList = hasAllCompAccess ? licInfo.getBasicAgents() : roleInfo.getBasicAgents();
	else if(agentType.equalsIgnoreCase("PremiumAgents"))
		agentList = hasAllCompAccess ? userBean.getPremiumAgents() : roleInfo.getPremiumAgents();
	else if(agentType.equalsIgnoreCase("RemoteAgents"))
		agentList = hasAllCompAccess ? licInfo.getRemoteAgents() : roleInfo.getRemoteAgents();
	else if (agentType.equalsIgnoreCase(USER_COMP_AGENTS))
		agentList = hasAllCompAccess ? userBean.getPremiumAgents(true) : roleInfo.getPremiumAgents(true);

	ArrayList aList = serverList.getAgentListFromDB();
	String currList[] = serverList.getTargetNames();
	agentList = serverList.getAgentList(agentList,aList,currList);

	ArrayList agentIPList = new ArrayList();
	if(agentList != null && !agentList.isEmpty())
	{
		for(int i=0;i<agentList.size();i=i+4)
		{
			String agent_ip = (String)agentList.get(i);
			String message = (String)agentList.get(i+1);
			if(message.equals("Installed-Running"))
			{
				agentIPList.add(agent_ip);
			}
		}
		Collections.sort(agentIPList,String.CASE_INSENSITIVE_ORDER);
	}

	JSONObject agentListObj = new JSONObject();
	JSONArray agentListArray = new JSONArray();
	String selDefault = agentIPList.isEmpty() ? "No agent IP/Nickname found" : "Select agent IP/Nickname";
	agentListObj.put("valueField","-1");
	agentListObj.put("displayField",selDefault);
	agentListArray.add(agentListObj);
	if(!agentIPList.isEmpty())
	{
		for(int i=0;i<agentIPList.size();i++)
		{
			String agent_ip = (String)agentIPList.get(i);
			agentListObj = new JSONObject();
			agentListObj.put("valueField",agent_ip);
			agentListObj.put("displayField",agent_ip);
			agentListArray.add(agentListObj);
		}
	}
	rootJson.put("agentListArray",agentListArray);

	String agentID = request.getParameter("componentName");
	if(agentID != null)
	{
		agentID = EgURLDecoder.decode(agentID,"UTF-8");
	}
	String dirName = request.getParameter("dirname");

	boolean foldersAdded=false;
	IniFile inifile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_ui.ini");
	if(inifile != null)
	{
		Vector displayNames = inifile.getVariables("AGENT_LOG_FOLDERS",true);
		Vector actualNames = inifile.getAllValues("AGENT_LOG_FOLDERS");
		if(displayNames != null && actualNames != null)
		{
			int count = displayNames.size();
			if (count > 0)
			{
				foldersAdded = true;
			}
			for(int i=0;i<count;i++)
			{
				directoryMap.put((String)displayNames.get(i),(String)actualNames.get(i));
			}
		}
	}
	if(!foldersAdded)
	{
		directoryMap.put("Agent","agent/logs");
		directoryMap.put(".NET","agent/logs/.NetProfLogs");
	}
	Iterator dirListIter = directoryMap.keySet().iterator();
	while(dirListIter.hasNext())
	{
		String dispField = (String)dirListIter.next();
		String valueField = (String)directoryMap.get(dispField);
		logDirList.put("displayField",dispField);
		logDirList.put("valueField",valueField);
		logDirListArray.add(logDirList);
	}
	rootJson.put("logDirectoryList",logDirListArray);

	boolean showAlert=false;
	String alertMessage="-";
	if(dirName != null && !dirName.equals("-1"))
	{
		if(agentID != null && agentID.length()>0 && agentID.indexOf(":")>0)
		{
			agentID = agentID.substring(0,agentID.indexOf(":"));
		}
		RemoteControlTaskHelper helper = new RemoteControlTaskHelper();
		if(helper.setAgentIntoControlMode(agentID))
		{
			helper.executeTask("ListLogFiles", session.getId(), dirName + "@#@Y");
			if(helper.isOutputAvailable())
			{
				logFileList = helper.getOutput();
			}
		}
		String message=null;
		int filesCount=logFileList.size();
		if(filesCount==1)
		{
			message=((String)logFileList.get(0)).trim();
		}
		if(message !=null && message.equalsIgnoreCase("Directory does not exist"))
		{
			showAlert=true;
			alertMessage="Selected directory does not exist";
			logList = new JSONObject();
			logListArray = new JSONArray();
			logList.put("displayField",message);
			logList.put("valueField","-1");
			logListArray.add(logList);
		}
		else if(message !=null && message.equalsIgnoreCase("Directory is empty"))
		{
			logList = new JSONObject();
			logListArray = new JSONArray();
			logList.put("displayField","Not Applicable");
			logList.put("valueField","-1");
			logListArray.add(logList);
		}
		else
		{
			logList.put("displayField","Select a log file");
			logList.put("valueField","-1");
			logListArray.add(logList);
			for(int i=0;i<logFileList.size();i++)
			{
				logList = new JSONObject();
				String fileName = (String)logFileList.get(i);
				logList.put("displayField",fileName);
				logList.put("valueField",fileName);
				logListArray.add(logList);
			}
		}
	}
	else
	{
		logList.put("displayField","Select a log file");
		logList.put("valueField","-1");
		logListArray.add(logList);
	}
	rootJson.put("showAlert",showAlert);
	rootJson.put("alertMessage",alertMessage);
	rootJson.put("logFileList",logListArray);
	out.println(rootJson);
%>



