/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgCrypt;
import com.eg.IniFile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;

public class UpgradingIndex {
    String installDir = EgInstallInfo.getInstallDir();
    String strntlmv2 = "false";
    boolean flag = false;
    private Connection conn = null;
    private boolean b_flag = false;
    private Statement stmt = null;
    private String dbServerType = null;
    private String dbDriver = null;
    private String dbUrl = null;
    private String dbUser = null;
    private String dbPassword = null;
    private String dbVersionName = null;
    private boolean isOracle = false;
    private boolean isMsSql = false;
    private boolean isDoubleByteEnabled = false;
    private String query = new String();
    ResultSet rs = null;
    private ArrayList a_allTables = new ArrayList();
    private ArrayList a_allIndexNames = new ArrayList();

    private boolean updateIndexChanges() {
        System.setProperty("jsse.enableCBCProtection", "false");
        IniFile iniFile = new IniFile(this.installDir + "/manager/config/eg_db.ini", true);
        this.dbServerType = iniFile.getValue("DB_PROPERTIES", "DB_Server_Type");
        this.dbDriver = iniFile.getValue("DB_PROPERTIES", "sql.driver");
        this.dbUrl = iniFile.getValue("DB_PROPERTIES", "sql.url");
        this.dbUser = iniFile.getValue("DB_PROPERTIES", "sql.user");
        this.dbPassword = EgCrypt.decrypt((String)iniFile.getValue("DB_PROPERTIES", "sql.password"));
        String string = iniFile.getValue("DB_PROPERTIES", "DoubleByteEnabled");
        if (string != null && !string.equals("") && string.equalsIgnoreCase("true")) {
            this.isDoubleByteEnabled = true;
        }
        this.strntlmv2 = iniFile.getValue("DB_PROPERTIES", "sql.ntlmv2");
        if (this.dbServerType != null && this.dbServerType.equalsIgnoreCase("EgOracleAdapter")) {
            this.isOracle = true;
            this.isMsSql = false;
        } else if (this.dbServerType.equalsIgnoreCase("EgMsSqlAdapter")) {
            this.isOracle = false;
            this.isMsSql = true;
        }
        System.out.println("Attempting to get the database connections");
        this.flag = this.setConnection();
        if (!this.flag) {
            System.out.println("Error in establishing the connection");
            System.err.println("Error in establishing the connection");
            return false;
        }
        System.out.println("Database connection obtained");
        this.a_allTables = this.getAllTables();
        this.a_allIndexNames = this.getAllIndex();
        this.b_flag = this.updateChangesInDb();
        if (!this.b_flag) {
            System.out.println("Failed to execute the query");
        } else {
            System.out.println("Query Execueted successfully");
        }
        System.out.println("Releasing the Established Database Connection....");
        this.releaseConnection();
        System.out.println("Released the database connection");
        if (!this.b_flag) {
            System.out.println(" Failed to execute!");
            System.err.println(" Failed to execute!");
            return false;
        }
        return true;
    }

    private boolean setConnection() {
        try {
            String string = "";
            Class.forName(this.dbDriver);
            int n = this.dbUser.indexOf("\\");
            if (n < 0) {
                n = this.dbUser.indexOf("/");
                if (n < 0) {
                    this.conn = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
                } else {
                    String string2 = this.dbUser.substring(0, n);
                    this.dbUser = this.dbUser.substring(n + 1);
                    Properties properties = new Properties();
                    properties.put("user", this.dbUser);
                    properties.put("password", this.dbPassword);
                    properties.put("domain", string2);
                    string = this.strntlmv2 != null && this.strntlmv2.trim().equalsIgnoreCase("True") ? "true" : "false";
                    properties.put("useNTLMv2", string);
                    this.conn = DriverManager.getConnection(this.dbUrl, properties);
                }
            } else {
                String string3 = this.dbUser.substring(0, n);
                this.dbUser = this.dbUser.substring(n + 1);
                Properties properties = new Properties();
                properties.put("user", this.dbUser);
                properties.put("password", this.dbPassword);
                properties.put("domain", string3);
                string = this.strntlmv2 != null && this.strntlmv2.trim().equalsIgnoreCase("True") ? "true" : "false";
                properties.put("useNTLMv2", string);
                this.conn = DriverManager.getConnection(this.dbUrl, properties);
            }
            this.stmt = this.conn.createStatement();
            return true;
        }
        catch (Exception exception) {
            this.b_flag = false;
            System.out.println("Problem In DB Connection : " + exception);
            System.err.println("Problem In DB Connection : " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    private ArrayList getAllIndex() {
        System.out.println("Collecting All Index Names in arraylist object...");
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.isOracle) {
                this.query = "SELECT INDEX_NAME FROM user_ind_columns";
            } else if (this.isMsSql) {
                this.dbVersionName = this.databaseVersionName();
                this.query = this.dbVersionName != null && this.dbVersionName.startsWith("Microsoft SQL Azure") ? "SELECT i.name as index_name,o.name as object_name,col1 = MIN (CASE ik.index_column_id WHEN 1 THEN c.name END),col2 = MIN (CASE ik.index_column_id WHEN 2 THEN c.name END),col3 = MIN (CASE ik.index_column_id WHEN 3 THEN c.name END),col4 = MIN (CASE ik.index_column_id WHEN 4 THEN c.name END),col5 = MIN (CASE ik.index_column_id WHEN 5 THEN c.name END) FROM sys.objects o JOIN sys.indexes i ON i.object_id = o.object_id JOIN sys.index_columns ik ON ik.object_id = i.object_id AND ik.index_id = i.index_id JOIN sys.columns c ON c.object_id = ik.object_id AND c.column_id = ik.column_id WHERE i.index_id BETWEEN 1 AND 254 AND indexproperty(o.object_id, i.name, 'IsStatistics') = 0 AND indexproperty(o.object_id, i.name, 'IsHypothetical') = 0 GROUP BY o.name, i.name ORDER BY o.name, i.name" : "select i.name index_name,object_name(t.object_id) ,t.type from sys.indexes i, sys.tables t where i.object_id=t.object_id";
            }
            this.stmt = this.conn.createStatement();
            this.rs = this.stmt.executeQuery(this.query);
            while (this.rs.next()) {
                if (this.rs.getString(1) == null) continue;
                arrayList.add(this.rs.getString(1).toUpperCase().trim());
            }
            this.closeRs(this.rs);
            this.closeSt(this.stmt);
            this.rs = null;
            return arrayList;
        }
        catch (Exception exception) {
            System.out.println("Error in getAllTables Method ");
            exception.printStackTrace();
            this.closeSt(this.stmt);
            System.err.println("Error" + exception);
            return null;
        }
    }

    private ArrayList getAllTables() {
        System.out.println("Collecting All Table Names in arraylist object...");
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.isOracle) {
                this.query = "SELECT table_name FROM user_tables";
            } else if (this.isMsSql) {
                this.query = "SELECT TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_TYPE = 'BASE TABLE'";
            }
            this.stmt = this.conn.createStatement();
            ResultSet resultSet = this.stmt.executeQuery(this.query);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1).toUpperCase().trim());
            }
            this.closeRs(resultSet);
            this.closeSt(this.stmt);
            resultSet = null;
            return arrayList;
        }
        catch (Exception exception) {
            System.out.println("Error in getAllTables Method ");
            exception.printStackTrace();
            this.closeSt(this.stmt);
            System.err.println("Error" + exception);
            return null;
        }
    }

    public String databaseVersionName() {
        String string = null;
        try {
            this.stmt = this.conn.createStatement();
            this.rs = this.stmt.executeQuery("select @@version");
            if (this.rs != null && this.rs.next()) {
                string = this.rs.getString(1);
            }
            System.out.println("dbVersionName__" + string);
        }
        catch (Exception exception) {
            System.out.println("Exception" + exception);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateChangesInDb() {
        try {
            this.stmt = this.conn.createStatement();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.isMsSql) {
                arrayList.add("CREATE NONCLUSTERED INDEX IDX1_NETWORKTRAFFICTEST ON NetworkTrafficTest (TRGT_HOST, PORT_NO, MSMT_TIME) INCLUDE (INP_PKT_RATE , OUT_PKT_RATE);");
                arrayList.add("CREATE NONCLUSTERED INDEX IDX2_DISKACTIVITYTEST ON DISKACTIVITYTEST (TRGT_HOST, PORT_NO, MSMT_TIME) INCLUDE (READ_RATE, WRITE_RATE, DATA_READ_RATE, DATA_WRITE_RATE );");
                arrayList.add("CREATE NONCLUSTERED INDEX IDX1_EsxNetworkTest  ON EsxNetworkTest  (TRGT_HOST, PORT_NO, MSMT_TIME) INCLUDE (DATA_RECEIVED, DATA_TRANSMITTED);");
                arrayList.add("CREATE NONCLUSTERED INDEX IDX2_XenHostNetworkTest ON XenHostNetworkTest (TRGT_HOST, PORT_NO, MSMT_TIME) INCLUDE (IO_READ_RATE, IO_WRITE_RATE);");
                arrayList.add("CREATE NONCLUSTERED INDEX IDX2_XenGuestTest ON XenGuestTest (TRGT_HOST, PORT_NO, MSMT_TIME) INCLUDE (DISK_READS, DISK_WRITES);");
                arrayList.add("CREATE NONCLUSTERED INDEX IDX2_HvGuestTest ON HvGuestTest (TRGT_HOST, PORT_NO, MSMT_TIME) INCLUDE (BYTES_READ, BYTES_WRITTEN );");
                arrayList.add("CREATE NONCLUSTERED INDEX IDX1_XenDiskIOTest ON XenDiskIOTest (TRGT_HOST, PORT_NO, MSMT_TIME) INCLUDE (READ_THROUGHPUTS, WRITE_THROUGHPUTS);");
                arrayList.add("CREATE NONCLUSTERED INDEX IDX4_CTXXCXAUSERTEST on CTXXCXAUSERTEST (MSMT_TIME) INCLUDE (TRGT_HOST,PORT_NO, INFO, MSMT_HOST, LATENCY_AVG);");
                arrayList.add("CREATE NONCLUSTERED INDEX IDX2_CtxXcXAAppTest ON CtxXcXAAppTest (MSMT_TIME ) INCLUDE (TRGT_HOST,PORT_NO,INFO,MSMT_HOST,NUMBER_OF_PROCESSES,CPU_USAGE,MEMORY_USAGE);");
                arrayList.add("CREATE NONCLUSTERED INDEX idx3_CtxXcXAAppTest ON CtxXcXAAppTest (TRGT_HOST,PORT_NO,MSMT_TIME) INCLUDE (INFO,CPU_USAGE, MEMORY_USAGE, NUMBER_OF_PROCESSES);");
            } else if (this.isOracle) {
                arrayList.add("CREATE INDEX IDX1_NETWORKTRAFFICTEST ON NETWORKTRAFFICTEST (TRGT_HOST, PORT_NO, MSMT_TIME, INP_PKT_RATE , OUT_PKT_RATE)");
                arrayList.add("CREATE INDEX IDX2_DiskActivityTest ON DiskActivityTest (TRGT_HOST, PORT_NO, MSMT_TIME, READ_RATE, WRITE_RATE, DATA_READ_RATE, DATA_WRITE_RATE )");
                arrayList.add("CREATE INDEX IDX1_EsxNetworkTest  ON EsxNetworkTest  (TRGT_HOST, PORT_NO, MSMT_TIME, DATA_RECEIVED, DATA_TRANSMITTED)");
                arrayList.add("CREATE INDEX IDX1_XenHostNetworkTest ON XenHostNetworkTest (TRGT_HOST, PORT_NO, MSMT_TIME, IO_READ_RATE, IO_WRITE_RATE)");
                arrayList.add("CREATE INDEX IDX2_XenGuestTest ON XenGuestTest (TRGT_HOST, PORT_NO, MSMT_TIME, DISK_READS, DISK_WRITES)");
                arrayList.add("CREATE INDEX IDX1_HvGuestTest ON HvGuestTest (TRGT_HOST, PORT_NO, MSMT_TIME, BYTES_READ, BYTES_WRITTEN )");
                arrayList.add("CREATE INDEX IDX1_XenDiskIOTest ON XenDiskIOTest (TRGT_HOST, PORT_NO, MSMT_TIME, READ_THROUGHPUTS, WRITE_THROUGHPUTS)");
                arrayList.add("CREATE INDEX IDX2_CtxXcXAAppTest ON CtxXcXAAppTest (MSMT_TIME,NUMBER_OF_PROCESSES)");
                arrayList.add("CREATE INDEX IDX3_CtxXcXAAppTest ON CtxXcXAAppTest (MSMT_TIME,CPU_USAGE)");
                arrayList.add("CREATE INDEX IDX4_CtxXcXAAppTest ON CtxXcXAAppTest (MSMT_TIME,MEMORY_USAGE)");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                String string2 = string.toUpperCase();
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                if (string2 != null && string2.indexOf("INDEX") > -1) {
                    string3 = string2.substring(string2.indexOf("INDEX") + 5, string2.length());
                    string4 = string3.substring(string3.indexOf("ON") + 2, string3.indexOf("("));
                    string5 = string4.trim();
                    string6 = string3.substring(0, string3.indexOf("ON"));
                    string7 = string6.trim();
                }
                if (this.a_allTables == null || !this.a_allTables.contains(string5.toUpperCase()) || this.a_allIndexNames == null || this.a_allIndexNames.contains(string7.toUpperCase())) continue;
                try {
                    System.out.println("query ___________ " + string);
                    this.stmt.executeUpdate(string);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("Problem in executing the query and exception is : " + exception.getMessage());
                }
            }
            this.closeSt(this.stmt);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem in Updating the index and exception is : " + exception.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeSt(this.stmt);
        }
        return true;
    }

    private void closeRs(ResultSet resultSet) {
        try {
            if (resultSet == null) {
                return;
            }
            resultSet.close();
            resultSet = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void closeSt(Statement statement) {
        try {
            if (statement == null) {
                return;
            }
            statement.close();
            statement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean releaseConnection() {
        block5: {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception exception) {
                if (this.stmt != null) {
                    this.stmt = null;
                }
                if (this.conn == null) break block5;
                this.conn = null;
            }
        }
        return true;
    }

    public static void main(String[] stringArray) {
        UpgradingIndex upgradingIndex = new UpgradingIndex();
        upgradingIndex.updateIndexChanges();
    }
}

