/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.util;

import com.eg.org.objectweb.asm.AnnotationVisitor;
import com.eg.org.objectweb.asm.Attribute;
import com.eg.org.objectweb.asm.ConstantDynamic;
import com.eg.org.objectweb.asm.Handle;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Opcodes;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.TypePath;
import com.eg.org.objectweb.asm.TypeReference;
import com.eg.org.objectweb.asm.tree.MethodNode;
import com.eg.org.objectweb.asm.tree.analysis.Analyzer;
import com.eg.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.eg.org.objectweb.asm.tree.analysis.BasicValue;
import com.eg.org.objectweb.asm.tree.analysis.BasicVerifier;
import com.eg.org.objectweb.asm.util.CheckAnnotationAdapter;
import com.eg.org.objectweb.asm.util.CheckClassAdapter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckMethodAdapter
extends MethodVisitor {
    private static final Method[] OPCODE_METHODS = new Method[]{Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INT_INSN, Method.VISIT_INT_INSN, null, null, null, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_VAR_INSN, null, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_METHOD_INSN, Method.VISIT_METHOD_INSN, Method.VISIT_METHOD_INSN, Method.VISIT_METHOD_INSN, null, Method.VISIT_TYPE_INSN, Method.VISIT_INT_INSN, Method.VISIT_TYPE_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_TYPE_INSN, Method.VISIT_TYPE_INSN, Method.VISIT_INSN, Method.VISIT_INSN, null, null, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN};
    private static final String INVALID = "Invalid ";
    private static final String INVALID_DESCRIPTOR = "Invalid descriptor: ";
    private static final String INVALID_TYPE_REFERENCE = "Invalid type reference sort 0x";
    private static final String INVALID_LOCAL_VARIABLE_INDEX = "Invalid local variable index";
    private static final String MUST_NOT_BE_NULL_OR_EMPTY = " (must not be null or empty)";
    private static final String START_LABEL = "start label";
    private static final String END_LABEL = "end label";
    public int version;
    private int access;
    private int visibleAnnotableParameterCount;
    private int invisibleAnnotableParameterCount;
    private boolean visitCodeCalled;
    private boolean visitMaxCalled;
    private boolean visitEndCalled;
    private int insnCount;
    private final Map<Label, Integer> labelInsnIndices;
    private Set<Label> referencedLabels;
    private int lastFrameInsnIndex = -1;
    private int numExpandedFrames;
    private int numCompressedFrames;
    private List<Label> handlers;

    public CheckMethodAdapter(MethodVisitor methodVisitor) {
        this(methodVisitor, new HashMap<Label, Integer>());
    }

    public CheckMethodAdapter(MethodVisitor methodVisitor, Map<Label, Integer> map) {
        this(458752, methodVisitor, map);
        if (this.getClass() != CheckMethodAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckMethodAdapter(int n, MethodVisitor methodVisitor, Map<Label, Integer> map) {
        super(n, methodVisitor);
        this.labelInsnIndices = map;
        this.referencedLabels = new HashSet<Label>();
        this.handlers = new ArrayList<Label>();
    }

    public CheckMethodAdapter(int n, String string, String string2, MethodVisitor methodVisitor, Map<Label, Integer> map) {
        this(458752, n, string, string2, methodVisitor, map);
        if (this.getClass() != CheckMethodAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckMethodAdapter(int n, int n2, String string, String string2, final MethodVisitor methodVisitor, Map<Label, Integer> map) {
        this(n, new MethodNode(n, n2, string, string2, null, null){

            @Override
            public void visitEnd() {
                Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicVerifier());
                try {
                    analyzer.analyze("dummy", this);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (this.maxLocals == 0 && this.maxStack == 0) {
                        throw new IllegalArgumentException("Data flow checking option requires valid, non zero maxLocals and maxStack.", indexOutOfBoundsException);
                    }
                    this.throwError(analyzer, indexOutOfBoundsException);
                }
                catch (AnalyzerException analyzerException) {
                    this.throwError(analyzer, analyzerException);
                }
                this.accept(methodVisitor);
            }

            private void throwError(Analyzer<BasicValue> analyzer, Exception exception) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
                CheckClassAdapter.printAnalyzerResult(this, analyzer, printWriter);
                printWriter.close();
                throw new IllegalArgumentException(exception.getMessage() + ' ' + stringWriter.toString(), exception);
            }
        }, map);
        this.access = n2;
    }

    @Override
    public void visitParameter(String string, int n) {
        if (string != null) {
            CheckMethodAdapter.checkUnqualifiedName(this.version, string, "name");
        }
        CheckClassAdapter.checkAccess(n, 36880);
        super.visitParameter(string, n);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(string, bl));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.checkVisitEndNotCalled();
        int n2 = new TypeReference(n).getSort();
        if (n2 != 1 && n2 != 18 && n2 != 20 && n2 != 21 && n2 != 22 && n2 != 23) {
            throw new IllegalArgumentException(INVALID_TYPE_REFERENCE + Integer.toHexString(n2));
        }
        CheckClassAdapter.checkTypeRef(n);
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(n, typePath, string, bl));
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.checkVisitEndNotCalled();
        return new CheckAnnotationAdapter(super.visitAnnotationDefault(), false);
    }

    @Override
    public void visitAnnotableParameterCount(int n, boolean bl) {
        this.checkVisitEndNotCalled();
        if (bl) {
            this.visibleAnnotableParameterCount = n;
        } else {
            this.invisibleAnnotableParameterCount = n;
        }
        super.visitAnnotableParameterCount(n, bl);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        this.checkVisitEndNotCalled();
        if (bl && this.visibleAnnotableParameterCount > 0 && n >= this.visibleAnnotableParameterCount || !bl && this.invisibleAnnotableParameterCount > 0 && n >= this.invisibleAnnotableParameterCount) {
            throw new IllegalArgumentException("Invalid parameter index");
        }
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitParameterAnnotation(n, string, bl));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkVisitEndNotCalled();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attribute);
    }

    @Override
    public void visitCode() {
        if ((this.access & 0x400) != 0) {
            throw new UnsupportedOperationException("Abstract methods cannot have code");
        }
        this.visitCodeCalled = true;
        super.visitCode();
    }

    @Override
    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        int n4;
        int n5;
        int n6;
        if (this.insnCount == this.lastFrameInsnIndex) {
            throw new IllegalStateException("At most one frame can be visited at a given code location.");
        }
        this.lastFrameInsnIndex = this.insnCount;
        switch (n) {
            case -1: 
            case 0: {
                n6 = Integer.MAX_VALUE;
                n5 = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                n6 = 0;
                n5 = 0;
                break;
            }
            case 4: {
                n6 = 0;
                n5 = 1;
                break;
            }
            case 1: 
            case 2: {
                n6 = 3;
                n5 = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid frame type " + n);
            }
        }
        if (n2 > n6) {
            throw new IllegalArgumentException("Invalid numLocal=" + n2 + " for frame type " + n);
        }
        if (n3 > n5) {
            throw new IllegalArgumentException("Invalid numStack=" + n3 + " for frame type " + n);
        }
        if (n != 2) {
            if (n2 > 0 && (objectArray == null || objectArray.length < n2)) {
                throw new IllegalArgumentException("Array local[] is shorter than numLocal");
            }
            for (n4 = 0; n4 < n2; ++n4) {
                this.checkFrameValue(objectArray[n4]);
            }
        }
        if (n3 > 0 && (objectArray2 == null || objectArray2.length < n3)) {
            throw new IllegalArgumentException("Array stack[] is shorter than numStack");
        }
        for (n4 = 0; n4 < n3; ++n4) {
            this.checkFrameValue(objectArray2[n4]);
        }
        if (n == -1) {
            ++this.numExpandedFrames;
        } else {
            ++this.numCompressedFrames;
        }
        if (this.numExpandedFrames > 0 && this.numCompressedFrames > 0) {
            throw new IllegalArgumentException("Expanded and compressed frames must not be mixed.");
        }
        super.visitFrame(n, n2, objectArray, n3, objectArray2);
    }

    @Override
    public void visitInsn(int n) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n, Method.VISIT_INSN);
        super.visitInsn(n);
        ++this.insnCount;
    }

    @Override
    public void visitIntInsn(int n, int n2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n, Method.VISIT_INT_INSN);
        switch (n) {
            case 16: {
                CheckMethodAdapter.checkSignedByte(n2, "Invalid operand");
                break;
            }
            case 17: {
                CheckMethodAdapter.checkSignedShort(n2, "Invalid operand");
                break;
            }
            case 188: {
                if (n2 >= 4 && n2 <= 11) break;
                throw new IllegalArgumentException("Invalid operand (must be an array type code T_...): " + n2);
            }
            default: {
                throw new AssertionError();
            }
        }
        super.visitIntInsn(n, n2);
        ++this.insnCount;
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n, Method.VISIT_VAR_INSN);
        CheckMethodAdapter.checkUnsignedShort(n2, INVALID_LOCAL_VARIABLE_INDEX);
        super.visitVarInsn(n, n2);
        ++this.insnCount;
    }

    @Override
    public void visitTypeInsn(int n, String string) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n, Method.VISIT_TYPE_INSN);
        CheckMethodAdapter.checkInternalName(this.version, string, "type");
        if (n == 187 && string.charAt(0) == '[') {
            throw new IllegalArgumentException("NEW cannot be used to create arrays: " + string);
        }
        super.visitTypeInsn(n, string);
        ++this.insnCount;
    }

    @Override
    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n, Method.VISIT_FIELD_INSN);
        CheckMethodAdapter.checkInternalName(this.version, string, "owner");
        CheckMethodAdapter.checkUnqualifiedName(this.version, string2, "name");
        CheckMethodAdapter.checkDescriptor(this.version, string3, false);
        super.visitFieldInsn(n, string, string2, string3);
        ++this.insnCount;
    }

    @Override
    @Deprecated
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        if (this.api >= 327680) {
            super.visitMethodInsn(n, string, string2, string3);
            return;
        }
        this.doVisitMethodInsn(n, string, string2, string3, n == 185);
    }

    @Override
    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        if (this.api < 327680) {
            super.visitMethodInsn(n, string, string2, string3, bl);
            return;
        }
        this.doVisitMethodInsn(n, string, string2, string3, bl);
    }

    private void doVisitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n, Method.VISIT_METHOD_INSN);
        if (n != 183 || !"<init>".equals(string2)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, string2, "name");
        }
        CheckMethodAdapter.checkInternalName(this.version, string, "owner");
        CheckMethodAdapter.checkMethodDescriptor(this.version, string3);
        if (n == 182 && bl) {
            throw new IllegalArgumentException("INVOKEVIRTUAL can't be used with interfaces");
        }
        if (n == 185 && !bl) {
            throw new IllegalArgumentException("INVOKEINTERFACE can't be used with classes");
        }
        if (n == 183 && bl && (this.version & 0xFFFF) < 52) {
            throw new IllegalArgumentException("INVOKESPECIAL can't be used with interfaces prior to Java 8");
        }
        if (this.mv != null) {
            this.mv.visitMethodInsn(n, string, string2, string3, bl);
        }
        ++this.insnCount;
    }

    @Override
    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkMethodIdentifier(this.version, string, "name");
        CheckMethodAdapter.checkMethodDescriptor(this.version, string2);
        if (handle.getTag() != 6 && handle.getTag() != 8) {
            throw new IllegalArgumentException("invalid handle tag " + handle.getTag());
        }
        for (Object object : objectArray) {
            this.checkLdcConstant(object);
        }
        super.visitInvokeDynamicInsn(string, string2, handle, objectArray);
        ++this.insnCount;
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n, Method.VISIT_JUMP_INSN);
        this.checkLabel(label, false, "label");
        super.visitJumpInsn(n, label);
        this.referencedLabels.add(label);
        ++this.insnCount;
    }

    @Override
    public void visitLabel(Label label) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.checkLabel(label, false, "label");
        if (this.labelInsnIndices.get(label) != null) {
            throw new IllegalArgumentException("Already visited label");
        }
        this.labelInsnIndices.put(label, this.insnCount);
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object object) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.checkLdcConstant(object);
        super.visitLdcInsn(object);
        ++this.insnCount;
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkUnsignedShort(n, INVALID_LOCAL_VARIABLE_INDEX);
        CheckMethodAdapter.checkSignedShort(n2, "Invalid increment");
        super.visitIincInsn(n, n2);
        ++this.insnCount;
    }

    @Override
    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        if (n2 < n) {
            throw new IllegalArgumentException("Max = " + n2 + " must be greater than or equal to min = " + n);
        }
        this.checkLabel(label, false, "default label");
        if (labelArray == null || labelArray.length != n2 - n + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (int i = 0; i < labelArray.length; ++i) {
            this.checkLabel(labelArray[i], false, "label at index " + i);
        }
        super.visitTableSwitchInsn(n, n2, label, labelArray);
        for (Label label2 : labelArray) {
            this.referencedLabels.add(label2);
        }
        ++this.insnCount;
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.checkVisitMaxsNotCalled();
        this.checkVisitCodeCalled();
        this.checkLabel(label, false, "default label");
        if (nArray == null || labelArray == null || nArray.length != labelArray.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (int i = 0; i < labelArray.length; ++i) {
            this.checkLabel(labelArray[i], false, "label at index " + i);
        }
        super.visitLookupSwitchInsn(label, nArray, labelArray);
        this.referencedLabels.add(label);
        for (Label label2 : labelArray) {
            this.referencedLabels.add(label2);
        }
        ++this.insnCount;
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int n) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        if (string.charAt(0) != '[') {
            throw new IllegalArgumentException("Invalid descriptor (must be an array type descriptor): " + string);
        }
        if (n < 1) {
            throw new IllegalArgumentException("Invalid dimensions (must be greater than 0): " + n);
        }
        if (n > string.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException("Invalid dimensions (must not be greater than numDimensions(descriptor)): " + n);
        }
        super.visitMultiANewArrayInsn(string, n);
        ++this.insnCount;
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        int n2 = new TypeReference(n).getSort();
        if (n2 != 67 && n2 != 68 && n2 != 69 && n2 != 70 && n2 != 71 && n2 != 72 && n2 != 73 && n2 != 74 && n2 != 75) {
            throw new IllegalArgumentException(INVALID_TYPE_REFERENCE + Integer.toHexString(n2));
        }
        CheckClassAdapter.checkTypeRef(n);
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitInsnAnnotation(n, typePath, string, bl));
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.checkLabel(label, false, START_LABEL);
        this.checkLabel(label2, false, END_LABEL);
        this.checkLabel(label3, false, "handler label");
        if (this.labelInsnIndices.get(label) != null || this.labelInsnIndices.get(label2) != null || this.labelInsnIndices.get(label3) != null) {
            throw new IllegalStateException("Try catch blocks must be visited before their labels");
        }
        if (string != null) {
            CheckMethodAdapter.checkInternalName(this.version, string, "type");
        }
        super.visitTryCatchBlock(label, label2, label3, string);
        this.handlers.add(label);
        this.handlers.add(label2);
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        int n2 = new TypeReference(n).getSort();
        if (n2 != 66) {
            throw new IllegalArgumentException(INVALID_TYPE_REFERENCE + Integer.toHexString(n2));
        }
        CheckClassAdapter.checkTypeRef(n);
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitTryCatchAnnotation(n, typePath, string, bl));
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkUnqualifiedName(this.version, string, "name");
        CheckMethodAdapter.checkDescriptor(this.version, string2, false);
        this.checkLabel(label, true, START_LABEL);
        this.checkLabel(label2, true, END_LABEL);
        CheckMethodAdapter.checkUnsignedShort(n, INVALID_LOCAL_VARIABLE_INDEX);
        int n2 = this.labelInsnIndices.get(label);
        int n3 = this.labelInsnIndices.get(label2);
        if (n3 < n2) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        super.visitLocalVariable(string, string2, string3, label, label2, n);
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        int n2 = new TypeReference(n).getSort();
        if (n2 != 64 && n2 != 65) {
            throw new IllegalArgumentException(INVALID_TYPE_REFERENCE + Integer.toHexString(n2));
        }
        CheckClassAdapter.checkTypeRef(n);
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        if (labelArray == null || labelArray2 == null || nArray == null || labelArray2.length != labelArray.length || nArray.length != labelArray.length) {
            throw new IllegalArgumentException("Invalid start, end and index arrays (must be non null and of identical length");
        }
        for (int i = 0; i < labelArray.length; ++i) {
            this.checkLabel(labelArray[i], true, START_LABEL);
            this.checkLabel(labelArray2[i], true, END_LABEL);
            CheckMethodAdapter.checkUnsignedShort(nArray[i], INVALID_LOCAL_VARIABLE_INDEX);
            int n3 = this.labelInsnIndices.get(labelArray[i]);
            int n4 = this.labelInsnIndices.get(labelArray2[i]);
            if (n4 >= n3) continue;
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        return super.visitLocalVariableAnnotation(n, typePath, labelArray, labelArray2, nArray, string, bl);
    }

    @Override
    public void visitLineNumber(int n, Label label) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid line number");
        this.checkLabel(label, true, START_LABEL);
        super.visitLineNumber(n, label);
    }

    @Override
    public void visitMaxs(int n, int n2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.visitMaxCalled = true;
        for (Label object : this.referencedLabels) {
            if (this.labelInsnIndices.get(object) != null) continue;
            throw new IllegalStateException("Undefined label used");
        }
        for (int i = 0; i < this.handlers.size(); i += 2) {
            Integer n3 = this.labelInsnIndices.get(this.handlers.get(i));
            Integer n4 = this.labelInsnIndices.get(this.handlers.get(i + 1));
            if (n3 == null || n4 == null) {
                throw new IllegalStateException("Undefined try catch block labels");
            }
            if (n4 > n3) continue;
            throw new IllegalStateException("Emty try catch block handler range");
        }
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid max stack");
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid max locals");
        super.visitMaxs(n, n2);
    }

    @Override
    public void visitEnd() {
        this.checkVisitEndNotCalled();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private void checkVisitCodeCalled() {
        if (!this.visitCodeCalled) {
            throw new IllegalStateException("Cannot visit instructions before visitCode has been called.");
        }
    }

    private void checkVisitMaxsNotCalled() {
        if (this.visitMaxCalled) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    private void checkVisitEndNotCalled() {
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot visit elements after visitEnd has been called.");
        }
    }

    private void checkFrameValue(Object object) {
        if (object == Opcodes.TOP || object == Opcodes.INTEGER || object == Opcodes.FLOAT || object == Opcodes.LONG || object == Opcodes.DOUBLE || object == Opcodes.NULL || object == Opcodes.UNINITIALIZED_THIS) {
            return;
        }
        if (object instanceof String) {
            CheckMethodAdapter.checkInternalName(this.version, (String)object, "Invalid stack frame value");
        } else if (object instanceof Label) {
            this.referencedLabels.add((Label)object);
        } else {
            throw new IllegalArgumentException("Invalid stack frame value: " + object);
        }
    }

    private static void checkOpcodeMethod(int n, Method method) {
        if (n < 0 || n > 199 || OPCODE_METHODS[n] != method) {
            throw new IllegalArgumentException("Invalid opcode: " + n);
        }
    }

    private static void checkSignedByte(int n, String string) {
        if (n < -128 || n > 127) {
            throw new IllegalArgumentException(string + " (must be a signed byte): " + n);
        }
    }

    private static void checkSignedShort(int n, String string) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException(string + " (must be a signed short): " + n);
        }
    }

    private static void checkUnsignedShort(int n, String string) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException(string + " (must be an unsigned short): " + n);
        }
    }

    static void checkConstant(Object object) {
        if (!(object instanceof Integer || object instanceof Float || object instanceof Long || object instanceof Double || object instanceof String)) {
            throw new IllegalArgumentException("Invalid constant: " + object);
        }
    }

    private void checkLdcConstant(Object object) {
        if (object instanceof Type) {
            int n = ((Type)object).getSort();
            if (n != 10 && n != 9 && n != 11) {
                throw new IllegalArgumentException("Illegal LDC constant value");
            }
            if (n != 11 && (this.version & 0xFFFF) < 49) {
                throw new IllegalArgumentException("ldc of a constant class requires at least version 1.5");
            }
            if (n == 11 && (this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a method type requires at least version 1.7");
            }
        } else if (object instanceof Handle) {
            if ((this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a Handle requires at least version 1.7");
            }
            Handle handle = (Handle)object;
            int n = handle.getTag();
            if (n < 1 || n > 9) {
                throw new IllegalArgumentException("invalid handle tag " + n);
            }
            CheckMethodAdapter.checkInternalName(this.version, handle.getOwner(), "handle owner");
            if (n <= 4) {
                CheckMethodAdapter.checkDescriptor(this.version, handle.getDesc(), false);
            } else {
                CheckMethodAdapter.checkMethodDescriptor(this.version, handle.getDesc());
            }
            String string = handle.getName();
            if (!"<init>".equals(string) || n != 8) {
                CheckMethodAdapter.checkMethodIdentifier(this.version, string, "handle name");
            }
        } else if (object instanceof ConstantDynamic) {
            if ((this.version & 0xFFFF) < 55) {
                throw new IllegalArgumentException("ldc of a ConstantDynamic requires at least version 11");
            }
            ConstantDynamic constantDynamic = (ConstantDynamic)object;
            CheckMethodAdapter.checkMethodIdentifier(this.version, constantDynamic.getName(), "constant dynamic name");
            CheckMethodAdapter.checkDescriptor(this.version, constantDynamic.getDescriptor(), false);
            this.checkLdcConstant(constantDynamic.getBootstrapMethod());
            int n = constantDynamic.getBootstrapMethodArgumentCount();
            for (int i = 0; i < n; ++i) {
                this.checkLdcConstant(constantDynamic.getBootstrapMethodArgument(i));
            }
        } else {
            CheckMethodAdapter.checkConstant(object);
        }
    }

    static void checkUnqualifiedName(int n, String string, String string2) {
        CheckMethodAdapter.checkIdentifier(n, string, 0, -1, string2);
    }

    static void checkIdentifier(int n, String string, int n2, int n3, String string2) {
        int n4;
        if (string == null || (n3 == -1 ? string.length() <= n2 : n3 <= n2)) {
            throw new IllegalArgumentException(INVALID + string2 + MUST_NOT_BE_NULL_OR_EMPTY);
        }
        int n5 = n4 = n3 == -1 ? string.length() : n3;
        if ((n & 0xFFFF) >= 49) {
            int n6 = n2;
            while (n6 < n4) {
                if (".;[/".indexOf(string.codePointAt(n6)) != -1) {
                    throw new IllegalArgumentException(INVALID + string2 + " (must not contain . ; [ or /): " + string);
                }
                n6 = string.offsetByCodePoints(n6, 1);
            }
            return;
        }
        int n7 = n2;
        while (n7 < n4) {
            if (n7 == n2 ? !Character.isJavaIdentifierStart(string.codePointAt(n7)) : !Character.isJavaIdentifierPart(string.codePointAt(n7))) {
                throw new IllegalArgumentException(INVALID + string2 + " (must be a valid Java identifier): " + string);
            }
            n7 = string.offsetByCodePoints(n7, 1);
        }
    }

    static void checkMethodIdentifier(int n, String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(INVALID + string2 + MUST_NOT_BE_NULL_OR_EMPTY);
        }
        if ((n & 0xFFFF) >= 49) {
            int n2 = 0;
            while (n2 < string.length()) {
                if (".;[/<>".indexOf(string.codePointAt(n2)) != -1) {
                    throw new IllegalArgumentException(INVALID + string2 + " (must be a valid unqualified name): " + string);
                }
                n2 = string.offsetByCodePoints(n2, 1);
            }
            return;
        }
        int n3 = 0;
        while (n3 < string.length()) {
            if (n3 == 0 ? !Character.isJavaIdentifierStart(string.codePointAt(n3)) : !Character.isJavaIdentifierPart(string.codePointAt(n3))) {
                throw new IllegalArgumentException(INVALID + string2 + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + string);
            }
            n3 = string.offsetByCodePoints(n3, 1);
        }
    }

    static void checkInternalName(int n, String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(INVALID + string2 + MUST_NOT_BE_NULL_OR_EMPTY);
        }
        if (string.charAt(0) == '[') {
            CheckMethodAdapter.checkDescriptor(n, string, false);
        } else {
            CheckMethodAdapter.checkInternalClassName(n, string, string2);
        }
    }

    private static void checkInternalClassName(int n, String string, String string2) {
        try {
            int n2;
            int n3 = 0;
            while ((n2 = string.indexOf(47, n3 + 1)) != -1) {
                CheckMethodAdapter.checkIdentifier(n, string, n3, n2, null);
                n3 = n2 + 1;
            }
            CheckMethodAdapter.checkIdentifier(n, string, n3, string.length(), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(INVALID + string2 + " (must be an internal class name): " + string, illegalArgumentException);
        }
    }

    static void checkDescriptor(int n, String string, boolean bl) {
        int n2 = CheckMethodAdapter.checkDescriptor(n, string, 0, bl);
        if (n2 != string.length()) {
            throw new IllegalArgumentException(INVALID_DESCRIPTOR + string);
        }
    }

    private static int checkDescriptor(int n, String string, int n2, boolean bl) {
        if (string == null || n2 >= string.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (string.charAt(n2)) {
            case 'V': {
                if (bl) {
                    return n2 + 1;
                }
                throw new IllegalArgumentException(INVALID_DESCRIPTOR + string);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n2 + 1;
            }
            case '[': {
                int n3;
                for (n3 = n2 + 1; n3 < string.length() && string.charAt(n3) == '['; ++n3) {
                }
                if (n3 < string.length()) {
                    return CheckMethodAdapter.checkDescriptor(n, string, n3, false);
                }
                throw new IllegalArgumentException(INVALID_DESCRIPTOR + string);
            }
            case 'L': {
                int n4 = string.indexOf(59, n2);
                if (n2 == -1 || n4 - n2 < 2) {
                    throw new IllegalArgumentException(INVALID_DESCRIPTOR + string);
                }
                try {
                    CheckMethodAdapter.checkInternalClassName(n, string.substring(n2 + 1, n4), null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(INVALID_DESCRIPTOR + string, illegalArgumentException);
                }
                return n4 + 1;
            }
        }
        throw new IllegalArgumentException(INVALID_DESCRIPTOR + string);
    }

    static void checkMethodDescriptor(int n, String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (string.charAt(0) != '(' || string.length() < 3) {
            throw new IllegalArgumentException(INVALID_DESCRIPTOR + string);
        }
        int n2 = 1;
        if (string.charAt(n2) != ')') {
            do {
                if (string.charAt(n2) != 'V') continue;
                throw new IllegalArgumentException(INVALID_DESCRIPTOR + string);
            } while ((n2 = CheckMethodAdapter.checkDescriptor(n, string, n2, false)) < string.length() && string.charAt(n2) != ')');
        }
        if ((n2 = CheckMethodAdapter.checkDescriptor(n, string, n2 + 1, true)) != string.length()) {
            throw new IllegalArgumentException(INVALID_DESCRIPTOR + string);
        }
    }

    private void checkLabel(Label label, boolean bl, String string) {
        if (label == null) {
            throw new IllegalArgumentException(INVALID + string + " (must not be null)");
        }
        if (bl && this.labelInsnIndices.get(label) == null) {
            throw new IllegalArgumentException(INVALID + string + " (must be visited first)");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Method {
        VISIT_INSN,
        VISIT_INT_INSN,
        VISIT_VAR_INSN,
        VISIT_TYPE_INSN,
        VISIT_FIELD_INSN,
        VISIT_METHOD_INSN,
        VISIT_JUMP_INSN;

    }
}

