/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.tree;

import com.eg.org.objectweb.asm.AnnotationVisitor;
import com.eg.org.objectweb.asm.Attribute;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.ConstantDynamic;
import com.eg.org.objectweb.asm.Handle;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.TypePath;
import com.eg.org.objectweb.asm.tree.AbstractInsnNode;
import com.eg.org.objectweb.asm.tree.AnnotationNode;
import com.eg.org.objectweb.asm.tree.FieldInsnNode;
import com.eg.org.objectweb.asm.tree.FrameNode;
import com.eg.org.objectweb.asm.tree.IincInsnNode;
import com.eg.org.objectweb.asm.tree.InsnList;
import com.eg.org.objectweb.asm.tree.InsnNode;
import com.eg.org.objectweb.asm.tree.IntInsnNode;
import com.eg.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import com.eg.org.objectweb.asm.tree.JumpInsnNode;
import com.eg.org.objectweb.asm.tree.LabelNode;
import com.eg.org.objectweb.asm.tree.LdcInsnNode;
import com.eg.org.objectweb.asm.tree.LineNumberNode;
import com.eg.org.objectweb.asm.tree.LocalVariableAnnotationNode;
import com.eg.org.objectweb.asm.tree.LocalVariableNode;
import com.eg.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.eg.org.objectweb.asm.tree.MethodInsnNode;
import com.eg.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import com.eg.org.objectweb.asm.tree.ParameterNode;
import com.eg.org.objectweb.asm.tree.TableSwitchInsnNode;
import com.eg.org.objectweb.asm.tree.TryCatchBlockNode;
import com.eg.org.objectweb.asm.tree.TypeAnnotationNode;
import com.eg.org.objectweb.asm.tree.TypeInsnNode;
import com.eg.org.objectweb.asm.tree.UnsupportedClassVersionException;
import com.eg.org.objectweb.asm.tree.Util;
import com.eg.org.objectweb.asm.tree.VarInsnNode;
import java.util.ArrayList;
import java.util.List;

public class MethodNode
extends MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List<String> exceptions;
    public List<ParameterNode> parameters;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public Object annotationDefault;
    public int visibleAnnotableParameterCount;
    public List<AnnotationNode>[] visibleParameterAnnotations;
    public int invisibleAnnotableParameterCount;
    public List<AnnotationNode>[] invisibleParameterAnnotations;
    public InsnList instructions;
    public List<TryCatchBlockNode> tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List<LocalVariableNode> localVariables;
    public List<LocalVariableAnnotationNode> visibleLocalVariableAnnotations;
    public List<LocalVariableAnnotationNode> invisibleLocalVariableAnnotations;
    private boolean visited;

    public MethodNode() {
        this(458752);
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    public MethodNode(int n) {
        super(n);
        this.instructions = new InsnList();
    }

    public MethodNode(int n, String string, String string2, String string3, String[] stringArray) {
        this(458752, n, string, string2, string3, stringArray);
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    public MethodNode(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        super(n);
        this.access = n2;
        this.name = string;
        this.desc = string2;
        this.signature = string3;
        this.exceptions = Util.asArrayList(stringArray);
        if ((n2 & 0x400) == 0) {
            this.localVariables = new ArrayList<LocalVariableNode>(5);
        }
        this.tryCatchBlocks = new ArrayList<TryCatchBlockNode>();
        this.instructions = new InsnList();
    }

    public void visitParameter(String string, int n) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterNode>(5);
        }
        this.parameters.add(new ParameterNode(string, n));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode((List<Object>)new ArrayList<Object>(0){

            @Override
            public boolean add(Object object) {
                MethodNode.this.annotationDefault = object;
                return super.add(object);
            }
        });
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.visibleAnnotations.add(annotationNode);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.invisibleAnnotations.add(annotationNode);
        }
        return annotationNode;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (this.visibleTypeAnnotations == null) {
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            this.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (this.invisibleTypeAnnotations == null) {
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            this.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitAnnotableParameterCount(int n, boolean bl) {
        if (bl) {
            this.visibleAnnotableParameterCount = n;
        } else {
            this.invisibleAnnotableParameterCount = n;
        }
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleParameterAnnotations == null) {
                int n2 = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[n2];
            }
            if (this.visibleParameterAnnotations[n] == null) {
                this.visibleParameterAnnotations[n] = new ArrayList<AnnotationNode>(1);
            }
            this.visibleParameterAnnotations[n].add(annotationNode);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int n3 = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[n3];
            }
            if (this.invisibleParameterAnnotations[n] == null) {
                this.invisibleParameterAnnotations[n] = new ArrayList<AnnotationNode>(1);
            }
            this.invisibleParameterAnnotations[n].add(annotationNode);
        }
        return annotationNode;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList<Attribute>(1);
        }
        this.attrs.add(attribute);
    }

    public void visitCode() {
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.instructions.add(new FrameNode(n, n2, objectArray == null ? null : this.getLabelNodes(objectArray), n3, objectArray2 == null ? null : this.getLabelNodes(objectArray2)));
    }

    public void visitInsn(int n) {
        this.instructions.add(new InsnNode(n));
    }

    public void visitIntInsn(int n, int n2) {
        this.instructions.add(new IntInsnNode(n, n2));
    }

    public void visitVarInsn(int n, int n2) {
        this.instructions.add(new VarInsnNode(n, n2));
    }

    public void visitTypeInsn(int n, String string) {
        this.instructions.add(new TypeInsnNode(n, string));
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.instructions.add(new FieldInsnNode(n, string, string2, string3));
    }

    @Deprecated
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        if (this.api >= 327680) {
            super.visitMethodInsn(n, string, string2, string3);
            return;
        }
        this.instructions.add(new MethodInsnNode(n, string, string2, string3));
    }

    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        if (this.api < 327680) {
            super.visitMethodInsn(n, string, string2, string3, bl);
            return;
        }
        this.instructions.add(new MethodInsnNode(n, string, string2, string3, bl));
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.instructions.add(new InvokeDynamicInsnNode(string, string2, handle, objectArray));
    }

    public void visitJumpInsn(int n, Label label) {
        this.instructions.add(new JumpInsnNode(n, this.getLabelNode(label)));
    }

    public void visitLabel(Label label) {
        this.instructions.add(this.getLabelNode(label));
    }

    public void visitLdcInsn(Object object) {
        this.instructions.add(new LdcInsnNode(object));
    }

    public void visitIincInsn(int n, int n2) {
        this.instructions.add(new IincInsnNode(n, n2));
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        this.instructions.add(new TableSwitchInsnNode(n, n2, this.getLabelNode(label), this.getLabelNodes(labelArray)));
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.instructions.add(new LookupSwitchInsnNode(this.getLabelNode(label), nArray, this.getLabelNodes(labelArray)));
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.instructions.add(new MultiANewArrayInsnNode(string, n));
    }

    public AnnotationVisitor visitInsnAnnotation(int n, TypePath typePath, String string, boolean bl) {
        AbstractInsnNode abstractInsnNode = this.instructions.getLast();
        while (abstractInsnNode.getOpcode() == -1) {
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (abstractInsnNode.visibleTypeAnnotations == null) {
                abstractInsnNode.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            abstractInsnNode.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (abstractInsnNode.invisibleTypeAnnotations == null) {
                abstractInsnNode.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            abstractInsnNode.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(this.getLabelNode(label), this.getLabelNode(label2), this.getLabelNode(label3), string));
    }

    public AnnotationVisitor visitTryCatchAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TryCatchBlockNode tryCatchBlockNode = this.tryCatchBlocks.get((n & 0xFFFF00) >> 8);
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (tryCatchBlockNode.visibleTypeAnnotations == null) {
                tryCatchBlockNode.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            tryCatchBlockNode.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (tryCatchBlockNode.invisibleTypeAnnotations == null) {
                tryCatchBlockNode.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            tryCatchBlockNode.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.localVariables.add(new LocalVariableNode(string, string2, string3, this.getLabelNode(label), this.getLabelNode(label2), n));
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        LocalVariableAnnotationNode localVariableAnnotationNode = new LocalVariableAnnotationNode(n, typePath, this.getLabelNodes(labelArray), this.getLabelNodes(labelArray2), nArray, string);
        if (bl) {
            if (this.visibleLocalVariableAnnotations == null) {
                this.visibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>(1);
            }
            this.visibleLocalVariableAnnotations.add(localVariableAnnotationNode);
        } else {
            if (this.invisibleLocalVariableAnnotations == null) {
                this.invisibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>(1);
            }
            this.invisibleLocalVariableAnnotations.add(localVariableAnnotationNode);
        }
        return localVariableAnnotationNode;
    }

    public void visitLineNumber(int n, Label label) {
        this.instructions.add(new LineNumberNode(n, this.getLabelNode(label)));
    }

    public void visitMaxs(int n, int n2) {
        this.maxStack = n;
        this.maxLocals = n2;
    }

    public void visitEnd() {
    }

    protected LabelNode getLabelNode(Label label) {
        if (!(label.info instanceof LabelNode)) {
            label.info = new LabelNode();
        }
        return (LabelNode)label.info;
    }

    private LabelNode[] getLabelNodes(Label[] labelArray) {
        LabelNode[] labelNodeArray = new LabelNode[labelArray.length];
        int n = labelArray.length;
        for (int i = 0; i < n; ++i) {
            labelNodeArray[i] = this.getLabelNode(labelArray[i]);
        }
        return labelNodeArray;
    }

    private Object[] getLabelNodes(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (Object object : objectArray) {
            if (object instanceof Label) {
                object = this.getLabelNode((Label)object);
            }
            objectArray2[var3_3] = object;
        }
        return objectArray2;
    }

    public void check(int n) {
        Object object;
        int n2;
        if (n == 262144) {
            if (this.parameters != null && !this.parameters.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.visibleTypeAnnotations != null && !this.visibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.invisibleTypeAnnotations != null && !this.invisibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.tryCatchBlocks != null) {
                for (n2 = this.tryCatchBlocks.size() - 1; n2 >= 0; --n2) {
                    object = this.tryCatchBlocks.get(n2);
                    if (((TryCatchBlockNode)object).visibleTypeAnnotations != null && !((TryCatchBlockNode)object).visibleTypeAnnotations.isEmpty()) {
                        throw new UnsupportedClassVersionException();
                    }
                    if (((TryCatchBlockNode)object).invisibleTypeAnnotations == null || ((TryCatchBlockNode)object).invisibleTypeAnnotations.isEmpty()) continue;
                    throw new UnsupportedClassVersionException();
                }
            }
            for (n2 = this.instructions.size() - 1; n2 >= 0; --n2) {
                Object object2;
                boolean bl;
                object = this.instructions.get(n2);
                if (((AbstractInsnNode)object).visibleTypeAnnotations != null && !((AbstractInsnNode)object).visibleTypeAnnotations.isEmpty()) {
                    throw new UnsupportedClassVersionException();
                }
                if (((AbstractInsnNode)object).invisibleTypeAnnotations != null && !((AbstractInsnNode)object).invisibleTypeAnnotations.isEmpty()) {
                    throw new UnsupportedClassVersionException();
                }
                if (!(object instanceof MethodInsnNode ? (bl = ((MethodInsnNode)object).itf) != (((AbstractInsnNode)object).opcode == 185) : object instanceof LdcInsnNode && ((object2 = ((LdcInsnNode)object).cst) instanceof Handle || object2 instanceof Type && ((Type)object2).getSort() == 11))) continue;
                throw new UnsupportedClassVersionException();
            }
            if (this.visibleLocalVariableAnnotations != null && !this.visibleLocalVariableAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.invisibleLocalVariableAnnotations != null && !this.invisibleLocalVariableAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
        }
        if (n != 458752) {
            for (n2 = this.instructions.size() - 1; n2 >= 0; --n2) {
                Object object3;
                object = this.instructions.get(n2);
                if (!(object instanceof LdcInsnNode) || !((object3 = ((LdcInsnNode)object).cst) instanceof ConstantDynamic)) continue;
                throw new UnsupportedClassVersionException();
            }
        }
    }

    public void accept(ClassVisitor classVisitor) {
        String[] stringArray = new String[this.exceptions.size()];
        this.exceptions.toArray(stringArray);
        MethodVisitor methodVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, this.signature, stringArray);
        if (methodVisitor != null) {
            this.accept(methodVisitor);
        }
    }

    public void accept(MethodVisitor methodVisitor) {
        AnnotationNode annotationNode;
        int n;
        int n2;
        List<AnnotationNode> list;
        int n3;
        int n4;
        if (this.parameters != null) {
            n4 = this.parameters.size();
            for (n3 = 0; n3 < n4; ++n3) {
                this.parameters.get(n3).accept(methodVisitor);
            }
        }
        if (this.annotationDefault != null) {
            AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotationDefault();
            AnnotationNode.accept(annotationVisitor, null, this.annotationDefault);
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
        if (this.visibleAnnotations != null) {
            n4 = this.visibleAnnotations.size();
            for (n3 = 0; n3 < n4; ++n3) {
                list = this.visibleAnnotations.get(n3);
                ((AnnotationNode)((Object)list)).accept(methodVisitor.visitAnnotation(((AnnotationNode)((Object)list)).desc, true));
            }
        }
        if (this.invisibleAnnotations != null) {
            n4 = this.invisibleAnnotations.size();
            for (n3 = 0; n3 < n4; ++n3) {
                list = this.invisibleAnnotations.get(n3);
                ((AnnotationNode)((Object)list)).accept(methodVisitor.visitAnnotation(((AnnotationNode)((Object)list)).desc, false));
            }
        }
        if (this.visibleTypeAnnotations != null) {
            n4 = this.visibleTypeAnnotations.size();
            for (n3 = 0; n3 < n4; ++n3) {
                list = this.visibleTypeAnnotations.get(n3);
                ((AnnotationNode)((Object)list)).accept(methodVisitor.visitTypeAnnotation(((TypeAnnotationNode)((Object)list)).typeRef, ((TypeAnnotationNode)((Object)list)).typePath, ((TypeAnnotationNode)((Object)list)).desc, true));
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            n4 = this.invisibleTypeAnnotations.size();
            for (n3 = 0; n3 < n4; ++n3) {
                list = this.invisibleTypeAnnotations.get(n3);
                ((AnnotationNode)((Object)list)).accept(methodVisitor.visitTypeAnnotation(((TypeAnnotationNode)((Object)list)).typeRef, ((TypeAnnotationNode)((Object)list)).typePath, ((TypeAnnotationNode)((Object)list)).desc, false));
            }
        }
        if (this.visibleAnnotableParameterCount > 0) {
            methodVisitor.visitAnnotableParameterCount(this.visibleAnnotableParameterCount, true);
        }
        if (this.visibleParameterAnnotations != null) {
            n4 = this.visibleParameterAnnotations.length;
            for (n3 = 0; n3 < n4; ++n3) {
                list = this.visibleParameterAnnotations[n3];
                if (list == null) continue;
                n2 = list.size();
                for (n = 0; n < n2; ++n) {
                    annotationNode = list.get(n);
                    annotationNode.accept(methodVisitor.visitParameterAnnotation(n3, annotationNode.desc, true));
                }
            }
        }
        if (this.invisibleAnnotableParameterCount > 0) {
            methodVisitor.visitAnnotableParameterCount(this.invisibleAnnotableParameterCount, false);
        }
        if (this.invisibleParameterAnnotations != null) {
            n4 = this.invisibleParameterAnnotations.length;
            for (n3 = 0; n3 < n4; ++n3) {
                list = this.invisibleParameterAnnotations[n3];
                if (list == null) continue;
                n2 = list.size();
                for (n = 0; n < n2; ++n) {
                    annotationNode = list.get(n);
                    annotationNode.accept(methodVisitor.visitParameterAnnotation(n3, annotationNode.desc, false));
                }
            }
        }
        if (this.visited) {
            this.instructions.resetLabels();
        }
        if (this.attrs != null) {
            n4 = this.attrs.size();
            for (n3 = 0; n3 < n4; ++n3) {
                methodVisitor.visitAttribute(this.attrs.get(n3));
            }
        }
        if (this.instructions.size() > 0) {
            methodVisitor.visitCode();
            if (this.tryCatchBlocks != null) {
                n4 = this.tryCatchBlocks.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    this.tryCatchBlocks.get(n3).updateIndex(n3);
                    this.tryCatchBlocks.get(n3).accept(methodVisitor);
                }
            }
            this.instructions.accept(methodVisitor);
            if (this.localVariables != null) {
                n4 = this.localVariables.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    this.localVariables.get(n3).accept(methodVisitor);
                }
            }
            if (this.visibleLocalVariableAnnotations != null) {
                n4 = this.visibleLocalVariableAnnotations.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    this.visibleLocalVariableAnnotations.get(n3).accept(methodVisitor, true);
                }
            }
            if (this.invisibleLocalVariableAnnotations != null) {
                n4 = this.invisibleLocalVariableAnnotations.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    this.invisibleLocalVariableAnnotations.get(n3).accept(methodVisitor, false);
                }
            }
            methodVisitor.visitMaxs(this.maxStack, this.maxLocals);
            this.visited = true;
        }
        methodVisitor.visitEnd();
    }
}

