/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.commons;

import com.eg.org.objectweb.asm.ConstantDynamic;
import com.eg.org.objectweb.asm.Handle;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.commons.SignatureRemapper;
import com.eg.org.objectweb.asm.signature.SignatureReader;
import com.eg.org.objectweb.asm.signature.SignatureVisitor;
import com.eg.org.objectweb.asm.signature.SignatureWriter;

public abstract class Remapper {
    public String mapDesc(String string) {
        return this.mapType(Type.getType(string)).getDescriptor();
    }

    private Type mapType(Type type) {
        switch (type.getSort()) {
            case 9: {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < type.getDimensions(); ++i) {
                    stringBuilder.append('[');
                }
                stringBuilder.append(this.mapType(type.getElementType()).getDescriptor());
                return Type.getType(stringBuilder.toString());
            }
            case 10: {
                String string = this.map(type.getInternalName());
                return string != null ? Type.getObjectType(string) : type;
            }
            case 11: {
                return Type.getMethodType(this.mapMethodDesc(type.getDescriptor()));
            }
        }
        return type;
    }

    public String mapType(String string) {
        if (string == null) {
            return null;
        }
        return this.mapType(Type.getObjectType(string)).getInternalName();
    }

    public String[] mapTypes(String[] stringArray) {
        String[] stringArray2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = this.mapType(string);
            if (string2 == null) continue;
            if (stringArray2 == null) {
                stringArray2 = new String[stringArray.length];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            }
            stringArray2[i] = string2;
        }
        return stringArray2 != null ? stringArray2 : stringArray;
    }

    public String mapMethodDesc(String string) {
        if ("()V".equals(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        for (Type type : Type.getArgumentTypes(string)) {
            stringBuilder.append(this.mapType(type).getDescriptor());
        }
        Type type = Type.getReturnType(string);
        if (type == Type.VOID_TYPE) {
            stringBuilder.append(")V");
        } else {
            stringBuilder.append(')').append(this.mapType(type).getDescriptor());
        }
        return stringBuilder.toString();
    }

    public Object mapValue(Object object) {
        if (object instanceof Type) {
            return this.mapType((Type)object);
        }
        if (object instanceof Handle) {
            Handle handle = (Handle)object;
            return new Handle(handle.getTag(), this.mapType(handle.getOwner()), this.mapMethodName(handle.getOwner(), handle.getName(), handle.getDesc()), handle.getTag() <= 4 ? this.mapDesc(handle.getDesc()) : this.mapMethodDesc(handle.getDesc()), handle.isInterface());
        }
        if (object instanceof ConstantDynamic) {
            ConstantDynamic constantDynamic = (ConstantDynamic)object;
            int n = constantDynamic.getBootstrapMethodArgumentCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.mapValue(constantDynamic.getBootstrapMethodArgument(i));
            }
            String string = constantDynamic.getDescriptor();
            return new ConstantDynamic(this.mapInvokeDynamicMethodName(constantDynamic.getName(), string), this.mapDesc(string), (Handle)this.mapValue(constantDynamic.getBootstrapMethod()), objectArray);
        }
        return object;
    }

    public String mapSignature(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        SignatureReader signatureReader = new SignatureReader(string);
        SignatureWriter signatureWriter = new SignatureWriter();
        SignatureVisitor signatureVisitor = this.createSignatureRemapper(signatureWriter);
        if (bl) {
            signatureReader.acceptType(signatureVisitor);
        } else {
            signatureReader.accept(signatureVisitor);
        }
        return signatureWriter.toString();
    }

    @Deprecated
    protected SignatureVisitor createRemappingSignatureAdapter(SignatureVisitor signatureVisitor) {
        return this.createSignatureRemapper(signatureVisitor);
    }

    protected SignatureVisitor createSignatureRemapper(SignatureVisitor signatureVisitor) {
        return new SignatureRemapper(signatureVisitor, this);
    }

    public String mapInnerClassName(String string, String string2, String string3) {
        String string4 = this.mapType(string);
        if (string4.contains("$")) {
            return string4.substring(string4.lastIndexOf(36) + 1);
        }
        return string3;
    }

    public String mapMethodName(String string, String string2, String string3) {
        return string2;
    }

    public String mapInvokeDynamicMethodName(String string, String string2) {
        return string;
    }

    public String mapFieldName(String string, String string2, String string3) {
        return string2;
    }

    public String mapPackageName(String string) {
        return string;
    }

    public String mapModuleName(String string) {
        return string;
    }

    public String map(String string) {
        return string;
    }
}

