/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jvmmonitor.utils;

import com.eg.jtm.BTMLog;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class JVMUtils {
    private static MBeanServerConnection beanServerConn = null;
    private static boolean isSunJVM = false;
    private static boolean isIBMJVM = false;
    private static boolean isZingJVM = false;
    private static boolean zingMXBeanExists = false;
    private static final String JAVAX_MANAGEMENT_BUILDER_INITIAL = "javax.management.builder.initial";
    private static OperatingSystemMXBean operatingSystemMXBean = null;
    private static int availableProcessor = 1;
    private static final String osName = System.getProperty("os.name").toLowerCase();
    private static String pid = null;
    private static ObjectName oname = null;

    public boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isIBMJVM() {
        return isIBMJVM;
    }

    public static boolean isSunJVM() {
        return isSunJVM;
    }

    public static boolean isZingJVM() {
        return isZingJVM;
    }

    private static MBeanServerConnection initalizeMbeanServerConnection() {
        if ((System.getProperty(JAVAX_MANAGEMENT_BUILDER_INITIAL) != null || ManagementFactory.getRuntimeMXBean().getUptime() > 20000L) && (beanServerConn = ManagementFactory.getPlatformMBeanServer()) != null) {
            try {
                operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
                oname = new ObjectName("java.lang:type=OperatingSystem");
                isIBMJVM = beanServerConn.isInstanceOf(oname, "com.ibm.lang.management.OperatingSystemMXBean");
                isSunJVM = beanServerConn.isInstanceOf(oname, "com.sun.management.OperatingSystemMXBean");
                availableProcessor = operatingSystemMXBean.getAvailableProcessors();
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                pid = runtimeMXBean.getName();
                String string = runtimeMXBean.getVmName();
                String string2 = runtimeMXBean.getVmVersion();
                if (string != null && (string = string.toLowerCase()).indexOf("zing") > -1) {
                    isZingJVM = true;
                }
                if (string2 != null && (string2 = string2.toLowerCase()).indexOf("azul") > -1) {
                    isZingJVM = true;
                }
                try {
                    String[] stringArray = beanServerConn.getDomains();
                    if (stringArray != null && stringArray.length > 0) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string3 = stringArray[i];
                            if (string3 == null || !string3.equals("com.azul.zing")) continue;
                            isZingJVM = true;
                            zingMXBeanExists = true;
                        }
                    }
                    BTMLog.logger.trace("[JVMUtils] - Operating System of target JVM : " + osName);
                    BTMLog.logger.trace("[JVMUtils] - PID of the target JVM : " + pid);
                    BTMLog.logger.trace("[JVMUtils] - Is target JVM is IBM JVM : " + isIBMJVM);
                    BTMLog.logger.trace("[JVMUtils] - Is target JVM is sun JVM : " + isSunJVM);
                    BTMLog.logger.trace("[JVMUtils] - Is target JVM is Zing JVM : " + isZingJVM);
                    BTMLog.logger.trace("[JVMUtils] - Target JVM is Zing JVM and Domain com.azul.zing exits : " + zingMXBeanExists);
                    BTMLog.logger.trace("[JVMUtils] - Number of processor available in the target JVM : " + availableProcessor);
                }
                catch (Exception exception) {
                    BTMLog.logger.error("[JVMUtils] - Exception while finding isZingJVM() :" + exception.getMessage());
                }
            }
            catch (Exception exception) {
                BTMLog.logger.error("[JVMUtils] - initalizeMbeanServerConnection Exception occured " + exception.getMessage());
            }
        }
        return beanServerConn;
    }

    public static MBeanServerConnection getMbeanServerConnection() {
        if (beanServerConn == null) {
            beanServerConn = JVMUtils.initalizeMbeanServerConnection();
        }
        return beanServerConn;
    }

    public static boolean isPlatFormMbeanInitialized() {
        return JVMUtils.initalizeMbeanServerConnection() != null;
    }

    public static ObjectName getOperatingSystemMXBeanObjectName() {
        return oname;
    }

    public static int getAvilableProcessor() {
        return availableProcessor;
    }

    public static String getOSName() {
        return osName;
    }

    public static boolean isZingMXBeanExists() {
        return zingMXBeanExists;
    }

    public static String getCurrentPID() {
        return pid;
    }

    public static final Long getProcessCpuTime() {
        Long l = null;
        try {
            ObjectName objectName = JVMUtils.getOperatingSystemMXBeanObjectName();
            if (!JVMUtils.getOSName().equalsIgnoreCase("aix") && (JVMUtils.isSunJVM() || JVMUtils.isIBMJVM())) {
                l = (Long)beanServerConn.getAttribute(objectName, "ProcessCpuTime");
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("[JVMUtils] - Exception occured while getting ProcessCpuTime " + exception.getMessage());
        }
        return l;
    }
}

