/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jvmmonitor.metric;

import com.eg.jtm.BTMLog;
import com.eg.jvmmonitor.JVMMetric;
import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class JVMGarbageCollectionInfo
extends JVMMetric {
    public ArrayList pollMeasures() {
        Object object;
        Hashtable hashtable = new Hashtable();
        Hashtable<String, Long> hashtable2 = new Hashtable<String, Long>();
        ArrayList<Hashtable<String, Serializable>> arrayList = new ArrayList<Hashtable<String, Serializable>>();
        try {
            object = ManagementFactory.getGarbageCollectorMXBeans();
            if (!this.isNull(object)) {
                Iterator<GarbageCollectorMXBean> iterator = object.iterator();
                while (iterator.hasNext()) {
                    GarbageCollectorMXBean garbageCollectorMXBean = iterator.next();
                    String string = garbageCollectorMXBean.getName();
                    Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
                    hashtable3.put("collectionName", new String(garbageCollectorMXBean.getName()));
                    hashtable3.put("gcCount", new Long(garbageCollectorMXBean.getCollectionCount()));
                    hashtable3.put("collectionTime", new Long(garbageCollectorMXBean.getCollectionTime()));
                    hashtable.put(string, hashtable3);
                }
            } else {
                BTMLog.logger.debug("[JVMGarbageCollectionInfo]-GarbageCollectorMXBean Object is null!!");
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("[JVMGarbageCollectionInfo] - Exception occured. " + exception.getMessage());
        }
        object = ManagementFactory.getRuntimeMXBean();
        if (object != null) {
            hashtable2.put("gcUptime", new Long(object.getUptime()));
        }
        arrayList.add(hashtable);
        arrayList.add(hashtable2);
        return arrayList;
    }
}

