/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jvmmonitor.metric;

import com.eg.jtm.BTMLog;
import com.eg.jvmmonitor.JVMMetric;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Hashtable;

public class JVMConfigInfo
extends JVMMetric {
    public ArrayList pollMeasures() {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
            if (!this.isNull(runtimeMXBean)) {
                String string = null;
                Object var4_5 = null;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                ArrayList<Hashtable<String, Object>> arrayList = new ArrayList<Hashtable<String, Object>>();
                hashtable.put("jvm", new String(runtimeMXBean.getVmName()));
                hashtable.put("version", new String(runtimeMXBean.getVmVersion()));
                hashtable.put("vendor", new String(runtimeMXBean.getVmVendor()));
                if (compilationMXBean != null) {
                    hashtable.put("JITCompiler", new String(compilationMXBean.getName()));
                } else {
                    hashtable.put("JITCompiler", new String("-"));
                }
                hashtable.put("vmArguments", new ArrayList<String>(runtimeMXBean.getInputArguments()));
                hashtable.put("classPath", new String(runtimeMXBean.getClassPath()));
                hashtable.put("libraryPath", new String(runtimeMXBean.getLibraryPath()));
                boolean bl = runtimeMXBean.isBootClassPathSupported();
                if (bl) {
                    try {
                        string = runtimeMXBean.getBootClassPath();
                    }
                    catch (SecurityException securityException) {
                        BTMLog.logger.error("[JVMConfigInfo] :[RuntimeMXBean.getBootClassPath] security manager exists and the caller does not have ManagementPermission(\"monitor\") ", (Object)securityException.getMessage());
                        string = "Unavailable";
                    }
                } else {
                    string = "Unavailable";
                }
                hashtable.put("bootClassPath", new String(string));
                MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                if (memoryMXBean != null) {
                    hashtable.put("max_heap_size", new Long(memoryMXBean.getHeapMemoryUsage().getMax()));
                } else {
                    hashtable.put("max_heap_size", new Long(0L));
                }
                hashtable.put("javaVersion", new String(runtimeMXBean.getSystemProperties().get("java.version")));
                hashtable.put("javaArch", new String(runtimeMXBean.getSystemProperties().get("sun.arch.data.model")));
                hashtable.put("startTime", new Long(runtimeMXBean.getStartTime()));
                arrayList.add(hashtable);
                return arrayList;
            }
            BTMLog.logger.debug("[JVMConfigInfo] - RuntimeMXBean object is null!!!");
        }
        catch (Exception exception) {
            BTMLog.logger.error("[JVMConfigInfo] - Exception occured. {}", (Object)exception.getMessage());
        }
        return null;
    }
}

