/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jvmmonitor;

import com.eg.jtm.BTMLog;
import com.eg.jtm.JVMConfig;
import com.eg.jvmmonitor.JVMMetric;
import com.eg.jvmmonitor.metric.JVMCPUInfo;
import com.eg.jvmmonitor.metric.JVMClassInfo;
import com.eg.jvmmonitor.metric.JVMConfigInfo;
import com.eg.jvmmonitor.metric.JVMFileDescriptorInfo;
import com.eg.jvmmonitor.metric.JVMGarbageCollectionInfo;
import com.eg.jvmmonitor.metric.JVMMemoryInfo;
import com.eg.jvmmonitor.metric.JVMMemoryLeakInfo;
import com.eg.jvmmonitor.metric.JVMMemoryPoolGCInfo;
import com.eg.jvmmonitor.metric.JVMMemoryPoolInfo;
import com.eg.jvmmonitor.metric.JVMThreadInfo;
import com.eg.jvmmonitor.metric.JVMUptimeInfo;
import com.eg.jvmmonitor.utils.JVMConstants;
import com.eg.jvmmonitor.utils.JVMUtils;
import java.util.ArrayList;
import java.util.Hashtable;

public class JVMMetricPoller
extends JVMUtils {
    private String entity = null;
    private String fileName = null;
    private String path = null;
    private String targetHost_port = null;
    public static final Hashtable<String, JVMMetric> ENTITY_MAPPING = new Hashtable();

    public JVMMetricPoller(String string) {
        this.entity = string;
    }

    public JVMMetricPoller(String string, String string2, String string3, String string4) {
        this.entity = string;
        this.fileName = string2;
        this.path = string3;
        this.targetHost_port = string4;
    }

    public JVMMetricPoller(String string, String string2, String string3, String string4, String string5, String string6) {
        this.entity = string;
    }

    public ArrayList getMetrics() {
        JVMMetric jVMMetric = null;
        ArrayList arrayList = null;
        try {
            jVMMetric = this.entity.equalsIgnoreCase(JVMConstants.JVM_TESTS[5]) ? new JVMMemoryInfo(JVMConfig.getJava_Home()) : (this.entity.equalsIgnoreCase(JVMConstants.JVM_TESTS[4]) ? new JVMMemoryLeakInfo(this.path, this.fileName, this.targetHost_port) : ENTITY_MAPPING.get(this.entity));
            if (!this.isNull(jVMMetric)) {
                arrayList = ((JVMMetric)jVMMetric).pollMeasures();
            }
            return arrayList;
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception while getting JVM metrics via JVMMetricPoller ", exception);
            return null;
        }
    }

    static {
        ENTITY_MAPPING.put(JVMConstants.JVM_TESTS[0], new JVMClassInfo());
        ENTITY_MAPPING.put(JVMConstants.JVM_TESTS[1], new JVMThreadInfo());
        ENTITY_MAPPING.put(JVMConstants.JVM_TESTS[2], new JVMUptimeInfo());
        ENTITY_MAPPING.put(JVMConstants.JVM_TESTS[3], new JVMMemoryPoolGCInfo());
        ENTITY_MAPPING.put(JVMConstants.JVM_TESTS[4], new JVMMemoryLeakInfo());
        ENTITY_MAPPING.put(JVMConstants.JVM_TESTS[5], new JVMMemoryInfo());
        ENTITY_MAPPING.put(JVMConstants.JVM_TESTS[6], new JVMGarbageCollectionInfo());
        ENTITY_MAPPING.put(JVMConstants.JVM_TESTS[7], new JVMCPUInfo());
        ENTITY_MAPPING.put(JVMConstants.JVM_TESTS[8], new JVMFileDescriptorInfo());
        ENTITY_MAPPING.put(JVMConstants.JVM_TESTS[9], new JVMConfigInfo());
        ENTITY_MAPPING.put(JVMConstants.JVM_TESTS[10], new JVMMemoryPoolInfo());
    }
}

