/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jvmmonitor;

import com.eg.jvmmonitor.utils.JVMUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public abstract class JVMMetric
extends JVMUtils {
    private String seperator = ":";
    public boolean zingJVM = false;
    public boolean jvmIdentified = false;
    public boolean zingMXBeanExists = false;

    public abstract ArrayList pollMeasures();

    protected Object getObject(Hashtable hashtable, String string, Object object) {
        if (object instanceof CompositeData) {
            return this.getCompositeData(hashtable, string, (CompositeData)object);
        }
        if (object instanceof TabularData) {
            return this.getTabularData(hashtable, string, (TabularData)object);
        }
        if (object instanceof Map) {
            return this.getMapData(hashtable, string, (Map)object);
        }
        if (object instanceof Collection) {
            return this.getArrayData(hashtable, string, ((Collection)object).toArray());
        }
        return this.getSimpleData(hashtable, string, object);
    }

    protected Object getSimpleData(Hashtable hashtable, String string, Object object) {
        if (string != null && object != null) {
            hashtable.put(string, object);
        }
        return hashtable;
    }

    protected Object getArrayData(Hashtable hashtable, String string, Object object) {
        if (object == null) {
            return this.getSimpleData(hashtable, string, null);
        }
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            this.getObject(hashtable, string + "[" + i + "]", object2);
        }
        return hashtable;
    }

    protected Object getMapData(Hashtable hashtable, String string, Map map) {
        if (map == null) {
            return this.getSimpleData(hashtable, string, null);
        }
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            this.getObject(hashtable, string + "[" + entry.getKey() + "]", entry.getValue());
        }
        return hashtable;
    }

    protected Object getTabularData(Hashtable hashtable, String string, TabularData tabularData) {
        if (tabularData == null) {
            return this.getSimpleData(hashtable, string, null);
        }
        List<String> list = tabularData.getTabularType().getIndexNames();
        int n = list.size();
        Set<?> set = tabularData.keySet();
        for (Object obj : set) {
            Object[] objectArray = ((List)obj).toArray();
            StringBuilder stringBuilder = new StringBuilder(string);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.seperator + objectArray[i]);
            }
            this.getCompositeData(hashtable, stringBuilder.toString(), tabularData.get(objectArray));
        }
        return hashtable;
    }

    protected Object getCompositeData(Hashtable hashtable, String string, CompositeData compositeData) {
        if (compositeData == null) {
            return this.getSimpleData(hashtable, string, null);
        }
        Set<String> set = compositeData.getCompositeType().keySet();
        for (String string2 : set) {
            if (string2.equals("key")) {
                Object object = compositeData.get(string2);
                string2 = "";
                continue;
            }
            if (string2.equals("value")) {
                this.getObject(hashtable, string, compositeData.get(string2));
                continue;
            }
            this.getObject(hashtable, string + this.seperator + string2, compositeData.get(string2));
        }
        return hashtable;
    }
}

