/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.discovery;

import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.discovery.AutoDiscovery;

public abstract class DiscoveryBase
extends Thread {
    protected boolean isPlatFormMbeanInitialized = false;

    public void run() {
        long l = BTMOffLoadConfig.getDiscoveryMaxWaitTime() - 60000L;
        long l2 = 0L;
        if (this.validateUsingSystemProperty()) {
            while (!this.isPlatFormMbeanInitialized) {
                try {
                    this.isPlatFormMbeanInitialized = AutoDiscovery.isPlatFormMbeanInitilized();
                    if (l2 >= l) {
                        BTMLog.logger.info("time out for Platform MBean Server and Platform MXBeans connection...");
                        break;
                    }
                    BTMLog.logger.info("connection to Platform MBean Server and Platform MXBeans is not initialized waiting, wait time : {}", (Object)(l2 += 10000L));
                    AutoDiscovery.waitTime(10000L);
                }
                catch (Exception exception) {
                    this.isPlatFormMbeanInitialized = false;
                }
            }
            if (AutoDiscovery.getmServerConnection() != null) {
                l2 = 0L;
                BTMLog.logger.warn("INFO:- connection to Platform MBean Server and Platform MXBeans is initialized = [{}] collecting details...", (Object)this.isPlatFormMbeanInitialized);
                while (AutoDiscovery.getServerNameWithVersion() == null || AutoDiscovery.getServerIP() == null) {
                    this.getOtherDetailsUsingMBeanServer();
                    if (l2 >= BTMOffLoadConfig.getMbeanMaxWaitTime()) {
                        BTMLog.logger.warn("INFO:- connection to Platform MBean Server available but MBean object not initialized waited for = [{}] ms.", (Object)BTMOffLoadConfig.getMbeanMaxWaitTime());
                        break;
                    }
                    l2 += 10000L;
                    AutoDiscovery.waitTime(10000L);
                }
                AutoDiscovery.setStausOfClassNameDiscovery(true);
            }
        }
    }

    protected abstract boolean validateUsingSystemProperty();

    protected abstract void getOtherDetailsUsingMBeanServer();
}

