/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLPatternData {
    String pName;
    boolean modified;
    double[] sumOf;
    double[] numOf;
    private ArrayList<MethodInfo> SlowURLsList = null;
    private ArrayList<MethodInfo> ErrorURLsList = null;
    private ArrayList<MethodInfo> AllURLsList = null;
    private ArrayList<MethodInfo> HealthyTHREADList = null;
    private ArrayList<MethodInfo> SlowTHREADsList = null;
    private ArrayList<MethodInfo> ErrorTHREADsList = null;
    private ArrayList<MethodInfo> StalledURLsList = null;
    private ArrayList<MethodInfo> StalledTHREADsList = null;
    static final double defaultValue = 0.0;

    URLPatternData(String string) {
        this.pName = string;
        this.modified = false;
        int n = PropsManager.getSubCompNameLength();
        this.sumOf = new double[n];
        this.numOf = new double[n];
    }

    public ArrayList<MethodInfo> getAllURLsList() {
        return this.AllURLsList;
    }

    public ArrayList<MethodInfo> getHealthyThreadList() {
        return this.HealthyTHREADList;
    }

    public ArrayList<MethodInfo> getSlowURLsList() {
        return this.SlowURLsList;
    }

    public ArrayList<MethodInfo> getErrorURLsList() {
        return this.ErrorURLsList;
    }

    public ArrayList<MethodInfo> getSlowTHREADsList() {
        return this.SlowTHREADsList;
    }

    public ArrayList<MethodInfo> getErrorTHREADsList() {
        return this.ErrorTHREADsList;
    }

    public ArrayList<MethodInfo> getStalledURLsList() {
        return this.StalledURLsList;
    }

    public ArrayList<MethodInfo> getStalledTHREADsList() {
        return this.StalledTHREADsList;
    }

    public void cleanStalledURLsList() {
        this.StalledURLsList = null;
    }

    public void cleanStalledTHREADsList() {
        this.StalledTHREADsList = null;
    }

    public void cleanAllURLsList() {
        this.AllURLsList = null;
    }

    public void cleanHealthyThreadList() {
        this.HealthyTHREADList = null;
    }

    public void cleanSlowURLsList() {
        this.SlowURLsList = null;
    }

    public void cleanErrorURLsList() {
        this.ErrorURLsList = null;
    }

    public void cleanSlowTHREADsList() {
        this.SlowTHREADsList = null;
    }

    public void cleanErrorTHREADsList() {
        this.ErrorTHREADsList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHashtables(int n, double d, double d2) {
        if (d >= 0.0) {
            URLPatternData uRLPatternData = this;
            synchronized (uRLPatternData) {
                this.sumOf[n] = this.sumOf[n] + d;
                this.numOf[n] = this.numOf[n] + d2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThreadTimingHashtables(int n, double d, double d2) {
        URLPatternData uRLPatternData = this;
        synchronized (uRLPatternData) {
            this.sumOf[n] = this.sumOf[n] + d;
            this.numOf[n] = this.numOf[n] + d2;
        }
    }

    private void parseMinfoAndCalc(MethodInfo methodInfo) {
        Object v = methodInfo.getProperties().remove("SlowSQLTime");
        if (v != null) {
            double d = 0.0;
            double d2 = 0.0;
            if (v instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)v;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Double d3 = (Double)arrayList.get(i);
                    double d4 = d3;
                    if (!(d4 >= PropsManager.getSQLExecCutOff())) continue;
                    d += 1.0;
                    d2 += d4;
                }
            } else {
                double[] dArray = (double[])v;
                d = dArray[0];
                d2 = dArray[1];
            }
            this.updateHashtables(4, d2, d);
        }
    }

    void SortedAddToURLList(ArrayList arrayList, MethodInfo methodInfo, String string, int n) {
        MethodInfo methodInfo2;
        int n2;
        double d = methodInfo.getExecutionTime();
        for (n2 = 0; n2 < arrayList.size() && !((double)(methodInfo2 = (MethodInfo)arrayList.get(n2)).getExecutionTime() < d); ++n2) {
        }
        arrayList.add(n2, methodInfo);
        if (arrayList.size() > n && (methodInfo2 = (MethodInfo)arrayList.remove(arrayList.size() - 1)) != null) {
            methodInfo2.clearURLTree();
        }
    }

    private void storeAllURLInfo(MethodInfo methodInfo, String string) {
        BTMLog.logger.info("Added the following Healthy URL to All urls list for pattern {} ", (Object)this.pName);
        BTMLog.logger.info(methodInfo.printTree());
        if (string.equals("Web")) {
            if (this.AllURLsList == null) {
                this.AllURLsList = new ArrayList();
            }
            this.SortedAddToURLList(this.AllURLsList, methodInfo, "ALL_URLS", PropsManager.getHelathyURLs());
        } else if (string.equals("Thread")) {
            if (this.HealthyTHREADList == null) {
                this.HealthyTHREADList = new ArrayList();
            }
            this.SortedAddToURLList(this.HealthyTHREADList, methodInfo, "ALL_URLS", PropsManager.getHelathyURLs());
        }
    }

    private boolean storeURLIfNeeded(MethodInfo methodInfo, boolean bl, String string) {
        double d = methodInfo.getExecutionTime();
        if (!methodInfo.isSlowURL() && !methodInfo.isErrorURL() && !methodInfo.isStalled() || !(d >= 0.0)) {
            return false;
        }
        if (methodInfo.isErrorURL()) {
            int n = PropsManager.getMaxErrorURLs();
            if (string.equals("Web")) {
                BTMLog.logger.info("Added the following ERROR URL to error urls list for pattern {} ", (Object)this.pName);
                BTMLog.logger.debug(methodInfo.printTree());
                if (this.ErrorURLsList == null) {
                    this.ErrorURLsList = new ArrayList();
                }
                this.updateHashtables(2, d, 1.0);
                if (bl) {
                    this.updateHashtables(7, d, 1.0);
                }
                this.SortedAddToURLList(this.ErrorURLsList, methodInfo, "ERROR_URLS", n);
            } else if (string.equals("Thread")) {
                BTMLog.logger.info("Added the following ERROR URL to error urls list for pattern {} ", (Object)this.pName);
                BTMLog.logger.info(methodInfo.printTree());
                if (this.ErrorTHREADsList == null) {
                    this.ErrorTHREADsList = new ArrayList();
                }
                this.SortedAddToURLList(this.ErrorTHREADsList, methodInfo, "ERROR_URLS", n);
            }
        } else if (methodInfo.isStalled()) {
            int n = PropsManager.getMaxStalledURLs();
            if (string.equals("Web")) {
                BTMLog.logger.info("Added the following STALLED URL to stalled urls list for pattern {}", (Object)this.pName);
                BTMLog.logger.debug(methodInfo.printTree());
                if (this.StalledURLsList == null) {
                    this.StalledURLsList = new ArrayList();
                }
                this.updateHashtables(3, d, 1.0);
                if (bl) {
                    this.updateHashtables(8, d, 1.0);
                }
                this.SortedAddToURLList(this.StalledURLsList, methodInfo, "STALLED_URLS", n);
            } else if (string.equals("Thread")) {
                BTMLog.logger.info("Added the following STALLED URL to stalled urls list for pattern {}", (Object)this.pName);
                BTMLog.logger.debug(methodInfo.printTree());
                if (this.StalledTHREADsList == null) {
                    this.StalledTHREADsList = new ArrayList();
                }
                this.SortedAddToURLList(this.StalledTHREADsList, methodInfo, "STALLED_URLS", n);
            }
        } else if (methodInfo.isSlowURL()) {
            int n = PropsManager.getMaxSlowURLs();
            if (string.equals("Web")) {
                BTMLog.logger.info("Added the following SLOW URL to slow urls list for pattern {} ", (Object)this.pName);
                BTMLog.logger.debug(methodInfo.printTree());
                if (this.SlowURLsList == null) {
                    this.SlowURLsList = new ArrayList();
                }
                this.updateHashtables(1, d, 1.0);
                if (bl) {
                    this.updateHashtables(6, d, 1.0);
                }
                this.SortedAddToURLList(this.SlowURLsList, methodInfo, "SLOW_URLS", n);
            } else if (string.equals("Thread")) {
                BTMLog.logger.info("Added the following SLOW URL to slow urls list for pattern {} ", (Object)this.pName);
                BTMLog.logger.debug(methodInfo.printTree());
                if (this.SlowTHREADsList == null) {
                    this.SlowTHREADsList = new ArrayList();
                }
                this.SortedAddToURLList(this.SlowTHREADsList, methodInfo, "SLOW_URLS", n);
            }
        }
        return true;
    }

    public void updateAllUrlCount(MethodInfo methodInfo, boolean bl, String string, long l, long l2, long l3) {
        if ((double)methodInfo.getExecutionTime() >= 0.0) {
            this.modified = true;
        }
        if (string != null && string.equals("Web")) {
            this.updateHashtables(0, methodInfo.getExecutionTime(), 1.0);
            this.updateThreadDiagonosis(l, l2, l3);
            if (bl) {
                this.updateHashtables(5, methodInfo.getExecutionTime(), 1.0);
            }
        }
        if (methodInfo.isSQLPresent()) {
            this.parseMinfoAndCalc(methodInfo);
        }
        if (PropsManager.isTraceHealthyURL()) {
            this.storeAllURLInfo(methodInfo, string);
        } else {
            methodInfo.clearURLTree();
        }
    }

    public void addStalledURLInfo(MethodInfo methodInfo, boolean bl, String string, long l, long l2, long l3) {
        if ((double)methodInfo.getExecutionTime() >= 0.0) {
            this.modified = true;
        }
        if (string != null && string.equals("Web")) {
            double d = methodInfo.getExecutionTime();
            this.updateHashtables(0, d, 1.0);
            this.updateThreadDiagonosis(l, l2, l3);
            if (bl) {
                this.updateHashtables(5, methodInfo.getExecutionTime(), 1.0);
            }
            if (methodInfo.isSQLPresent()) {
                this.parseMinfoAndCalc(methodInfo);
            }
        }
        boolean bl2 = this.storeURLIfNeeded(methodInfo, bl, string);
    }

    public void addURLInfo(MethodInfo methodInfo, boolean bl, String string, long l, long l2, long l3) {
        if ((double)methodInfo.getExecutionTime() >= 0.0) {
            this.modified = true;
        }
        if (string != null && string.equals("Web")) {
            this.updateHashtables(0, methodInfo.getExecutionTime(), 1.0);
            this.updateThreadDiagonosis(l, l2, l3);
            if (bl) {
                this.updateHashtables(5, methodInfo.getExecutionTime(), 1.0);
            }
        }
        if (methodInfo.isSQLPresent()) {
            this.parseMinfoAndCalc(methodInfo);
        }
        boolean bl2 = this.storeURLIfNeeded(methodInfo, bl, string);
    }

    private void updateThreadDiagonosis(long l, long l2, long l3) {
        if (l >= 0L) {
            this.updateThreadTimingHashtables(9, l, 1.0);
        }
        if (l2 >= 0L) {
            this.updateThreadTimingHashtables(10, l2, 1.0);
        }
        if (l3 >= 0L) {
            this.updateThreadTimingHashtables(11, l3, 1.0);
        }
    }
}

