/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.BTMSocket;
import com.eg.jtm.DataWriterProvider;
import com.eg.jtm.PropsManager;
import com.eg.jtm.STATUS;
import com.eg.org.apache.commons.lang3.SerializationUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.List;

public final class OffLoadAgentCheck
implements Runnable {
    private static final int SOCKET_MAX_RETRY_ATTEMPTS = 4;
    private static final int MAX_RETRY_ATTEMPTS = 4;
    private STATUS checkStatus = STATUS.NONE;
    private static final long FIVE_SECOND = 5000L;
    private int port;
    private static final String PING_MESSAGE = "OFFLOAD - PING";
    private static OffLoadAgentCheck offloadAgentCheckInstance;

    private OffLoadAgentCheck(int n) {
        this.port = n;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setCheckStatus(STATUS sTATUS) {
        this.checkStatus = sTATUS;
    }

    public STATUS getCheckStatus() {
        return this.checkStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OffLoadAgentCheck getInstance() {
        if (offloadAgentCheckInstance != null) return offloadAgentCheckInstance;
        Class<OffLoadAgentCheck> clazz = OffLoadAgentCheck.class;
        synchronized (OffLoadAgentCheck.class) {
            if (offloadAgentCheckInstance != null) return offloadAgentCheckInstance;
            offloadAgentCheckInstance = new OffLoadAgentCheck(BTMOffLoadConfig.getCollectorAgentPortNo());
            // ** MonitorExit[var0] (shouldn't be in output)
            return offloadAgentCheckInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ObjectOutputStream objectOutputStream = null;
        DataWriterProvider dataWriterProvider = new DataWriterProvider();
        String string = "[" + Thread.currentThread().getName() + "]";
        int n = 1;
        String string2 = "";
        if (this.checkStatus == STATUS.DISCOVERY) {
            string2 = "[OFFLoad DiscoveryCheck]";
            try {
                BTMLog.logger.info("{}- {} check started by {} !!! ", new Object[]{string2, STATUS.DISCOVERY, string});
                BTMLog.logger.info("{}- {} Retry attempt - {} & Is this component is managed? {} ", new Object[]{string2, STATUS.DISCOVERY, n, BTMOffLoadConfig.isThisComponentManaged()});
                while (!BTMOffLoadConfig.isThisComponentManaged() && n <= 4) {
                    ++n;
                    try {
                        boolean bl = this.doCheck(dataWriterProvider, objectOutputStream, this.port, false, string, string2);
                        if (!BTMOffLoadConfig.isThisComponentManaged()) {
                            if (!bl) {
                                string2 = "[OFFLoad DiscoveryAgentPortCheck]";
                                this.portCheck(dataWriterProvider, objectOutputStream, false, string, string2);
                                continue;
                            }
                            BTMLog.logger.trace("{} eG Agent responded to {}, So, Skipping the next eG Agent port list check !!!", (Object)string2, (Object)this.port);
                            continue;
                        }
                        break;
                    }
                    catch (Exception exception) {
                        BTMOffLoadConfig.resetThisComponentManaged();
                        BTMLog.logger.warn("{} eG Agent is not reachable from this JVM {} ", (Object)string2, (Object)exception.getMessage());
                    }
                    finally {
                        if (BTMOffLoadConfig.isThisComponentManaged()) continue;
                        try {
                            Thread.sleep(5000L);
                            BTMLog.logger.debug("{} eG Java BTM trying on {} attempt to find eG Agent is reachable or not", (Object)string2, (Object)n);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("{} Exception in the {} check due to {} ", new Object[]{string2, STATUS.DISCOVERY, exception});
            }
            this.checkStatus = STATUS.NONE;
        } else if (this.checkStatus == STATUS.OFFLOAD) {
            string2 = "[OFFLoad AgentCheck]";
            try {
                BTMLog.logger.info("{}- {} check started by {} !!! ", new Object[]{string2, STATUS.OFFLOAD, string});
                BTMLog.logger.info("{}- Is this Offload-Agent?  {} ", (Object)string2, (Object)BTMOffLoadConfig.isThisOffloadAgent());
                while (!BTMOffLoadConfig.isThisOffloadAgent() && n <= 4) {
                    ++n;
                    try {
                        boolean bl = this.doCheck(dataWriterProvider, objectOutputStream, this.port, true, string, string2);
                        if (BTMOffLoadConfig.isThisOffloadAgent()) break;
                        if (!bl) {
                            string2 = "[OFFLoad AgentPortCheck]";
                            this.portCheck(dataWriterProvider, objectOutputStream, true, string, string2);
                        } else {
                            BTMLog.logger.trace("{} eG Agent responded to {}, So, Skipping the next eG Agent port list check !!!", (Object)string2, (Object)this.port);
                        }
                    }
                    catch (Exception exception) {
                        BTMOffLoadConfig.resetThisOffloadAgent();
                        BTMLog.logger.warn("{} eG Agent is not reachable from this JVM {} ", (Object)string2, (Object)exception.getMessage());
                    }
                    finally {
                        if (n != 3 || !BTMOffLoadConfig.isThisOffloadAgent()) {
                            // empty if block
                        }
                    }
                    if (BTMOffLoadConfig.isThisOffloadAgent()) continue;
                    try {
                        Thread.sleep(5000L);
                        BTMLog.logger.debug("{} eG Java BTM trying on {} attempt to find eG Agent is reachable or not", (Object)string2, (Object)n);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("{} Exception in the {} check due to {} ", new Object[]{string2, STATUS.OFFLOAD, exception});
            }
            this.checkStatus = STATUS.NONE;
        }
        BTMLog.logger.info("{} eG Java BTM Status Found as {} ", (Object)string2, (Object)this.checkStatus);
    }

    private void portCheck(DataWriterProvider dataWriterProvider, ObjectOutputStream objectOutputStream, boolean bl, String string, String string2) {
        List list = BTMOffLoadConfig.getOffloadPortOrder();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                int n = Integer.parseInt((String)list.get(i));
                boolean bl2 = this.doCheck(dataWriterProvider, objectOutputStream, n, bl, string, string2);
                if (bl2) {
                    BTMLog.logger.info("{} eG Agent responded to {}, So, Skipping the next eG Agent port check !!!", (Object)string2, (Object)n);
                    if (this.checkStatus != STATUS.DISCOVERY) break;
                    BTMOffLoadConfig.writeDetailsInConfig("AGENT_PORT", n + "");
                    break;
                }
                if (bl ? BTMOffLoadConfig.isThisOffloadAgent() : BTMOffLoadConfig.isThisComponentManaged()) break;
            }
        }
    }

    private boolean doCheck(DataWriterProvider dataWriterProvider, ObjectOutputStream objectOutputStream, int n, boolean bl, String string, String string2) {
        boolean bl2;
        block13: {
            bl2 = false;
            BTMSocket bTMSocket = null;
            try {
                dataWriterProvider.closeObjectOutputStream(objectOutputStream, string);
                bTMSocket = dataWriterProvider.establishConnection(true, n);
                bTMSocket = bTMSocket == null ? dataWriterProvider.establishConnection(true, n) : bTMSocket;
                objectOutputStream = dataWriterProvider.getOOStreamForOffloadAgentCheck(bTMSocket, string, n);
                if (objectOutputStream != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string3 = "DISCOVER message [DISCOVER_ME]";
                    if (bl) {
                        stringBuilder.append(PING_MESSAGE).append("!;-;!");
                        string3 = "PING message [OFFLOAD - PING]";
                    }
                    stringBuilder.append(PropsManager.getJvmGUID());
                    byte[] byArray = SerializationUtils.serialize((Serializable)((Object)new String(stringBuilder)));
                    objectOutputStream.writeInt(byArray.length);
                    objectOutputStream.write(byArray);
                    objectOutputStream.flush();
                    BTMLog.logger.debug("{} Sent " + string3 + " to eG Agent {}:{}", string2, BTMOffLoadConfig.getCollectorAgentIP(), n);
                    ObjectInputStream objectInputStream = dataWriterProvider.getObjInputStream(bTMSocket, false, string);
                    try {
                        if (objectInputStream != null) {
                            Object object;
                            BTMLog.logger.debug("{} Trying to get reply from eG Agent {}:{}", string2, bTMSocket.getInetAddress(), bTMSocket.getLocalPort());
                            do {
                                object = objectInputStream.readObject();
                                BTMLog.logger.debug("{} Got reply[{}] from eG Agent {}:{}", string2, object.toString(), bTMSocket.getInetAddress(), bTMSocket.getLocalPort());
                            } while (!(object instanceof String));
                            String string4 = (String)object;
                            bl2 = bl ? BTMOffLoadConfig.validateMessage(string4, bTMSocket, n, string) : BTMOffLoadConfig.validateDiscoverMessage(string4, bTMSocket, string);
                            return bl2;
                        }
                        if (bl) {
                            BTMOffLoadConfig.resetThisOffloadAgent();
                        } else {
                            BTMOffLoadConfig.resetThisComponentManaged();
                        }
                        BTMLog.logger.debug("{} eG Java Agent is reachable but NO response ", (Object)string2);
                    }
                    catch (IOException iOException) {
                        try {
                            OffLoadAgentCheck.closeClientSocket(bTMSocket);
                            BTMLog.logger.warn("{} IO Exception due to {} ", (Object)string2, (Object)iOException);
                            break block13;
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (Exception exception) {
                        BTMLog.logger.error("{} Exception due to {} ", (Object)string2, (Object)exception);
                    }
                    break block13;
                }
                BTMLog.logger.info("{} Getting NULL Stream while pinging eG Agent.", (Object)string2);
            }
            catch (Exception exception) {
                BTMLog.logger.error("{} Exception occured while doing OFFLoad / Discovery check ", (Object)string2, (Object)exception);
            }
        }
        return bl2;
    }

    private static void closeClientSocket(Socket socket) {
        if (socket != null) {
            try {
                if (!socket.isClosed()) {
                    socket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

