/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.rolling.helper;

import com.eg.ch.qos.logback.core.pattern.DynamicConverter;
import com.eg.ch.qos.logback.core.rolling.helper.MonoTypedConverter;
import com.eg.ch.qos.logback.core.util.CachingDateFormatter;
import com.eg.ch.qos.logback.core.util.DatePatternToRegexUtil;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTokenConverter<E>
extends DynamicConverter<E>
implements MonoTypedConverter {
    public static final String CONVERTER_KEY = "d";
    public static final String AUXILIARY_TOKEN = "AUX";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private String datePattern;
    private TimeZone timeZone;
    private CachingDateFormatter cdf;
    private boolean primary = true;

    @Override
    public void start() {
        List<String> list;
        this.datePattern = this.getFirstOption();
        if (this.datePattern == null) {
            this.datePattern = DEFAULT_DATE_PATTERN;
        }
        if ((list = this.getOptionList()) != null) {
            for (int i = 1; i < list.size(); ++i) {
                String string = list.get(i);
                if (AUXILIARY_TOKEN.equalsIgnoreCase(string)) {
                    this.primary = false;
                    continue;
                }
                this.timeZone = TimeZone.getTimeZone(string);
            }
        }
        this.cdf = new CachingDateFormatter(this.datePattern);
        if (this.timeZone != null) {
            this.cdf.setTimeZone(this.timeZone);
        }
    }

    @Override
    public String convert(Date date) {
        return this.cdf.format(date.getTime());
    }

    @Override
    public String convert(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null argument forbidden");
        }
        if (object instanceof Date) {
            return this.convert((Date)object);
        }
        throw new IllegalArgumentException("Cannot convert " + object + " of type" + object.getClass().getName());
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public boolean isApplicable(Object object) {
        return object instanceof Date;
    }

    public String toRegex() {
        DatePatternToRegexUtil datePatternToRegexUtil = new DatePatternToRegexUtil(this.datePattern);
        return datePatternToRegexUtil.toRegex();
    }

    public boolean isPrimary() {
        return this.primary;
    }
}

