/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.net;

import com.eg.ch.qos.logback.core.AppenderBase;
import com.eg.ch.qos.logback.core.Layout;
import com.eg.ch.qos.logback.core.net.SyslogOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SyslogAppenderBase<E>
extends AppenderBase<E> {
    static final String SYSLOG_LAYOUT_URL = "http://logback.qos.ch/codes.html#syslog_layout";
    static final int MAX_MESSAGE_SIZE_LIMIT = 65000;
    Layout<E> layout;
    String facilityStr;
    String syslogHost;
    protected String suffixPattern;
    SyslogOutputStream sos;
    int port = 514;
    int maxMessageSize;
    Charset charset;

    @Override
    public void start() {
        int n = 0;
        if (this.facilityStr == null) {
            this.addError("The Facility option is mandatory");
            ++n;
        }
        if (this.charset == null) {
            this.charset = Charset.defaultCharset();
        }
        try {
            this.sos = this.createOutputStream();
            int n2 = this.sos.getSendBufferSize();
            if (this.maxMessageSize == 0) {
                this.maxMessageSize = Math.min(n2, 65000);
                this.addInfo("Defaulting maxMessageSize to [" + this.maxMessageSize + "]");
            } else if (this.maxMessageSize > n2) {
                this.addWarn("maxMessageSize of [" + this.maxMessageSize + "] is larger than the system defined datagram size of [" + n2 + "].");
                this.addWarn("This may result in dropped logs.");
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.addError("Could not create SyslogWriter", unknownHostException);
            ++n;
        }
        catch (SocketException socketException) {
            this.addWarn("Failed to bind to a random datagram socket. Will try to reconnect later.", socketException);
        }
        if (this.layout == null) {
            this.layout = this.buildLayout();
        }
        if (n == 0) {
            super.start();
        }
    }

    public abstract SyslogOutputStream createOutputStream() throws UnknownHostException, SocketException;

    public abstract Layout<E> buildLayout();

    public abstract int getSeverityForEvent(Object var1);

    @Override
    protected void append(E e) {
        if (!this.isStarted()) {
            return;
        }
        try {
            String string = this.layout.doLayout(e);
            if (string == null) {
                return;
            }
            if (string.length() > this.maxMessageSize) {
                string = string.substring(0, this.maxMessageSize);
            }
            this.sos.write(string.getBytes(this.charset));
            this.sos.flush();
            this.postProcess(e, this.sos);
        }
        catch (IOException iOException) {
            this.addError("Failed to send diagram to " + this.syslogHost, iOException);
        }
    }

    protected void postProcess(Object object, OutputStream outputStream) {
    }

    public static int facilityStringToint(String string) {
        if ("KERN".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("USER".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("MAIL".equalsIgnoreCase(string)) {
            return 16;
        }
        if ("DAEMON".equalsIgnoreCase(string)) {
            return 24;
        }
        if ("AUTH".equalsIgnoreCase(string)) {
            return 32;
        }
        if ("SYSLOG".equalsIgnoreCase(string)) {
            return 40;
        }
        if ("LPR".equalsIgnoreCase(string)) {
            return 48;
        }
        if ("NEWS".equalsIgnoreCase(string)) {
            return 56;
        }
        if ("UUCP".equalsIgnoreCase(string)) {
            return 64;
        }
        if ("CRON".equalsIgnoreCase(string)) {
            return 72;
        }
        if ("AUTHPRIV".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("FTP".equalsIgnoreCase(string)) {
            return 88;
        }
        if ("NTP".equalsIgnoreCase(string)) {
            return 96;
        }
        if ("AUDIT".equalsIgnoreCase(string)) {
            return 104;
        }
        if ("ALERT".equalsIgnoreCase(string)) {
            return 112;
        }
        if ("CLOCK".equalsIgnoreCase(string)) {
            return 120;
        }
        if ("LOCAL0".equalsIgnoreCase(string)) {
            return 128;
        }
        if ("LOCAL1".equalsIgnoreCase(string)) {
            return 136;
        }
        if ("LOCAL2".equalsIgnoreCase(string)) {
            return 144;
        }
        if ("LOCAL3".equalsIgnoreCase(string)) {
            return 152;
        }
        if ("LOCAL4".equalsIgnoreCase(string)) {
            return 160;
        }
        if ("LOCAL5".equalsIgnoreCase(string)) {
            return 168;
        }
        if ("LOCAL6".equalsIgnoreCase(string)) {
            return 176;
        }
        if ("LOCAL7".equalsIgnoreCase(string)) {
            return 184;
        }
        throw new IllegalArgumentException(string + " is not a valid syslog facility string");
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setSyslogHost(String string) {
        this.syslogHost = string;
    }

    public String getFacility() {
        return this.facilityStr;
    }

    public void setFacility(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.facilityStr = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int n) {
        this.maxMessageSize = n;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.addWarn("The layout of a SyslogAppender cannot be set directly. See also http://logback.qos.ch/codes.html#syslog_layout");
    }

    @Override
    public void stop() {
        if (this.sos != null) {
            this.sos.close();
        }
        super.stop();
    }

    public String getSuffixPattern() {
        return this.suffixPattern;
    }

    public void setSuffixPattern(String string) {
        this.suffixPattern = string;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

