/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran.spi;

import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.joran.action.Action;
import com.eg.ch.qos.logback.core.joran.spi.ElementPath;
import com.eg.ch.qos.logback.core.joran.spi.ElementSelector;
import com.eg.ch.qos.logback.core.joran.spi.RuleStore;
import com.eg.ch.qos.logback.core.spi.ContextAwareBase;
import com.eg.ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRuleStore
extends ContextAwareBase
implements RuleStore {
    static String KLEENE_STAR = "*";
    HashMap<ElementSelector, List<Action>> rules = new HashMap();

    public SimpleRuleStore(Context context) {
        this.setContext(context);
    }

    @Override
    public void addRule(ElementSelector elementSelector, Action action) {
        action.setContext(this.context);
        List<Action> list = this.rules.get(elementSelector);
        if (list == null) {
            list = new ArrayList<Action>();
            this.rules.put(elementSelector, list);
        }
        list.add(action);
    }

    @Override
    public void addRule(ElementSelector elementSelector, String string) {
        Action action = null;
        try {
            action = (Action)OptionHelper.instantiateByClassName(string, Action.class, this.context);
        }
        catch (Exception exception) {
            this.addError("Could not instantiate class [" + string + "]", exception);
        }
        if (action != null) {
            this.addRule(elementSelector, action);
        }
    }

    @Override
    public List<Action> matchActions(ElementPath elementPath) {
        List<Action> list = this.fullPathMatch(elementPath);
        if (list != null) {
            return list;
        }
        list = this.suffixMatch(elementPath);
        if (list != null) {
            return list;
        }
        list = this.prefixMatch(elementPath);
        if (list != null) {
            return list;
        }
        list = this.middleMatch(elementPath);
        if (list != null) {
            return list;
        }
        return null;
    }

    List<Action> fullPathMatch(ElementPath elementPath) {
        for (ElementSelector elementSelector : this.rules.keySet()) {
            if (!elementSelector.fullPathMatch(elementPath)) continue;
            return this.rules.get(elementSelector);
        }
        return null;
    }

    List<Action> suffixMatch(ElementPath elementPath) {
        int n = 0;
        ElementSelector elementSelector = null;
        for (ElementSelector elementSelector2 : this.rules.keySet()) {
            int n2;
            if (!this.isSuffixPattern(elementSelector2) || (n2 = elementSelector2.getTailMatchLength(elementPath)) <= n) continue;
            n = n2;
            elementSelector = elementSelector2;
        }
        if (elementSelector != null) {
            return this.rules.get(elementSelector);
        }
        return null;
    }

    private boolean isSuffixPattern(ElementSelector elementSelector) {
        return elementSelector.size() > 1 && elementSelector.get(0).equals(KLEENE_STAR);
    }

    List<Action> prefixMatch(ElementPath elementPath) {
        int n = 0;
        ElementSelector elementSelector = null;
        for (ElementSelector elementSelector2 : this.rules.keySet()) {
            int n2;
            String string = elementSelector2.peekLast();
            if (!this.isKleeneStar(string) || (n2 = elementSelector2.getPrefixMatchLength(elementPath)) != elementSelector2.size() - 1 || n2 <= n) continue;
            n = n2;
            elementSelector = elementSelector2;
        }
        if (elementSelector != null) {
            return this.rules.get(elementSelector);
        }
        return null;
    }

    private boolean isKleeneStar(String string) {
        return KLEENE_STAR.equals(string);
    }

    List<Action> middleMatch(ElementPath elementPath) {
        int n = 0;
        ElementSelector elementSelector = null;
        for (ElementSelector elementSelector2 : this.rules.keySet()) {
            String string = elementSelector2.peekLast();
            String string2 = null;
            if (elementSelector2.size() > 1) {
                string2 = elementSelector2.get(0);
            }
            if (!this.isKleeneStar(string) || !this.isKleeneStar(string2)) continue;
            List<String> list = elementSelector2.getCopyOfPartList();
            if (list.size() > 2) {
                list.remove(0);
                list.remove(list.size() - 1);
            }
            int n2 = 0;
            ElementSelector elementSelector3 = new ElementSelector(list);
            if (elementSelector3.isContainedIn(elementPath)) {
                n2 = elementSelector3.size();
            }
            if (n2 <= n) continue;
            n = n2;
            elementSelector = elementSelector2;
        }
        if (elementSelector != null) {
            return this.rules.get(elementSelector);
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SimpleRuleStore ( ").append("rules = ").append(this.rules).append("  ").append(" )");
        return stringBuilder.toString();
    }
}

