/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.db;

import com.eg.ch.qos.logback.core.db.ConnectionSourceBase;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JNDIConnectionSource
extends ConnectionSourceBase {
    private String jndiLocation = null;
    private DataSource dataSource = null;

    public void start() {
        if (this.jndiLocation == null) {
            this.addError("No JNDI location specified for JNDIConnectionSource.");
        }
        this.discoverConnectionProperties();
    }

    public Connection getConnection() throws SQLException {
        Connection connection = null;
        try {
            if (this.dataSource == null) {
                this.dataSource = this.lookupDataSource();
            }
            if (this.getUser() != null) {
                this.addWarn("Ignoring property [user] with value [" + this.getUser() + "] for obtaining a connection from a DataSource.");
            }
            connection = this.dataSource.getConnection();
        }
        catch (NamingException namingException) {
            this.addError("Error while getting data source", namingException);
            throw new SQLException("NamingException while looking up DataSource: " + namingException.getMessage());
        }
        catch (ClassCastException classCastException) {
            this.addError("ClassCastException while looking up DataSource.", classCastException);
            throw new SQLException("ClassCastException while looking up DataSource: " + classCastException.getMessage());
        }
        return connection;
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public void setJndiLocation(String string) {
        this.jndiLocation = string;
    }

    private DataSource lookupDataSource() throws NamingException, SQLException {
        this.addInfo("Looking up [" + this.jndiLocation + "] in JNDI");
        InitialContext initialContext = new InitialContext();
        Object object = initialContext.lookup(this.jndiLocation);
        DataSource dataSource = (DataSource)object;
        if (dataSource == null) {
            throw new SQLException("Failed to obtain data source from JNDI location " + this.jndiLocation);
        }
        return dataSource;
    }
}

