/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.gaffer;

import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.gaffer.GafferConfigurator;
import com.eg.ch.qos.logback.core.status.ErrorStatus;
import com.eg.ch.qos.logback.core.status.StatusManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;

public class GafferUtil {
    private static String ERROR_MSG = "Failed to instantiate ch.qos.logback.classic.gaffer.GafferConfigurator";

    public static void runGafferConfiguratorOn(LoggerContext loggerContext, Object object, File file) {
        GafferConfigurator gafferConfigurator = GafferUtil.newGafferConfiguratorInstance(loggerContext, object);
        if (gafferConfigurator != null) {
            gafferConfigurator.run(file);
        }
    }

    public static void runGafferConfiguratorOn(LoggerContext loggerContext, Object object, URL uRL) {
        GafferConfigurator gafferConfigurator = GafferUtil.newGafferConfiguratorInstance(loggerContext, object);
        if (gafferConfigurator != null) {
            gafferConfigurator.run(uRL);
        }
    }

    private static GafferConfigurator newGafferConfiguratorInstance(LoggerContext loggerContext, Object object) {
        try {
            Class<?> clazz = Class.forName("ch.qos.logback.classic.gaffer.GafferConfigurator");
            Constructor<?> constructor = clazz.getConstructor(LoggerContext.class);
            return (GafferConfigurator)constructor.newInstance(loggerContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            GafferUtil.addError(loggerContext, object, ERROR_MSG, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            GafferUtil.addError(loggerContext, object, ERROR_MSG, noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            GafferUtil.addError(loggerContext, object, ERROR_MSG, invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            GafferUtil.addError(loggerContext, object, ERROR_MSG, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            GafferUtil.addError(loggerContext, object, ERROR_MSG, illegalAccessException);
        }
        return null;
    }

    private static void addError(LoggerContext loggerContext, Object object, String string) {
        GafferUtil.addError(loggerContext, object, string, null);
    }

    private static void addError(LoggerContext loggerContext, Object object, String string, Throwable throwable) {
        StatusManager statusManager = loggerContext.getStatusManager();
        if (statusManager == null) {
            return;
        }
        statusManager.add(new ErrorStatus(string, object, throwable));
    }
}

