/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.org.objectweb.asm.ClassReader;
import com.eg.org.objectweb.asm.Type;
import java.io.IOException;
import java.io.InputStream;

public class EgClassMetaData {
    private static final int HEADER_MODIFIERS_OFFSET = 0;
    private static final int HEADER_SUPER_CLASS_CONSTANT_POOL_OFFSET = 4;
    private static final int HEADER_NUM_INTERFACES_OFFSET = 6;
    private static final int HEADER_INITIAL_INTERFACE_OFFSET = 8;
    private static final int INTERFACE = 512;
    private Type type;
    private ClassLoader classLoader;
    private ClassReader classReader;
    int modifiers;
    String superClass;
    String[] interfaces;
    EgClassMetaData superClassMetadata;
    EgClassMetaData[] interfaceMetadata;

    public EgClassMetaData(String string, ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (classLoader == null) {
            this.classLoader = ClassLoader.getSystemClassLoader();
        }
        this.type = Type.getObjectType(string);
        this.classReader = this.getClassReader(string, this.classLoader);
        this.modifiers = this.classReader.readUnsignedShort(this.classReader.header + 0);
        char[] cArray = new char[2048];
        int n = this.classReader.getItem(this.classReader.readUnsignedShort(this.classReader.header + 4));
        this.superClass = n == 0 ? null : this.classReader.readUTF8(n, cArray);
        this.interfaces = new String[this.classReader.readUnsignedShort(this.classReader.header + 6)];
        int n2 = this.classReader.header + 8;
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.interfaces[i] = this.classReader.readClass(n2, cArray);
            n2 += 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassReader getClassReader(String string, ClassLoader classLoader) {
        String string2 = string.replace('.', '/') + ".class";
        InputStream inputStream = null;
        ClassReader classReader = null;
        try {
            inputStream = classLoader.getResourceAsStream(string2);
            classReader = new ClassReader(inputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return classReader;
    }

    String getName() {
        return this.type.getInternalName();
    }

    EgClassMetaData getSuperclass() {
        if (this.superClass == null) {
            return null;
        }
        if (this.superClassMetadata == null) {
            this.superClassMetadata = new EgClassMetaData(this.superClass, this.classLoader);
        }
        return this.superClassMetadata;
    }

    EgClassMetaData[] getInterfaces() {
        if (this.interfaceMetadata == null) {
            this.interfaceMetadata = new EgClassMetaData[this.interfaces.length];
            for (int i = 0; i < this.interfaces.length; ++i) {
                this.interfaceMetadata[i] = new EgClassMetaData(this.interfaces[i], this.classLoader);
            }
        }
        return this.interfaceMetadata;
    }

    boolean isInterface() {
        return (this.modifiers & 0x200) > 0;
    }

    private boolean implementsInterface(EgClassMetaData egClassMetaData) {
        if (this == egClassMetaData) {
            return true;
        }
        for (EgClassMetaData egClassMetaData2 = this; egClassMetaData2 != null; egClassMetaData2 = egClassMetaData2.getSuperclass()) {
            for (EgClassMetaData egClassMetaData3 : egClassMetaData2.getInterfaces()) {
                if (!egClassMetaData3.type.equals(egClassMetaData.type) && !egClassMetaData3.implementsInterface(egClassMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSubclassOf(EgClassMetaData egClassMetaData) {
        for (EgClassMetaData egClassMetaData2 = this; egClassMetaData2 != null; egClassMetaData2 = egClassMetaData2.getSuperclass()) {
            EgClassMetaData egClassMetaData3 = egClassMetaData2.getSuperclass();
            if (egClassMetaData3 == null || !egClassMetaData3.type.equals(egClassMetaData.type)) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableFrom(EgClassMetaData egClassMetaData) {
        return this == egClassMetaData || egClassMetaData.implementsInterface(this) || egClassMetaData.isSubclassOf(this) || egClassMetaData.isInterface() && this.type.getDescriptor().equals("Ljava/lang/Object;");
    }
}

