/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.trace.utils;

import com.eg.agent.trace.utils.TraceUtils;
import com.eg.jtm.BTMLog;
import com.eg.jtm.RequestIdentifier;

public class HtmlTagChecker {
    public static void checkTag(RequestIdentifier requestIdentifier, String string) {
        String string2;
        String string3 = requestIdentifier.getRequestURL();
        Object object = requestIdentifier.getResponseObject();
        if (object != null && requestIdentifier.getContentType() == RequestIdentifier.ContentType.UNKNOWN) {
            try {
                string2 = TraceUtils.getResponseContentType(object, string3);
                if (string2 == null) {
                    return;
                }
                BTMLog.logger.debug("Content-Type is : {}  for the URL {} ", (Object)string2, (Object)string3);
                if (string2 != null) {
                    if (string2.indexOf("text/html") != -1) {
                        requestIdentifier.setContentType(RequestIdentifier.ContentType.TEXT_HTML, string2);
                        BTMLog.logger.debug("Assiging TEXT_HTML, since content-type is : {} for the URL : {} ", (Object)string2, (Object)string3);
                    } else {
                        requestIdentifier.setContentType(RequestIdentifier.ContentType.NOT_TEXT_HTML, string2);
                        BTMLog.logger.debug("Assiging NOT_TEXT_HTML, since content-type is : {} for the URL : {}", (Object)string2, (Object)string3);
                    }
                } else {
                    requestIdentifier.setContentType(RequestIdentifier.ContentType.UNKNOWN, null);
                    BTMLog.logger.debug("Assiging UNKNOWN, since content-type is : {} for the URL : {} ", (Object)string2, (Object)string3);
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception occured while finding the Content-Type of the Response {}", exception);
                return;
            }
        }
        if (requestIdentifier.getContentType() == RequestIdentifier.ContentType.NOT_TEXT_HTML) {
            BTMLog.logger.debug("Content-Type is : {}  for the URL : {} So not checking the tags ", (Object)RequestIdentifier.ContentType.NOT_TEXT_HTML, (Object)string3);
            return;
        }
        if (string != null && string.length() > 0) {
            if ((string = string.trim()).startsWith("<")) {
                if (string.startsWith("<!-")) {
                    int n = string.indexOf("->");
                    if (n > 0) {
                        string = string.substring(n + 2);
                    } else {
                        requestIdentifier.setTags(TAGS.PARSE_ERROR);
                        BTMLog.logger.debug("Assigned PARSE_ERROR for the URL : {} since html comment tag is not ended properly", (Object)string3);
                        return;
                    }
                }
                if ((string = string.trim()).startsWith("<?xml")) {
                    int n = string.indexOf("?>");
                    if (n > 0) {
                        string = string.substring(n + 2);
                    } else {
                        requestIdentifier.setTags(TAGS.PARSE_ERROR);
                        BTMLog.logger.debug("Assigned PARSE_ERROR for the URL : {} since <?xml tag is not ended properly", (Object)string3);
                        return;
                    }
                }
                if ((string = string.trim()).startsWith("<!>")) {
                    string = string.substring(3);
                }
                if (string.length() == 0) {
                    return;
                }
                string2 = string.toLowerCase().trim();
                String string4 = (String)requestIdentifier.getRootMinfo().getProperties().get("RequestURI");
                if (requestIdentifier.getTags() == TAGS.UNKNOWN) {
                    if (string2.startsWith("<link") || string2.startsWith("<meta") || string2.startsWith("<script") || string2.startsWith("<style") || string2.startsWith("<!doctype") || string2.startsWith("<html")) {
                        HtmlTagChecker.printWriterHelper(requestIdentifier, string2, string4);
                    } else {
                        requestIdentifier.setTags(TAGS.INITIAL_TAG_INVALID);
                        BTMLog.logger.debug("Assigned INITIAL_TAG_INVALID for the URL : {} since initial tag rule is violated", (Object)string3);
                    }
                } else {
                    HtmlTagChecker.printWriterHelper(requestIdentifier, string2, string4);
                }
            } else {
                int n = string.indexOf("<");
                if (n > 0) {
                    String string5 = string.substring(n);
                    HtmlTagChecker.checkTag(requestIdentifier, string5);
                } else if (requestIdentifier.getTemplateBuilder() != null) {
                    requestIdentifier.getTemplateBuilder().append(string);
                }
            }
        }
    }

    private static void printWriterHelper(RequestIdentifier requestIdentifier, String string, String string2) {
        int n = string.indexOf("<!doctype");
        if (n > -1) {
            String string3 = string.substring(n + 9).trim();
            if (string3.startsWith("html")) {
                requestIdentifier.setTags(TAGS.DOCTYPE_HTML);
                BTMLog.logger.debug("Assigned DOCTYPE_HTML for the URL : {} ", (Object)string2);
            } else if (string3.length() == 0) {
                if (requestIdentifier.getTemplateBuilder() == null) {
                    requestIdentifier.createNewTemplateBuilder(string);
                } else {
                    requestIdentifier.getTemplateBuilder().append(string);
                }
            } else if (string3.length() > 0) {
                requestIdentifier.setTags(TAGS.DOCTYPE_NON_HTML);
                BTMLog.logger.debug("Assigned DOCTYPE_NON_HTML for the URL : {} ", (Object)string2);
            }
        } else if (string.indexOf("<html") > -1 || string.indexOf("</html>") > -1) {
            requestIdentifier.setTags(TAGS.HTML);
            BTMLog.logger.debug("Assigned HTML for the URL : {} ", (Object)string2);
        } else if (string.indexOf("<body") > -1 || string.indexOf("</body>") > -1) {
            requestIdentifier.setTags(TAGS.BODY);
            BTMLog.logger.debug("Assigned BODY for the URL : {} ", (Object)string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TAGS {
        UNKNOWN{

            public boolean isTagFound() {
                return false;
            }

            public boolean isInject() {
                return false;
            }
        }
        ,
        HTML{

            public boolean isTagFound() {
                return true;
            }

            public boolean isInject() {
                return true;
            }
        }
        ,
        BODY{

            public boolean isTagFound() {
                return true;
            }

            public boolean isInject() {
                return true;
            }
        }
        ,
        DOCTYPE_HTML{

            public boolean isTagFound() {
                return true;
            }

            public boolean isInject() {
                return true;
            }
        }
        ,
        DOCTYPE_NON_HTML{

            public boolean isTagFound() {
                return true;
            }

            public boolean isInject() {
                return false;
            }
        }
        ,
        INITIAL_TAG_INVALID{

            public boolean isTagFound() {
                return true;
            }

            public boolean isInject() {
                return false;
            }
        }
        ,
        PARSE_ERROR{

            public boolean isTagFound() {
                return true;
            }

            public boolean isInject() {
                return false;
            }
        }
        ,
        CHARSET_ERROR{

            public boolean isTagFound() {
                return true;
            }

            public boolean isInject() {
                return false;
            }
        };


        public abstract boolean isTagFound();

        public abstract boolean isInject();
    }
}

