/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.status;

import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.status.ErrorStatus;
import com.eg.ch.qos.logback.core.status.InfoStatus;
import com.eg.ch.qos.logback.core.status.Status;
import com.eg.ch.qos.logback.core.status.StatusListener;
import com.eg.ch.qos.logback.core.status.StatusManager;
import com.eg.ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusUtil {
    StatusManager sm;

    public StatusUtil(StatusManager statusManager) {
        this.sm = statusManager;
    }

    public StatusUtil(Context context) {
        this.sm = context.getStatusManager();
    }

    public static boolean contextHasStatusListener(Context context) {
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            return false;
        }
        List<StatusListener> list = statusManager.getCopyOfStatusListenerList();
        return list != null && list.size() != 0;
    }

    public static List<Status> filterStatusListByTimeThreshold(List<Status> list, long l2) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        for (Status status : list) {
            if (status.getDate() < l2) continue;
            arrayList.add(status);
        }
        return arrayList;
    }

    public void addStatus(Status status) {
        if (this.sm != null) {
            this.sm.add(status);
        }
    }

    public void addInfo(Object object, String string) {
        this.addStatus(new InfoStatus(string, object));
    }

    public void addWarn(Object object, String string) {
        this.addStatus(new WarnStatus(string, object));
    }

    public void addError(Object object, String string, Throwable throwable) {
        this.addStatus(new ErrorStatus(string, object, throwable));
    }

    public boolean hasXMLParsingErrors(long l2) {
        return this.containsMatch(l2, 2, "XML_PARSING");
    }

    public boolean noXMLParsingErrorsOccurred(long l2) {
        return !this.hasXMLParsingErrors(l2);
    }

    public int getHighestLevel(long l2) {
        List<Status> list = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l2);
        int n2 = 0;
        for (Status status : list) {
            if (status.getLevel() <= n2) continue;
            n2 = status.getLevel();
        }
        return n2;
    }

    public boolean isErrorFree(long l2) {
        return 2 > this.getHighestLevel(l2);
    }

    public boolean isWarningOrErrorFree(long l2) {
        return 1 > this.getHighestLevel(l2);
    }

    public boolean containsMatch(long l2, int n2, String string) {
        List<Status> list = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l2);
        Pattern pattern = Pattern.compile(string);
        for (Status status : list) {
            String string2;
            Matcher matcher;
            if (n2 != status.getLevel() || !(matcher = pattern.matcher(string2 = status.getMessage())).lookingAt()) continue;
            return true;
        }
        return false;
    }

    public boolean containsMatch(int n2, String string) {
        return this.containsMatch(0L, n2, string);
    }

    public boolean containsMatch(String string) {
        Pattern pattern = Pattern.compile(string);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String string2 = status.getMessage();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.lookingAt()) continue;
            return true;
        }
        return false;
    }

    public int matchCount(String string) {
        int n2 = 0;
        Pattern pattern = Pattern.compile(string);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String string2 = status.getMessage();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.lookingAt()) continue;
            ++n2;
        }
        return n2;
    }

    public boolean containsException(Class<?> clazz) {
        for (Status status : this.sm.getCopyOfStatusList()) {
            for (Throwable throwable = status.getThrowable(); throwable != null; throwable = throwable.getCause()) {
                if (!throwable.getClass().getName().equals(clazz.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public long timeOfLastReset() {
        List<Status> list = this.sm.getCopyOfStatusList();
        if (list == null) {
            return -1L;
        }
        int n2 = list.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            Status status = list.get(i2);
            if (!"Will reset and reconfigure context ".equals(status.getMessage())) continue;
            return status.getDate();
        }
        return -1L;
    }
}

