/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgAgentInfo;
import com.eg.EgConfigInfo;
import com.eg.EgDiscInfo;
import com.eg.EgSpecsInfo;
import com.eg.IniFile;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EgExternalAgent {
    private static String whoami = "manager";
    private String extFileName;
    private String tempFile;
    private IniFile extFilePtr;
    private String managerHost;
    private static String extAgentSection = "Eg_External_Agents";
    private static String testMappingSection = "Test_Mapping_Section";
    private static String remoteAgentSection = "Eg_Remote_Agents";
    private static String remoteAgentMappingSection = "Remote_Agent_Mapping_Section";
    private static String agentlessInfosSection = "Agentless_Infos_Section";
    private static String internalAgentSection = "Internal_Agent_Mapping";
    private EgConfigInfo configInfo = new EgConfigInfo();
    private EgAgentInfo agentInfo;
    private EgSpecsInfo specsInfo;
    private EgDiscInfo discInfo;

    public static void main(String[] stringArray) {
        EgExternalAgent egExternalAgent = new EgExternalAgent(true);
        egExternalAgent.setInternalAgent("tom", "jack");
    }

    public EgExternalAgent(boolean bl) {
        this.extFileName = this.configInfo.getExtFile();
        this.extFilePtr = new IniFile(this.extFileName, bl);
    }

    public EgExternalAgent(String string, String string2) {
        this.managerHost = string2;
        this.agentInfo = new EgAgentInfo(whoami, string);
        this.specsInfo = new EgSpecsInfo(whoami);
        this.extFileName = this.configInfo.getExtFile();
        this.extFilePtr = new IniFile(this.extFileName);
    }

    public EgExternalAgent(IniFile iniFile, String string) {
        this.managerHost = string;
        this.agentInfo = new EgAgentInfo(whoami, iniFile);
        this.specsInfo = new EgSpecsInfo(whoami);
        this.extFileName = this.configInfo.getExtFile();
        this.extFilePtr = new IniFile(this.extFileName);
    }

    public EgExternalAgent(EgDiscInfo egDiscInfo, String string, boolean bl) {
        this.managerHost = string;
        this.discInfo = egDiscInfo;
        this.extFileName = this.configInfo.getExtFile();
        this.extFilePtr = new IniFile(this.extFileName, bl);
    }

    public EgExternalAgent(EgDiscInfo egDiscInfo, String string, String string2, boolean bl) {
        this.managerHost = string;
        this.discInfo = egDiscInfo;
        this.extFileName = string2;
        this.extFilePtr = new IniFile(this.extFileName, bl);
    }

    public void setInternalAgent(String string, String string2) {
        this.extFilePtr.setValue(internalAgentSection, string, string2);
        this.extFilePtr.saveFile();
    }

    private ArrayList getExtAgents() {
        String[] stringArray = this.extFilePtr.getVariables(extAgentSection);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    private ArrayList getRemoteAgents() {
        String[] stringArray = this.extFilePtr.getVariables(remoteAgentSection);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    private String[] getComponents() {
        String[] stringArray = this.extFilePtr.getVariables(testMappingSection);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    private String[] getRemoteComponents() {
        String[] stringArray = this.extFilePtr.getVariables(remoteAgentMappingSection);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    private String[] getAlInfoComponents() {
        String[] stringArray = this.extFilePtr.getVariables(agentlessInfosSection);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    public boolean buildExternalFile() {
        return this.buildExternalFile(null);
    }

    public boolean buildExternalFile(ArrayList arrayList) {
        Object object;
        int n;
        Vector vector = this.discInfo.getAllHosts();
        if (vector == null || vector.size() == 0) {
            this.discInfo.checkForUpdate(true);
            vector = this.discInfo.getAllHosts();
            if (vector == null || vector.size() == 0) {
                this.cleanUp();
                this.extFilePtr.saveFile();
                boolean bl = this.extFilePtr.wasFileSaved;
                this.extFilePtr = null;
                return bl;
            }
        }
        String[] stringArray = this.getComponents();
        String[] stringArray2 = this.getRemoteComponents();
        ArrayList arrayList2 = this.discInfo.getAllExternalHosts();
        if (stringArray == null || stringArray.length == 0) {
            this.fillUp(vector);
            this.extFilePtr.saveFile();
            boolean bl = this.extFilePtr.wasFileSaved;
            this.extFilePtr = null;
            return bl;
        }
        ArrayList arrayList3 = this.getArrayList(stringArray);
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            object = (String)vector.get(n);
            if (arrayList3.indexOf(object) >= 0) continue;
            this.extFilePtr.setValue(testMappingSection, (String)object, this.managerHost);
        }
        n2 = arrayList3.size();
        for (n = 0; n < n2; ++n) {
            object = (String)arrayList3.get(n);
            if (vector.indexOf(object) >= 0) continue;
            this.extFilePtr.deleteValue(testMappingSection, (String)object);
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            ArrayList arrayList4 = this.getArrayList(stringArray2);
            object = (Vector)vector.clone();
            if (arrayList2 != null) {
                ((Vector)object).removeAll(arrayList2);
            }
            int n3 = arrayList4.size();
            for (int i = 0; i < n3; ++i) {
                String string = (String)arrayList4.get(i);
                if (((Vector)object).indexOf(string) >= 0) continue;
                boolean bl = false;
                if (arrayList == null) {
                    bl = true;
                } else if (!arrayList.contains(string)) {
                    bl = true;
                }
                if (!bl) continue;
                this.extFilePtr.deleteValue(remoteAgentMappingSection, string);
                this.extFilePtr.deleteValue(agentlessInfosSection, string);
            }
        }
        this.extFilePtr.saveFile();
        boolean bl = this.extFilePtr.wasFileSaved;
        this.extFilePtr = null;
        return bl;
    }

    private boolean cleanUp() {
        String[] stringArray = this.getComponents();
        if (stringArray == null || stringArray.length == 0) {
            int n;
            String[] stringArray2 = this.extFilePtr.getVariables(remoteAgentMappingSection);
            if (stringArray2 != null && stringArray2.length > 0) {
                for (n = 0; n < stringArray2.length; ++n) {
                    this.extFilePtr.deleteValue(remoteAgentMappingSection, stringArray2[n]);
                }
            }
            if ((stringArray2 = this.extFilePtr.getVariables(agentlessInfosSection)) != null && stringArray2.length > 0) {
                for (n = 0; n < stringArray2.length; ++n) {
                    this.extFilePtr.deleteValue(agentlessInfosSection, stringArray2[n]);
                }
            }
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.extFilePtr.deleteValue(testMappingSection, stringArray[i]);
            this.extFilePtr.deleteValue(remoteAgentMappingSection, stringArray[i]);
            this.extFilePtr.deleteValue(agentlessInfosSection, stringArray[i]);
        }
        return true;
    }

    private void fillUp(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            this.extFilePtr.setValue(testMappingSection, string, this.managerHost);
        }
    }

    private ArrayList getArrayList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public void process() {
        AbstractList abstractList;
        String string;
        Object object;
        Object object2;
        int n;
        int n2;
        int n3;
        if (this.managerHost == null || this.managerHost.length() == 0) {
            return;
        }
        ArrayList arrayList = this.getExtAgents();
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        String[] stringArray = this.getComponents();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = this.agentInfo.getTestsForTarget(this.managerHost);
        if (this.stop()) {
            return;
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            this.processRemoteAgents();
            this.agentInfo.saveFile();
            return;
        }
        if (this.stop()) {
            return;
        }
        String[] stringArray3 = this.agentInfo.getLhs(stringArray2);
        String[] stringArray4 = this.agentInfo.getRhs(stringArray2);
        String[] stringArray5 = this.agentInfo.getTargetHosts(stringArray3);
        if (stringArray5 == null || stringArray5.length == 0) {
            return;
        }
        String[] stringArray6 = this.agentInfo.getTests(stringArray3, true);
        boolean[] blArray = new boolean[stringArray6.length];
        for (int i = 0; i < stringArray6.length; ++i) {
            blArray[i] = this.specsInfo.isTestExternal(stringArray6[i], false);
        }
        if (this.stop()) {
            return;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        String[] stringArray7 = this.extFilePtr.getVariables(testMappingSection);
        Vector vector = this.extFilePtr.getAllValues(testMappingSection);
        if (stringArray7 != null && vector != null && (n3 = stringArray7.length) == (n2 = vector.size())) {
            for (n = 0; n < n3; ++n) {
                object2 = stringArray7[n];
                object = vector.get(n).toString();
                hashMap.put(object2, object);
            }
        }
        Vector<String> vector2 = new Vector<String>();
        n2 = 0;
        n = stringArray.length;
        object2 = new Hashtable();
        object = new Hashtable();
        boolean[] blArray2 = new boolean[stringArray5.length];
        for (int i = 0; i < stringArray5.length; ++i) {
            if (i % 3 == 0 && this.stop()) {
                return;
            }
            if (!blArray[i] || (string = (String)hashMap.get(stringArray5[i])) == null || string.length() == 0 || (abstractList = this.tokenizeTargets(string)) == null || ((ArrayList)abstractList).size() == 0) continue;
            blArray2[i] = false;
            for (int j = 0; j < ((ArrayList)abstractList).size(); ++j) {
                String string2 = (String)((ArrayList)abstractList).get(j);
                blArray2[i] = string2.equals(this.managerHost);
                if (blArray2[i] || string2.equalsIgnoreCase("none")) continue;
                Vector<String> vector3 = (Vector<String>)((Hashtable)object2).get(string2);
                if (vector3 == null) {
                    vector3 = new Vector<String>();
                    ((Hashtable)object2).put(string2, vector3);
                }
                vector3.add(stringArray3[i]);
                Vector<String> vector4 = (Vector<String>)((Hashtable)object).get(string2);
                if (vector4 == null) {
                    vector4 = new Vector<String>();
                    ((Hashtable)object).put(string2, vector4);
                }
                vector4.add(stringArray4[i]);
                if (blArray2[i] || ((ArrayList)abstractList).indexOf(this.managerHost) >= 0) continue;
                vector2.add(stringArray3[i]);
                n2 = 1;
            }
        }
        Enumeration enumeration = ((Hashtable)object2).keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            abstractList = (Vector)((Hashtable)object2).get(string);
            Vector vector5 = (Vector)((Hashtable)object).get(string);
            if (abstractList == null || vector5 == null) continue;
            this.agentInfo.setValues(string, (Vector)abstractList, vector5, false);
        }
        if (n2 != 0) {
            this.agentInfo.deleteValues(this.managerHost, vector2);
        }
        if (this.stop()) {
            return;
        }
        this.processRemoteAgents();
        this.agentInfo.saveFile();
    }

    private ArrayList getAgentlessParams(String string) {
        String string2 = this.extFilePtr.getValue(agentlessInfosSection, string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        ArrayList arrayList = this.myTokenizer(string2, ",");
        return arrayList;
    }

    private Hashtable getAllAgentlessParams() {
        String[] stringArray = this.extFilePtr.getVariables(agentlessInfosSection);
        Vector vector = this.extFilePtr.getAllValues(agentlessInfosSection);
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = (String)vector.get(i);
            if (string2 == null || string2.length() == 0) continue;
            ArrayList arrayList = this.myTokenizer(string2, ",");
            hashtable.put(string, arrayList);
        }
        return hashtable;
    }

    private ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3);
        return arrayList;
    }

    private void processRemoteAgents() {
        String[] stringArray;
        String[] stringArray2;
        int n;
        int n2;
        int n3;
        ArrayList arrayList = this.getExtAgents();
        ArrayList arrayList2 = this.getRemoteAgents();
        if (arrayList2 == null || arrayList2.size() == 0) {
            return;
        }
        String[] stringArray3 = this.getRemoteComponents();
        if (stringArray3 == null || stringArray3.length == 0) {
            return;
        }
        if (this.stop()) {
            return;
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        HashMap<String[], String[]> hashMap = new HashMap<String[], String[]>();
        String[] stringArray4 = this.extFilePtr.getVariables(remoteAgentMappingSection);
        Vector vector = this.extFilePtr.getAllValues(remoteAgentMappingSection);
        if (stringArray4 != null && vector != null && (n3 = stringArray4.length) == (n2 = vector.size())) {
            for (n = 0; n < n3; ++n) {
                stringArray2 = stringArray4[n];
                stringArray = vector.get(n).toString();
                hashMap.put(stringArray2, stringArray);
            }
        }
        Hashtable hashtable = this.getAllAgentlessParams();
        for (n2 = 0; n2 < stringArray3.length; ++n2) {
            if (n2 % 3 == 0 && this.stop()) {
                return;
            }
            String string = (String)hashMap.get(stringArray3[n2]);
            if (string == null || string.length() == 0 || (stringArray2 = this.agentInfo.getTestsForTarget(stringArray3[n2], true)) == null || stringArray2.length == 0) continue;
            stringArray = new String[stringArray2.length];
            String[] stringArray5 = new String[stringArray2.length];
            this.agentInfo.getLhsAndRhs(stringArray2, stringArray, stringArray5);
            ArrayList arrayList4 = (ArrayList)hashtable.get(stringArray3[n2]);
            if (arrayList4 == null || arrayList4.size() < 5) continue;
            int n4 = arrayList4.size();
            String string2 = (String)arrayList4.get(0);
            String string3 = (String)arrayList4.get(1);
            String string4 = (String)arrayList4.get(2);
            String string5 = (String)arrayList4.get(3);
            String string6 = (String)arrayList4.get(4);
            String string7 = "None";
            String string8 = "None";
            if (n4 >= 6) {
                string7 = (String)arrayList4.get(5);
            }
            if (n4 >= 7) {
                string8 = (String)arrayList4.get(6);
            }
            String string9 = " -agentless ";
            boolean bl = false;
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            int n5 = string9.length() - 1;
            Vector<String> vector4 = new Vector<String>();
            Vector<String> vector5 = new Vector<String>();
            for (int i = 0; i < stringArray5.length; ++i) {
                int n6;
                String string10;
                String string11;
                Object object;
                int n7 = stringArray5[i].indexOf(string9);
                if (n7 < 0) {
                    int n8 = stringArray[i].indexOf(":");
                    object = stringArray[i].substring(0, n8);
                    String string12 = stringArray[i].substring(n8 + 1);
                    string11 = string12.substring(0, string12.indexOf(":"));
                    boolean bl2 = false;
                    bl2 = string11 != null && string11.trim().length() != 0 ? this.specsInfo.isTestExternal((String)object, string11, false) : this.specsInfo.isTestExternal((String)object, false);
                    if (bl2) continue;
                    vector3.add(stringArray[i]);
                    continue;
                }
                bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray5[i]);
                object = new ArrayList();
                boolean bl3 = false;
                string11 = "";
                String string13 = "";
                String string14 = "";
                String string15 = "";
                String string16 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string10 = stringTokenizer.nextToken();
                    if (string10.equals("-agentless")) {
                        if (stringTokenizer.countTokens() <= 0) continue;
                        string10 = stringTokenizer.nextToken();
                        if (string10.startsWith("y")) {
                            bl3 = true;
                            if (string10.equals("y,")) {
                                string11 = string11 + "-agentless y ,";
                                continue;
                            }
                            string11 = string11 + "-agentless y ";
                            continue;
                        }
                        bl3 = true;
                        if (string10.equals("n,")) {
                            string11 = string11 + "-agentless y ,";
                            continue;
                        }
                        string11 = string11 + "-agentless y ";
                        continue;
                    }
                    if (string10.equals("-aluser")) {
                        if (stringTokenizer.countTokens() <= 0) continue;
                        string10 = stringTokenizer.nextToken();
                        if (!bl3) continue;
                        string11 = string11 + " -aluser " + string10 + " ";
                        continue;
                    }
                    if (string10.equals("-alpassword")) {
                        if (stringTokenizer.countTokens() <= 0) continue;
                        string10 = stringTokenizer.nextToken();
                        if (!bl3) continue;
                        string11 = string11 + " -alpassword " + string10 + " ";
                        continue;
                    }
                    if (string10.equals("-os")) {
                        if (stringTokenizer.countTokens() <= 0) continue;
                        string10 = stringTokenizer.nextToken();
                        if (!bl3) continue;
                        string11 = string11 + " -os " + string10;
                        continue;
                    }
                    if (string10.equals("-sshPort")) {
                        if (stringTokenizer.countTokens() <= 0) continue;
                        string10 = stringTokenizer.nextToken();
                        if (!bl3) continue;
                        string13 = string10;
                        continue;
                    }
                    if (string10.equals("-almode")) {
                        if (stringTokenizer.countTokens() <= 0) continue;
                        string10 = stringTokenizer.nextToken();
                        if (!bl3) continue;
                        string14 = string10;
                        continue;
                    }
                    if (string10.equals("-alencrypt")) {
                        if (stringTokenizer.countTokens() <= 0) continue;
                        string10 = stringTokenizer.nextToken();
                        if (!bl3) continue;
                        string7 = string10;
                        continue;
                    }
                    if (string10.equals("-alkeyfile")) {
                        if (stringTokenizer.countTokens() <= 0) continue;
                        string10 = stringTokenizer.nextToken();
                        if (!bl3) continue;
                        string8 = string10;
                        continue;
                    }
                    string11 = string11 + string10 + " ";
                }
                if (string14 != null && string14.length() > 0 && string14.equalsIgnoreCase("Rexec")) {
                    string11 = " -remotePort " + string13 + " " + " -almode " + string14 + " -alencrypt " + string7 + " -alkeyfile " + string8 + " ";
                }
                vector2.add(stringArray[i]);
                string10 = "";
                if (string11.indexOf("-aluser ") < 0 && (n6 = string11.indexOf("-rptName ")) >= 0) {
                    string10 = string11.substring(0, n6);
                    string10 = string4 != null && string4.length() > 0 && string4.equalsIgnoreCase("Rexec") ? string10 + " -aluser " + string2 + " -alpassword " + string3 + " -almode " + string4 + " -os " + string5 + " -remotePort " + string6 + " -alencrypt " + string7 + " -alkeyfile " + string8 + "  " + string11.substring(n6) : string10 + " -aluser " + string2 + " -alpassword " + string3 + " -almode " + string4 + " -os " + string5 + " -sshPort " + string6 + " -alencrypt " + string7 + " -alkeyfile " + string8 + "  " + string11.substring(n6);
                    string11 = string10;
                }
                stringArray5[i] = string11;
                vector4.add(stringArray[i]);
                vector5.add(stringArray5[i]);
            }
            if (vector4.size() > 0 && vector5.size() > 0) {
                this.agentInfo.setValues(string, vector4, vector5, false);
            }
            if (vector2.size() > 0) {
                this.agentInfo.deleteValues(stringArray3[n2], vector2);
            }
            if (vector3.size() > 0) {
                this.agentInfo.deleteValues(stringArray3[n2], vector3);
            }
            if (bl && arrayList2.indexOf(stringArray3[n2]) < 0 && arrayList.indexOf(stringArray3[n2]) < 0) {
                arrayList3.add(stringArray3[n2]);
                continue;
            }
            String[] stringArray6 = this.agentInfo.getTestsForTarget(stringArray3[n2]);
            if (stringArray6 != null && stringArray6.length != 0) continue;
            arrayList3.add(stringArray3[n2]);
        }
        n2 = arrayList3.size();
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                stringArray2 = arrayList3.get(n).toString();
                this.agentInfo.deleteSection((String)stringArray2);
            }
        }
    }

    private boolean stop() {
        return EgConfigInfo.stopDiscovery;
    }

    private ArrayList tokenizeTargets(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.indexOf(",") < 0) {
            arrayList.add(string);
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList;
    }

    public void removeFile(String string) {
        try {
            File file = new File(string);
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

