/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgSpecsInfo;
import com.eg.IniFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EgDiscInfo2 {
    private IniFile discFilePtr;
    private String discFileName;
    private String whoami;
    private File discFile;
    private static String siteServerSection = "Site_servers";
    private String whomai;
    public long lastModifiedTime;
    public String[] types;

    public static void main(String[] stringArray) {
        EgDiscInfo2 egDiscInfo2 = new EgDiscInfo2("manager");
        System.out.println(egDiscInfo2.getVariable("Web_server", "192.168.10.7"));
    }

    public EgDiscInfo2(String string) {
        this.whoami = string;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.discFileName = string.equals("agent") ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egDiscoveryConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egDiscoveryConfigFile);
        egConfigInfo = null;
        this.discFilePtr = new IniFile(this.discFileName);
        this.discFile = new File(this.discFileName);
        this.lastModifiedTime = this.discFile.lastModified();
        this.types = this.getServerTypes();
    }

    public EgDiscInfo2(String string, int n) {
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.discFileName = string.equals("agent") ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egDiscoveryConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egDiscoveryConfigFile);
        egConfigInfo = null;
        this.discFile = new File(this.discFileName);
        this.lastModifiedTime = this.discFile.lastModified();
    }

    public EgDiscInfo2(String string, boolean bl) {
        this.whoami = string;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.discFileName = string.equals("agent") ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egDiscoveryConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egDiscoveryConfigFile);
        egConfigInfo = null;
        this.discFilePtr = new IniFile(this.discFileName, bl);
        this.discFile = new File(this.discFileName);
        this.lastModifiedTime = this.discFile.lastModified();
        this.types = this.getServerTypes();
    }

    public EgDiscInfo2(String string, IniFile iniFile) {
        this.whoami = string;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.discFileName = string.equals("agent") ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egDiscoveryConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egDiscoveryConfigFile);
        egConfigInfo = null;
        this.discFilePtr = iniFile;
        this.discFile = new File(this.discFileName);
        this.lastModifiedTime = this.discFile.lastModified();
        this.types = this.getServerTypes();
    }

    public void initialize() {
        this.discFilePtr = new IniFile(this.discFileName);
    }

    public long lastModified() {
        return this.discFile.lastModified();
    }

    public void release() {
        this.discFilePtr = null;
    }

    public synchronized boolean checkForUpdate() {
        long l = this.discFile.lastModified();
        if (l == this.lastModifiedTime) {
            return false;
        }
        this.lastModifiedTime = l;
        this.discFilePtr = new IniFile(this.discFileName);
        this.types = this.getServerTypes();
        return true;
    }

    public String[] getServerTypes() {
        String[] stringArray = this.discFilePtr.getSubjects();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(siteServerSection)) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        arrayList = null;
        return stringArray2;
    }

    public String[] getAllServersOfType(String string) {
        String[] stringArray = this.discFilePtr.getVariables(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("#") || stringArray[i].startsWith("Format:")) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        arrayList = null;
        return stringArray2;
    }

    public ArrayList getAllHostsWithPort() {
        StringTokenizer stringTokenizer = null;
        String[] stringArray = this.getServerTypes();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray == null || stringArray.length == 0) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            if (stringArray[i].equals(siteServerSection) || (stringArray2 = this.discFilePtr.getVariables(stringArray[i])) == null) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].startsWith("Format:") || stringArray2[j].startsWith("#")) continue;
                String string = this.discFilePtr.getValue(stringArray[i], stringArray2[j]);
                stringTokenizer = new StringTokenizer(string, ",");
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                string = string2 + ":" + string3;
                string = string.trim();
                if (arrayList.indexOf(string) >= 0) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public ArrayList getAllIpsOfType(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.discFilePtr.getVariables(string);
        if (stringArray == null || stringArray.length == 0) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            StringTokenizer stringTokenizer;
            if (stringArray[i].startsWith("Format:") || (stringTokenizer = new StringTokenizer(string2 = this.discFilePtr.getValue(string, stringArray[i]), ",")).countTokens() < 2) continue;
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (arrayList.indexOf(string3) >= 0) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public ArrayList getAllEntries(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.discFilePtr.getVariables(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("Format:")) continue;
            String string2 = this.discFilePtr.getValue(string, stringArray[i]);
            arrayList.add(stringArray[i] + "=" + string2);
        }
        return arrayList;
    }

    public void deleteEntry(String string, String string2, String string3) {
        String[] stringArray = this.discFilePtr.getVariables(string);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            int n = string4.indexOf(":");
            if (n < 0 || !(string4 = string4.substring(n + 1)).equals(string2 + ":" + string3)) continue;
            this.discFilePtr.deleteValue(string, stringArray[i]);
            break;
        }
    }

    public void deleteEntry(String string, String string2) {
        this.discFilePtr.deleteValue(string, string2);
    }

    public String[] getFieldsForServer(String string) {
        String[] stringArray = this.discFilePtr.getVariables(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("Format:")) continue;
            String string2 = this.discFilePtr.getValue(string, stringArray[i]);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = stringTokenizer.countTokens();
            String[] stringArray2 = new String[n];
            for (int j = 0; j < n; ++j) {
                stringArray2[j] = stringTokenizer.nextToken().trim();
            }
            return stringArray2;
        }
        return null;
    }

    public String[] getFieldValuesForServer(String string, String string2) {
        this.checkForUpdate();
        String string3 = this.discFilePtr.getValue(string, string2);
        if (string3 == null || string3.equals("")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    public String[] getTypeOfServer(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.types.length; ++i) {
            String string2 = this.types[i] + ":" + string;
            String string3 = this.discFilePtr.getValue(this.types[i], string2);
            if (string3 == null || string3.equals("")) continue;
            arrayList.add(this.types[i]);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public Hashtable getNickIpMap() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i].equals(siteServerSection)) continue;
            String[] stringArray = this.discFilePtr.getVariables(this.types[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].startsWith("Format") || stringArray[j].startsWith("#")) continue;
                String string = this.discFilePtr.getValue(this.types[i], stringArray[j]);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (!hashtable.containsKey(string4)) {
                    hashtable.put(string4, string3);
                    continue;
                }
                String string5 = (String)hashtable.get(string4);
                if (string5.equals(string3)) continue;
                if (string5.indexOf(string3) < 0) {
                    hashtable.put(string4, string3 + ":" + string5);
                    continue;
                }
                boolean bl = true;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ":");
                int n = stringTokenizer2.countTokens();
                for (int k = 0; k < n; ++k) {
                    if (!stringTokenizer2.nextToken().trim().equals(string3)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                hashtable.put(string4, string3 + ":" + string5);
            }
        }
        return hashtable;
    }

    public Hashtable getIpNickMap() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i].equals(siteServerSection)) continue;
            String[] stringArray = this.discFilePtr.getVariables(this.types[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].startsWith("Format") || stringArray[j].startsWith("#")) continue;
                String string = this.discFilePtr.getValue(this.types[i], stringArray[j]);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (!hashtable.containsKey(string3)) {
                    hashtable.put(string3, string4);
                    continue;
                }
                String string5 = (String)hashtable.get(string3);
                if (string5.equals(string4)) continue;
                if (string5.indexOf(string4) < 0) {
                    hashtable.put(string3, string4 + ":" + string5);
                    continue;
                }
                boolean bl = true;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ":");
                int n = stringTokenizer2.countTokens();
                for (int k = 0; k < n; ++k) {
                    if (!stringTokenizer2.nextToken().trim().equals(string4)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                hashtable.put(string3, string4 + ":" + string5);
            }
        }
        return hashtable;
    }

    public ArrayList getAllIps() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i].equals(siteServerSection)) continue;
            String[] stringArray = this.discFilePtr.getVariables(this.types[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].startsWith("Format")) continue;
                String string = this.discFilePtr.getValue(this.types[i], stringArray[j]);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (arrayList.indexOf(string3) >= 0) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public ArrayList getAllHostsFromRhs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i].equals(siteServerSection)) continue;
            String[] stringArray = this.discFilePtr.getVariables(this.types[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].startsWith("Format") || stringArray[j].startsWith("#")) continue;
                String string = this.discFilePtr.getValue(this.types[i], stringArray[j]);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (arrayList.indexOf(string3) >= 0) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public ArrayList getAllHostsOfTypes(ArrayList arrayList) {
        if (this.types == null || this.types.length == 0) {
            return new ArrayList();
        }
        if (arrayList == null || arrayList.size() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i].equals(siteServerSection) || arrayList.indexOf(this.types[i]) < 0) continue;
            String[] stringArray = this.discFilePtr.getVariables(this.types[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].startsWith("Format") || stringArray[j].startsWith("#")) continue;
                String string = this.discFilePtr.getValue(this.types[i], stringArray[j]);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (arrayList2.indexOf(string3) >= 0) continue;
                arrayList2.add(string3);
            }
        }
        return arrayList2;
    }

    public ArrayList getAllHostsExceptType(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i].equals(siteServerSection) || this.types[i].equals(string)) continue;
            String[] stringArray = this.discFilePtr.getVariables(this.types[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].startsWith("Format") || stringArray[j].startsWith("#")) continue;
                String string2 = this.discFilePtr.getValue(this.types[i], stringArray[j]);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (arrayList.indexOf(string4) >= 0) continue;
                arrayList.add(string4);
            }
        }
        return arrayList;
    }

    public ArrayList getAllHostsExceptTypes(ArrayList arrayList) {
        if (this.types == null || this.types.length == 0) {
            return new ArrayList();
        }
        if (arrayList == null || arrayList.size() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i].equals(siteServerSection) || arrayList.indexOf(this.types[i]) >= 0) continue;
            String[] stringArray = this.discFilePtr.getVariables(this.types[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].startsWith("Format") || stringArray[j].startsWith("#")) continue;
                String string = this.discFilePtr.getValue(this.types[i], stringArray[j]);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (arrayList2.indexOf(string3) >= 0) continue;
                arrayList2.add(string3);
            }
        }
        return arrayList2;
    }

    public ArrayList getAllExternalHosts() {
        EgSpecsInfo egSpecsInfo = new EgSpecsInfo(this.whoami);
        String[] stringArray = egSpecsInfo.getAllExternalServerTypes();
        if (stringArray == null || stringArray.length == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return this.getAllHostsOfTypes(arrayList);
    }

    public void addEntry(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        if (stringTokenizer.countTokens() < 3) {
            return;
        }
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string2, ":");
        if (stringTokenizer.countTokens() < 2) {
            return;
        }
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        String string7 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string7 = string7 + ":" + stringTokenizer.nextToken();
        }
        string2 = string5 + ":" + string4 + string7;
        this.discFilePtr.setValue(string, string2, string3);
    }

    public void saveFile() {
        this.discFilePtr.saveFile();
    }

    public String getVariable(String string, String string2) {
        String string3 = null;
        String[] stringArray = this.discFilePtr.getVariables(string);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = this.discFilePtr.getValue(string, stringArray[i]);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            if (stringTokenizer.countTokens() < 2) continue;
            stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            string5 = string5 + stringTokenizer.nextToken();
            if (!string2.equals(string5)) continue;
            string3 = stringArray[i];
            string3 = string3.trim();
            break;
        }
        return string3;
    }

    public Vector getAllHosts() {
        String[] stringArray = this.discFilePtr.getSubjects();
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = null;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(siteServerSection)) continue;
            String[] stringArray2 = this.discFilePtr.getVariables(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].startsWith("Format:") || stringArray2[j].startsWith("#")) continue;
                stringTokenizer = new StringTokenizer(stringArray2[j], ":");
                string = stringTokenizer.nextToken();
                string = stringTokenizer.nextToken();
                if (vector.contains(string)) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }

    public Vector getAllManagedComponents() {
        String[] stringArray = this.discFilePtr.getSubjects();
        Object var2_2 = null;
        String string = null;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(siteServerSection)) continue;
            String[] stringArray2 = this.discFilePtr.getVariables(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].startsWith("Format:") || stringArray2[j].startsWith("#") || stringArray2[j].startsWith("UnManaged")) continue;
                string = this.discFilePtr.getValue(stringArray[i], stringArray2[j]);
                vector.addElement(new String(string));
            }
        }
        var2_2 = null;
        stringArray = null;
        return vector;
    }

    public Vector getAllUnManagedComponents() {
        String[] stringArray = this.discFilePtr.getSubjects();
        Object var2_2 = null;
        String string = null;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(siteServerSection)) continue;
            String[] stringArray2 = this.discFilePtr.getVariables(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].startsWith("#Unmanage")) continue;
                string = stringArray2[j].substring(stringArray2[j].indexOf("|") + 1);
                vector.addElement(new String(string));
            }
        }
        var2_2 = null;
        stringArray = null;
        return vector;
    }

    public Vector updateAllServers(String string, String string2) {
        this.checkForUpdate();
        String string3 = null;
        String string4 = null;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < this.types.length; ++i) {
            String[] stringArray = this.discFilePtr.getVariables(this.types[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].startsWith("Format:") || stringArray[j].startsWith("#Unmanage")) continue;
                String string5 = this.discFilePtr.getValue(this.types[i], stringArray[j]);
                StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                n = stringTokenizer.countTokens();
                bl = false;
                if (n > 5) {
                    bl = true;
                }
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string8 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                if (!string.equals(string7)) continue;
                string4 = "";
                string4 = bl ? string6 + "," + string7 + "," + string2 + "," + string8 + "," + string3 + "," + stringTokenizer.nextToken() : string6 + "," + string7 + "," + string2 + "," + string8 + "," + string3;
                stringTokenizer = new StringTokenizer(stringArray[j], ":");
                n = stringTokenizer.countTokens();
                bl = false;
                if (n > 3) {
                    bl = true;
                }
                string6 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string8 = stringTokenizer.nextToken();
                String string9 = "";
                string9 = bl ? string6 + ":" + string2 + ":" + string8 + ":" + stringTokenizer.nextToken() : string6 + ":" + string2 + ":" + string8;
                this.discFilePtr.deleteValue(this.types[i], stringArray[j]);
                this.discFilePtr.setValue(this.types[i], string9, string4);
                if (string6.indexOf("|") > -1) {
                    string6 = string6.substring(string6.indexOf("|") + 1);
                }
                if (vector.contains(string6)) continue;
                vector.add(string6);
            }
        }
        this.discFilePtr.saveFile();
        return vector;
    }

    public Vector updateAllServers(String string, String string2, String string3) {
        this.checkForUpdate();
        String string4 = null;
        String string5 = "";
        String string6 = null;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < this.types.length; ++i) {
            String[] stringArray = this.discFilePtr.getVariables(this.types[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].startsWith("Format:") || stringArray[j].startsWith("#Unmanage")) continue;
                String string7 = this.discFilePtr.getValue(this.types[i], stringArray[j]);
                StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                n = stringTokenizer.countTokens();
                bl = false;
                if (n > 5) {
                    bl = true;
                }
                String string8 = stringTokenizer.nextToken();
                String string9 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken().trim();
                String string10 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                if (!string.equals(string9) || !string5.equals(string3)) continue;
                string6 = "";
                string6 = bl ? string8 + "," + string9 + "," + string2 + "," + string10 + "," + string4 + "," + stringTokenizer.nextToken() : string8 + "," + string9 + "," + string2 + "," + string10 + "," + string4;
                stringTokenizer = new StringTokenizer(stringArray[j], ":");
                n = stringTokenizer.countTokens();
                bl = false;
                if (n > 3) {
                    bl = true;
                }
                string8 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string10 = stringTokenizer.nextToken();
                String string11 = "";
                string11 = bl ? string8 + ":" + string2 + ":" + string10 + ":" + stringTokenizer.nextToken() : string8 + ":" + string2 + ":" + string10;
                this.discFilePtr.deleteValue(this.types[i], stringArray[j]);
                this.discFilePtr.setValue(this.types[i], string11, string6);
                if (string8.indexOf("|") > -1) {
                    string8 = string8.substring(string8.indexOf("|") + 1);
                }
                if (vector.contains(string8)) continue;
                vector.add(string8);
            }
        }
        this.discFilePtr.saveFile();
        return vector;
    }
}

