/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgCheckDbHelper;
import com.eg.EgConfigInfo;
import com.eg.EgDbInfo;
import java.util.StringTokenizer;

public class EgCheckDb {
    private String dbType = "sql";
    private EgConfigInfo confInfo = new EgConfigInfo("manager");
    String dbName = "";
    String sidName;
    public String dbHost;
    String dburl = "";
    String driverName;
    String dbuser;
    String dbpass;
    String ntlmV2;
    String errMessage = "";
    boolean error_state;

    public EgCheckDb() {
        System.setProperty("jsse.enableCBCProtection", "false");
        EgDbInfo egDbInfo = new EgDbInfo("manager");
        this.driverName = egDbInfo.getDriverForDb(this.dbType);
        this.dburl = egDbInfo.getUrlForDb(this.dbType);
        this.dbuser = egDbInfo.getUserForDb(this.dbType);
        this.dbpass = egDbInfo.getPasswdForDb(this.dbType);
        this.ntlmV2 = egDbInfo.getNtlmV2ForDb(this.dbType);
        StringTokenizer stringTokenizer = new StringTokenizer(this.dburl, ":@/");
        if (stringTokenizer.countTokens() > 5) {
            String string = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            this.dbHost = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            this.sidName = stringTokenizer.nextToken();
        } else if (stringTokenizer.countTokens() > 4) {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            this.dbHost = stringTokenizer.nextToken();
        }
    }

    public static void main(String[] stringArray) {
        EgCheckDb egCheckDb = new EgCheckDb();
        egCheckDb.isDbRunning();
        System.out.println(egCheckDb.getDbMessage());
    }

    public boolean isDbRunning() {
        if (this.driverName == null || this.driverName.equals("")) {
            this.writeToLog("Failed to get Driver Name.");
            return false;
        }
        if (this.dburl == null || this.dburl.equals("")) {
            this.writeToLog("Failed to get database URL.");
            return false;
        }
        if (this.dbuser == null || this.dbuser.equals("")) {
            this.writeToLog("Failed to get database user.");
            return false;
        }
        if (this.dbpass == null || this.dbpass.equals("")) {
            this.writeToLog("Failed to get database password.");
            return false;
        }
        if (this.ntlmV2 == null || this.ntlmV2.length() <= 0) {
            this.ntlmV2 = "false";
        }
        EgCheckDbHelper egCheckDbHelper = new EgCheckDbHelper(this.driverName, this.dburl, this.dbuser, this.dbpass, this.ntlmV2);
        boolean bl = this.checkForTimeout(egCheckDbHelper);
        if (bl) {
            return egCheckDbHelper.success;
        }
        return false;
    }

    private void writeToLog(String string) {
        this.confInfo.logToErrorFile("EgCheckDb", string);
    }

    public String getDbMessage() {
        if (this.error_state) {
            return this.errMessage;
        }
        if (this.sidName != null && this.dbHost != null) {
            return "eG Database: Not OK.\nDatabase " + this.sidName.toUpperCase() + " on host " + this.dbHost + " is either not up or you have reached the maximum " + "connection limit for this database. Please take action " + "immediately to correct this problem.";
        }
        if (this.sidName == null && this.dbHost != null) {
            return "eG Database: Not OK.\nDatabase on host " + this.dbHost + " is either not up or you have reached the maximum " + "connection limit for this database. Please take action " + "immediately to correct this problem.";
        }
        return null;
    }

    private boolean checkForTimeout(EgCheckDbHelper egCheckDbHelper) {
        long l;
        long l2 = EgConfigInfo.msecPerMin * 2L;
        long l3 = 0L;
        long l4 = 100L;
        do {
            this.threadSleep(l4);
            if (egCheckDbHelper.done) {
                return true;
            }
            if ((l3 += l4) >= l2) {
                egCheckDbHelper.interrupt();
                Thread.currentThread();
                Thread.yield();
                egCheckDbHelper.stop();
                return false;
            }
            l = l4;
            if (l2 - l3 >= l) continue;
            l = l2 - l3;
        } while ((l4 = l) > 0L);
        egCheckDbHelper.interrupt();
        Thread.currentThread();
        Thread.yield();
        egCheckDbHelper.stop();
        return false;
    }

    public void threadSleep(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            block3: {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    long l3 = System.currentTimeMillis();
                    l = l2 - l3;
                    if (l >= 0L) break block3;
                    return;
                }
            }
            long l4 = System.currentTimeMillis();
            l = l2 - l4;
        }
    }
}

