#!/bin/sh

EG_HOME=/opt/egurkha
export EG_HOME

#### - set java path to the PATH variable and set the CLASSPATH variable

JAVA_HOME=`grep "JAVASTART_HOME=" /opt/egurkha/bin/start_manager | cut -d "=" -f2`
export JAVA_HOME
if [ -z "$JAVA_HOME" ]
then
	JAVA_HOME=`grep "JAVA_HOME=" /opt/egurkha/bin/start_manager | cut -d "=" -f2`
	export JAVA_HOME
fi
PATH=$JAVA_HOME/bin:$EG_HOME/bin:/sbin:/usr/bin:/usr/sbin:/bin:$PATH:/usr/local/bin:/usr/ucb
export PATH

CLASSPATH=.:eg_update.jar:$EG_HOME/lib/eg_manager.jar:$EG_HOME/lib/eg_util.jar:$EG_HOME/lib/classes111.zip:$EG_HOME/lib/TwFreeTds.jar:$EG_HOME/lib/jtds.jar:$JAVA_HOME/lib/tools.jar:/opt/egurkha/lib/eg_agent.jar:/opt/egurkha/lib/xmlParserAPIs.jar:/opt/egurkha/manager/tomcat/webapps/final/WEB-INF/classes:$CLASSPATH:$EG_HOME/lib/xmlParserAPIs.jar:$EG_HOME/lib/xml-apis.jar:$EG_HOME/lib/parser.jar
export CLASSPATH


echo
echo
echo
echo *********************************************************
echo  PLEASE DO NOT INTERRUPT THIS PROCESS.
echo *********************************************************

if [ -f /opt/egurkha/tmp/postUpgrade_error ]
then 
	rm -f /opt/egurkha/tmp/postUpgrade_error
fi

if [ -f /opt/egurkha/tmp/postUpgrade_event ]
then 
	rm -f /opt/egurkha/tmp/postUpgrade_event
fi

echo
echo

echo "Going to update the Index"

echo "Index will be updated shortly...."

java -cp $curDir:$CLASSPATH UpgradingIndex >>$EG_HOME/manager/logs/postUpgrade_event 2>>$EG_HOME/tmp/postUpgrade_error

if [ -f /opt/egurkha/tmp/postUpgrade_error ]
then
	STATUS=`wc -l /opt/egurkha/tmp/postUpgrade_error|awk '{print $1}'`
else
	STATUS=0
fi

if [ `expr $STATUS` -ne 0 ]
 then
	echo "ERROR : Unable to Update the Index "
	echo "ERROR : Unable to Update the Index " >>$EG_HOME/manager/logs/postUpgrade_event
	cat /opt/egurkha/tmp/postUpgrade_error >>$EG_HOME/manager/logs/postUpgrade_event
	echo "Please refer to file /opt/egurkha/manager/logs/postUpgrade_event for further details"
	exit 1
fi
	echo "Index Updated Successfully"
	echo "Index Updated Successfully" >>$EG_HOME/manager/logs/postUpgrade_event
