/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.tree.analysis;

import com.eg.org.objectweb.asm.Opcodes;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.tree.AbstractInsnNode;
import com.eg.org.objectweb.asm.tree.IincInsnNode;
import com.eg.org.objectweb.asm.tree.InsnList;
import com.eg.org.objectweb.asm.tree.JumpInsnNode;
import com.eg.org.objectweb.asm.tree.LabelNode;
import com.eg.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.eg.org.objectweb.asm.tree.MethodNode;
import com.eg.org.objectweb.asm.tree.TableSwitchInsnNode;
import com.eg.org.objectweb.asm.tree.TryCatchBlockNode;
import com.eg.org.objectweb.asm.tree.VarInsnNode;
import com.eg.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.eg.org.objectweb.asm.tree.analysis.Frame;
import com.eg.org.objectweb.asm.tree.analysis.Interpreter;
import com.eg.org.objectweb.asm.tree.analysis.Subroutine;
import com.eg.org.objectweb.asm.tree.analysis.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer<V extends Value>
implements Opcodes {
    private final Interpreter<V> interpreter;
    private InsnList insnList;
    private int insnListSize;
    private List<TryCatchBlockNode>[] handlers;
    private Frame<V>[] frames;
    private Subroutine[] subroutines;
    private boolean[] inInstructionsToProcess;
    private int[] instructionsToProcess;
    private int numInstructionsToProcess;

    public Analyzer(Interpreter<V> interpreter) {
        this.interpreter = interpreter;
    }

    public Frame<V>[] analyze(String string, MethodNode methodNode) throws AnalyzerException {
        List<TryCatchBlockNode> list;
        Object object;
        if ((methodNode.access & 0x500) != 0) {
            this.frames = new Frame[0];
            return this.frames;
        }
        this.insnList = methodNode.instructions;
        this.insnListSize = this.insnList.size();
        this.handlers = new List[this.insnListSize];
        this.frames = new Frame[this.insnListSize];
        this.subroutines = new Subroutine[this.insnListSize];
        this.inInstructionsToProcess = new boolean[this.insnListSize];
        this.instructionsToProcess = new int[this.insnListSize];
        this.numInstructionsToProcess = 0;
        for (int i = 0; i < methodNode.tryCatchBlocks.size(); ++i) {
            object = methodNode.tryCatchBlocks.get(i);
            int n = this.insnList.indexOf(((TryCatchBlockNode)object).start);
            int n2 = this.insnList.indexOf(((TryCatchBlockNode)object).end);
            for (int j = n; j < n2; ++j) {
                list = this.handlers[j];
                if (list == null) {
                    list = new ArrayList<TryCatchBlockNode>();
                    this.handlers[j] = list;
                }
                list.add((TryCatchBlockNode)object);
            }
        }
        Subroutine subroutine = new Subroutine(null, methodNode.maxLocals, null);
        object = new ArrayList();
        this.findSubroutine(0, subroutine, (List<AbstractInsnNode>)object);
        HashMap<LabelNode, Subroutine> hashMap = new HashMap<LabelNode, Subroutine>();
        while (!object.isEmpty()) {
            JumpInsnNode jumpInsnNode = (JumpInsnNode)object.remove(0);
            Subroutine subroutine2 = (Subroutine)hashMap.get(jumpInsnNode.label);
            if (subroutine2 == null) {
                subroutine2 = new Subroutine(jumpInsnNode.label, methodNode.maxLocals, jumpInsnNode);
                hashMap.put(jumpInsnNode.label, subroutine2);
                this.findSubroutine(this.insnList.indexOf(jumpInsnNode.label), subroutine2, (List<AbstractInsnNode>)object);
                continue;
            }
            subroutine2.callers.add(jumpInsnNode);
        }
        for (int i = 0; i < this.insnListSize; ++i) {
            if (this.subroutines[i] == null || this.subroutines[i].start != null) continue;
            this.subroutines[i] = null;
        }
        Frame<V> frame = this.computeInitialFrame(string, methodNode);
        this.merge(0, frame, null);
        this.init(string, methodNode);
        while (this.numInstructionsToProcess > 0) {
            int n = this.instructionsToProcess[--this.numInstructionsToProcess];
            list = this.frames[n];
            Subroutine subroutine3 = this.subroutines[n];
            this.inInstructionsToProcess[n] = false;
            AbstractInsnNode abstractInsnNode = null;
            try {
                Object object2;
                Object object3;
                abstractInsnNode = methodNode.instructions.get(n);
                int n3 = abstractInsnNode.getOpcode();
                int n4 = abstractInsnNode.getType();
                if (n4 == 8 || n4 == 15 || n4 == 14) {
                    this.merge(n + 1, (Frame<V>)((Object)list), subroutine3);
                    this.newControlFlowEdge(n, n + 1);
                } else {
                    int n5;
                    frame.init((Frame<V>)((Object)list)).execute(abstractInsnNode, this.interpreter);
                    Subroutine subroutine4 = subroutine3 = subroutine3 == null ? null : new Subroutine(subroutine3);
                    if (abstractInsnNode instanceof JumpInsnNode) {
                        object3 = (JumpInsnNode)abstractInsnNode;
                        if (n3 != 167 && n3 != 168) {
                            frame.initJumpTarget(n3, null);
                            this.merge(n + 1, frame, subroutine3);
                            this.newControlFlowEdge(n, n + 1);
                        }
                        int n6 = this.insnList.indexOf(((JumpInsnNode)object3).label);
                        frame.initJumpTarget(n3, ((JumpInsnNode)object3).label);
                        if (n3 == 168) {
                            this.merge(n6, frame, new Subroutine(((JumpInsnNode)object3).label, methodNode.maxLocals, (JumpInsnNode)object3));
                        } else {
                            this.merge(n6, frame, subroutine3);
                        }
                        this.newControlFlowEdge(n, n6);
                    } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
                        object3 = (LookupSwitchInsnNode)abstractInsnNode;
                        int n7 = this.insnList.indexOf(((LookupSwitchInsnNode)object3).dflt);
                        frame.initJumpTarget(n3, ((LookupSwitchInsnNode)object3).dflt);
                        this.merge(n7, frame, subroutine3);
                        this.newControlFlowEdge(n, n7);
                        for (n5 = 0; n5 < ((LookupSwitchInsnNode)object3).labels.size(); ++n5) {
                            object2 = ((LookupSwitchInsnNode)object3).labels.get(n5);
                            n7 = this.insnList.indexOf((AbstractInsnNode)object2);
                            frame.initJumpTarget(n3, (LabelNode)object2);
                            this.merge(n7, frame, subroutine3);
                            this.newControlFlowEdge(n, n7);
                        }
                    } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
                        object3 = (TableSwitchInsnNode)abstractInsnNode;
                        int n8 = this.insnList.indexOf(((TableSwitchInsnNode)object3).dflt);
                        frame.initJumpTarget(n3, ((TableSwitchInsnNode)object3).dflt);
                        this.merge(n8, frame, subroutine3);
                        this.newControlFlowEdge(n, n8);
                        for (n5 = 0; n5 < ((TableSwitchInsnNode)object3).labels.size(); ++n5) {
                            object2 = ((TableSwitchInsnNode)object3).labels.get(n5);
                            frame.initJumpTarget(n3, (LabelNode)object2);
                            n8 = this.insnList.indexOf((AbstractInsnNode)object2);
                            this.merge(n8, frame, subroutine3);
                            this.newControlFlowEdge(n, n8);
                        }
                    } else if (n3 == 169) {
                        if (subroutine3 == null) {
                            throw new AnalyzerException(abstractInsnNode, "RET instruction outside of a sub routine");
                        }
                        for (int i = 0; i < subroutine3.callers.size(); ++i) {
                            JumpInsnNode jumpInsnNode = subroutine3.callers.get(i);
                            n5 = this.insnList.indexOf(jumpInsnNode);
                            if (this.frames[n5] == null) continue;
                            this.merge(n5 + 1, this.frames[n5], frame, this.subroutines[n5], subroutine3.localsUsed);
                            this.newControlFlowEdge(n, n5 + 1);
                        }
                    } else if (n3 != 191 && (n3 < 172 || n3 > 177)) {
                        if (subroutine3 != null) {
                            if (abstractInsnNode instanceof VarInsnNode) {
                                int n9 = ((VarInsnNode)abstractInsnNode).var;
                                subroutine3.localsUsed[n9] = true;
                                if (n3 == 22 || n3 == 24 || n3 == 55 || n3 == 57) {
                                    subroutine3.localsUsed[n9 + 1] = true;
                                }
                            } else if (abstractInsnNode instanceof IincInsnNode) {
                                int n10 = ((IincInsnNode)abstractInsnNode).var;
                                subroutine3.localsUsed[n10] = true;
                            }
                        }
                        this.merge(n + 1, frame, subroutine3);
                        this.newControlFlowEdge(n, n + 1);
                    }
                }
                if ((object3 = this.handlers[n]) == null) continue;
                Iterator<TryCatchBlockNode> iterator = object3.iterator();
                while (iterator.hasNext()) {
                    TryCatchBlockNode tryCatchBlockNode = iterator.next();
                    object2 = tryCatchBlockNode.type == null ? Type.getObjectType("java/lang/Throwable") : Type.getObjectType(tryCatchBlockNode.type);
                    if (!this.newControlFlowExceptionEdge(n, tryCatchBlockNode)) continue;
                    Frame<V> frame2 = this.newFrame((Frame<? extends V>)((Object)list));
                    frame2.clearStack();
                    frame2.push(this.interpreter.newExceptionValue(tryCatchBlockNode, frame2, (Type)object2));
                    this.merge(this.insnList.indexOf(tryCatchBlockNode.handler), frame2, subroutine3);
                }
            }
            catch (AnalyzerException analyzerException) {
                throw new AnalyzerException(analyzerException.node, "Error at instruction " + n + ": " + analyzerException.getMessage(), analyzerException);
            }
            catch (RuntimeException runtimeException) {
                throw new AnalyzerException(abstractInsnNode, "Error at instruction " + n + ": " + runtimeException.getMessage(), runtimeException);
            }
        }
        return this.frames;
    }

    private void findSubroutine(int n, Subroutine subroutine, List<AbstractInsnNode> list) throws AnalyzerException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(n);
        block3: while (!arrayList.isEmpty()) {
            Object object;
            Object object2;
            int n2 = (Integer)arrayList.remove(arrayList.size() - 1);
            if (n2 < 0 || n2 >= this.insnListSize) {
                throw new AnalyzerException(null, "Execution can fall off the end of the code");
            }
            if (this.subroutines[n2] != null) continue;
            this.subroutines[n2] = new Subroutine(subroutine);
            AbstractInsnNode abstractInsnNode = this.insnList.get(n2);
            if (abstractInsnNode instanceof JumpInsnNode) {
                if (abstractInsnNode.getOpcode() == 168) {
                    list.add(abstractInsnNode);
                } else {
                    object2 = (JumpInsnNode)abstractInsnNode;
                    arrayList.add(this.insnList.indexOf(((JumpInsnNode)object2).label));
                }
            } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
                object2 = (TableSwitchInsnNode)abstractInsnNode;
                this.findSubroutine(this.insnList.indexOf(((TableSwitchInsnNode)object2).dflt), subroutine, list);
                for (int i = ((TableSwitchInsnNode)object2).labels.size() - 1; i >= 0; --i) {
                    object = ((TableSwitchInsnNode)object2).labels.get(i);
                    arrayList.add(this.insnList.indexOf((AbstractInsnNode)object));
                }
            } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
                object2 = (LookupSwitchInsnNode)abstractInsnNode;
                this.findSubroutine(this.insnList.indexOf(((LookupSwitchInsnNode)object2).dflt), subroutine, list);
                for (int i = ((LookupSwitchInsnNode)object2).labels.size() - 1; i >= 0; --i) {
                    object = ((LookupSwitchInsnNode)object2).labels.get(i);
                    arrayList.add(this.insnList.indexOf((AbstractInsnNode)object));
                }
            }
            object2 = this.handlers[n2];
            if (object2 != null) {
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (TryCatchBlockNode)iterator.next();
                    arrayList.add(this.insnList.indexOf(((TryCatchBlockNode)object).handler));
                }
            }
            switch (abstractInsnNode.getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    continue block3;
                }
            }
            arrayList.add(n2 + 1);
        }
    }

    private Frame<V> computeInitialFrame(String string, MethodNode methodNode) {
        Type[] typeArray;
        boolean bl;
        Frame<V> frame = this.newFrame(methodNode.maxLocals, methodNode.maxStack);
        int n = 0;
        boolean bl2 = bl = (methodNode.access & 8) == 0;
        if (bl) {
            typeArray = Type.getObjectType(string);
            frame.setLocal(n, this.interpreter.newParameterValue(bl, n, (Type)typeArray));
            ++n;
        }
        for (Type type : typeArray = Type.getArgumentTypes(methodNode.desc)) {
            frame.setLocal(n, this.interpreter.newParameterValue(bl, n, type));
            ++n;
            if (type.getSize() != 2) continue;
            frame.setLocal(n, this.interpreter.newEmptyValue(n));
            ++n;
        }
        while (n < methodNode.maxLocals) {
            frame.setLocal(n, this.interpreter.newEmptyValue(n));
            ++n;
        }
        frame.setReturn(this.interpreter.newReturnTypeValue(Type.getReturnType(methodNode.desc)));
        return frame;
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    public List<TryCatchBlockNode> getHandlers(int n) {
        return this.handlers[n];
    }

    protected void init(String string, MethodNode methodNode) throws AnalyzerException {
    }

    protected Frame<V> newFrame(int n, int n2) {
        return new Frame(n, n2);
    }

    protected Frame<V> newFrame(Frame<? extends V> frame) {
        return new Frame<V>(frame);
    }

    protected void newControlFlowEdge(int n, int n2) {
    }

    protected boolean newControlFlowExceptionEdge(int n, int n2) {
        return true;
    }

    protected boolean newControlFlowExceptionEdge(int n, TryCatchBlockNode tryCatchBlockNode) {
        return this.newControlFlowExceptionEdge(n, this.insnList.indexOf(tryCatchBlockNode.handler));
    }

    private void merge(int n, Frame<V> frame, Subroutine subroutine) throws AnalyzerException {
        boolean bl;
        Frame<V> frame2 = this.frames[n];
        if (frame2 == null) {
            this.frames[n] = this.newFrame(frame);
            bl = true;
        } else {
            bl = frame2.merge(frame, this.interpreter);
        }
        Subroutine subroutine2 = this.subroutines[n];
        if (subroutine2 == null) {
            if (subroutine != null) {
                this.subroutines[n] = new Subroutine(subroutine);
                bl = true;
            }
        } else if (subroutine != null) {
            bl |= subroutine2.merge(subroutine);
        }
        if (bl && !this.inInstructionsToProcess[n]) {
            this.inInstructionsToProcess[n] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = n;
        }
    }

    private void merge(int n, Frame<V> frame, Frame<V> frame2, Subroutine subroutine, boolean[] blArray) throws AnalyzerException {
        boolean bl;
        frame2.merge(frame, blArray);
        Frame<V> frame3 = this.frames[n];
        if (frame3 == null) {
            this.frames[n] = this.newFrame(frame2);
            bl = true;
        } else {
            bl = frame3.merge(frame2, this.interpreter);
        }
        Subroutine subroutine2 = this.subroutines[n];
        if (subroutine2 != null && subroutine != null) {
            bl |= subroutine2.merge(subroutine);
        }
        if (bl && !this.inInstructionsToProcess[n]) {
            this.inInstructionsToProcess[n] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = n;
        }
    }
}

