/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.commons;

import com.eg.org.objectweb.asm.AnnotationVisitor;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Opcodes;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.TypePath;

public class LocalVariablesSorter
extends MethodVisitor {
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private int[] remappedVariableIndices = new int[40];
    private Object[] remappedLocalTypes = new Object[20];
    protected final int firstLocal;
    protected int nextLocal;

    public LocalVariablesSorter(int n, String string, MethodVisitor methodVisitor) {
        this(458752, n, string, methodVisitor);
        if (this.getClass() != LocalVariablesSorter.class) {
            throw new IllegalStateException();
        }
    }

    protected LocalVariablesSorter(int n, int n2, String string, MethodVisitor methodVisitor) {
        super(n, methodVisitor);
        this.nextLocal = (8 & n2) == 0 ? 1 : 0;
        for (Type type : Type.getArgumentTypes(string)) {
            this.nextLocal += type.getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    public void visitVarInsn(int n, int n2) {
        Type type;
        switch (n) {
            case 22: 
            case 55: {
                type = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                type = Type.DOUBLE_TYPE;
                break;
            }
            case 23: 
            case 56: {
                type = Type.FLOAT_TYPE;
                break;
            }
            case 21: 
            case 54: {
                type = Type.INT_TYPE;
                break;
            }
            case 25: 
            case 58: 
            case 169: {
                type = OBJECT_TYPE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid opcode " + n);
            }
        }
        super.visitVarInsn(n, this.remap(n2, type));
    }

    public void visitIincInsn(int n, int n2) {
        super.visitIincInsn(this.remap(n, Type.INT_TYPE), n2);
    }

    public void visitMaxs(int n, int n2) {
        super.visitMaxs(n, this.nextLocal);
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        int n2 = this.remap(n, Type.getType(string2));
        super.visitLocalVariable(string, string2, string3, label, label2, n2);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        Type type = Type.getType(string);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = this.remap(nArray[i], type);
        }
        return super.visitLocalVariableAnnotation(n, typePath, labelArray, labelArray2, nArray2, string, bl);
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        Object object;
        int n4;
        if (n != -1) {
            throw new IllegalArgumentException("LocalVariablesSorter only accepts expanded frames (see ClassReader.EXPAND_FRAMES)");
        }
        Object[] objectArray3 = new Object[this.remappedLocalTypes.length];
        System.arraycopy(this.remappedLocalTypes, 0, objectArray3, 0, objectArray3.length);
        this.updateNewLocals(this.remappedLocalTypes);
        int n5 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            Object object2 = objectArray[n4];
            if (object2 != Opcodes.TOP) {
                object = OBJECT_TYPE;
                if (object2 == Opcodes.INTEGER) {
                    object = Type.INT_TYPE;
                } else if (object2 == Opcodes.FLOAT) {
                    object = Type.FLOAT_TYPE;
                } else if (object2 == Opcodes.LONG) {
                    object = Type.LONG_TYPE;
                } else if (object2 == Opcodes.DOUBLE) {
                    object = Type.DOUBLE_TYPE;
                } else if (object2 instanceof String) {
                    object = Type.getObjectType((String)object2);
                }
                this.setFrameLocal(this.remap(n5, (Type)object), object2);
            }
            n5 += object2 == Opcodes.LONG || object2 == Opcodes.DOUBLE ? 2 : 1;
        }
        n4 = 0;
        int n6 = 0;
        for (n5 = 0; n5 < this.remappedLocalTypes.length; n5 += (object = this.remappedLocalTypes[n5]) == Opcodes.LONG || object == Opcodes.DOUBLE ? 2 : 1) {
            if (object != null && object != Opcodes.TOP) {
                this.remappedLocalTypes[n4++] = object;
                n6 = n4;
                continue;
            }
            this.remappedLocalTypes[n4++] = Opcodes.TOP;
        }
        super.visitFrame(n, n6, this.remappedLocalTypes, n3, objectArray2);
        this.remappedLocalTypes = objectArray3;
    }

    public int newLocal(Type type) {
        Object object;
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                object = Opcodes.INTEGER;
                break;
            }
            case 6: {
                object = Opcodes.FLOAT;
                break;
            }
            case 7: {
                object = Opcodes.LONG;
                break;
            }
            case 8: {
                object = Opcodes.DOUBLE;
                break;
            }
            case 9: {
                object = type.getDescriptor();
                break;
            }
            case 10: {
                object = type.getInternalName();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        int n = this.newLocalMapping(type);
        this.setLocalType(n, type);
        this.setFrameLocal(n, object);
        return n;
    }

    protected void updateNewLocals(Object[] objectArray) {
    }

    protected void setLocalType(int n, Type type) {
    }

    private void setFrameLocal(int n, Object object) {
        int n2 = this.remappedLocalTypes.length;
        if (n >= n2) {
            Object[] objectArray = new Object[Math.max(2 * n2, n + 1)];
            System.arraycopy(this.remappedLocalTypes, 0, objectArray, 0, n2);
            this.remappedLocalTypes = objectArray;
        }
        this.remappedLocalTypes[n] = object;
    }

    private int remap(int n, Type type) {
        int n2;
        int n3;
        if (n + type.getSize() <= this.firstLocal) {
            return n;
        }
        int n4 = 2 * n + type.getSize() - 1;
        if (n4 >= (n3 = this.remappedVariableIndices.length)) {
            int[] nArray = new int[Math.max(2 * n3, n4 + 1)];
            System.arraycopy(this.remappedVariableIndices, 0, nArray, 0, n3);
            this.remappedVariableIndices = nArray;
        }
        if ((n2 = this.remappedVariableIndices[n4]) == 0) {
            n2 = this.newLocalMapping(type);
            this.setLocalType(n2, type);
            this.remappedVariableIndices[n4] = n2 + 1;
        } else {
            --n2;
        }
        return n2;
    }

    protected int newLocalMapping(Type type) {
        int n = this.nextLocal;
        this.nextLocal += type.getSize();
        return n;
    }
}

