/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jvmmonitor.metric;

import com.eg.jtm.BTMLog;
import com.eg.jvmmonitor.JVMMetric;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Hashtable;

public class JVMClassInfo
extends JVMMetric {
    private long measurePeriod;

    public ArrayList pollMeasures() {
        ArrayList arrayList = new ArrayList();
        try {
            ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
            if (!this.isNull(classLoadingMXBean)) {
                Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
                hashtable.put("NumberOfClassesLoaded", new Double(classLoadingMXBean.getLoadedClassCount()));
                hashtable.put("NumberOfClassesUnloaded", new Double(classLoadingMXBean.getUnloadedClassCount()));
                hashtable.put("TotalNumberOfClassesLoaded", new Double(classLoadingMXBean.getTotalLoadedClassCount()));
                arrayList.add(hashtable);
                return arrayList;
            }
            BTMLog.logger.debug("[JVMClassInfo] ClassLoadingMXBean is Null!!!");
        }
        catch (Exception exception) {
            BTMLog.logger.error("[JVMClassInfo.pollMeasures()] /t Error while polling measures. {} ", (Object)exception.getMessage());
        }
        return arrayList;
    }
}

