/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.learning;

import com.eg.jtm.PropsManager;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;

public class LearningProperties {
    private final Properties learningProps = new Properties();
    private static boolean learningMode = false;
    private static int slowMethodLimit = 100;
    private static int fastMethodLimit = 100;
    private static int slowMethodExecutionCount = 25;
    private static int corePoolSize = 2;
    private static int maxPoolSize = 3;
    private static long keepAliveTime = 5000L;
    private static int queueCapacity = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LearningProperties() {
        InputStream inputStream = null;
        try {
            String string;
            inputStream = new BufferedInputStream(new FileInputStream(PropsManager.EG_BTM_HOME + "/" + "btmOther.props"));
            this.learningProps.load(inputStream);
            Set<Object> set = this.learningProps.keySet();
            learningMode = this.checkLearningMode();
            try {
                string = this.learningProps.getProperty("Core_Pool_Size");
                corePoolSize = Integer.parseInt(string);
                if (corePoolSize < 0) {
                    corePoolSize = 2;
                }
            }
            catch (Exception exception) {
                corePoolSize = 2;
            }
            try {
                string = this.learningProps.getProperty("Max_Pool_Size");
                maxPoolSize = Integer.parseInt(string);
                if (maxPoolSize < 0) {
                    maxPoolSize = 3;
                }
            }
            catch (Exception exception) {
                maxPoolSize = 3;
            }
            if (maxPoolSize <= corePoolSize) {
                maxPoolSize = corePoolSize + 1;
            }
            try {
                string = this.learningProps.getProperty("Keep_Alive_Time");
                keepAliveTime = Long.parseLong(string);
                if (keepAliveTime < 0L) {
                    keepAliveTime = 5000L;
                }
            }
            catch (Exception exception) {
                keepAliveTime = 5000L;
            }
            try {
                string = this.learningProps.getProperty("Queue_Capacity");
                queueCapacity = Integer.parseInt(string);
                if (queueCapacity < 0) {
                    queueCapacity = 50;
                }
            }
            catch (Exception exception) {
                queueCapacity = 50;
            }
            try {
                string = this.learningProps.getProperty("Fast_Methods_Per_Request");
                fastMethodLimit = Integer.parseInt(string);
            }
            catch (Exception exception) {
                fastMethodLimit = 100;
            }
            try {
                string = this.learningProps.getProperty("Slow_Methods_Per_Request");
                slowMethodLimit = Integer.parseInt(string);
            }
            catch (Exception exception) {
                slowMethodLimit = 100;
            }
            try {
                string = this.learningProps.getProperty("Slow_Method_Invocation_Limit");
                slowMethodExecutionCount = Integer.parseInt(string);
            }
            catch (Exception exception) {
                slowMethodExecutionCount = 25;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static LearningProperties getInstance() {
        return LazyHolder.INSTANCE;
    }

    private String getProperty(String string) {
        return this.learningProps.getProperty(string);
    }

    private boolean containsKey(String string) {
        return this.learningProps.containsKey(string);
    }

    private boolean checkLearningMode() {
        String string = this.learningProps.getProperty("Learning_Mode");
        boolean bl = false;
        if (string != null && (string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("TRUE") || string.equalsIgnoreCase("YES"))) {
            bl = true;
        }
        return bl;
    }

    public static int getSlowMethodLimit() {
        return slowMethodLimit;
    }

    public static int getFastMethodLimit() {
        return fastMethodLimit;
    }

    public static int getCorePoolSize() {
        return corePoolSize;
    }

    public static int getMaxPoolSize() {
        return maxPoolSize;
    }

    public static long getKeepAliveTime() {
        return keepAliveTime;
    }

    public static int getQueueCapacity() {
        return queueCapacity;
    }

    public static boolean isLearningMode() {
        return learningMode;
    }

    public static int getSlowMethodExecutionCount() {
        return slowMethodExecutionCount;
    }

    private static class LazyHolder {
        private static final LearningProperties INSTANCE = new LearningProperties();

        private LazyHolder() {
        }
    }
}

