/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.jtm.URLPatternData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;

public class URLPatternMeasure {
    boolean modified = false;
    private String pName;
    private Hashtable pMeasureHT;
    private static final Double defaultMeasure = new Double(0.0);
    private static final List<Double> defaultPatternData = new ArrayList<Double>();
    private double averageResponseTime = 0.0;
    private static final String ERROR_URL_EXISTS = "ERROR_URL_EXISTS";
    private static int old_measure_count = 18;
    private static final String PATTERN_DATA = "patternData";
    private static final String SLOW_URL_LISTS = "SlowURLLists";
    private static final String ERROR_URL_LISTS = "ErrorURLLists";
    private static final String ALL_URL_LISTS = "AllURLLists";
    private static final String STALLED_URL_LISTS = "StalledURLLists";
    private static final String SLOWURL_THREAD_LISTS = "SlowURLThreadLists";
    private static final String ERRORURL_THREAD_LISTS = "ErrorURLThreadLists";
    private static final String STALLEDURL_THREAD_LISTS = "StalledURLThreadLists";
    private static final String HEALTHYURL_THREAD_LISTS = "HealthyURLThreadLists";
    private static final String HYPEN_STRING = "-";

    URLPatternMeasure() {
        this.pName = "SUMMARY_PATTERN";
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put(this.pName, defaultPatternData);
    }

    URLPatternMeasure(String string) {
        this.pName = string;
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put(PATTERN_DATA, defaultPatternData);
        this.pMeasureHT.put(SLOW_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERROR_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ALL_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLED_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(HEALTHYURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(SLOWURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERRORURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLEDURL_THREAD_LISTS, HYPEN_STRING);
    }

    public Hashtable getMeasureTbl() {
        Hashtable hashtable = (Hashtable)this.pMeasureHT.clone();
        this.modified = false;
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put(PATTERN_DATA, defaultPatternData);
        this.pMeasureHT.put(SLOW_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERROR_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ALL_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLED_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(HEALTHYURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(SLOWURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERRORURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLEDURL_THREAD_LISTS, HYPEN_STRING);
        if (!PropsManager.isNewAgent()) {
            ArrayList arrayList = (ArrayList)hashtable.get(PATTERN_DATA);
            this.getBackWardCompatibalityResult(arrayList);
        }
        return hashtable;
    }

    private void getBackWardCompatibalityResult(ArrayList arrayList) {
        int n = arrayList.size();
        if (n > old_measure_count) {
            for (int i = n - 1; i >= old_measure_count; --i) {
                arrayList.remove(i);
            }
        }
    }

    public Hashtable getSummaryMeasures() {
        Hashtable hashtable = (Hashtable)this.pMeasureHT.clone();
        this.modified = false;
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put("SUMMARY_PATTERN", defaultPatternData);
        if (!PropsManager.isNewAgent()) {
            ArrayList arrayList = (ArrayList)hashtable.get("SUMMARY_PATTERN");
            this.getBackWardCompatibalityResult(arrayList);
        }
        return hashtable;
    }

    public boolean isErrorURLExists() {
        boolean bl = false;
        if (this.pMeasureHT != null) {
            bl = this.pMeasureHT.containsKey(ERROR_URL_EXISTS);
        }
        return bl;
    }

    public void update(URLPatternData uRLPatternData, URLPatternMeasure uRLPatternMeasure, boolean bl) {
        this.modified = true;
        ArrayList arrayList = (ArrayList)uRLPatternMeasure.pMeasureHT.get("SUMMARY_PATTERN");
        if (this.pMeasureHT.containsKey(PATTERN_DATA)) {
            ArrayList arrayList2 = (ArrayList)this.pMeasureHT.get(PATTERN_DATA);
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            ArrayList<Double> arrayList4 = new ArrayList<Double>();
            for (int i = 0; i < uRLPatternData.numOf.length; ++i) {
                double d = uRLPatternData.numOf[i];
                double d2 = uRLPatternData.sumOf[i];
                double d3 = 0.0;
                double d4 = 0.0;
                try {
                    d3 = (Double)arrayList2.get(i * 2);
                    d4 = (Double)arrayList2.get(i * 2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                arrayList3.add(new Double(d3 + d));
                arrayList3.add(new Double(d4 + d2));
                if (i >= 5 && i <= 8) {
                    arrayList4.add(defaultMeasure);
                    arrayList4.add(defaultMeasure);
                    continue;
                }
                double d5 = 0.0;
                double d6 = 0.0;
                try {
                    d5 = (Double)arrayList.get(i * 2);
                    d6 = (Double)arrayList.get(i * 2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                arrayList4.add(new Double(d5 + d));
                arrayList4.add(new Double(d6 + d2));
            }
            this.pMeasureHT.put(PATTERN_DATA, arrayList3);
            uRLPatternMeasure.pMeasureHT.put("SUMMARY_PATTERN", arrayList4);
            if (bl) {
                this.calculateAverage(arrayList3);
            }
        } else {
            ArrayList<Double> arrayList5 = new ArrayList<Double>();
            ArrayList<Double> arrayList6 = new ArrayList<Double>();
            for (int i = 0; i < uRLPatternData.numOf.length; ++i) {
                double d = uRLPatternData.numOf[i];
                double d7 = uRLPatternData.sumOf[i];
                arrayList5.add(d);
                arrayList5.add(d7);
                if (i >= 5 && i <= 8) {
                    arrayList6.add(defaultMeasure);
                    arrayList6.add(defaultMeasure);
                    continue;
                }
                double d8 = 0.0;
                double d9 = 0.0;
                try {
                    d8 = (Double)arrayList.get(i * 2);
                    d9 = (Double)arrayList.get(i * 2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                arrayList6.add(new Double(d8 + d));
                arrayList6.add(new Double(d9 + d7));
            }
            this.pMeasureHT.put(PATTERN_DATA, arrayList5);
            uRLPatternMeasure.pMeasureHT.put("SUMMARY_PATTERN", arrayList6);
            if (bl) {
                this.calculateAverage(arrayList5);
            }
        }
        this.calculateSlowURLDetails(uRLPatternData);
        this.calculateErrorURLDetails(uRLPatternData);
        if (PropsManager.isTraceHealthyURL()) {
            this.calculateAllURLDetails(uRLPatternData);
        }
        this.calculateStalledURLDetails(uRLPatternData);
    }

    private void calculateAverage(ArrayList arrayList) {
        double d = (Double)arrayList.get(0);
        if (d > 0.0) {
            double d2 = (Double)arrayList.get(1);
            this.averageResponseTime = d2 / d;
        }
    }

    private void calculateStalledURLDetails(URLPatternData uRLPatternData) {
        ArrayList<MethodInfo> arrayList = null;
        boolean bl = false;
        Object v = this.pMeasureHT.get(STALLED_URL_LISTS);
        if (v != null && v instanceof ArrayList && (arrayList = (ArrayList<MethodInfo>)v) != null && arrayList.size() > 0) {
            bl = true;
        }
        ArrayList arrayList2 = null;
        int n = 0;
        if (uRLPatternData.getStalledURLsList() != null) {
            int n2;
            if (arrayList == null) {
                arrayList = new ArrayList<MethodInfo>();
            }
            arrayList2 = (ArrayList)uRLPatternData.getStalledURLsList().clone();
            n = arrayList2.size();
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList2.get(n2);
                    arrayList.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    BTMLog.logger.error("Exception while iterating stalledUrlList {}", exception);
                    break;
                }
            }
            if (bl) {
                Collections.sort(arrayList, new BTMUrlComparator());
                n2 = arrayList.size();
                int n3 = PropsManager.getMaxStalledURLs();
                if (n2 > n3) {
                    for (int i = n2 - 1; i >= n3; --i) {
                        arrayList.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(STALLED_URL_LISTS, arrayList);
        }
        arrayList2 = null;
        uRLPatternData.cleanStalledURLsList();
        ArrayList<MethodInfo> arrayList3 = null;
        boolean bl2 = false;
        Object v2 = this.pMeasureHT.get(STALLEDURL_THREAD_LISTS);
        if (v2 != null && v2 instanceof ArrayList && (arrayList3 = (ArrayList<MethodInfo>)v2) != null && arrayList3.size() > 0) {
            bl2 = true;
        }
        ArrayList arrayList4 = null;
        int n4 = 0;
        if (uRLPatternData.getStalledTHREADsList() != null) {
            int n5;
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<MethodInfo>();
            }
            arrayList4 = (ArrayList)uRLPatternData.getStalledTHREADsList().clone();
            n4 = arrayList4.size();
            for (n5 = 0; n5 < n4; ++n5) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList4.get(n5);
                    arrayList3.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    BTMLog.logger.error("Exception while iterating stalledThreadList {}", exception);
                    break;
                }
            }
            if (bl2) {
                Collections.sort(arrayList3, new BTMUrlComparator());
                n5 = arrayList3.size();
                int n6 = PropsManager.getMaxSlowURLs();
                if (n5 > n6) {
                    for (int i = n5 - 1; i >= n6; --i) {
                        arrayList3.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(STALLEDURL_THREAD_LISTS, arrayList3);
        }
        arrayList4 = null;
        uRLPatternData.cleanStalledTHREADsList();
    }

    private void calculateSlowURLDetails(URLPatternData uRLPatternData) {
        ArrayList<MethodInfo> arrayList = null;
        boolean bl = false;
        Object v = this.pMeasureHT.get(SLOW_URL_LISTS);
        if (v != null && v instanceof ArrayList && (arrayList = (ArrayList<MethodInfo>)v) != null && arrayList.size() > 0) {
            bl = true;
        }
        ArrayList arrayList2 = null;
        int n = 0;
        if (uRLPatternData.getSlowURLsList() != null) {
            int n2;
            if (arrayList == null) {
                arrayList = new ArrayList<MethodInfo>();
            }
            arrayList2 = (ArrayList)uRLPatternData.getSlowURLsList().clone();
            n = arrayList2.size();
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList2.get(n2);
                    arrayList.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    BTMLog.logger.error("Exception while iterating slowUrlList {} ", exception);
                    break;
                }
            }
            arrayList2 = null;
            uRLPatternData.cleanSlowURLsList();
            if (bl) {
                Collections.sort(arrayList, new BTMUrlComparator());
                n2 = arrayList.size();
                int n3 = PropsManager.getMaxSlowURLs();
                if (n2 > n3) {
                    for (int i = n2 - 1; i >= n3; --i) {
                        arrayList.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(SLOW_URL_LISTS, arrayList);
        }
        ArrayList<MethodInfo> arrayList3 = null;
        boolean bl2 = false;
        Object v2 = this.pMeasureHT.get(SLOWURL_THREAD_LISTS);
        if (v2 != null && v2 instanceof ArrayList && (arrayList3 = (ArrayList<MethodInfo>)v2) != null && arrayList3.size() > 0) {
            bl2 = true;
        }
        ArrayList arrayList4 = null;
        int n4 = 0;
        if (uRLPatternData.getSlowTHREADsList() != null) {
            int n5;
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<MethodInfo>();
            }
            arrayList4 = (ArrayList)uRLPatternData.getSlowTHREADsList().clone();
            n4 = arrayList4.size();
            for (n5 = 0; n5 < n4; ++n5) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList4.get(n5);
                    arrayList3.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    BTMLog.logger.error("Exception while iterating slowUrlList {} ", exception);
                    break;
                }
            }
            if (bl2) {
                Collections.sort(arrayList3, new BTMUrlComparator());
                n5 = arrayList3.size();
                int n6 = PropsManager.getMaxSlowURLs();
                if (n5 > n6) {
                    for (int i = n5 - 1; i >= n6; --i) {
                        arrayList3.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(SLOWURL_THREAD_LISTS, arrayList3);
        }
        arrayList4 = null;
        uRLPatternData.cleanSlowTHREADsList();
    }

    private void calculateErrorURLDetails(URLPatternData uRLPatternData) {
        ArrayList<MethodInfo> arrayList = null;
        boolean bl = false;
        Object v = this.pMeasureHT.get(ERROR_URL_LISTS);
        if (v != null && v instanceof ArrayList && (arrayList = (ArrayList<MethodInfo>)v) != null && arrayList.size() > 0) {
            bl = true;
        }
        ArrayList arrayList2 = null;
        int n = 0;
        if (uRLPatternData.getErrorURLsList() != null) {
            int n2;
            if (arrayList == null) {
                arrayList = new ArrayList<MethodInfo>();
            }
            arrayList2 = (ArrayList)uRLPatternData.getErrorURLsList().clone();
            n = arrayList2.size();
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList2.get(n2);
                    arrayList.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    BTMLog.logger.error("Exception while iterating errorUrlList {}", exception);
                    break;
                }
            }
            if (bl) {
                Collections.sort(arrayList, new BTMUrlComparator());
                n2 = arrayList.size();
                int n3 = PropsManager.getMaxErrorURLs();
                if (n2 > n3) {
                    for (int i = n2 - 1; i >= n3; --i) {
                        arrayList.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(ERROR_URL_LISTS, arrayList);
            if (arrayList.size() > 0) {
                this.pMeasureHT.put(ERROR_URL_EXISTS, ERROR_URL_EXISTS);
            }
        }
        arrayList2 = null;
        uRLPatternData.cleanErrorURLsList();
        ArrayList<MethodInfo> arrayList3 = null;
        boolean bl2 = false;
        Object v2 = this.pMeasureHT.get(ERRORURL_THREAD_LISTS);
        if (v2 != null && v2 instanceof ArrayList && (arrayList3 = (ArrayList<MethodInfo>)v2) != null && arrayList3.size() > 0) {
            bl2 = true;
        }
        ArrayList arrayList4 = null;
        int n4 = 0;
        if (uRLPatternData.getErrorTHREADsList() != null) {
            int n5;
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<MethodInfo>();
            }
            arrayList4 = (ArrayList)uRLPatternData.getErrorTHREADsList().clone();
            n4 = arrayList4.size();
            for (n5 = 0; n5 < n4; ++n5) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList4.get(n5);
                    arrayList3.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    BTMLog.logger.error("Exception while iterating errorThreadList {} ", exception);
                    break;
                }
            }
            if (bl2) {
                Collections.sort(arrayList3, new BTMUrlComparator());
                n5 = arrayList3.size();
                int n6 = PropsManager.getMaxErrorURLs();
                if (n5 > n6) {
                    for (int i = n5 - 1; i >= n6; --i) {
                        arrayList3.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(ERRORURL_THREAD_LISTS, arrayList3);
        }
        arrayList4 = null;
        uRLPatternData.cleanErrorTHREADsList();
    }

    private void calculateAllURLDetails(URLPatternData uRLPatternData) {
        ArrayList<MethodInfo> arrayList = null;
        boolean bl = false;
        Object v = this.pMeasureHT.get(ALL_URL_LISTS);
        if (v != null && v instanceof ArrayList && (arrayList = (ArrayList<MethodInfo>)v) != null && arrayList.size() > 0) {
            bl = true;
        }
        ArrayList arrayList2 = null;
        int n = 0;
        if (uRLPatternData.getAllURLsList() != null) {
            int n2;
            if (arrayList == null) {
                arrayList = new ArrayList<MethodInfo>();
            }
            arrayList2 = (ArrayList)uRLPatternData.getAllURLsList().clone();
            n = arrayList2.size();
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList2.get(n2);
                    arrayList.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    BTMLog.logger.error("Exception while iterating AllUrlList {}", exception);
                    break;
                }
            }
            if (bl) {
                Collections.sort(arrayList, new BTMUrlComparator());
                n2 = arrayList.size();
                int n3 = PropsManager.getHelathyURLs();
                if (n2 > n3) {
                    for (int i = n2 - 1; i >= n3; --i) {
                        arrayList.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(ALL_URL_LISTS, arrayList);
        }
        arrayList2 = null;
        uRLPatternData.cleanAllURLsList();
        ArrayList<MethodInfo> arrayList3 = null;
        boolean bl2 = false;
        Object v2 = this.pMeasureHT.get(HEALTHYURL_THREAD_LISTS);
        if (v2 != null && v2 instanceof ArrayList && (arrayList3 = (ArrayList<MethodInfo>)v2) != null && arrayList3.size() > 0) {
            bl2 = true;
        }
        ArrayList arrayList4 = null;
        int n4 = 0;
        if (uRLPatternData.getHealthyThreadList() != null) {
            int n5;
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<MethodInfo>();
            }
            arrayList4 = (ArrayList)uRLPatternData.getHealthyThreadList().clone();
            n4 = arrayList4.size();
            for (n5 = 0; n5 < n4; ++n5) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList4.get(n5);
                    arrayList3.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    BTMLog.logger.error("Exception while iterating helathyThreadList {} ", exception);
                    break;
                }
            }
            if (bl2) {
                Collections.sort(arrayList3, new BTMUrlComparator());
                n5 = arrayList3.size();
                int n6 = PropsManager.getHelathyURLs();
                if (n5 > n6) {
                    for (int i = n5 - 1; i >= n6; --i) {
                        arrayList3.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(HEALTHYURL_THREAD_LISTS, arrayList3);
        }
        arrayList4 = null;
        uRLPatternData.cleanHealthyThreadList();
    }

    public String toString() {
        ArrayList arrayList;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("URLPatternMeasure for pattern ").append(this.pName).append("\n");
        stringBuffer.append("'modified' flag is  ").append(this.modified).append("\n");
        ArrayList arrayList2 = (ArrayList)this.pMeasureHT.get(PATTERN_DATA);
        if (arrayList2 != null) {
            stringBuffer.append(arrayList2.toString()).append("\n");
        } else {
            stringBuffer.append("No measures\n");
        }
        ArrayList arrayList3 = (ArrayList)this.pMeasureHT.get(ALL_URL_LISTS);
        int n = 0;
        if (arrayList3 != null) {
            n = arrayList3.size();
            stringBuffer.append("All URL List Size: ").append(n).append(" \n");
        } else {
            stringBuffer.append("No All URLs for this pattern.\n");
        }
        ArrayList arrayList4 = (ArrayList)this.pMeasureHT.get(SLOW_URL_LISTS);
        if (arrayList4 != null) {
            if (arrayList4.size() > 0) {
                stringBuffer.append("Slow URL List: \n");
                for (int i = 0; i < arrayList4.size(); ++i) {
                    ArrayList arrayList5 = (ArrayList)arrayList4.get(i);
                    stringBuffer.append("Slow URL ").append(i).append(" : ").append(arrayList5.toString());
                }
            } else {
                stringBuffer.append("No Slow URLs for this pattern.\n");
            }
        }
        if ((arrayList = (ArrayList)this.pMeasureHT.get(ERROR_URL_LISTS)) != null) {
            if (arrayList.size() > 0) {
                stringBuffer.append("Error URL List: \n");
                for (int i = 0; i < arrayList.size(); ++i) {
                    ArrayList arrayList6 = (ArrayList)arrayList.get(i);
                    stringBuffer.append("Error URL ").append(i).append(" : ").append(arrayList6.toString());
                }
            } else {
                stringBuffer.append("No Error URLs for this pattern.\n");
            }
        }
        stringBuffer.append("*******************************************************************************************");
        return stringBuffer.toString();
    }

    public double getAverageResponseTime() {
        return this.averageResponseTime;
    }

    static void modifyDefaultPatternData() {
        int n = defaultPatternData.size();
        if (n > old_measure_count) {
            for (int i = n - 1; i >= old_measure_count; --i) {
                defaultPatternData.remove(i);
            }
        }
    }

    static void updateDefaultPatternData() {
        int n = defaultPatternData.size();
        int n2 = PropsManager.getSubCompNameLength() * 2 - n;
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                defaultPatternData.add(defaultMeasure);
            }
        }
    }

    static {
        for (int i = 0; i < PropsManager.getSubCompNameLength(); ++i) {
            defaultPatternData.add(defaultMeasure);
            defaultPatternData.add(defaultMeasure);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BTMUrlComparator
    implements Comparator<MethodInfo> {
        BTMUrlComparator() {
        }

        @Override
        public int compare(MethodInfo methodInfo, MethodInfo methodInfo2) {
            Long l = new Long(0L);
            if (methodInfo != null) {
                l = methodInfo.getExecutionTime();
            }
            Long l2 = new Long(0L);
            if (methodInfo2 != null) {
                l2 = methodInfo2.getExecutionTime();
            }
            return l2.compareTo(l);
        }
    }
}

