/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.agent.Utilities;
import com.eg.agent.trace.utils.CustomConfigurationManager;
import com.eg.agent.trace.utils.StatusCodeUtils;
import com.eg.agent.ux.MeasureUtil;
import com.eg.jtm.ACTION;
import com.eg.jtm.BTMDiscovery;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.ContainerDiscovery;
import com.eg.jtm.JVMConfig;
import com.eg.jtm.LogCleanUp;
import com.eg.jtm.LogbackManager;
import com.eg.jtm.PropsManager;
import com.eg.jtm.ThreadPoolManager;
import com.eg.jtm.TimeZoneManager;
import com.eg.jtm.UPDManager;
import com.eg.jtm.Worker;
import com.eg.jvmmonitor.JVMMetricsManager;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.TimerTask;

public class TrackerTask
extends TimerTask {
    private long lastModLogProps = -1L;
    private long lastModOtherProps = -1L;
    private long lastModConfigProps = -1L;
    private long lastModThreshProps = -1L;
    private long lastModCommonProps = -1L;
    private String btmHome = null;
    private boolean isBtmHomeOk;
    private boolean logPropsFileValid = false;
    private boolean otherPropsFileValid = false;
    private boolean configPropsFileValid = false;
    private boolean thershPropsFileValid = false;
    private String currPortStr;
    private String currDesigAgt;
    private static long previousHeartBeatCheckTime = -1L;
    private static long previousLogFileAccessGrantedTime = -1L;
    private static long previousLogFileDeleteTime = -1L;
    private static long previousLogFileUpdatedTime = -1L;
    private static long waitTime = 21600000L;
    private static long sixtyMinCounter = 0L;
    private static boolean isFirstTime = true;
    private static final String MODIFICATION_DETECTED = "Modification detected for file ";
    private long lastModExcludeProps = -1L;
    private long lastModifiedCPCProps = -1L;

    public TrackerTask() {
        try {
            if (PropsManager.otherPropsFile == null || PropsManager.logPropsFile == null) {
                this.btmHome = PropsManager.EG_BTM_HOME = System.getProperty("EG_BTM_HOME");
                PropsManager.setPropFileNames();
            }
            this.logPropsFileValid = PropsManager.isPropsFileValid(PropsManager.logPropsFile);
            this.otherPropsFileValid = PropsManager.isPropsFileValid(PropsManager.otherPropsFile);
            this.configPropsFileValid = PropsManager.isPropsFileValid(PropsManager.configPropsFile);
            this.thershPropsFileValid = PropsManager.isPropsFileValid(PropsManager.thresholdPropsFile);
            if (this.otherPropsFileValid) {
                PropsManager.initProps();
                PropsManager.loadPropsFromFile(true);
                if (Utilities.getExcludeClassSize() <= 0 || Utilities.getExcludePojoSize() <= 0) {
                    Utilities.prepareExcludeList();
                }
            }
            this.btmHome = PropsManager.EG_BTM_HOME;
            this.isBtmHomeOk = this.btmHome != null && this.btmHome.length() > 0;
        }
        catch (Exception exception) {
            System.out.println(" Exception Occured in  TrackerTask Contructor.....");
            exception.printStackTrace();
            this.isBtmHomeOk = false;
        }
        ++sixtyMinCounter;
    }

    public void run() {
        long l = System.currentTimeMillis();
        this.trackLogProps();
        this.trackOtherProps();
        this.trackJVMThread();
        TimeZoneManager.updateTimeZoneDetails();
        StatusCodeUtils.send404MethodInfo();
        if (!PropsManager.isOldModel()) {
            this.trackConfigProps();
            if (BTMOffLoadConfig.isDataCollectionMode()) {
                this.trackThreshProps();
                this.doHeartBeatCheck(l);
            }
        }
        this.trackCPCProps();
        this.trackExcludeProps();
        this.trackCommonProps();
        if (sixtyMinCounter % 60L == 0L) {
            this.trackBtmLogFolderPermission(l);
            this.trackBtmLogDeletion(l);
            this.trackLogPaths(l);
            sixtyMinCounter = 0L;
        }
        ++sixtyMinCounter;
    }

    private void trackLogPaths(long l) {
        try {
            if (!BTMOffLoadConfig.isDataCollectionMode()) {
                return;
            }
            boolean bl = false;
            if (previousLogFileUpdatedTime > -1L) {
                long l2 = l - previousLogFileUpdatedTime;
                if (l2 >= waitTime) {
                    bl = true;
                    previousLogFileUpdatedTime = l;
                }
            } else {
                bl = true;
                previousLogFileUpdatedTime = l;
            }
            BTMLog.logger.trace("[eG BTM Log File Update] previousLogFileUpdatedTime: {} ms & Waittime: {} ms & Update modfied time : {} ", previousLogFileUpdatedTime, waitTime, bl);
            if (bl) {
                ThreadPoolManager threadPoolManager = ThreadPoolManager.getThreadPoolManager();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("LogPath").append("!;-;!").append(PropsManager.getJvmGUID()).append("!;-;!").append((Object)LogCleanUp.getCleanUpCode()).append("!;-;!").append(BTMOffLoadConfig.getAbsoluteBTMLogFilePath());
                threadPoolManager.submitTask(stringBuilder.toString());
                BTMLog.logger.info("[LogPath] message [{}] added into the queue & current queue size {} ", (Object)stringBuilder, (Object)threadPoolManager.getQueueSize());
                LogCleanUp.setLastModifiedTimeToLogFile();
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn(" Unable to track BTM log file path and send status ", exception);
        }
    }

    private void trackBtmLogDeletion(long l) {
        try {
            if (!BTMOffLoadConfig.isLogFileCleanUpEnabled()) {
                return;
            }
            boolean bl = false;
            if (previousLogFileDeleteTime > -1L) {
                long l2 = l - previousLogFileDeleteTime;
                if (l2 >= waitTime) {
                    bl = true;
                    previousLogFileDeleteTime = l;
                }
            } else {
                bl = true;
                previousLogFileDeleteTime = l;
            }
            BTMLog.logger.trace("[eG BTM Log Folder Clean-up] previousLogFileDeleteTime: {} ms & fileFileDeleteWaitTime: {} ms & delete logs: {} ", previousLogFileDeleteTime, waitTime, bl);
            if (bl) {
                LogCleanUp.initLogDeletion();
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn(" Unable to track BTM log file deletion process ", exception);
        }
    }

    private void trackBtmLogFolderPermission(long l) {
        try {
            if (!BTMOffLoadConfig.isLogFileGrantAccessEnabled()) {
                return;
            }
            if (!ContainerDiscovery.isLinux) {
                return;
            }
            boolean bl = false;
            if (previousLogFileAccessGrantedTime > -1L) {
                long l2 = l - previousLogFileAccessGrantedTime;
                if (l2 >= waitTime) {
                    bl = true;
                    previousLogFileAccessGrantedTime = l;
                }
            } else {
                bl = true;
                previousLogFileAccessGrantedTime = l;
            }
            BTMLog.logger.trace("[BTM Log File Access ] previousLogFileAccessGrantedTime: {} ms & fileAccessWaitTime: {} ms & grantAccess: {} ", previousLogFileAccessGrantedTime, waitTime, bl);
            if (bl) {
                ContainerDiscovery.discoverContainerInformation(ACTION.GRANT_BTM_LOGS_FILE_ACCESS, 5);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.info(" Unable to track BTM log file permission granting process ", exception);
        }
    }

    private void trackCPCProps() {
        if (CustomConfigurationManager.isValid()) {
            long l = CustomConfigurationManager.getLastModifiedTime();
            if (this.lastModifiedCPCProps == -1L) {
                this.lastModifiedCPCProps = l;
                return;
            }
            if (this.lastModifiedCPCProps != l) {
                BTMLog.logger.info("Modification detected for file custom.props");
                Properties properties = CustomConfigurationManager.readCPCProps();
                CustomConfigurationManager.getCustomConfiguredPatternMap(properties);
                this.lastModifiedCPCProps = l;
            }
        }
    }

    private void trackCommonProps() {
        block6: {
            if (PropsManager.isCommonGuidPropsFileAvailable()) {
                try {
                    long l = PropsManager.getCommonLastModified();
                    if (this.lastModCommonProps != l) {
                        BTMLog.logger.info(MODIFICATION_DETECTED + PropsManager.getCommonFileName());
                        PropsManager.processIcMeasuresFromGuidPropsFile();
                        Properties properties = CustomConfigurationManager.readCPCProps();
                        CustomConfigurationManager.getCustomConfiguredPatternMap(properties);
                        this.lastModCommonProps = l;
                    }
                    break block6;
                }
                catch (Exception exception) {
                    if (BTMLog.logger != null) {
                        BTMLog.logger.warn("Exception occured while tracking CommonProps {}", exception);
                    }
                    break block6;
                }
            }
            if (sixtyMinCounter % 5L == 0L) {
                PropsManager.discoverCommonPropsFileLocation();
            }
        }
    }

    private void doHeartBeatCheck(long l) {
        long l2 = l - previousHeartBeatCheckTime;
        BTMLog.logger.trace("[HB-Check] Time since recent heartbeat {} ms & measurement period {} ms & Current HeartBeat Intervel Time {} ms, tracker counter : {} ", l2, PropsManager.getEgMeasPeriod(), BTMOffLoadConfig.getHearBeatIntervalTime(), sixtyMinCounter);
        if (isFirstTime || l2 >= BTMOffLoadConfig.getHearBeatIntervalTime()) {
            StringBuilder stringBuilder;
            ThreadPoolManager threadPoolManager = ThreadPoolManager.getThreadPoolManager();
            if (isFirstTime || PropsManager.requestConfigFromAgent()) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("HeartBeatCheck").append("!;-;!").append(PropsManager.getJvmGUID()).append("!;-;!").append("eGTest_Config_Request");
                threadPoolManager.submitTask(stringBuilder.toString());
                BTMLog.logger.info("[HB-Check&Config-Request] message [{}] added into the queue & current queue size {} ", (Object)stringBuilder, (Object)threadPoolManager.getQueueSize());
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("HeartBeatCheck").append("!;-;!").append(PropsManager.getJvmGUID());
            threadPoolManager.submitTask(stringBuilder.toString());
            BTMLog.logger.info("[HB-Check] message [{}] added into the queue & current queue size {} ", (Object)stringBuilder, (Object)threadPoolManager.getQueueSize());
            previousHeartBeatCheckTime = l;
            isFirstTime = false;
            BTMDiscovery.setOKtoSendTimeZone();
        } else if (l2 >= PropsManager.getEgMeasPeriod()) {
            BTMDiscovery.setOKtoSendTimeZone();
        }
    }

    private void trackConfigProps() {
        if (this.configPropsFileValid && this.isBtmHomeOk) {
            block4: {
                try {
                    long l = PropsManager.configPropsFile.lastModified();
                    if (this.lastModConfigProps != l) {
                        BTMLog.logger.info("Modification detected for file config.props");
                        PropsManager.getConfigFromPropsFile();
                        this.lastModConfigProps = l;
                    }
                }
                catch (Exception exception) {
                    if (BTMLog.logger == null) break block4;
                    BTMLog.logger.warn("Exception occured while tracking configProps {}", exception);
                }
            }
            this.trackOffloadAgentPortDiscovery();
        }
    }

    private void trackOffloadAgentPortDiscovery() {
        try {
            boolean bl = Boolean.parseBoolean(PropsManager.getProperty("AGENT_PORT_DISCOVERY"));
            BTMLog.logger.debug(" Offload agent port discovery : {} & Is BTM worker able to send data to eG Agent : {} ", (Object)bl, (Object)BTMOffLoadConfig.isOKToSendOffloadData());
            if (bl && !BTMOffLoadConfig.isOKToSendOffloadData()) {
                BTMOffLoadConfig.resetThisOffloadAgent();
                Worker.offLoadAgentCheck("TrackerTask");
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception occured while tracking offload agent port {}", exception);
        }
    }

    private void trackJVMThread() {
        if (!JVMConfig.isJvmCollectorThreadRunning()) {
            boolean bl = JVMConfig.isJarModeEnabled();
            if (!PropsManager.isOldModel() && BTMOffLoadConfig.isOKToSendOffloadData() && bl) {
                new JVMMetricsManager(PropsManager.getJvmGUID());
            }
        }
    }

    private void trackThreshProps() {
        block4: {
            if (this.thershPropsFileValid && this.isBtmHomeOk) {
                try {
                    long l = PropsManager.thresholdPropsFile.lastModified();
                    if (this.lastModThreshProps != l) {
                        BTMLog.logger.info("Modification detected for file threshold.props");
                        PropsManager.getThreshFromPropsFile();
                        this.lastModThreshProps = l;
                    }
                }
                catch (Exception exception) {
                    if (BTMLog.logger == null) break block4;
                    BTMLog.logger.warn("Exception occured while tracking threshProps {}", exception);
                }
            }
        }
    }

    private void trackOtherProps() {
        try {
            long l;
            if (this.otherPropsFileValid && this.isBtmHomeOk && this.lastModOtherProps != (l = PropsManager.otherPropsFile.lastModified())) {
                PropsManager.loadPropsFromFile(false);
                PropsManager.updateOtherBTMProps();
                this.checkAndSetConnProps(PropsManager.getDesignatedAgentString(), PropsManager.getBTMPortString());
                this.lastModOtherProps = l;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception Occured in trackOtherProps ....");
            exception.printStackTrace();
        }
    }

    private void trackExcludeProps() {
        long l = PropsManager.getExcludeLastModified();
        if (this.lastModExcludeProps == -1L) {
            this.lastModExcludeProps = l;
            return;
        }
        if (this.lastModExcludeProps != l) {
            BTMLog.logger.info(MODIFICATION_DETECTED + PropsManager.getExcludeFileName());
            Properties properties = new Properties();
            try {
                properties.load(new BufferedInputStream(new FileInputStream(PropsManager.getExcludeFileName())));
                MeasureUtil.addMeasures(properties);
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception during reading properties from {} {}", (Object)PropsManager.getExcludeFileName(), (Object)exception);
            }
            this.lastModLogProps = l;
        }
    }

    private void trackLogProps() {
        if (!this.logPropsFileValid || BTMLog.isNone) {
            return;
        }
        long l = PropsManager.logPropsFile.lastModified();
        if (this.lastModLogProps == -1L) {
            this.lastModLogProps = l;
            return;
        }
        if (this.lastModLogProps != l) {
            BTMLog.logger.info(MODIFICATION_DETECTED + PropsManager.logPropsFileName);
            this.modifyLogProperties();
            this.lastModLogProps = l;
        }
    }

    private void modifyLogProperties() {
        Properties properties = new Properties();
        try {
            properties.load(new BufferedInputStream(new FileInputStream(PropsManager.logPropsFileName)));
            LogbackManager.updateLogProps(properties);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        properties = null;
    }

    private void checkAndSetConnProps(String string, String string2) {
        String string3;
        if (!PropsManager.isOldModel()) {
            return;
        }
        if (string != null && string.length() > 0) {
            if (this.currDesigAgt == null || !this.currDesigAgt.equals(string)) {
                string3 = this.chkDesigAgtValidity(string);
                if (string3 == null) {
                    UPDManager.setDesigAgtInetAddr(string);
                    this.currDesigAgt = string;
                } else {
                    BTMLog.logger.warn("New Designated Agent in btm connection properties file seems to be invalid : {}  . Please rectify. ", (Object)string3);
                }
            }
        } else {
            this.currDesigAgt = null;
            UPDManager.resetDesigAgtInetAddr();
        }
        if (string2 != null) {
            if (this.currPortStr == null || !this.currPortStr.equals(string2)) {
                string3 = BTMUtils.checkPortAvailability(string2);
                if (string3 == null) {
                    UPDManager.setBTMPort(string2);
                    this.currPortStr = string2;
                } else {
                    BTMLog.logger.warn("New port in btm connection properties file is invalid/unavailable : {} . Please rectify.", (Object)string3);
                }
            }
        } else {
            BTMLog.logger.warn("Please provide the BTM Port value in the BTM connection properties file.");
        }
    }

    private String chkDesigAgtValidity(String string) {
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return "Designated Agent cannot be resolved.";
        }
        catch (Exception exception) {
            BTMLog.logger.error("[chkDesigAgtValidity] - DesigAgtToChk : {} {}", (Object)string, (Object)exception);
            return "Cannot determine validity of designated agent." + exception.toString();
        }
        return null;
    }
}

