/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.ch.qos.logback.classic.Level;
import com.eg.jtm.BTMLog;
import com.eg.jtm.LogbackFileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class LogbackManager {
    private static final String defaultBtmLogFileName = "BTMLog.log";
    private static final Level defaultBtmLogLevel = Level.OFF;
    private static final int defaultBtmLogFileMaxCount = 5;
    private static final int defaultBtmLogFileLimit = 2;
    private static final int defaultQueueSize = 500;
    private static final int defaultDiscardThresholdLimit = 0;
    private static final String LOG_LEVEL = "LOG_LEVEL";
    private static final String LOG_FILE_COUNT = "LOG_FILE_COUNT";
    private static final String LOG_FILE_SIZE = "LOG_FILE_SIZE";
    private static final String LOG_FILE_NAME = "LOG_FILE_NAME";
    private static final String QUEUE_SIZE = "QUEUE_SIZE";
    private static final String DISCARDING_THRESHOLD = "DISCARDING_THRESHOLD";
    private static final Level defaultBtmDebugLogLevel = Level.OFF;
    private static final int defaultBtmDebugLogFileMaxCount = 5;
    private static final int defaultBtmDebugLogFileLimit = 2;
    private static final String DEBUG_LOG_LEVEL = "DEBUG_LOG_LEVEL";
    private static final String DEBUG_LOG_FILE_COUNT = "DEBUG_LOG_FILE_COUNT";
    private static final String DEBUG_LOG_FILE_SIZE = "DEBUG_LOG_FILE_SIZE";
    private static boolean isModified = false;

    public static void initLogProperties(String string) {
        String string2 = System.getProperty("EG_LOG_HOME");
        if (string2 != null && string2.length() > 0) {
            if (string2.equalsIgnoreCase("none")) {
                BTMLog.isNone = true;
                System.out.println("EG_LOG_HOMEis None. Applying default logging properties");
                LogbackManager.setDefaultLogging();
            } else {
                String string3 = "";
                try {
                    string3 = string + File.separatorChar + "btmLogging.props";
                    File file = new File(string3);
                    Properties properties = new Properties();
                    properties.load(new BufferedInputStream(new FileInputStream(file)));
                    String string4 = properties.getProperty(LOG_LEVEL);
                    String string5 = properties.getProperty(LOG_FILE_COUNT);
                    String string6 = properties.getProperty(LOG_FILE_SIZE);
                    String string7 = properties.getProperty(LOG_FILE_NAME);
                    String string8 = properties.getProperty(QUEUE_SIZE);
                    int n = 500;
                    if (string8 != null && string8.length() > 0) {
                        n = Integer.parseInt(string8);
                    }
                    String string9 = properties.getProperty(DISCARDING_THRESHOLD);
                    int n2 = 0;
                    if (string9 != null && string9.length() > 0) {
                        n2 = Integer.parseInt(string9);
                    }
                    LogbackManager.setLogLevel(string4);
                    LogbackManager.setLogFileCount(string5);
                    LogbackManager.setLogFileSize(string6);
                    LogbackManager.setLogFileName(string7);
                    LogbackManager.setQueueSize(n);
                    LogbackManager.setDiscardThreshold(n2);
                    String string10 = properties.getProperty(DEBUG_LOG_LEVEL);
                    String string11 = properties.getProperty(DEBUG_LOG_FILE_COUNT);
                    String string12 = properties.getProperty(DEBUG_LOG_FILE_SIZE);
                    LogbackManager.setDebugLogLevel(string10);
                    LogbackManager.setDebugLogFileCount(string11);
                    LogbackManager.setDebugLogFileSize(string12);
                }
                catch (Exception exception) {
                    System.out.println("Exception Occured while Reading logging properties from " + string3);
                    System.out.println("eG BTM proceeds with default logging properties ");
                    LogbackManager.setDefaultLogging();
                }
                LogbackFileUtils.reset();
                LogbackFileUtils.start(string2);
            }
        }
    }

    private static void updateDebugLogLevel(String string) {
        Level level;
        Level level2 = LogbackManager.getLevelFromProps(string);
        if (level2 != null && !level2.equals(level = LogbackFileUtils.getBtmDebugLogLevel())) {
            LogbackFileUtils.setBTMDebugLogbackLevel(level2);
        }
    }

    private static void updateLogLevel(String string) {
        Level level;
        Level level2 = LogbackManager.getLevelFromProps(string);
        if (level2 != null && !level2.equals(level = LogbackFileUtils.getBtmLogLevel())) {
            LogbackFileUtils.setBTMLogbackLevel(level2);
        }
    }

    private static void updateDebugLogFileSize(String string) {
        try {
            int n = Integer.parseInt(string);
            int n2 = LogbackFileUtils.getBtmDebugLogFileLimit();
            if (n > 0 && n != n2) {
                isModified = true;
                LogbackFileUtils.setBtmDebugLogFileLimit(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void updateLogFileSize(String string) {
        try {
            int n = Integer.parseInt(string);
            int n2 = LogbackFileUtils.getBtmLogFileLimit();
            if (n > 0 && n != n2) {
                isModified = true;
                LogbackFileUtils.setBtmLogFileLimit(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void updateDebugLogFileCount(String string) {
        try {
            int n = Integer.parseInt(string);
            int n2 = LogbackFileUtils.getBtmDebugLogFileMaxCount();
            if (n > 0 && n != n2) {
                isModified = true;
                LogbackFileUtils.setBtmDebugLogFileMaxCount(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void updateLogFileCount(String string) {
        try {
            int n = Integer.parseInt(string);
            int n2 = LogbackFileUtils.getBtmLogFileMaxCount();
            if (n > 0 && n != n2) {
                isModified = true;
                LogbackFileUtils.setBtmLogFileMaxCount(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void updateLogFileName(String string) {
        try {
            String string2 = LogbackFileUtils.getBtmLogFileName();
            if (!string.equalsIgnoreCase(string2)) {
                LogbackFileUtils.setBtmLogFileName(string);
                isModified = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void updateQSize(String string) {
        int n;
        int n2 = 500;
        n2 = Integer.parseInt(string);
        if (n2 != (n = LogbackFileUtils.getQsize()) && n2 > 0) {
            isModified = true;
            LogbackManager.setQueueSize(n2);
        }
    }

    private static void updateThreshold(String string) {
        int n;
        int n2 = 0;
        if (string != null && string.length() > 0) {
            n2 = Integer.parseInt(string);
        }
        if ((n = LogbackFileUtils.getThreshold()) != n2 && n2 >= 0) {
            isModified = true;
            LogbackManager.setDiscardThreshold(n2);
        }
    }

    public static void updateLogProps(Properties properties) {
        String string = properties.getProperty(LOG_LEVEL);
        String string2 = properties.getProperty(LOG_FILE_COUNT);
        String string3 = properties.getProperty(LOG_FILE_SIZE);
        String string4 = properties.getProperty(LOG_FILE_NAME);
        String string5 = properties.getProperty(QUEUE_SIZE);
        String string6 = properties.getProperty(DISCARDING_THRESHOLD);
        String string7 = properties.getProperty(DEBUG_LOG_LEVEL);
        String string8 = properties.getProperty(DEBUG_LOG_FILE_COUNT);
        String string9 = properties.getProperty(DEBUG_LOG_FILE_SIZE);
        if (string != null && string.length() > 0) {
            LogbackManager.updateLogLevel(string);
        }
        if (string2 != null && string2.length() > 0) {
            LogbackManager.updateLogFileCount(string2);
        }
        if (string3 != null && string3.length() > 0) {
            LogbackManager.updateLogFileSize(string3);
        }
        if (string4 != null && string4.length() > 0) {
            LogbackManager.updateLogFileName(string4);
        }
        if (string5 != null && string5.length() > 0) {
            LogbackManager.updateQSize(string5);
        }
        if (string6 != null && string6.length() > 0) {
            LogbackManager.updateThreshold(string6);
        }
        if (string7 != null && string7.length() > 0) {
            LogbackManager.updateDebugLogLevel(string7);
        }
        if (string8 != null && string8.length() > 0) {
            LogbackManager.updateDebugLogFileCount(string8);
        }
        if (string9 != null && string9.length() > 0) {
            LogbackManager.updateDebugLogFileSize(string9);
        }
        if (isModified) {
            LogbackFileUtils.reInitializeBTMLogger();
            LogbackFileUtils.reInitializeBTMDebugLogger();
            isModified = false;
        }
    }

    private static Level getLevelFromProps(String string) {
        Level level = null;
        String string2 = string.toLowerCase();
        if (string2.equals("all")) {
            level = Level.ALL;
        } else if (string2.equals("off")) {
            level = Level.OFF;
        } else if (string2.equals("info")) {
            level = Level.INFO;
        } else if (string2.equals("warn")) {
            level = Level.WARN;
        } else if (string2.equals("debug")) {
            level = Level.DEBUG;
        } else if (string2.equals("trace")) {
            level = Level.TRACE;
        } else if (string2.equals("error")) {
            level = Level.ERROR;
        }
        return level;
    }

    private static void setDefaultLogging() {
        LogbackFileUtils.setBtmLogFileName(defaultBtmLogFileName);
        LogbackFileUtils.setBtmLogFileLimit(2);
        LogbackFileUtils.setBtmLogLevel(defaultBtmLogLevel);
        LogbackFileUtils.setBtmLogFileMaxCount(5);
        LogbackFileUtils.setBtmDebugLogFileLimit(2);
        LogbackFileUtils.setBtmDebugLogFileMaxCount(5);
        LogbackFileUtils.setBtmDebugLogLevel(defaultBtmDebugLogLevel);
        LogbackManager.setQueueSize(500);
        LogbackManager.setDiscardThreshold(0);
    }

    private static void setLogFileName(String string) {
        if (string != null && string.length() > 0) {
            LogbackFileUtils.setBtmLogFileName(string);
        } else {
            LogbackFileUtils.setBtmLogFileName(LogbackManager.getDefaultBtmLogFileName());
        }
    }

    private static int getFileSize(String string) {
        int n = 0;
        if (string != null && string.length() > 0) {
            try {
                n = Integer.parseInt(string);
                if (n <= 0) {
                    n = 0;
                }
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        return n;
    }

    private static void setLogFileSize(String string) {
        int n = LogbackManager.getFileSize(string);
        if (n <= 0) {
            n = LogbackManager.getDefaultBtmLogFileLimit();
        }
        LogbackFileUtils.setBtmLogFileLimit(n);
    }

    private static void setDebugLogFileSize(String string) {
        int n = LogbackManager.getFileSize(string);
        if (n <= 0) {
            n = 2;
        }
        LogbackFileUtils.setBtmDebugLogFileLimit(n);
    }

    private static int getMaxFileCount(String string) {
        int n = 0;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
                if (n <= 0) {
                    n = 0;
                }
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        return n;
    }

    private static void setLogFileCount(String string) {
        int n = LogbackManager.getMaxFileCount(string);
        if (n <= 0) {
            n = LogbackManager.getDefaultBtmLogFileMaxCount();
        }
        LogbackFileUtils.setBtmLogFileMaxCount(n);
    }

    private static void setDebugLogFileCount(String string) {
        int n = LogbackManager.getMaxFileCount(string);
        if (n <= 0) {
            n = 5;
        }
        LogbackFileUtils.setBtmDebugLogFileMaxCount(n);
    }

    private static Level getLevelValue(String string) {
        Level level = Level.OFF;
        if (string != null && string.length() > 0) {
            String string2 = string.toLowerCase();
            if (string2.equals("all")) {
                level = Level.ALL;
            } else if (string2.equals("off")) {
                level = Level.OFF;
            } else if (string2.equals("info")) {
                level = Level.INFO;
            } else if (string2.equals("warn")) {
                level = Level.WARN;
            } else if (string2.equals("debug")) {
                level = Level.DEBUG;
            } else if (string2.equals("trace")) {
                level = Level.TRACE;
            } else if (string2.equals("error")) {
                level = Level.ERROR;
            }
        }
        return level;
    }

    private static void setDebugLogLevel(String string) {
        Level level = LogbackManager.getLevelValue(string);
        LogbackFileUtils.setBtmDebugLogLevel(level);
    }

    private static void setLogLevel(String string) {
        Level level = LogbackManager.getLevelValue(string);
        LogbackFileUtils.setBtmLogLevel(level);
    }

    private static void setQueueSize(int n) {
        if (n > 0) {
            LogbackFileUtils.setAsyncQueueSize(n);
        } else {
            LogbackFileUtils.setAsyncQueueSize(500);
        }
    }

    private static void setDiscardThreshold(int n) {
        if (n >= 0) {
            LogbackFileUtils.setDiscardThreshold(n);
        } else {
            LogbackFileUtils.setDiscardThreshold(0);
        }
    }

    private static String getDefaultBtmLogFileName() {
        return defaultBtmLogFileName;
    }

    private static Level getDefaultBtmLogLevel() {
        return defaultBtmLogLevel;
    }

    private static int getDefaultBtmLogFileMaxCount() {
        return 5;
    }

    private static int getDefaultBtmLogFileLimit() {
        return 2;
    }
}

