/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.agent.RetransformThread;
import com.eg.jtm.BTMDiscovery;
import com.eg.jtm.BTMLog;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class EgCustomPointCutManager {
    private final Hashtable<String, String> customPCMappingTable = new Hashtable();
    private final Hashtable<String, String> customPCDescTable = new Hashtable();
    private final Hashtable<String, ArrayList<String>> customPCClassMethodTable = new Hashtable();
    private final Properties currentProperties = new Properties();
    private final Properties previousProperties = new Properties();
    private static final EgCustomPointCutManager customPointcutInstance = new EgCustomPointCutManager();

    private EgCustomPointCutManager() {
    }

    public static EgCustomPointCutManager getInstance() {
        return customPointcutInstance;
    }

    public void assembleCustomPointcutData(Properties properties) {
        Object object;
        Object object2;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (object2 != null && !((String)object2).startsWith("POINTCUT")) continue;
            object = properties.getProperty((String)object2);
            this.currentProperties.put(object2, object);
        }
        if (this.currentProperties.isEmpty()) {
            return;
        }
        object2 = new Properties();
        object = this.currentProperties.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            String string2 = this.currentProperties.getProperty(string);
            if (this.previousProperties.containsKey(string)) {
                String string3 = this.previousProperties.getProperty(string);
                if (string3.equals(string2)) continue;
                ((Properties)object2).put(string, string2);
                continue;
            }
            ((Properties)object2).put(string, string2);
        }
        this.previousProperties.clear();
        this.previousProperties.putAll((Map<?, ?>)this.currentProperties);
        this.currentProperties.clear();
        if (((Properties)object2).size() > 0) {
            this.updateCustomPointcutData((Properties)object2);
        }
    }

    private void updateCustomPointcutData(Properties properties) {
        Object object;
        Enumeration<Object> enumeration = properties.keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            try {
                String string;
                int n = ((String)object).lastIndexOf("_");
                if (n <= 0) continue;
                String string2 = ((String)object).substring(n + 1);
                String string3 = properties.getProperty((String)object);
                String string4 = null;
                if (string3 == null || string3.length() <= 0) continue;
                string2 = "Custom_" + string2;
                int n2 = string3.indexOf("#");
                if (n2 > 0) {
                    string4 = string3.substring(0, n2);
                    if (string4 != null && string4.length() > 0) {
                        this.customPCMappingTable.put(string2, string4);
                    }
                    string3 = string3.substring(n2 + 1);
                }
                if (string3.length() <= 0 || arrayList.contains(string = this.updateDetails(string3, string2))) continue;
                arrayList.add(string);
            }
            catch (Exception exception) {
                BTMLog.logger.error("Exception while iterating custom pointcut- {} {}", object, (Object)exception);
            }
        }
        if (arrayList.size() > 0) {
            object = new RetransformThread(arrayList);
        }
        this.printDetails();
        BTMDiscovery.getDataBaseHT().put("CustomPC", this.customPCMappingTable);
    }

    private String updateDetails(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            ArrayList<Object> arrayList;
            StringTokenizer stringTokenizer2;
            int n;
            String string4 = stringTokenizer.nextToken();
            if (string4 == null || string4.length() <= 0 || (n = (stringTokenizer2 = new StringTokenizer(string4, ":")).countTokens()) != 3) continue;
            string3 = stringTokenizer2.nextToken();
            String string5 = stringTokenizer2.nextToken();
            if (this.customPCClassMethodTable.containsKey(string3)) {
                arrayList = this.customPCClassMethodTable.get(string3);
                if (!arrayList.contains(string5)) {
                    arrayList.add(string5);
                    this.customPCClassMethodTable.put(string3, arrayList);
                }
            } else {
                arrayList = new ArrayList<String>();
                arrayList.add(string5);
                this.customPCClassMethodTable.put(string3, arrayList);
            }
            this.customPCDescTable.put(string4, string2);
        }
        return string3;
    }

    private void printDetails() {
        if (BTMLog.logger.isInfoEnabled()) {
            Object object;
            Set<String> set;
            BTMLog.logger.info("********** Custom PointCut Details *****************");
            if (this.customPCClassMethodTable != null && this.customPCClassMethodTable.size() > 0) {
                set = this.customPCClassMethodTable.keySet();
                for (String string : set) {
                    object = this.customPCClassMethodTable.get(string);
                    BTMLog.logger.info("{} == {}", (Object)string, object);
                }
            }
            if (this.customPCDescTable != null && this.customPCDescTable.size() > 0) {
                set = this.customPCDescTable.keySet();
                for (String string : set) {
                    object = this.customPCDescTable.get(string);
                    BTMLog.logger.info("{} == {}", (Object)string, object);
                }
            }
            if (this.customPCMappingTable != null && this.customPCMappingTable.size() > 0) {
                set = this.customPCMappingTable.keySet();
                for (String string : set) {
                    object = this.customPCMappingTable.get(string);
                    BTMLog.logger.info("{} == {}", (Object)string, object);
                }
            }
        }
    }

    public boolean isCustomPointCutClass(String string) {
        return this.customPCClassMethodTable.containsKey(string);
    }

    public ArrayList getCustomPointCutMethodList(String string) {
        return this.customPCClassMethodTable.get(string);
    }

    public String getCustomPointCutDisplayName(String string) {
        return this.customPCMappingTable.get(string);
    }

    public Hashtable getCustomPCMappingTable() {
        return this.customPCMappingTable;
    }

    public String getPointCutName(String string, String string2, String string3) {
        String string4 = new StringBuffer(string).append(":").append(string2).append(":").append(string3).toString();
        String string5 = this.customPCDescTable.get(string4);
        if (string5 != null) {
            return string5;
        }
        return "POJO";
    }
}

