/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.BTMSocket;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public final class DataWriterProvider {
    private BTMSocket clientSocket = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BTMSocket establishConnection(boolean bl, int n) {
        String string = "[" + Thread.currentThread().getName() + "]";
        String string2 = BTMOffLoadConfig.getCollectorAgentIP();
        int n2 = BTMOffLoadConfig.getSocketConnectionTimeOut();
        this.clientSocket = new BTMSocket();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string2);
            this.clientSocket.bind(null);
            this.clientSocket.setKeepAlive(true);
            this.clientSocket.setTcpNoDelay(true);
            this.clientSocket.setSoTimeout(1000);
            BTMLog.logger.debug("{}  Trying to connect to {}  at port : {}", string, inetAddress, n);
            this.clientSocket.connect(new InetSocketAddress(inetAddress, n), n2);
            BTMLog.logger.debug("{}  Connected to {}  at port : {}", string, inetAddress, n);
            this.clientSocket.setConnectionSuccess(true);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            BTMLog.logger.warn("{} Could not establish connection with eG Agent @{} {}:{} due to {} ", string, string2, inetAddress, n, socketTimeoutException.getMessage());
            this.clientSocket.setConnectionSuccess(false);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} Could not establish connection with eG Agent @{} {}:{} due to {}", string, string2, inetAddress, n, exception.getMessage());
            this.clientSocket.setConnectionSuccess(false);
        }
        finally {
            if (!this.clientSocket.isConnectionSuccess()) {
                this.closeClientSocket();
            }
        }
        BTMLog.logger.warn("INFO:- {} Successfully established connection with eG Agent @{} {}:{} ? {} ", string, string2, inetAddress, n, this.clientSocket.isConnectionSuccess());
        return this.clientSocket;
    }

    public ObjectOutputStream getOOStreamForOffloadAgentCheck(Socket socket, String string, int n) {
        if (socket == null) {
            return null;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
        }
        catch (SocketException socketException) {
            String string2 = socketException.getMessage();
            if (string2.equals("Socket is closed")) {
                BTMLog.logger.warn("{} java.net.SocketException due to {}. Please check the port {} is listening or not ", string, socketException.getMessage(), n);
            } else {
                BTMLog.logger.warn("{} java.net.SocketException due to {}", (Object)string, (Object)socketException);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn(" Exception due to {} : {} ", (Object)string, (Object)exception);
        }
        return objectOutputStream;
    }

    public ObjectInputStream getObjInputStream(BTMSocket bTMSocket, boolean bl, String string) {
        ObjectInputStream objectInputStream;
        block5: {
            if (bTMSocket == null) {
                return null;
            }
            objectInputStream = null;
            try {
                objectInputStream = new ObjectInputStream(bTMSocket.getInputStream());
            }
            catch (SocketTimeoutException socketTimeoutException) {
                BTMLog.logger.error("{} java.net.SocketTimeoutException due to {}, eG Agent may be closing the connection", (Object)string, (Object)socketTimeoutException.getMessage());
                if (bl) {
                    bTMSocket.setConnectionSuccess(false);
                }
            }
            catch (Exception exception) {
                BTMLog.logger.error("{} Exception while creating ObjectInputStream due to {} ", (Object)string, (Object)exception);
                if (!bl) break block5;
                bTMSocket.setConnectionSuccess(false);
            }
        }
        return objectInputStream;
    }

    public ObjectOutputStream getObjOutputStream(BTMSocket bTMSocket, String string) {
        if (bTMSocket == null) {
            return null;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            if (BTMOffLoadConfig.isCollectorDetailsFound()) {
                objectOutputStream = new ObjectOutputStream(bTMSocket.getOutputStream());
                BTMOffLoadConfig.checkStatus(true);
            } else {
                BTMOffLoadConfig.checkStatus(false);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} Not able to get ObjectOutputStream Object {} ", (Object)string, (Object)exception);
            BTMOffLoadConfig.checkStatus(false);
        }
        return objectOutputStream;
    }

    private void closeClientSocket() {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void closeObjectOutputStream(ObjectOutputStream objectOutputStream, String string) {
        try {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("{} Unable to close ObjectOutputStream due to {} ", (Object)string, (Object)exception);
        }
        this.closeClientSocket();
    }
}

