/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.ACTION;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.ContainerDiscoveryHelperThread;
import com.eg.jtm.DiscoveryDetails;
import com.eg.jtm.LogCleanUp;
import com.eg.jtm.PropsManager;
import com.eg.jtm.ThreadPoolManager;
import com.eg.jtm.discovery.AutoDiscovery;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContainerDiscovery {
    private static final String DOCKER = "docker";
    private static final String CRIO = "crio";
    private static final String AWS_ECS = "ecs";
    private static final String POD = "kubepods.slice";
    private static final String AWS_DOCKER_POD = "kubepods";
    private static final String CGROUPFILENAME = "/proc/1/cgroup";
    private static final String HOSTNAME_FILENAME = "/etc/hostname";
    private static final String NAMESPACE_FILENAME = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    static boolean isWindows = false;
    static boolean isSolaris = false;
    static boolean isLinux = false;
    static boolean isAIX = false;
    static boolean isHpUx = false;
    private static final DiscoveryDetails DISCOVERY_DETAILS = new DiscoveryDetails();
    private static final Hashtable discoveredDetailsByStartUp = new Hashtable();
    private static final Hashtable discoveredDetailsByRequest = new Hashtable();
    private static final String LOG_HEADER = "[CONTAINER DISCOVERY] ";

    private ContainerDiscovery() {
    }

    static void initDiscoveryProcess() {
        String string;
        if (BTMLog.logger.isInfoEnabled()) {
            BTMLog.logger.info("****************************************************************************************");
            BTMLog.logger.info("********************** Starting D I S C O V E R Y Process ******************************");
            BTMLog.logger.info("****************************************************************************************");
            BTMLog.logger.info("eG Agent IP Address Discovery Enabled : {}", (Object)BTMOffLoadConfig.isAgentIpDiscoveryEnabled());
            BTMLog.logger.info("PID of this JAVA Process              : {}", (Object)DISCOVERY_DETAILS.getProcessID());
            BTMLog.logger.info("PID + Hostname of this JAVA Process   : {} @ {}", (Object)DISCOVERY_DETAILS.getProcessID(), (Object)DISCOVERY_DETAILS.getHostName());
            BTMLog.logger.info("eG BTM Log Folder Path                : {}", (Object)BTMOffLoadConfig.getBtmLogFolderName());
            BTMLog.logger.info("*****************************************************************************************");
            BTMLog.logger.info("{} Name of the OS :{} , Windows :{}, Linux :{}, AIX :{}, HP-UX :{} , SOLARIS :{}", LOG_HEADER, System.getProperty("os.name"), isWindows, isLinux, isAIX, isHpUx, isSolaris);
        }
        if (BTMOffLoadConfig.isAgentIpDiscoveryEnabled()) {
            ContainerDiscovery.discoverContainerInformation(ACTION.DISCOVER_CONTAINER_HOST_IP, 5);
        }
        ContainerDiscovery.discoverContainerInformation(ACTION.DISCOVER_FULL_CONTAINER_DETAILS, 10);
        BTMLog.logger.info("{} Container startup discovery enabled {}", (Object)LOG_HEADER, (Object)BTMOffLoadConfig.isContainerStartUpDiscoveryEnabled());
        ThreadPoolManager.getThreadPoolManager();
        if (BTMOffLoadConfig.isContainerStartUpDiscoveryEnabled()) {
            ContainerDiscovery.discoverContainerInformation(ACTION.SUBMIT_DISCOVERD_CONTAINER_DETAILS);
        }
        if ((string = ContainerDiscovery.getCollectorAgentIPDetails()) != null) {
            if (ContainerDiscovery.isDockerContainer()) {
                BTMOffLoadConfig.writeDetailsInConfig("AGENT_CONTAINER_IP", string);
            } else {
                BTMOffLoadConfig.writeDetailsInConfig("AGENT_IP", string);
            }
            BTMOffLoadConfig.setCollectorAgentIP(null);
            BTMOffLoadConfig.assignCollectorAgentIP(string);
            BTMOffLoadConfig.setSystemPropsIpUsed(true);
        }
    }

    private static String getCollectorAgentIPDetails() {
        try {
            String string = System.getProperty("eg.agent.ip");
            if (string != null && ContainerDiscovery.isValidIPv4Address(string)) {
                return string;
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} - Found Invalid details for {} , {}", LOG_HEADER, "eg.agent.ip", exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean searchInFile(String string, String string2) {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            String string3;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf(string2) <= -1) continue;
                bl = true;
                if (string2.equals(DOCKER)) {
                    DISCOVERY_DETAILS.setStandaloneDockerContainer(true);
                } else if (string2.equals(POD)) {
                    DISCOVERY_DETAILS.setKubernetesPODContainer(true);
                } else if (string2.equals(CRIO)) {
                    DISCOVERY_DETAILS.setKubernetesPODContainer(true);
                    DISCOVERY_DETAILS.setCrioContainer(true);
                    DISCOVERY_DETAILS.setStandaloneDockerContainer(true);
                } else if (string2.equals(AWS_DOCKER_POD)) {
                    DISCOVERY_DETAILS.setKubernetesPODContainer(true);
                    DISCOVERY_DETAILS.setStandaloneDockerContainer(true);
                } else if (string2.equals(AWS_ECS)) {
                    DISCOVERY_DETAILS.setStandaloneDockerContainer(true);
                }
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!isWindows) {
                BTMLog.logger.info("{} Unable to locate : {}", (Object)LOG_HEADER, (Object)string);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} Unable to read : {}, {}", LOG_HEADER, string, exception.getMessage());
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileContentAsString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!isWindows) {
                BTMLog.logger.info("{} Unable to locate : {}", (Object)LOG_HEADER, (Object)string);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} Unable to read : {}, {}", LOG_HEADER, string, exception.getMessage());
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return stringBuilder.toString();
    }

    static boolean isDockerContainer() {
        boolean bl = ContainerDiscovery.searchInFile(CGROUPFILENAME, DOCKER);
        if (!bl) {
            bl = ContainerDiscovery.searchInFile(CGROUPFILENAME, AWS_DOCKER_POD);
        }
        if (!bl) {
            bl = ContainerDiscovery.searchInFile(CGROUPFILENAME, AWS_ECS);
        }
        return bl;
    }

    static boolean isCrioContainer() {
        boolean bl = ContainerDiscovery.searchInFile(CGROUPFILENAME, CRIO);
        if (!bl) {
            bl = ContainerDiscovery.searchInFile(CGROUPFILENAME, AWS_DOCKER_POD);
        }
        return bl;
    }

    static boolean isPODContainer() {
        boolean bl = ContainerDiscovery.searchInFile(CGROUPFILENAME, POD);
        if (!bl) {
            bl = ContainerDiscovery.searchInFile(CGROUPFILENAME, AWS_DOCKER_POD);
        }
        return bl;
    }

    static String getDockerContainerIdOrPodName() {
        return ContainerDiscovery.readFileContentAsString(HOSTNAME_FILENAME);
    }

    static String getKubernetesNameSpaceName() {
        return ContainerDiscovery.readFileContentAsString(NAMESPACE_FILENAME);
    }

    static String getDockerContainerIDFromPod() {
        String string = "";
        String string2 = "cat /proc/self/cgroup | grep -o  -e \"docker-.*.scope\" | head -n 1 | sed \"s/docker-\\(.*\\).scope/\\\\1/\"";
        string = ContainerDiscovery.findContainerId(string2, "DOCKER");
        if (string.length() == 0) {
            string2 = "cat /proc/self/cgroup | grep -o  -e \"crio-.*.scope\" | head -n 1 | sed \"s/crio-\\(.*\\).scope/\\\\1/\"";
            string = ContainerDiscovery.findContainerId(string2, "CRI-O");
        }
        if (string.length() == 0) {
            string2 = "cat /proc/self/cgroup  | awk -F\"/\" '{print $NF}' | head -1";
            string = ContainerDiscovery.findContainerId(string2, "AWS-EKS-ECS");
        }
        if (string.length() == 0) {
            string2 = "cat /proc/self/cgroup | head -1";
            ContainerDiscovery.findContainerId(string2, "CONTAINER");
        }
        return string;
    }

    private static String findContainerId(String string, String string2) {
        String string3 = "";
        try {
            String string4;
            ArrayList arrayList = ContainerDiscovery.executeCommand(string);
            BTMLog.logger.info(string2 + ":- container ID by using {} & output : {}", (Object)string, (Object)arrayList);
            ContainerDiscovery.printOutLog("INFO", string2 + ":- cmd : " + string + ", outPut :" + arrayList);
            if (arrayList != null && arrayList.size() > 0 && (string4 = arrayList.get(0).toString()) != null && string4.length() > 0) {
                string3 = string4;
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error(string2 + ":- Unable to get output for : {}", (Object)string);
        }
        return string3;
    }

    public static String getDockerContainerIp() {
        String string;
        String string2 = "";
        String string3 = "hostname -i";
        ArrayList arrayList = ContainerDiscovery.executeCommand(string3);
        BTMLog.logger.info("{} DOCKER Container IP by using [{}] , output is {}", LOG_HEADER, string3, arrayList);
        if (arrayList != null && arrayList.size() > 0 && ContainerDiscovery.isValidIPv4Address(string = arrayList.get(0).toString())) {
            string2 = string;
        }
        return string2;
    }

    static String getDockerContainerHostIp() {
        String string;
        String string2 = "";
        String string3 = "/sbin/ip route | awk '/default/ { print $3 }'";
        ArrayList arrayList = ContainerDiscovery.executeCommand(string3);
        BTMLog.logger.info("DOCKER Host IP by using {} & output : {}", (Object)string3, (Object)arrayList);
        if (arrayList != null && arrayList.size() > 0 && ContainerDiscovery.isValidIPv4Address(string = arrayList.get(0).toString())) {
            string2 = string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList executeCommand(String string) {
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        Process process = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        InputStream inputStream2 = null;
        try {
            String[] stringArray = new String[]{"/bin/sh", "-c", string};
            process = Runtime.getRuntime().exec(stringArray);
            inputStream = process.getInputStream();
            inputStream2 = process.getErrorStream();
            outputStream = process.getOutputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            while ((string2 = bufferedReader2.readLine()) != null) {
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn(" Unable to execute cmd {} in Runtime.getRuntime().exec(), {} ", (Object)string, (Object)exception);
        }
        finally {
            try {
                if (process != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        inputStream2.close();
                    }
                    catch (Exception exception) {}
                    process.destroy();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedReader2 != null) {
                    bufferedReader2.close();
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception occurred while closing streams & buffers {} - {}", (Object)string, (Object)exception);
            }
        }
        return arrayList;
    }

    private static boolean isValidIPv4Address(String string) {
        if (string == null) {
            return false;
        }
        String string2 = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    static void discoverContainerInformation(ACTION aCTION) {
        new ContainerDiscoveryHelperThread(aCTION);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void discoverContainerInformation(ACTION aCTION, int n) {
        try {
            ContainerDiscoveryHelperThread containerDiscoveryHelperThread = new ContainerDiscoveryHelperThread(aCTION);
            long l = 50L;
            int n2 = 0;
            do {
                ContainerDiscovery.suspendForPeriod(l);
                if (containerDiscoveryHelperThread.isDone()) return;
            } while (++n2 < n);
            containerDiscoveryHelperThread.interrupt();
            return;
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} - Unable to get details for  {} due to {}", LOG_HEADER, aCTION.toString(), exception);
        }
    }

    private static void suspendForPeriod(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getHostName() {
        return DISCOVERY_DETAILS.getHostName();
    }

    public static boolean isThisDockerContainer() {
        return DISCOVERY_DETAILS.isDockerContainer();
    }

    private static void initDiscoveryDetails() {
        ContainerDiscovery.getProcessDetails();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("IS_STANDALONE", "false");
        hashtable.put("IS_CONTAINER", "false");
        hashtable.put("IS_KUBERNETES", "false");
        hashtable.put("IS_OTHER_TYPES", "false");
        hashtable.put("CONTAINER_NAME", "NONE");
        hashtable.put("CONTAINER_ID", "NONE");
        hashtable.put("CONTAINER_SERVER_NAME", "Java_virtual_machine");
        hashtable.put("CONTAINER_SERVER_NAME", "Java Application");
        hashtable.put("CONTAINER_IP", DISCOVERY_DETAILS.getHostName());
        hashtable.put("CONTAINER_PORT", "0000");
        hashtable.put("CONTAINER_SCHEME", "http");
        hashtable.put("CONTAINER_VERSION", "NONE");
        hashtable.put("CONTAINER_HOST_NAME", "NONE");
        hashtable.put("CONTAINER_REQUESTED_IP", DISCOVERY_DETAILS.getHostName());
        hashtable.put("CONTAINER_REQUESTED_PORT", "0000");
        hashtable.put("POD_NAME", "NONE");
        hashtable.put("POD_NAME_SPACE", "NONE");
        hashtable.put("POD_IP", DISCOVERY_DETAILS.getHostName());
        hashtable.put("CONTAINER_PID", DISCOVERY_DETAILS.getProcessID());
        discoveredDetailsByRequest.putAll(hashtable);
        discoveredDetailsByStartUp.putAll(hashtable);
    }

    public static Hashtable getDiscoveredDetailsByRequest() {
        return discoveredDetailsByRequest;
    }

    public static Hashtable getDiscoveredDetailsByStartup() {
        return discoveredDetailsByStartUp;
    }

    static void addToStartupDiscoveryDetails(String string, String string2) {
        if (string != null && string2 != null) {
            discoveredDetailsByStartUp.put(string, string2);
        }
    }

    public static String getDiscoveredDetailsByStartup(String string) {
        String string2 = (String)discoveredDetailsByStartUp.get(string);
        string2 = string2 != null ? string2 : "";
        return string2;
    }

    static void logConfigDetails() {
        if (BTMLog.logger.isWarnEnabled()) {
            String string = "INFO :";
            BTMLog.logger.warn("{} {} PID of this JAVA Process       : {}", string, LOG_HEADER, DISCOVERY_DETAILS.getProcessID());
            BTMLog.logger.warn("{} {} Current JVM GUID               : {}", string, LOG_HEADER, PropsManager.getJvmGUID());
            BTMLog.logger.warn("{} {} Current Node ID                : {}", string, LOG_HEADER, BTMOffLoadConfig.getNodeID());
            BTMLog.logger.warn("{} {} On-Memory config write enabled : {}", string, LOG_HEADER, BTMOffLoadConfig.isMemoryCopyOnly());
            BTMLog.logger.warn("{} {} Is JVM running on DOCKER       : {}", string, LOG_HEADER, DISCOVERY_DETAILS.isDockerContainer());
            BTMLog.logger.warn("{} {} eG BTM Log Folder Path         : {}", string, LOG_HEADER, PropsManager.EG_BTM_HOME + BTMOffLoadConfig.getBtmLogFolderName());
            BTMLog.logger.warn("{} {} Application Name | Service Name assigned as : {} ", string, LOG_HEADER, BTMOffLoadConfig.getApplicationName());
            BTMLog.logger.warn("{} {} Tier Name | Group Name assigned as         : {} ", string, LOG_HEADER, BTMOffLoadConfig.getTierName());
            BTMLog.logger.warn("{} {} Log Clean-Up code         : {} ", new Object[]{string, LOG_HEADER, LogCleanUp.getCleanUpCode()});
            if (!isWindows) {
                String string2 = ContainerDiscovery.readFileContentAsString(CGROUPFILENAME);
                Properties properties = PropsManager.getSystemProperties();
                Map map = PropsManager.getSystemEnvVariable();
                BTMLog.logger.warn("{} {}  C-Group Details   : {} ", string, LOG_HEADER, string2);
                BTMLog.logger.warn("{} {}  System Properties   : {} ", string, LOG_HEADER, properties);
                BTMLog.logger.warn("{} {}  System Environment Variables   : {} ", string, LOG_HEADER, map);
                ContainerDiscovery.printOutLog("INFO", " C-Group Details   : " + string2);
                ContainerDiscovery.printOutLog("INFO", " System Properties   : " + properties);
                ContainerDiscovery.printOutLog("INFO", " System Environment Variables   : " + map);
            }
        }
    }

    static void printOutLog(String string, String string2) {
        if (string == null || string.length() == 0) {
            string = "INFO";
        }
        if (string2 != null) {
            System.out.println(new Date() + " " + string + "  [eG BTM] - " + string2);
        }
    }

    private static void getProcessDetails() {
        try {
            String string = ManagementFactory.getRuntimeMXBean().getName();
            if (string != null && string.length() > 0) {
                int n = string.indexOf("@");
                if (n > 0) {
                    String string2 = string.substring(n + 1);
                    String string3 = string.substring(0, n);
                    DISCOVERY_DETAILS.setHostName(string2);
                    DISCOVERY_DETAILS.setProcessID(string3);
                } else {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    String string4 = inetAddress.getHostName();
                    String string5 = string;
                    DISCOVERY_DETAILS.setHostName(string4);
                    DISCOVERY_DETAILS.setProcessID(string5);
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception while getting processDetails ", exception);
        }
    }

    static void grantBtmLogFolderAccess(String string) {
        try {
            String string2 = "chmod -R 777 " + string;
            ArrayList arrayList = ContainerDiscovery.executeCommand(string2);
            BTMLog.logger.info("Granting full file permission to [{}], cmd : {} & output : {}", string, string2, arrayList);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Unable to change file permission : {}", (Object)string, (Object)exception);
        }
    }

    public static void storeClassNameDiscoveredDataToStartupDiscovery() {
        try {
            Hashtable hashtable = ContainerDiscovery.getDiscoveredDetailsByStartup();
            boolean bl = false;
            if (AutoDiscovery.isClassNameDiscoveryCompleted()) {
                String string;
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                String string2 = AutoDiscovery.getHttpServerPort();
                if (string2 != null && string2.length() > 0) {
                    hashtable2.put("CONTAINER_PORT", string2);
                    bl = true;
                }
                if ((string = AutoDiscovery.getJmxPort()) != null && string.length() > 1) {
                    hashtable2.put("CONTAINER_JMX_PORT", string);
                }
                String string3 = AutoDiscovery.getServerName();
                String string4 = AutoDiscovery.getServerNameWithVersion();
                if (string3 != null && string3.length() > 0) {
                    hashtable2.put("CONTAINER_SERVER_NAME", string3);
                }
                if (string4 != null && string4.length() > 0) {
                    hashtable2.put("CONTAINER_SERVER_VERSION_NAME", string4);
                }
                boolean bl2 = DISCOVERY_DETAILS.isDockerContainer();
                if (hashtable != null && !hashtable.containsKey("DISCOVERED")) {
                    if (BTMOffLoadConfig.isContainerStartUpDiscoveryEnabled() && bl2) {
                        hashtable2.put("DISCOVERED", "DISCOVERED");
                    } else if (BTMOffLoadConfig.isContainerStartUpDiscoveryEnabled() && bl) {
                        hashtable2.put("DISCOVERED", "DISCOVERED");
                    }
                }
                ContainerDiscovery.getDiscoveredDetailsByStartup().putAll(hashtable2);
                BTMLog.logger.debug("Startup Discovery Details updated with 'ClassName Discovery Details', updated details - {}", (Object)ContainerDiscovery.getDiscoveredDetailsByStartup());
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Unable to store class name discovered data to startup discovery details : ", exception);
        }
    }

    public static String getContainerName() {
        return DISCOVERY_DETAILS.getContainerName();
    }

    public static String getProcessID() {
        return DISCOVERY_DETAILS.getProcessID();
    }

    public static boolean isKubernetesPOD() {
        return DISCOVERY_DETAILS.isKubernetesPOD();
    }

    public static void setContainerName(String string) {
        DISCOVERY_DETAILS.setContainerName(string);
    }

    static {
        ContainerDiscovery.initDiscoveryDetails();
        String string = System.getProperty("os.name").toLowerCase();
        try {
            isWindows = string.startsWith("windows") && string.indexOf("windows") >= 0;
            isSolaris = string.indexOf("sun") >= 0;
            isLinux = string.indexOf("linux") >= 0;
            isAIX = string.indexOf("aix") >= 0;
            isHpUx = string.indexOf("hp-ux") >= 0;
        }
        catch (Exception exception) {
            BTMLog.logger.warn("{} Exception due to {} ", (Object)LOG_HEADER, (Object)exception);
        }
    }
}

