/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BTMLog;
import com.eg.jtm.JavaAgentCommunicator;
import com.eg.jtm.PropFilesTracker;
import com.eg.jtm.PropsManager;
import com.eg.jtm.SnapshotManager;
import com.eg.jtm.UPDManager;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class BTMServer
extends Thread {
    ServerSocket serverSocket = null;
    int numTimeouts = 0;
    boolean infiniteFlag = true;

    public void run() {
        int n = UPDManager.getBTMPort();
        if (!PropsManager.isOldModel()) {
            BTMLog.logger.info("BTM running at Offloading mode, so BTM Server not started on the port {} ", (Object)n);
            return;
        }
        BTMLog.logger.info("BTM running at Non-offload mode, so BTM Server started on the port {} ", (Object)n);
        while (n == -1) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n = UPDManager.getBTMPort();
            BTMLog.logger.info("Port not yet initialized. Waiting for 1 more second ....");
        }
        BTMLog.logger.debug("port is {}  and useDesigAgtOnly is {} and desigAgtInetAddr is {} ", n, UPDManager.isUseDesigAgtOnly(), UPDManager.getDesigAgtInetAddr());
        UPDManager.updateTables4Summary();
        int n2 = 0;
        while (this.infiniteFlag) {
            Object object;
            Socket socket = null;
            if (UPDManager.getPortChanged()) {
                if (!this.createSrvrSock()) {
                    BTMLog.logger.info("Unable to recreate server socket with new port. Retrying after one second...");
                    if (n2 <= 10) {
                        this.sleepMethod(1000L);
                        ++n2;
                        continue;
                    }
                    PropsManager.setTalkingToAgent(false);
                    UPDManager.clearStoredData();
                    SnapshotManager.stopSnapshotTaker();
                    BTMLog.logger.warn("SHUTTING DONE BTM !!! - Unable to create server socket with the port {} ", (Object)n);
                    return;
                }
                UPDManager.resetPortChanged();
                n2 = 0;
            }
            if (UPDManager.getMeasPeriodChanged() && this.resetWaitTimeout()) {
                UPDManager.resetMeasPeriodChanged();
            }
            if (this.serverSocket == null) {
                this.createSrvrSock();
            }
            try {
                socket = this.serverSocket.accept();
                this.numTimeouts = 0;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                BTMLog.logger.debug("BTM Server timed-out. Waiting again....");
                ++this.numTimeouts;
                if (this.numTimeouts > 4) {
                    BTMLog.logger.debug("BTM Server timed-out 5 times in a row. Will now wait indefinitely");
                    this.resetWaitTimeout(0);
                }
                this.closeCliSock(socket);
                continue;
            }
            catch (Exception exception) {
                BTMLog.logger.error("Exception while accepting connection from Test. Ignoring connection request.. {}", exception);
                this.closeCliSock(socket);
                continue;
            }
            InetAddress inetAddress = socket.getInetAddress();
            boolean bl = false;
            boolean bl2 = false;
            try {
                if (UPDManager.isUseDesigAgtOnly()) {
                    object = UPDManager.getDesigAgtInetAddr();
                    if (object != null) {
                        if (((InetAddress)object).equals(inetAddress)) {
                            bl = true;
                            bl2 = true;
                        } else {
                            BTMLog.logger.warn("Client IPAddress : {} doesn't match with Designated Agent IPAddress:{} ", (Object)inetAddress, object);
                            BTMLog.logger.warn("So,Rejecting Request from Client IPAddress : {} ", (Object)inetAddress);
                        }
                    }
                } else {
                    bl = true;
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception Occured during Designated IPAddress validation");
                bl = false;
            }
            if (!bl) continue;
            object = new JavaAgentCommunicator(bl2, socket);
            new Thread((Runnable)object, "BTM Test Handler").start();
        }
    }

    void shutDownServerSocket() {
        this.infiniteFlag = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            PropFilesTracker.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SnapshotManager.stopSnapshotTaker();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sleepMethod(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeCliSock(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                BTMLog.logger.warn("Error closing client socket {} ", (Object)socket.toString(), (Object)iOException);
            }
        }
    }

    private boolean createSrvrSock() {
        int n = UPDManager.getPrevBTMPort();
        int n2 = UPDManager.getBTMPort();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                BTMLog.logger.warn("Exception while closing server on port {} {} ", (Object)n, (Object)iOException);
            }
        }
        try {
            this.serverSocket = new ServerSocket(n2);
        }
        catch (Exception exception) {
            if (exception instanceof BindException) {
                BTMLog.logger.error("Unable to start BTM Server on port {} . Port may already be in use. {} ", (Object)n2, (Object)exception);
            } else {
                BTMLog.logger.error("Unable to start BTM Server due to Exception. {} ", exception);
            }
            return false;
        }
        this.resetWaitTimeout();
        BTMLog.logger.info("BTM listening to eG agents on port {} ", (Object)n2);
        return true;
    }

    private boolean resetWaitTimeout() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.setSoTimeout((int)(PropsManager.getEgMeasPeriod() * 2L));
                return true;
            }
            BTMLog.logger.error("BTM Server socket becomes NULL");
            return false;
        }
        catch (SocketException socketException) {
            BTMLog.logger.error("Unable to set timeout for BTM Server socket due to Exception : {}", socketException);
            return false;
        }
    }

    private boolean resetWaitTimeout(int n) {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.setSoTimeout(n);
                return true;
            }
            return false;
        }
        catch (SocketException socketException) {
            BTMLog.logger.error("Unable to set timeout for BTM Server socket due to Exception. {}", socketException);
            return false;
        }
    }
}

