/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.util;

import com.eg.ch.qos.logback.core.util.CharSequenceState;
import com.eg.ch.qos.logback.core.util.CharSequenceToRegexMapper;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePatternToRegexUtil {
    final String datePattern;
    final int datePatternLength;
    final CharSequenceToRegexMapper regexMapper = new CharSequenceToRegexMapper();

    public DatePatternToRegexUtil(String string) {
        this.datePattern = string;
        this.datePatternLength = string.length();
    }

    public String toRegex() {
        List<CharSequenceState> list = this.tokenize();
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequenceState charSequenceState : list) {
            stringBuilder.append(this.regexMapper.toRegex(charSequenceState));
        }
        return stringBuilder.toString();
    }

    private List<CharSequenceState> tokenize() {
        ArrayList<CharSequenceState> arrayList = new ArrayList<CharSequenceState>();
        CharSequenceState charSequenceState = null;
        for (int i = 0; i < this.datePatternLength; ++i) {
            char c = this.datePattern.charAt(i);
            if (charSequenceState == null || charSequenceState.c != c) {
                charSequenceState = new CharSequenceState(c);
                arrayList.add(charSequenceState);
                continue;
            }
            charSequenceState.incrementOccurrences();
        }
        return arrayList;
    }
}

