/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.pattern;

import com.eg.ch.qos.logback.core.pattern.CompositeConverter;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplacingCompositeConverter<E>
extends CompositeConverter<E> {
    Pattern pattern;
    String regex;
    String replacement;

    @Override
    public void start() {
        List<String> list = this.getOptionList();
        if (list == null) {
            this.addError("at least two options are expected whereas you have declared none");
            return;
        }
        int n = list.size();
        if (n < 2) {
            this.addError("at least two options are expected whereas you have declared only " + n + "as [" + list + "]");
            return;
        }
        this.regex = list.get(0);
        this.pattern = Pattern.compile(this.regex);
        this.replacement = list.get(1);
        super.start();
    }

    @Override
    protected String transform(E e, String string) {
        if (!this.started) {
            return string;
        }
        return this.pattern.matcher(string).replaceAll(this.replacement);
    }
}

