/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.pattern;

import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.LayoutBase;
import com.eg.ch.qos.logback.core.pattern.Converter;
import com.eg.ch.qos.logback.core.pattern.ConverterUtil;
import com.eg.ch.qos.logback.core.pattern.PostCompileProcessor;
import com.eg.ch.qos.logback.core.pattern.parser.Node;
import com.eg.ch.qos.logback.core.pattern.parser.Parser;
import com.eg.ch.qos.logback.core.spi.ScanException;
import com.eg.ch.qos.logback.core.status.ErrorStatus;
import com.eg.ch.qos.logback.core.status.StatusManager;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PatternLayoutBase<E>
extends LayoutBase<E> {
    static final int INTIAL_STRING_BUILDER_SIZE = 256;
    Converter<E> head;
    String pattern;
    protected PostCompileProcessor<E> postCompileProcessor;
    Map<String, String> instanceConverterMap = new HashMap<String, String>();
    protected boolean outputPatternAsHeader = false;

    public abstract Map<String, String> getDefaultConverterMap();

    public Map<String, String> getEffectiveConverterMap() {
        Map map;
        Context context;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, String> map2 = this.getDefaultConverterMap();
        if (map2 != null) {
            hashMap.putAll(map2);
        }
        if ((context = this.getContext()) != null && (map = (Map)context.getObject("PATTERN_RULE_REGISTRY")) != null) {
            hashMap.putAll(map);
        }
        hashMap.putAll(this.instanceConverterMap);
        return hashMap;
    }

    @Override
    public void start() {
        if (this.pattern == null || this.pattern.length() == 0) {
            this.addError("Empty or null pattern.");
            return;
        }
        try {
            Parser parser = new Parser(this.pattern);
            if (this.getContext() != null) {
                parser.setContext(this.getContext());
            }
            Node node = parser.parse();
            this.head = parser.compile(node, this.getEffectiveConverterMap());
            if (this.postCompileProcessor != null) {
                this.postCompileProcessor.process(this.context, this.head);
            }
            ConverterUtil.setContextForConverters(this.getContext(), this.head);
            ConverterUtil.startConverters(this.head);
            super.start();
        }
        catch (ScanException scanException) {
            StatusManager statusManager = this.getContext().getStatusManager();
            statusManager.add(new ErrorStatus("Failed to parse pattern \"" + this.getPattern() + "\".", this, scanException));
        }
    }

    public void setPostCompileProcessor(PostCompileProcessor<E> postCompileProcessor) {
        this.postCompileProcessor = postCompileProcessor;
    }

    protected void setContextForConverters(Converter<E> converter) {
        ConverterUtil.setContextForConverters(this.getContext(), converter);
    }

    protected String writeLoopOnConverters(E e) {
        StringBuilder stringBuilder = new StringBuilder(256);
        for (Converter<E> converter = this.head; converter != null; converter = converter.getNext()) {
            converter.write(stringBuilder, e);
        }
        return stringBuilder.toString();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public String toString() {
        return this.getClass().getName() + "(\"" + this.getPattern() + "\")";
    }

    public Map<String, String> getInstanceConverterMap() {
        return this.instanceConverterMap;
    }

    protected String getPresentationHeaderPrefix() {
        return "";
    }

    public boolean isOutputPatternAsHeader() {
        return this.outputPatternAsHeader;
    }

    public void setOutputPatternAsHeader(boolean bl) {
        this.outputPatternAsHeader = bl;
    }

    @Override
    public String getPresentationHeader() {
        if (this.outputPatternAsHeader) {
            return this.getPresentationHeaderPrefix() + this.pattern;
        }
        return super.getPresentationHeader();
    }
}

