/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran;

import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.joran.event.SaxEvent;
import com.eg.ch.qos.logback.core.joran.event.SaxEventRecorder;
import com.eg.ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import com.eg.ch.qos.logback.core.joran.spi.ElementPath;
import com.eg.ch.qos.logback.core.joran.spi.InterpretationContext;
import com.eg.ch.qos.logback.core.joran.spi.Interpreter;
import com.eg.ch.qos.logback.core.joran.spi.JoranException;
import com.eg.ch.qos.logback.core.joran.spi.RuleStore;
import com.eg.ch.qos.logback.core.joran.spi.SimpleRuleStore;
import com.eg.ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import com.eg.ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import com.eg.ch.qos.logback.core.spi.ContextAwareBase;
import com.eg.ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericConfigurator
extends ContextAwareBase {
    private BeanDescriptionCache beanDescriptionCache;
    protected Interpreter interpreter;

    public final void doConfigure(URL uRL) throws JoranException {
        InputStream inputStream = null;
        try {
            GenericConfigurator.informContextOfURLUsedForConfiguration(this.getContext(), uRL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
            this.doConfigure(inputStream, uRL.toExternalForm());
        }
        catch (IOException iOException) {
            String string = "Could not open URL [" + uRL + "].";
            this.addError(string, iOException);
            throw new JoranException(string, iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    String string = "Could not close input stream";
                    this.addError(string, iOException);
                    throw new JoranException(string, iOException);
                }
            }
        }
    }

    public final void doConfigure(String string) throws JoranException {
        this.doConfigure(new File(string));
    }

    public final void doConfigure(File file) throws JoranException {
        FileInputStream fileInputStream = null;
        try {
            URL uRL = file.toURI().toURL();
            GenericConfigurator.informContextOfURLUsedForConfiguration(this.getContext(), uRL);
            fileInputStream = new FileInputStream(file);
            this.doConfigure(fileInputStream, uRL.toExternalForm());
        }
        catch (IOException iOException) {
            String string = "Could not open [" + file.getPath() + "].";
            this.addError(string, iOException);
            throw new JoranException(string, iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    String string = "Could not close [" + file.getName() + "].";
                    this.addError(string, iOException);
                    throw new JoranException(string, iOException);
                }
            }
        }
    }

    public static void informContextOfURLUsedForConfiguration(Context context, URL uRL) {
        ConfigurationWatchListUtil.setMainWatchURL(context, uRL);
    }

    public final void doConfigure(InputStream inputStream) throws JoranException {
        this.doConfigure(new InputSource(inputStream));
    }

    public final void doConfigure(InputStream inputStream, String string) throws JoranException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        this.doConfigure(inputSource);
    }

    protected BeanDescriptionCache getBeanDescriptionCache() {
        if (this.beanDescriptionCache == null) {
            this.beanDescriptionCache = new BeanDescriptionCache(this.getContext());
        }
        return this.beanDescriptionCache;
    }

    protected abstract void addInstanceRules(RuleStore var1);

    protected abstract void addImplicitRules(Interpreter var1);

    protected void addDefaultNestedComponentRegistryRules(DefaultNestedComponentRegistry defaultNestedComponentRegistry) {
    }

    protected ElementPath initialElementPath() {
        return new ElementPath();
    }

    protected void buildInterpreter() {
        SimpleRuleStore simpleRuleStore = new SimpleRuleStore(this.context);
        this.addInstanceRules(simpleRuleStore);
        this.interpreter = new Interpreter(this.context, simpleRuleStore, this.initialElementPath());
        InterpretationContext interpretationContext = this.interpreter.getInterpretationContext();
        interpretationContext.setContext(this.context);
        this.addImplicitRules(this.interpreter);
        this.addDefaultNestedComponentRegistryRules(interpretationContext.getDefaultNestedComponentRegistry());
    }

    public final void doConfigure(InputSource inputSource) throws JoranException {
        long l = System.currentTimeMillis();
        SaxEventRecorder saxEventRecorder = new SaxEventRecorder(this.context);
        saxEventRecorder.recordEvents(inputSource);
        this.doConfigure(saxEventRecorder.saxEventList);
        StatusUtil statusUtil = new StatusUtil(this.context);
        if (statusUtil.noXMLParsingErrorsOccurred(l)) {
            this.addInfo("Registering current configuration as safe fallback point");
            this.registerSafeConfiguration(saxEventRecorder.saxEventList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConfigure(List<SaxEvent> list) throws JoranException {
        this.buildInterpreter();
        Object object = this.context.getConfigurationLock();
        synchronized (object) {
            this.interpreter.getEventPlayer().play(list);
        }
    }

    public void registerSafeConfiguration(List<SaxEvent> list) {
        this.context.putObject("SAFE_JORAN_CONFIGURATION", list);
    }

    public List<SaxEvent> recallSafeConfiguration() {
        return (List)this.context.getObject("SAFE_JORAN_CONFIGURATION");
    }
}

