/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.trace.utils;

import com.eg.agent.trace.utils.CustomConfigurationManager;
import com.eg.agent.trace.utils.StatusCodeUtils;
import com.eg.agent.ux.Measure;
import com.eg.agent.ux.MeasureUtil;
import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMOffLoadConfig;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.ContainerDiscovery;
import com.eg.jtm.MethodEventProcessor;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.OtherAPMTestConfiguration;
import com.eg.jtm.PropsManager;
import com.eg.jtm.RedisCommandInfo;
import com.eg.jtm.RequestIdentifier;
import com.eg.jtm.RumPropsManager;
import com.eg.jtm.discovery.AutoDiscovery;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TraceUtils {
    private static final String BTM_DATE_PATTERN = "dd/MM/yy hh:mm:ss a";
    private static final SimpleDateFormat BTM_DATE_FORMAT = new SimpleDateFormat("dd/MM/yy hh:mm:ss a", Locale.US);
    private static final Hashtable<Object, Boolean> STATUS_CHECK = new Hashtable();
    private static final SimpleDateFormat UTC_DATE_FORMATTER = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.US);
    public static final int NumRowsInStackTrace = 10;
    public static final String ExcpnRowSep = "?^?";
    private static final String ADD_HEADER = "addHeader";
    private static final String ADD_REQUEST_HEADER = "addRequestHeader";
    private static final String UNKNOWN_HOST = "UNKNOWN_HOST";
    private static final String DASH = "-";
    private static final String ERROR_EXCEPTION = "javax.servlet.error.exception";
    private static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    private static final int HTTP_STATUS_CODE_MINIMUM = 200;
    private static final int HTTP_STATUS_CODE_MAXIMUM = 600;
    public static final Object[] ARGS;
    private static String serverName;
    public static boolean discoveryDetailsSent;
    private static long requestInvokeCount;
    private static final String[] REQUEST_METHODS;
    private static final String[] APACHE_CXF_REQUEST_METHODS;
    private static final String[] SERVER_NAME_METHODS;

    private TraceUtils() {
    }

    public static Map getApacheCxfCallInfo(Object object, Object object2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Object object3 = TraceUtils.invokeRequestMethod(object, object.getClass(), APACHE_CXF_REQUEST_METHODS[1], DASH);
            Object object4 = TraceUtils.invokeRequestMethod(object3, object3.getClass(), APACHE_CXF_REQUEST_METHODS[2], DASH);
            Object object5 = TraceUtils.invokeRequestMethod(object4, object4.getClass(), APACHE_CXF_REQUEST_METHODS[3], DASH);
            Object object6 = TraceUtils.invokeRequestMethod(object5, object5.getClass(), APACHE_CXF_REQUEST_METHODS[4], DASH);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(DASH);
            String string = object6.toString();
            hashMap.put("OperationName", stringBuilder.toString());
            hashMap.put("TargetUrl", string);
            if (OtherAPMTestConfiguration.isFlowTestRunning()) {
                hashMap.put("TFT_KEY", string);
            }
        }
        catch (Exception exception) {
            hashMap.put("OperationName", DASH);
            hashMap.put("TargetUrl", DASH);
            BTMLog.logger.error("Exception occured while fetching CXF details {} ", exception);
        }
        return hashMap;
    }

    public static HashMap getSOAPCallInfo(Object object, Object object2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object var3_3 = null;
        Object object3 = DASH;
        String string = DASH;
        if (object2 != null) {
            object3 = object2;
        }
        if (OtherAPMTestConfiguration.isFlowTestRunning() && (object2 instanceof String || object2 instanceof URL)) {
            hashMap.put("TFT_KEY", object2.toString());
        }
        hashMap.put("OperationName", string.toString());
        hashMap.put("TargetUrl", object3.toString());
        BTMLog.logger.debug(" getSOAPCallInfo :{}", (Object)hashMap);
        return hashMap;
    }

    private static void realUpdate(Object object, String string, String string2, RequestIdentifier requestIdentifier) {
        Class<?> clazz = null;
        try {
            int n = Integer.parseInt(string);
            if (n >= 400) {
                clazz = object.getClass();
                Method method = clazz.getMethod(string2, new Class[0]);
                method.setAccessible(true);
                Object object2 = method.invoke(object, ARGS);
                if (object2 != null) {
                    String string3 = object2.toString();
                    requestIdentifier.updateApacheHTTPStatusCode(n, string3);
                }
            } else if (n > 0) {
                requestIdentifier.updateApacheHTTPStatusCode(n);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception while converting HTTP Status code for the GUID : {} from the {} {}", requestIdentifier.getReqGUID(), string, exception);
        }
    }

    public static void updateHTTPStatusCode(Object object, RequestIdentifier requestIdentifier, boolean bl) {
        block8: {
            Object object2 = null;
            Class<?> clazz = null;
            if (bl) {
                TraceUtils.getAndSetApacheResponseUniqueJvmGuid(object, true, requestIdentifier);
                try {
                    clazz = object.getClass();
                    Method method = clazz.getMethod("getStatusLine", new Class[0]);
                    method.setAccessible(true);
                    Object object3 = method.invoke(object, ARGS);
                    if (object3 == null) break block8;
                    Class<?> clazz2 = object3.getClass();
                    Method method2 = clazz2.getMethod("getStatusCode", new Class[0]);
                    method2.setAccessible(true);
                    object2 = method2.invoke(object3, ARGS);
                    if (object2 != null) {
                        String string = object2.toString();
                        TraceUtils.realUpdate(object3, string, "getReasonPhrase", requestIdentifier);
                    }
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("Exception while fetching HTTP Status code for the GUID : {} : {} ", (Object)requestIdentifier.getReqGUID(), (Object)exception.getMessage());
                    BTMLog.logger.error("Exception for the GUID : {} is {}", (Object)requestIdentifier.getReqGUID(), (Object)exception);
                }
            } else {
                TraceUtils.getAndSetApacheResponseUniqueJvmGuid(object, false, requestIdentifier);
                try {
                    clazz = object.getClass();
                    Method method = clazz.getMethod("getStatusCode", new Class[0]);
                    method.setAccessible(true);
                    object2 = method.invoke(object, ARGS);
                    if (object2 != null) {
                        String string = object2.toString();
                        TraceUtils.realUpdate(object, string, "getStatusText", requestIdentifier);
                    }
                }
                catch (Exception exception) {
                    BTMLog.logger.warn("Exception while fetching HTTP Status code for the GUID : {} {} ", (Object)requestIdentifier.getReqGUID(), (Object)exception.getMessage());
                    BTMLog.logger.error("Exception for the GUID : {} is {} ", (Object)requestIdentifier.getReqGUID(), (Object)exception);
                }
            }
        }
    }

    public static boolean isValidHttpObject(Object object) {
        boolean bl = false;
        if (object instanceof HttpURLConnection) {
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)object;
                bl = true;
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception while casting HTTPCall Object {} ", exception);
            }
        }
        return bl;
    }

    public static void updateHTTPStatusCodeFromStreamEnd(Object object, RequestIdentifier requestIdentifier) {
        boolean bl = requestIdentifier.isCodeFound();
        if (bl) {
            return;
        }
        HttpURLConnection httpURLConnection = null;
        if (object instanceof HttpURLConnection) {
            try {
                httpURLConnection = (HttpURLConnection)object;
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception while casting HTTPCall Object {} ", exception);
                return;
            }
        }
        requestIdentifier.beginHTTPStatus();
        String string = httpURLConnection.getURL().toString();
        try {
            int n = httpURLConnection.getResponseCode();
            BTMLog.logger.info("Found status code {} for the GUID : {} & URL : {} ", n, requestIdentifier.getReqGUID(), string);
            if (n >= 400) {
                String string2 = httpURLConnection.getResponseMessage();
                requestIdentifier.updateHTTPStatusCode(n, string2);
            } else {
                requestIdentifier.updateHTTPStatusCode(n);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception while fetching HTTP Status code for the GUID : {} & URL : {} ", (Object)requestIdentifier.getReqGUID(), (Object)string);
            BTMLog.logger.error("Exception for the GUID : {} & URL : {} {}", requestIdentifier.getReqGUID(), string, exception);
        }
        TraceUtils.getAndSetResponseUniqueJvmGuid(httpURLConnection, requestIdentifier, string);
        requestIdentifier.endHTTPStatus();
    }

    public static HashMap<String, String> getHttpCallInfo(Object object, RequestIdentifier requestIdentifier) {
        Object object2;
        Object object3;
        Object object4;
        String string;
        if (requestIdentifier == null || object == null) {
            return null;
        }
        if (!(object instanceof HttpURLConnection)) {
            return null;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)object;
        URL uRL = httpURLConnection.getURL();
        String string2 = uRL.toString();
        String string3 = httpURLConnection.getRequestMethod();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        boolean bl2 = OtherAPMTestConfiguration.isFlowTestRunning();
        boolean bl3 = false;
        Class<?> clazz = object.getClass();
        try {
            while (!bl3 && (string = clazz.getName()) != null) {
                if (string.equals("sun.net.www.protocol.http.HttpURLConnection")) {
                    try {
                        object4 = clazz.getDeclaredField("connecting");
                        ((Field)object4).setAccessible(true);
                        object3 = ((Field)object4).get(object);
                        object2 = (Boolean)object3;
                        if (((Boolean)object2).booleanValue()) {
                            ((Field)object4).setBoolean(object, false);
                            BTMLog.logger.debug(" Successfully modified : {}  field as false for the Class Name {} ", (Object)"connecting", (Object)string);
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (Exception exception) {
                        BTMLog.logger.warn("Exception occured while modifing : {} {} ", (Object)"connecting", (Object)exception.getMessage());
                    }
                } else if (string.equals("java.net.URLConnection") || string.equals("java.lang.Object")) {
                    bl3 = true;
                    object4 = clazz.getDeclaredField("connected");
                    ((Field)object4).setAccessible(true);
                    object3 = ((Field)object4).get(object);
                    object2 = (Boolean)object3;
                    bl = !((Boolean)object2).booleanValue();
                    BTMLog.logger.debug("{} {} for the Arguments : {} {} {}  ", "connected", object3, object, bl, requestIdentifier);
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception occured when retriving {} for the Arguments : {} {} {} {} ", "connected", object, bl, requestIdentifier, exception);
        }
        BTMLog.logger.debug("[TraceUtils - getHttpCallInfo] is already not connected ? {} ", (Object)bl);
        if (bl) {
            String string4;
            block29: {
                String string5;
                string = httpURLConnection.getRequestProperty("eG-GUID");
                if (string == null || string.trim().length() == 0) {
                    string = MethodEventProcessor.getInComingGUID();
                }
                if (string == null) {
                    hashMap.put("EXTURL", string2);
                    hashMap.put("METHOD", string3);
                    if (bl2) {
                        hashMap.put("TFT_KEY", uRL.toString());
                    }
                    BTMLog.logger.debug("[TraceUtils - getHttpCallInfo] guidString is null, returning {} ", (Object)hashMap);
                    return hashMap;
                }
                object4 = string.substring(0, string.lastIndexOf("#~#"));
                object3 = string.substring(string.lastIndexOf("#~#") + 3);
                object2 = requestIdentifier.getHttpCallCounter();
                if (object2 == null) {
                    if (object3 != null) {
                        string4 = (String)object3 + ".1";
                        requestIdentifier.setHttpCallCounter(string4, string2);
                    }
                    object2 = requestIdentifier.getHttpCallCounter();
                    BTMLog.logger.debug("[TraceUtils - getHttpCallInfo] current nodeOrderString is null, so assigning : {} ", object2);
                } else {
                    BTMLog.logger.debug("[TraceUtils - getHttpCallInfo] current nodeOrderString is : {} ", object2);
                    string4 = ((String)object2).substring(((String)object2).lastIndexOf(".") + 1);
                    string5 = ((String)object2).substring(0, ((String)object2).lastIndexOf("."));
                    try {
                        int n = Integer.parseInt(string4);
                        object2 = string5 + "." + ++n;
                    }
                    catch (Exception exception) {
                        BTMLog.logger.error("[TraceUtils - getHttpCallInfo] Exception Occured {} ", exception);
                    }
                }
                try {
                    string4 = (String)object4 + "#~#" + (String)object2;
                    httpURLConnection.setRequestProperty("eG-GUID", string4);
                    requestIdentifier.setHttpCallCounter((String)object2, string2);
                    hashMap.put("NODE_ORDER", (String)object2);
                    BTMLog.logger.debug(" Added Successfully tag and follow header : {} ", (Object)string4);
                    hashMap.put("HTTP", "HTTP");
                    try {
                        if (bl2) {
                            hashMap.put("TFT_KEY", uRL.toString());
                        }
                    }
                    catch (Exception exception) {
                        BTMLog.logger.error("Error occured while adding TFT details on the HTTP Headers !!! {} ", exception);
                    }
                }
                catch (Throwable throwable) {
                    string5 = throwable.getMessage();
                    if (!string5.equals("Already connected")) break block29;
                    hashMap.put("CONNECTED", "ALREADY");
                }
            }
            hashMap.put("EXTURL", string2);
            hashMap.put("METHOD", string3);
            if (!hashMap.containsKey("NODE_ORDER") && requestIdentifier != null && (string4 = requestIdentifier.getHttpCallCounter()) != null) {
                hashMap.put("NODE_ORDER", requestIdentifier.getHttpCallCounter());
            }
        } else {
            string = requestIdentifier.getHttpCallCounter();
            BTMLog.logger.debug("[TraceUtils - getHttpCallInfo] Already HTTP Connection is established !!! {} ", (Object)string);
        }
        BTMLog.logger.debug("[TraceUtils - getHttpCallInfo] Final Result : {} {} ", (Object)hashMap, (Object)bl);
        return hashMap;
    }

    public static Map getApacheHttpCallInfo(Object object, Object object2, RequestIdentifier requestIdentifier) {
        Object object3;
        if (object2 == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = DASH;
        String string2 = DASH;
        Class<?> clazz = object2.getClass();
        String string3 = null;
        boolean bl = OtherAPMTestConfiguration.isFlowTestRunning();
        try {
            Object object4;
            GenericDeclaration genericDeclaration;
            object3 = clazz.getMethod("getMethod", new Class[0]);
            ((Method)object3).setAccessible(true);
            string2 = (String)((Method)object3).invoke(object2, ARGS);
            if (object == null) {
                genericDeclaration = clazz.getMethod("getURI", new Class[0]);
                ((Method)genericDeclaration).setAccessible(true);
                object4 = ((Method)genericDeclaration).invoke(object2, ARGS);
                string = object4.toString();
                if (bl) {
                    TraceUtils.updateHostIpDetails(object4, "getHost", "getPort", "getScheme", hashMap);
                }
            } else {
                genericDeclaration = object.getClass();
                object4 = ((Class)genericDeclaration).getMethod("toURI", new Class[0]);
                ((Method)object4).setAccessible(true);
                Object object5 = ((Method)object4).invoke(object, ARGS);
                string = object5.toString();
                if (bl) {
                    TraceUtils.updateHostIpDetails(object5, "getHostName", "getPort", "getSchemeName", hashMap);
                }
            }
            genericDeclaration = clazz.getMethod("containsHeader", String.class);
            ((Method)genericDeclaration).setAccessible(true);
            boolean bl2 = (Boolean)((Method)genericDeclaration).invoke(object2, new String("eG-GUID"));
            string3 = bl2 ? TraceUtils.getEgGuidFromHeader(object2, "eG-GUID") : MethodEventProcessor.getInComingGUID();
        }
        catch (Exception exception) {
            BTMLog.logger.error("[TraceUtils - getApacheHttpCallInfo] Exception Occured {} ", exception);
        }
        if (string3 == null) {
            hashMap.put("EXTURL", string);
            hashMap.put("METHOD", string2);
            return hashMap;
        }
        TraceUtils.addEgGuidToRequestHeader(string3, object2, hashMap, ARGS, string, string2, requestIdentifier, clazz, ADD_HEADER, bl);
        hashMap.put("EXTURL", string);
        hashMap.put("METHOD", string2);
        if (!hashMap.containsKey("NODE_ORDER") && requestIdentifier != null && (object3 = requestIdentifier.getHttpCallCounter()) != null) {
            hashMap.put("NODE_ORDER", requestIdentifier.getHttpCallCounter());
        }
        return hashMap;
    }

    private static void updateHostIpDetails(Object object, String string, String string2, String string3, HashMap hashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, ARGS);
            String string4 = (String)object2;
            Method method2 = clazz.getMethod(string2, new Class[0]);
            method2.setAccessible(true);
            Object object3 = method2.invoke(object, ARGS);
            Integer n = (Integer)object3;
            int n2 = n;
            Method method3 = clazz.getMethod(string3, new Class[0]);
            method3.setAccessible(true);
            Object object4 = method3.invoke(object, ARGS);
            String string5 = (String)object4;
            if (n2 < 0) {
                stringBuffer.append(string5).append("://").append(string4);
            } else {
                stringBuffer.append(string5).append("://").append(string4).append(":").append(n2);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("[TraceUtils - updateHostIpDetails] Exception Occured {} ", exception);
        }
        hashMap.put("TFT_KEY", stringBuffer.toString());
    }

    public static Map getApacheHttpCommonCallInfo(Object object, RequestIdentifier requestIdentifier) {
        Object object2;
        if (requestIdentifier == null || object == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = DASH;
        String string2 = DASH;
        Class<?> clazz = object.getClass();
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = OtherAPMTestConfiguration.isFlowTestRunning();
        try {
            object2 = clazz.getMethod("getName", new Class[0]);
            ((Method)object2).setAccessible(true);
            string2 = (String)((Method)object2).invoke(object, ARGS);
            Method method = clazz.getMethod("getURI", new Class[0]);
            method.setAccessible(true);
            Object object3 = method.invoke(object, ARGS);
            string = object3.toString();
            if (bl) {
                TraceUtils.updateHostIpDetails(object3, "getHost", "getPort", "getScheme", hashMap);
            }
            Method method2 = clazz.getMethod("getRequestHeaders", String.class);
            method2.setAccessible(true);
            Object[] objectArray = (Object[])method2.invoke(object, new String("eG-GUID"));
            if (objectArray.length != 0) {
                Class<?> clazz2 = objectArray[0].getClass();
                Method method3 = clazz2.getMethod("getValue", new Class[0]);
                method3.setAccessible(true);
                string3 = (String)method3.invoke(objectArray[0], ARGS);
            }
            if (string3 == null || string3.trim().length() == 0) {
                string3 = MethodEventProcessor.getInComingGUID();
            }
            if (string3 == null) {
                hashMap.put("EXTURL", string);
                hashMap.put("METHOD", string2);
                return hashMap;
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("[TraceUtils - getApacheHttpCommonCallInfo] Exception Occured {} ", exception);
        }
        TraceUtils.addEgGuidToRequestHeader(string3, object, hashMap, ARGS, string, string2, requestIdentifier, clazz, ADD_REQUEST_HEADER, bl);
        hashMap.put("EXTURL", string);
        hashMap.put("METHOD", string2);
        if (!hashMap.containsKey("NODE_ORDER") && requestIdentifier != null && (object2 = requestIdentifier.getHttpCallCounter()) != null) {
            hashMap.put("NODE_ORDER", object2);
        }
        return hashMap;
    }

    private static void addEgGuidToRequestHeader(String string, Object object, HashMap hashMap, Object[] objectArray, String string2, String string3, RequestIdentifier requestIdentifier, Class clazz, String string4, boolean bl) {
        try {
            Object object2;
            String string5;
            String string6 = string.substring(0, string.lastIndexOf("#~#"));
            String string7 = string.substring(string.lastIndexOf("#~#") + 3);
            String string8 = requestIdentifier.getHttpCallCounter();
            if (string8 == null) {
                if (string7 != null) {
                    string5 = string7 + ".1";
                    requestIdentifier.setHttpCallCounter(string5, string2);
                }
                string8 = requestIdentifier.getHttpCallCounter();
            } else {
                string5 = string8.substring(string8.lastIndexOf(".") + 1);
                object2 = string8.substring(0, string8.lastIndexOf("."));
                try {
                    int n = Integer.parseInt(string5);
                    string8 = (String)object2 + "." + ++n;
                }
                catch (Exception exception) {
                    BTMLog.logger.error("[TraceUtils - addEgGuidToRequestheader] Exception Occured {} ", exception);
                }
            }
            try {
                string5 = string6 + "#~#" + string8;
                object2 = clazz.getMethod(string4, String.class, String.class);
                ((Method)object2).setAccessible(true);
                Object object3 = ((Method)object2).invoke(object, new String("eG-GUID"), new String(string5));
                requestIdentifier.setHttpCallCounter(string8, string2);
                hashMap.put("NODE_ORDER", string8);
                BTMLog.logger.debug(" Added Successfully tag and follow header :{}", (Object)string5);
            }
            catch (Throwable throwable) {
                object2 = throwable.getMessage();
                if (((String)object2).equals("Already connected")) {
                    hashMap.put("CONNECTED", "ALREADY");
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("[TraceUtils - addEgGuidToRequestheader] Exception Occured {}", exception);
        }
    }

    private static String getEgGuidFromHeader(Object object, String string) {
        Class<?> clazz = object.getClass();
        String string2 = null;
        try {
            Method method = clazz.getMethod("getHeaders", String.class);
            method.setAccessible(true);
            Object[] objectArray = (Object[])method.invoke(object, new String(string));
            Class<?> clazz2 = objectArray[0].getClass();
            Method method2 = clazz2.getMethod("getValue", new Class[0]);
            method2.setAccessible(true);
            string2 = (String)method2.invoke(objectArray[0], ARGS);
        }
        catch (Exception exception) {
            BTMLog.logger.error(" [TraceUtils - getEgGuidFromHeader] Exception Occured {} ", exception);
        }
        return string2;
    }

    public static HashMap getAxisCallInfo(Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Class<?> clazz = null;
        Object object2 = DASH;
        String string = DASH;
        try {
            clazz = object.getClass();
            Method method = clazz.getMethod("getTargetEndpointAddress", new Class[0]);
            method.setAccessible(true);
            object2 = method.invoke(object, ARGS);
            if (object2 == null) {
                object2 = DASH;
            }
            if (OtherAPMTestConfiguration.isFlowTestRunning()) {
                hashMap.put("TFT_KEY", object2);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("[TraceUtils - getAxisCallInfo] Exception Occured {} ", exception);
        }
        hashMap.put("OperationName", string.toString());
        hashMap.put("TargetUrl", object2.toString());
        BTMLog.logger.debug(" getAxisCallInfo :{}", (Object)hashMap);
        return hashMap;
    }

    public static HashMap requestDetails(Object object, Object object2) {
        Class<?> clazz = null;
        try {
            clazz = object.getClass();
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception while getting the Class Object using reflection {} ", exception);
            return null;
        }
        Object object3 = TraceUtils.invokeRequestMethod(object, clazz, REQUEST_METHODS[0], DASH);
        boolean[] blArray = TraceUtils.isAttributeExists(object, clazz, ERROR_STATUS_CODE);
        if (blArray[0]) {
            String string = Thread.currentThread().getName() + "." + Thread.currentThread().getId();
            BTMLog.logger.warn("Status code 404 Found for the URL :" + object3.toString() + "  Thread ID :" + string);
            StatusCodeUtils.update404Counter(0.0, 1.0);
            return null;
        }
        try {
            for (Object object4 : PropsManager.getExcludeCharsList()) {
                if (object3.toString().indexOf((String)object4) <= -1) continue;
                BTMLog.logger.debug("Excluded character is found in the Request URI, Hence not tracing this request. URI is : {}  \t Excluded charater is {} ", (Object)object3.toString(), object4);
                return null;
            }
            for (Object object5 : PropsManager.autoFilteredPatternsList) {
                boolean bl = BTMUtils.patternMatch(object3.toString(), (String)object5);
                if (!bl) continue;
                BTMLog.logger.debug("Excluded pattern from Business Transaction Test is found in the Request URI, Hence not tracing this request. URI is : {} \t Excluded pattern is {} ", (Object)object3.toString(), object5);
                return null;
            }
            for (String string : PropsManager.manualFilteredPatternsList) {
                boolean bl = BTMUtils.patternMatch(object3.toString(), string);
                if (!bl) continue;
                BTMLog.logger.debug("Excluded pattern from Key Business Transaction Test is found in the Request URI, Hence not tracing this request. URI is : {} \t Excluded pattern is {} ", (Object)object3.toString(), (Object)string);
                return null;
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception while exclude pattern and exclude char check {} ", exception);
        }
        HashMap hashMap = new HashMap();
        try {
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object5;
            Object object4;
            object4 = TraceUtils.invokeRequestMethod(object, clazz, REQUEST_METHODS[1], UNKNOWN_HOST);
            object5 = TraceUtils.invokeRequestMethod(object, clazz, REQUEST_METHODS[2], DASH);
            Object object12 = TraceUtils.invokeRequestMethod(object, clazz, REQUEST_METHODS[3], DASH);
            Object object13 = TraceUtils.invokeRequestMethod(object, clazz, REQUEST_METHODS[4], DASH);
            Object object14 = TraceUtils.invokeRequestMethod(object, clazz, REQUEST_METHODS[5], DASH);
            if (STATUS_CHECK.get(object13) == null) {
                object11 = TraceUtils.invokeRequestMethod(object, clazz, REQUEST_METHODS[6], DASH);
                if (object11.equals(DASH)) {
                    STATUS_CHECK.put(object13, Boolean.FALSE);
                } else {
                    STATUS_CHECK.put(object13, Boolean.TRUE);
                }
            }
            object11 = clazz.getMethod("getHeader", String.class);
            ((Method)object11).setAccessible(true);
            Object object15 = ((Method)object11).invoke(object, "eG-GUID");
            if (object15 == null) {
                object15 = ((Method)object11).invoke(object, "eg-guid");
            }
            Object object16 = ((Method)object11).invoke(object, "EGRUM");
            Object object17 = null;
            boolean bl = PropsManager.captureHttpHeadersDetails();
            boolean bl2 = PropsManager.captureHttpCookiesDetails();
            if (bl || bl2) {
                object10 = clazz.getMethod("getHeaderNames", new Class[0]);
                ((Method)object10).setAccessible(true);
                Object object18 = ((Method)object10).invoke(object, ARGS);
                object9 = new Hashtable();
                if (object18 != null) {
                    object8 = (Enumeration)object18;
                    if (bl && bl2) {
                        while (object8.hasMoreElements()) {
                            object7 = (String)object8.nextElement();
                            object6 = ((Method)object11).invoke(object, object7);
                            ((Hashtable)object9).put(object7, object6);
                        }
                    } else if (bl) {
                        while (object8.hasMoreElements()) {
                            object7 = (String)object8.nextElement();
                            if (((String)object7).equalsIgnoreCase("cookie")) continue;
                            object6 = ((Method)object11).invoke(object, object7);
                            ((Hashtable)object9).put(object7, object6);
                        }
                    } else {
                        while (object8.hasMoreElements()) {
                            object7 = (String)object8.nextElement();
                            if (!((String)object7).equalsIgnoreCase("cookie") && !((String)object7).equalsIgnoreCase("referer")) continue;
                            object6 = ((Method)object11).invoke(object, object7);
                            ((Hashtable)object9).put(object7, object6);
                        }
                    }
                    object17 = ((Hashtable)object9).remove("referer");
                }
                hashMap.put("HEADERS", object9);
            } else {
                object17 = ((Method)object11).invoke(object, "referer");
            }
            TraceUtils.updateUserAgentHeaderAndXForwardDetails(bl, hashMap, object);
            if (object16 != null && ((String)(object10 = object16.toString())).equals("isAjax:true")) {
                hashMap.put("AJAX", "true");
            }
            boolean bl3 = (object10 = (Object)TraceUtils.isAttributeExists(object, clazz, ERROR_EXCEPTION))[1] != false || blArray[1];
            hashMap.put("REDIRECTED_ERROR_PAGE", bl3);
            if (object15 != null) {
                TraceUtils.addUniqueJvmGuidToResponseHeader(object2);
                object9 = object15.toString();
                if (bl3) {
                    object9 = (String)object9 + ".E.1";
                    BTMLog.logger.debug("Given HTTP Request is ErrorPage Redirect Page, So adding GUID with '.E'  {}", object9);
                }
                hashMap.put("eG-GUID", object9);
            }
            if (object17 == null) {
                object17 = DASH;
            }
            object9 = new StringBuilder();
            ((StringBuilder)object9).append(Thread.currentThread().getName()).append("[").append(Thread.currentThread().getId()).append("]");
            hashMap.put("QUERYSTRING", object5);
            hashMap.put("THREAD", ((StringBuilder)object9).toString());
            hashMap.put("SESSIONID", object12);
            hashMap.put("CONTEXT", object13.toString());
            hashMap.put("REFERER", object17);
            hashMap.put("DEVICE", DASH);
            hashMap.put("OS", DASH);
            hashMap.put("BROWSER", DASH);
            hashMap.put("METHODTYPE", object14);
            object8 = object3.toString();
            TraceUtils.updateMatchedURLPattern((String)object8, hashMap, object5);
            object7 = new Date();
            object6 = BTM_DATE_FORMAT.format((Date)object7);
            String string = TraceUtils.getUTC((Date)object7);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object3.toString()).append(" @ ").append((String)object6);
            hashMap.put("requestID", stringBuilder.toString());
            hashMap.put("Thread_GUID", DASH);
            hashMap.put("RequestURI", object3.toString());
            hashMap.put("remoteHost", object4);
            hashMap.put("UTC", string);
        }
        catch (SecurityException securityException) {
            BTMLog.logger.error("[TraceUtils - requestDetails] SecurityException Occured {}", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            BTMLog.logger.error("[TraceUtils - requestDetails] NoSuchMethodException Occured {}", noSuchMethodException);
        }
        catch (Exception exception) {
            BTMLog.logger.error("[TraceUtils - requestDetails] Exception Occured {}", exception);
        }
        BTMLog.logger.debug("NEW REQUEST FOUND !!! Details =  :{}", (Object)hashMap);
        return hashMap;
    }

    private static void updateUserAgentHeaderAndXForwardDetails(boolean bl, HashMap hashMap, Object object) {
        String string = PropsManager.getRemoteAddressHeaderName();
        if (!bl) {
            String string2;
            Object object2;
            Object object3 = TraceUtils.getRequestHeaderValue(object, string);
            if (object3 != null) {
                hashMap.put("REMOTE_ADDRESS_HEADER_VALUE", object3);
            }
            if ((object2 = TraceUtils.getRequestHeaderValue(object, string2 = "User-Agent".toLowerCase())) != null) {
                hashMap.put(string2, object2);
            }
        }
        hashMap.put("REMOTE_ADDRESS_HEADER_NAME", string);
    }

    private static boolean[] isAttributeExists(Object object, Class clazz, String string) {
        boolean[] blArray = new boolean[]{false, false};
        try {
            Method method = clazz.getMethod(REQUEST_METHODS[7], String.class);
            method.setAccessible(true);
            Object object2 = method.invoke(object, (Object[])new String[]{string});
            if (object2 != null) {
                if (string.equals(ERROR_STATUS_CODE)) {
                    Integer n = (Integer)object2;
                    int n2 = n;
                    if (n2 == 404) {
                        blArray[0] = true;
                    } else if (n2 >= 200 && n2 < 600) {
                        blArray[1] = true;
                    }
                } else {
                    blArray[1] = true;
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception occured while invoking  {} :  with attribute {} ", (Object)REQUEST_METHODS[7], (Object)ERROR_STATUS_CODE);
            BTMLog.logger.error("", exception);
            return blArray;
        }
        return blArray;
    }

    private static Object invokeRequestMethod(Object object, Class clazz, String string, String string2) {
        Object object2 = null;
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            method.setAccessible(true);
            object2 = method.invoke(object, ARGS);
            if (object2 == null) {
                object2 = string2;
            }
        }
        catch (Exception exception) {
            object2 = string2;
        }
        return object2;
    }

    private static Object invokeRequestField(Object object, Class clazz, String string, String string2) {
        Object object2 = null;
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            object2 = field.get(object);
            if (object2 == null) {
                object2 = string2;
            }
        }
        catch (Exception exception) {
            object2 = string2;
        }
        return object2;
    }

    public static String getResponseContentType(Object object, String string) {
        String string2 = "";
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getMethod("getContentType", new Class[0]);
            method.setAccessible(true);
            string2 = (String)method.invoke(object, ARGS);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Couldn't find ContentType of the URL : {} {} ", (Object)string, (Object)exception);
        }
        return string2;
    }

    public static Object getResponseDetails(Object object) {
        Object object2 = null;
        Class<?> clazz = null;
        try {
            clazz = object.getClass();
            Method method = clazz.getMethod("getStatus", new Class[0]);
            method.setAccessible(true);
            object2 = method.invoke(object, ARGS);
        }
        catch (SecurityException securityException) {
            BTMLog.logger.error("[TraceUtils - responseDetails] SecurityException Occured {} ", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            BTMLog.logger.error("[TraceUtils - responseDetails] NoSuchMethodException Occured {} ", noSuchMethodException);
        }
        catch (Exception exception) {
            BTMLog.logger.error("[TraceUtils - responseDetails] Exception Occured {} ", exception);
        }
        return object2;
    }

    public static boolean getStatusTable(String string) {
        boolean bl = STATUS_CHECK.get(string);
        return bl;
    }

    private static String getPatternName(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            int n = stringTokenizer.countTokens();
            String string2 = string;
            if (n <= PropsManager.getURLLevel()) {
                int n2 = string2.indexOf(";jsessionid=");
                if (n2 > 0) {
                    string2 = string2.substring(0, n2);
                }
            } else {
                int n3;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("/");
                for (n3 = 0; n3 < PropsManager.getURLLevel(); ++n3) {
                    stringBuffer.append(stringTokenizer.nextToken());
                    stringBuffer.append("/");
                }
                string2 = stringBuffer.toString();
                n3 = string2.indexOf(";jsessionid=");
                if (n3 > 0) {
                    string2 = string2.substring(0, n3);
                }
            }
            return string2;
        }
        return string;
    }

    public static HashMap jbossEjbExitDetails(Object object, Object object2, Object object3, RequestIdentifier requestIdentifier) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object object4 = null;
        try {
            Class<?> clazz = object2.getClass();
            Method method = clazz.getMethod("getInvokedMethod", new Class[0]);
            method.setAccessible(true);
            Object object5 = method.invoke(object2, ARGS);
            Method method2 = clazz.getMethod("getContextData", new Class[0]);
            method2.setAccessible(true);
            Object object6 = method2.invoke(object2, ARGS);
            Class<?> clazz2 = object3.getClass();
            Method method3 = clazz2.getMethod("getEjbReceiverContext", new Class[0]);
            method3.setAccessible(true);
            Object object7 = method3.invoke(object3, ARGS);
            Class<?> clazz3 = object.getClass();
            Field field = clazz3.getDeclaredField("channelAssociations");
            field.setAccessible(true);
            Object object8 = field.get(object);
            if (object8 instanceof Map) {
                Map map = (Map)object8;
                Object v = map.get(object7);
                Class<?> clazz4 = v.getClass();
                Field field2 = clazz4.getDeclaredField("channel");
                field2.setAccessible(true);
                object4 = field2.get(v);
            }
            if (object5 != null && object4 != null) {
                hashMap.put("method", object5.toString());
                hashMap.put("ejbhost", object4.toString());
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("Error occured while getting jboss ejb exit point cut details... {} ", exception);
        }
        return hashMap;
    }

    public static HashMap weblogicEjbExitDetails(Object object, Object object2, RequestIdentifier requestIdentifier) {
        HashMap<String, String> hashMap = null;
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        Object object6 = null;
        if (string.equals("weblogic.rmi.internal.BasicRemoteRef") || string.equals("weblogic.rmi.internal.activation.ActivatableRemoteRef") || string.equals("weblogic.rmi.cluster.ClusterableRemoteRef")) {
            try {
                hashMap = new HashMap<String, String>();
                Method method = clazz.getMethod("getChannel", new Class[0]);
                method.setAccessible(true);
                object3 = method.invoke(object, ARGS);
                Class<?> clazz2 = object3.getClass();
                Method method2 = clazz2.getMethod("getInetAddress", new Class[0]);
                method2.setAccessible(true);
                Object object7 = method2.invoke(object3, ARGS);
                Method method3 = clazz2.getMethod("getPublicPort", new Class[0]);
                method3.setAccessible(true);
                object4 = method3.invoke(object3, ARGS);
                Method method4 = clazz2.getMethod("getProtocolPrefix", new Class[0]);
                method4.setAccessible(true);
                object5 = method4.invoke(object3, ARGS);
                Class<?> clazz3 = object7.getClass();
                Method method5 = clazz3.getMethod("getHostAddress", new Class[0]);
                method5.setAccessible(true);
                object6 = method5.invoke(object7, ARGS);
            }
            catch (Exception exception) {
                BTMLog.logger.error("Error occured while getting weblogic ejb exit point cut details... {} ", exception);
            }
            if (object5 != null && object6 != null && object4 != null) {
                hashMap.put("method", object2.toString());
                hashMap.put("ejbhost", object5 + "://" + object6 + ":" + object4);
            } else if (object3 != null) {
                hashMap.put("method", object2.toString());
                hashMap.put("ejbhost", object3.toString());
            }
        }
        return hashMap;
    }

    public static HashMap websphereEjbExitDetails(Object object, Object object2, RequestIdentifier requestIdentifier) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Class<?> clazz = object2.getClass();
            Method method = clazz.getMethod("target", new Class[0]);
            method.setAccessible(true);
            Object object3 = method.invoke(object2, ARGS);
            Method method2 = clazz.getMethod("operation", new Class[0]);
            method2.setAccessible(true);
            Object object4 = method2.invoke(object2, ARGS);
            Method method3 = clazz.getMethod("getConnectionData", new Class[0]);
            method3.setAccessible(true);
            Object object5 = method3.invoke(object2, ARGS);
            Class<?> clazz2 = object5.getClass();
            Method method4 = clazz2.getMethod("getRemoteHost", new Class[0]);
            method4.setAccessible(true);
            Object object6 = method4.invoke(object5, ARGS);
            InetAddress inetAddress = InetAddress.getByName(object6.toString());
            String string = inetAddress.getHostAddress();
            Method method5 = clazz2.getMethod("getRemotePort", new Class[0]);
            method5.setAccessible(true);
            Object object7 = method5.invoke(object5, ARGS);
            if (object3 != null && object4 != null && string != null) {
                hashMap.put("ejbhost", "//" + string + ":" + object7);
                hashMap.put("method", object3.getClass().getName().toString() + "." + object4.toString() + "()");
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("Error occured while getting websphere ejb exit point cut details.. {} ", exception);
        }
        return hashMap;
    }

    private static String getNodeOrderDetails(RequestIdentifier requestIdentifier, String string) {
        String string2 = requestIdentifier.getReqGUID();
        String string3 = string2.substring(string2.lastIndexOf("#~#") + 3);
        String string4 = requestIdentifier.getHttpCallCounter();
        if (string4 != null && string4.length() > 0) {
            String string5 = string4.substring(string4.lastIndexOf(".") + 1);
            String string6 = string4.substring(0, string4.lastIndexOf("."));
            try {
                int n = Integer.parseInt(string5);
                string4 = string6 + "." + ++n;
                requestIdentifier.setHttpCallCounter(string4, string);
            }
            catch (Exception exception) {
                BTMLog.logger.error("[TraceUtils.nodeOrderAndExtraDetails] Exception Occured {} ", exception);
            }
        } else {
            if (string3 != null) {
                String string7 = string3 + ".1";
                requestIdentifier.setHttpCallCounter(string7, string);
            }
            string4 = requestIdentifier.getHttpCallCounter();
        }
        return string4;
    }

    public static final String transmitGUIDandJMSDetails(Object object, RequestIdentifier requestIdentifier, String string, String string2, String string3) {
        String string4 = null;
        try {
            Class<?> clazz = object.getClass().getSuperclass();
            String string5 = requestIdentifier.getReqGUID();
            String string6 = string5.substring(0, string5.lastIndexOf("#~#"));
            String string7 = "Async_Listener_" + string2;
            string4 = TraceUtils.getNodeOrderDetails(requestIdentifier, string7);
            String string8 = string6 + "#~#" + string4;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string8).append("^@^");
            stringBuilder.append(string7).append("^@^");
            stringBuilder.append(string).append("^@^");
            stringBuilder.append(string2).append("^@^");
            if (string3.equalsIgnoreCase("producer")) {
                stringBuilder.append("consumer");
            } else {
                stringBuilder.append("subscriber");
            }
            String string9 = stringBuilder.toString();
            Method method = clazz.getMethod("setStringProperty", String.class, String.class);
            method.setAccessible(true);
            method.invoke(object, "eGGUID", string9);
            BTMLog.logger.debug("Added Successfully GUID details to the JMS message property {}", (Object)string9);
            return string4;
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception occured while adding GUID details to JMS Message {} ", exception);
            return null;
        }
    }

    private static String getJMSTagDetails(Object object) {
        Class<?> clazz = object.getClass().getSuperclass();
        String string = null;
        try {
            Method method = clazz.getMethod("getStringProperty", String.class);
            method.setAccessible(true);
            string = (String)method.invoke(object, new String("eGGUID"));
            BTMLog.logger.debug("Successfully fetched JMS tag from the JMS message : {} ", (Object)string);
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception Occured while fetching JMS tag from the JMS message {}", exception);
            return string;
        }
        return string;
    }

    public static HashMap getJmsEntryRequestDetails(Object object, Object object2) {
        String string = TraceUtils.getJMSTagDetails(object2);
        HashMap hashMap = new HashMap();
        BTMLog.logger.debug("JMS Entry  - JMS tag details : {}", (Object)string);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "^@^");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            TraceUtils.createJmsEntryPropsDetails(hashMap, string2, string3, string4, string5, string6);
        } else {
            try {
                Object object3 = TraceUtils.invokeRequestMethod(object2, object2.getClass(), "getJMSDestination", DASH);
                BTMLog.logger.info("JMS Entry  - JMS tag details not found for Destination : {} ", object3);
                String string7 = TraceUtils.getJMSType(object3);
                String string8 = object3.toString();
                String string9 = "Async_Listener_" + string8;
                String string10 = object2.getClass().getName();
                String string11 = DASH;
                if (string10 != null && string10.indexOf("activemq") >= 0) {
                    string11 = "ActiveMQ";
                }
                TraceUtils.createJmsEntryPropsDetails(hashMap, null, string9, string11, string8, string7);
            }
            catch (Exception exception) {
                BTMLog.logger.error(" Exception Occured while retrieving JMS destination {} ", exception);
            }
        }
        return hashMap;
    }

    private static final String getJMSType(Object object) {
        String string = "CONSUMER";
        if (object != null) {
            ClassLoader classLoader = object.getClass().getClassLoader();
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass("javax.jms.Topic");
                boolean bl = clazz.isInstance(object);
                if (bl) {
                    string = "SUBSCRIBER";
                }
            }
            catch (Throwable throwable) {
                BTMLog.logger.error(" Exception occured while finding JMS Type for the Destination Obj {} - {}", object, (Object)throwable);
            }
        }
        return string;
    }

    private static void createJmsEntryPropsDetails(HashMap hashMap, String string, String string2, String string3, String string4, String string5) {
        if (string != null) {
            hashMap.put("eG-GUID", string + "." + BTMOffLoadConfig.getNodeID() + "!~!" + TraceUtils.getRandomString());
        }
        String string6 = Thread.currentThread().getName() + "[" + Thread.currentThread().getId() + "]";
        Date date = new Date();
        String string7 = BTM_DATE_FORMAT.format(date);
        String string8 = TraceUtils.getUTC(date);
        hashMap.put("requestID", " -  @ " + string7);
        hashMap.put("UTC", string8);
        hashMap.put("THREAD", string6);
        hashMap.put("RequestURI", string2);
        hashMap.put("JMS-PROVIDER", string3);
        hashMap.put("JMS-QUEUE", string4);
        hashMap.put("TYPE", string5);
        hashMap.put("MATCH", string2);
        TraceUtils.configureDefaultProperties(hashMap, "JMS_ENTRY");
    }

    public static final String[] getMuleJMSDetails(Object object, Object object2, RequestIdentifier requestIdentifier) {
        try {
            Class<?> clazz = object2.getClass();
            Method method = clazz.getMethod("getConnection", new Class[0]);
            method.setAccessible(true);
            Object object3 = method.invoke(object2, ARGS);
            String string = requestIdentifier.getProviderName(object3);
            if (string != null && string.equals(DASH)) {
                string = TraceUtils.getJMSProvider(object3);
            }
            if (string != null && !string.equals(DASH)) {
                requestIdentifier.addProviderName(object3, string);
                Class<?> clazz2 = object.getClass();
                Method method2 = clazz2.getMethod("getDestination", new Class[0]);
                method2.setAccessible(true);
                Object object4 = method2.invoke(object, ARGS);
                String[] stringArray = TraceUtils.getJMSData(object, object4, string, true);
                requestIdentifier.addJMSDetails(object, stringArray);
                return stringArray;
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception occured in the method getMuleJMSDetails {} ", exception);
        }
        return null;
    }

    public static final String getJMSProvider(Object object) {
        String string = DASH;
        if (object != null) {
            try {
                Object object2 = TraceUtils.invokeRequestMethod(object, object.getClass(), "getMetaData", DASH);
                Object object3 = TraceUtils.invokeRequestMethod(object2, object2.getClass(), "getJMSProviderName", DASH);
                if (object3 != null) {
                    string = object3.toString();
                }
            }
            catch (Exception exception) {
                BTMLog.logger.error(" Exception occured while getting details from JMS connection object {} ", exception);
            }
        }
        return string;
    }

    public static final String[] getJMSData(Object object, Object object2, String string, boolean bl) {
        Class<?> clazz = object.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        String string2 = DASH;
        String string3 = DASH;
        if (object2 != null) {
            string3 = object2.toString();
        }
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        Class<?> clazz4 = null;
        Class<?> clazz5 = null;
        try {
            clazz2 = classLoader.loadClass("javax.jms.Queue");
            boolean bl2 = clazz2.isInstance(object2);
            if (bl2) {
                string2 = bl ? "PRODUCER" : "CONSUMER";
                clazz3 = classLoader.loadClass("javax.jms.TemporaryQueue");
                if (clazz3.isInstance(object2)) {
                    string3 = "TEMP-QUEUE";
                }
            } else {
                clazz4 = classLoader.loadClass("javax.jms.Topic");
                boolean bl3 = clazz4.isInstance(object2);
                if (bl3) {
                    string2 = bl ? "PUBLISHER" : "SUBSCRIBER";
                    clazz5 = classLoader.loadClass("javax.jms.TemporaryTopic");
                    if (clazz5.isInstance(object2)) {
                        string3 = "TEMP-TOPIC";
                    }
                }
            }
        }
        catch (Throwable throwable) {
            BTMLog.logger.error(" Exception occured while finding JMS Type {} ", throwable);
        }
        String[] stringArray = new String[]{string3, string2, string};
        return stringArray;
    }

    private static void configureDefaultProperties(Map map, String string) {
        if ("JMS_ENTRY".equals(string)) {
            map.put("QUERYSTRING", DASH);
            map.put("METHODTYPE", DASH);
            map.put("remoteHost", DASH);
            map.put("CONTEXT", DASH);
        }
        map.put("SESSIONID", DASH);
        map.put("REFERER", DASH);
        map.put("DEVICE", DASH);
        map.put("OS", DASH);
        map.put("BROWSER", DASH);
    }

    public static HashMap getMuleRequestDetails(Object object) {
        Class<?> clazz = object.getClass();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Object object2;
            Method method = clazz.getMethod("getMessage", new Class[0]);
            method.setAccessible(true);
            Object object3 = method.invoke(object, ARGS);
            Method method2 = object3.getClass().getMethod("getInboundProperty", String.class);
            method2.setAccessible(true);
            Object object4 = method2.invoke(object3, new String("eG-GUID"));
            Object object5 = method2.invoke(object3, new String("http.context.path"));
            Object object6 = method2.invoke(object3, new String("http.method"));
            Object object7 = method2.invoke(object3, new String("MULE_REMOTE_CLIENT_ADDRESS"));
            Object object8 = method2.invoke(object3, new String("http.query.string"));
            Object object9 = method2.invoke(object3, new String("http.query.params"));
            Object object10 = method2.invoke(object3, new String("http.request.path"));
            if (PropsManager.captureHttpHeadersDetails()) {
                object2 = method2.invoke(object3, new String("http.headers"));
                hashMap.put("HEADERS", object2 == null ? DASH : (HashMap)object2);
            }
            Object object11 = object9 = object9 == null ? DASH : object9.toString();
            if (object4 != null) {
                hashMap.put("eG-GUID", object4);
            }
            hashMap.put("CONTEXT", object5);
            hashMap.put("METHODTYPE", object6);
            hashMap.put("remoteHost", object7);
            hashMap.put("QUERYSTRING", object6.equals("POST") ? object9 : object8);
            object2 = Thread.currentThread().getName() + "[" + Thread.currentThread().getId() + "]";
            String string = object10.toString();
            Date date = new Date();
            String string2 = BTM_DATE_FORMAT.format(date);
            String string3 = TraceUtils.getUTC(date);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string).append(" @ ").append(string2);
            hashMap.put("UTC", string3);
            hashMap.put("requestID", stringBuilder.toString());
            hashMap.put("RequestURI", string);
            hashMap.put("THREAD", object2);
            TraceUtils.updateMatchedURLPattern(string, hashMap, object8);
            TraceUtils.configureDefaultProperties(hashMap, "MULE");
            BTMLog.logger.debug("NEW MULE REQUEST FOUND !!! Details =  : {} ", (Object)hashMap);
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception occured when collecting details from MULE Request {} ", exception);
            hashMap = null;
        }
        return hashMap;
    }

    private static void updateMatchedURLPattern(String string, HashMap hashMap, Object object) {
        Object object2;
        boolean bl = PropsManager.manualPatternTable.size() > 0;
        boolean bl2 = false;
        if (bl && (object2 = PropsManager.manualPatternTable.keys()).hasMoreElements()) {
            while (object2.hasMoreElements()) {
                String string2 = (String)object2.nextElement();
                boolean bl3 = BTMUtils.patternMatch(string + "?" + object, PropsManager.manualPatternTable.get(string2));
                if (!bl3) continue;
                bl2 = true;
                hashMap.put("MATCH", string2);
                break;
            }
        }
        if (bl2) {
            hashMap.put("KEY_TRANSACTION", "TRUE");
        } else {
            object2 = TraceUtils.getPatternName(string);
            hashMap.put("MATCH", object2);
        }
    }

    public static String getEmailServerAddress(Object object) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod("getURLName", new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, ARGS);
            return object2.toString();
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception Occured in [TraceUtils.getEmailServerAddress] {} ", exception);
            return null;
        }
    }

    public static String partialSTEs2Str(Throwable throwable, int n) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        StringBuilder stringBuilder = new StringBuilder();
        String string = stringWriter.toString().trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = stringTokenizer.countTokens();
        if (n < 1 || n > n2) {
            n = n2;
        }
        String string2 = throwable.getMessage();
        while (stringTokenizer.hasMoreTokens() && n >= 0) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf("...") > -1 && string2.indexOf("...") <= -1 || string3.length() <= 0) continue;
            stringBuilder2.append(string3.trim());
            stringBuilder2.append(ExcpnRowSep);
            --n;
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        return stringBuilder.toString();
    }

    public static String[] getRedisHostPortDetails(Object object, RequestIdentifier requestIdentifier) {
        Class<?> clazz = object.getClass();
        String[] stringArray = null;
        try {
            Method method = clazz.getMethod("getHost", new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, ARGS);
            Method method2 = clazz.getMethod("getPort", new Class[0]);
            method2.setAccessible(true);
            Object object3 = method2.invoke(object, ARGS);
            stringArray = new String[]{object2.toString(), object3.toString()};
            requestIdentifier.addNoSQLConnectionDetails(object, stringArray);
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception Occured in [TraceUtils.getRedisHostPortDetails] {} ", exception);
        }
        return stringArray;
    }

    public static void updateRedisDetails(Object object, String[] stringArray, String string, RequestIdentifier requestIdentifier) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod("getDB", new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, ARGS);
            String string2 = object2.toString();
            RedisCommandInfo redisCommandInfo = new RedisCommandInfo(stringArray[0], stringArray[1], string2, string);
            requestIdentifier.addRedisCommandDetails(redisCommandInfo);
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception Occured in [TraceUtils.updateRedisDetails] {} ", exception);
        }
    }

    public static String[] getMongoHostPortDetails(Object object, RequestIdentifier requestIdentifier) {
        Class<?> clazz = object.getClass();
        String[] stringArray = null;
        try {
            Method method = clazz.getMethod("getDB", new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, ARGS);
            Class<?> clazz2 = object2.getClass();
            Method method2 = clazz2.getMethod("getMongo", new Class[0]);
            method2.setAccessible(true);
            Object object3 = method2.invoke(object2, ARGS);
            Class<?> clazz3 = object3.getClass();
            Method method3 = clazz3.getMethod("getAddress", new Class[0]);
            method3.setAccessible(true);
            Object object4 = method3.invoke(object3, ARGS);
            stringArray = new String[]{object4.toString()};
            requestIdentifier.addNoSQLConnectionDetails(object, stringArray);
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception Occured in [TraceUtils.getMongoHostPortDetails] ", exception);
        }
        return stringArray;
    }

    public static Map getMongoDBDetails(Object object, Object object2, String[] stringArray, String string) {
        Class<?> clazz = object.getClass();
        String string2 = DASH;
        String string3 = DASH;
        String string4 = DASH;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Method method = clazz.getMethod("getFullName", new Class[0]);
            method.setAccessible(true);
            String string5 = (String)method.invoke(object, ARGS);
            int n = string5.indexOf(".");
            if (n > -1) {
                string3 = string5.substring(0, n);
                string4 = string5.substring(n + 1);
            }
            if (object2 != null) {
                Method method2;
                Class<?> clazz2 = object2.getClass();
                String string6 = clazz2.getName();
                if (string6.equals("com.mongodb.BasicDBObject")) {
                    method2 = clazz2.getMethod("toJson", new Class[0]);
                    method2.setAccessible(true);
                    string2 = (String)method2.invoke(object2, ARGS);
                } else if (string6.equals("java.lang.String") || string6.equals("java.util.Arrays$ArrayList")) {
                    method2 = clazz2.getMethod("toString", new Class[0]);
                    method2.setAccessible(true);
                    string2 = (String)method2.invoke(object2, ARGS);
                }
                int n2 = PropsManager.getMaxMongoDbQueryLimit();
                if (string2.length() > n2) {
                    string2 = string2.substring(0, n2 - 3) + "...";
                }
            }
            hashMap.put("mongoServerDetails", stringArray[0]);
            hashMap.put("mongoDBName", string3);
            hashMap.put("mongoTableName", string4);
            hashMap.put("mongoMethodName", string);
            hashMap.put("mongoQuery", string2);
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception Occured in [TraceUtils.getMongoDBDetails] {} ", exception);
            hashMap = null;
        }
        return hashMap;
    }

    public static String ldapNamingEnumerationURL(Object object) {
        Object object2 = null;
        Object object3 = TraceUtils.getField(object.getClass(), "homeCtx", object);
        if (object3 != null) {
            Class<?> clazz = object3.getClass();
            try {
                Method method = clazz.getDeclaredMethod("getURL", new Class[0]);
                method.setAccessible(true);
                object2 = method.invoke(object3, ARGS);
                BTMLog.logger.trace("TraceUtils.ldapNamingEnumerationURL()  ====> {} ", object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object2 == null) {
            object2 = DASH;
        }
        return object2.toString();
    }

    public static Object getField(Class<?> clazz, String string, Object object) {
        Class<?> clazz2 = clazz;
        int n = 0;
        while (n <= 2) {
            try {
                Field field = clazz2.getDeclaredField(string);
                field.setAccessible(true);
                Object object2 = field.get(object);
                return object2;
            }
            catch (Exception exception) {
                ++n;
                clazz2 = clazz2.getSuperclass();
                BTMLog.logger.warn("Warnning field '{}' is not available in current class '{}' looking in super class {}", string, clazz2.getName(), clazz2.getName());
            }
        }
        return null;
    }

    public static String ldapClientURL(Object object) {
        Class<?> clazz = object.getClass();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Field field = clazz.getDeclaredField("conn");
            field.setAccessible(true);
            Object object2 = field.get(object);
            Class<?> clazz2 = object2.getClass();
            Field field2 = clazz2.getDeclaredField("host");
            field2.setAccessible(true);
            Object object3 = field2.get(object2);
            if (object3 != null) {
                Field field3 = clazz2.getDeclaredField("port");
                field3.setAccessible(true);
                Object object4 = field3.get(object2);
                if (object4 != null) {
                    stringBuilder.append(object3).append(":").append(object4);
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception occured while getting LDAP HostName from the ldapClientURL {} ", exception);
        }
        BTMLog.logger.debug("LDAP HostName from the ldapClientURL() : {} ", (Object)stringBuilder);
        return stringBuilder.toString();
    }

    public static String initialLdapContextURL(Object object, RequestIdentifier requestIdentifier) {
        String string = requestIdentifier.getLdapDetails(object);
        if (string != null) {
            BTMLog.logger.debug("LDAP HostName from the initialLdapContextURL() : {}", (Object)string);
            return string;
        }
        Class<?> clazz = null;
        try {
            clazz = object.getClass();
            Method method = clazz.getMethod("getEnvironment", new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, ARGS);
            if (object2 != null) {
                Hashtable hashtable = (Hashtable)object2;
                string = hashtable.get("java.naming.provider.url").toString();
            } else {
                BTMLog.logger.error("LDAP Details provided by getEnvironment is null");
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception Occured in [TraceUtils.initialLdapContextURL] {}", exception);
        }
        if (string == null) {
            string = DASH;
        }
        requestIdentifier.addLdapDetails(object, string);
        BTMLog.logger.debug("LDAP HostName from the initialLdapContextURL() : {}", (Object)string);
        return string;
    }

    public static void getContainerDetails(Object object, Map map) {
        boolean bl = BTMOffLoadConfig.isDiscoveryMode();
        if (bl) {
            if (TraceUtils.getRequestInvokeCount() < PropsManager.getRequestInvokeCount() && object != null) {
                try {
                    Class<?> clazz = object.getClass();
                    Object object2 = TraceUtils.invokeRequestMethod(object, clazz, SERVER_NAME_METHODS[0], DASH);
                    String string = null;
                    if (object2 != null && ((string = object2.toString()).equalsIgnoreCase("localhost") || string.startsWith("127.") || string.equals("0:0:0:0:0:0:0:1"))) {
                        object2 = InetAddress.getLocalHost().getHostAddress();
                    }
                    Object object3 = TraceUtils.invokeRequestMethod(object, clazz, SERVER_NAME_METHODS[3], DASH);
                    Object object4 = TraceUtils.invokeRequestMethod(object, clazz, SERVER_NAME_METHODS[4], DASH);
                    if (serverName == null) {
                        TraceUtils.containerNameDiscovery(null, object);
                    }
                    String string2 = ContainerDiscovery.getDiscoveredDetailsByStartup("CONTAINER_NAME");
                    map.put("CONTAINER_NAME", string2.toString());
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("CONTAINER_REQUESTED_IP", object2.toString());
                    String string3 = ContainerDiscovery.getHostName();
                    hashtable.put("CONTAINER_IP", string3);
                    hashtable.put("CONTAINER_HOST_NAME", string3);
                    hashtable.put("CONTAINER_SCHEME", object4.toString());
                    hashtable.put("CONTAINER_PORT", object3.toString());
                    hashtable.put("CONTAINER_REQUESTED_PORT", object3.toString());
                    hashtable.put("CONTAINER_NAME", string2.toString());
                    hashtable.put("CONTAINER_ID", string2.toString());
                    hashtable.put("CONTAINER_SERVER_NAME", serverName + "");
                    hashtable.put("CONTAINER_SERVER_VERSION_NAME", serverName + "");
                    hashtable.put("DISCOVERED", "DISCOVERED");
                    ContainerDiscovery.getDiscoveredDetailsByRequest().putAll(hashtable);
                    TraceUtils.setRequestInvokeCount();
                    BTMLog.logger.debug("Auto discovery has been completed for request number : {}, rootProps {}", (Object)TraceUtils.getRequestInvokeCount(), (Object)map);
                }
                catch (Exception exception) {
                    BTMLog.logger.error("Exception while getting the Server details using reflection...", exception);
                }
            } else if (object == null) {
                BTMLog.logger.error("Request object is null auto discovery not done for this request...");
            } else {
                BTMLog.logger.error("Auto discovery has been stopped, because request reached max limit : {} ", (Object)PropsManager.getRequestInvokeCount());
                TraceUtils.setDiscoveryDetailsSent(true);
            }
        }
    }

    private static boolean isSystemPropertyKeyAvailable(String string) {
        return System.getProperty(string) != null;
    }

    public static void containerNameDiscovery(Object object, Object object2) {
        block13: {
            try {
                Object object3 = TraceUtils.invokeRequestMethod(object2, object2.getClass(), SERVER_NAME_METHODS[1], null);
                if (object3 != null) {
                    Object object4 = TraceUtils.invokeRequestMethod(object3, object3.getClass(), SERVER_NAME_METHODS[2], null);
                    if (object4 != null) {
                        serverName = object4.toString();
                    }
                    try {
                        String string = ContainerDiscovery.getHostName();
                        BTMLog.logger.debug("Hostname as IP address : {}", (Object)string);
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        hashtable.put("CONTAINER_IP", string);
                        hashtable.put("CONTAINER_HOST_NAME", string);
                        boolean bl = ContainerDiscovery.isThisDockerContainer();
                        boolean bl2 = false;
                        String string2 = (String)ContainerDiscovery.getDiscoveredDetailsByStartup().get("CONTAINER_PORT");
                        if (string2 != null && string2.equalsIgnoreCase("0000")) {
                            String string3;
                            if (AutoDiscovery.isClassNameDiscoveryCompleted() && (string3 = AutoDiscovery.getHttpServerPort()) != null && string3.length() > 0) {
                                hashtable.put("CONTAINER_PORT", string3);
                                bl2 = true;
                            }
                        } else if (string2 == null) {
                            hashtable.put("CONTAINER_PORT", "0000");
                        }
                        if (BTMOffLoadConfig.isContainerStartUpDiscoveryEnabled() && bl) {
                            hashtable.put("DISCOVERED", "DISCOVERED");
                        } else if (BTMOffLoadConfig.isContainerStartUpDiscoveryEnabled() && bl2) {
                            hashtable.put("DISCOVERED", "DISCOVERED");
                        }
                        hashtable.put("CONTAINER_SERVER_NAME", serverName + "");
                        hashtable.put("CONTAINER_SERVER_VERSION_NAME", serverName + "");
                        ContainerDiscovery.getDiscoveredDetailsByStartup().putAll(hashtable);
                    }
                    catch (Exception exception) {
                        BTMLog.logger.error("[Discovery] Exception occurs during container name discovery ", exception);
                    }
                    BTMLog.logger.debug("[Discovery] Found container : {}", (Object)serverName);
                    break block13;
                }
                BTMLog.logger.error("[Discovery] Unable to find container details due to ServletConfig object is null");
            }
            catch (Exception exception) {
                BTMLog.logger.error("[Discovery] Exception occurs during container name discovery ", exception);
            }
        }
    }

    public static void updateSessionID(Object object, MethodInfo methodInfo, String string, String string2) {
        Class<?> clazz = null;
        try {
            clazz = object.getClass();
            Method method = clazz.getMethod("getSession", Boolean.TYPE);
            method.setAccessible(true);
            Object object2 = method.invoke(object, false);
            if (object2 != null) {
                Method method2 = object2.getClass().getMethod("getId", new Class[0]);
                method2.setAccessible(true);
                Object object3 = method2.invoke(object2, ARGS);
                if (object3 != null && methodInfo.getProperties() != null) {
                    methodInfo.getProperties().put("SESSIONID", object3);
                    BTMLog.logger.info("[updateSessionID] is updated : {}  for the GUID : {} URL : {} ", object3, string, string2);
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception in the method updateSessionID {} ", exception);
        }
    }

    public static String updateCPCPattern(Object object, Map map, String string, String string2) {
        Class<?> clazz = null;
        try {
            clazz = object.getClass();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            return string;
        }
        String string3 = null;
        boolean bl = map.containsKey("KEY_TRANSACTION");
        if (bl) {
            if (CustomConfigurationManager.isKeyConfigurationExists()) {
                BTMLog.logger.debug("[UpdateCPCPattern] - Trying to get BTName for the GUID : {}", (Object)string2);
                Map map2 = (Map)TraceUtils.invokeRequestMethod(object, clazz, REQUEST_METHODS[8], null);
                String string4 = (String)map.get("RequestURI");
                String string5 = (String)map.get("QUERYSTRING");
                Hashtable hashtable = (Hashtable)map.get("HEADERS");
                string3 = CustomConfigurationManager.getGroupedURLPattern(string4, string5, map2, hashtable, string);
                BTMLog.logger.info("[UpdateCPCPattern] - for the GUID : {} - {} & Final Key BT is {} ", string2, string, string3);
            }
        } else if (CustomConfigurationManager.isConfigurationExists()) {
            BTMLog.logger.debug("[UpdateCPCPattern] - Trying to get BTName for the GUID : {}", (Object)string2);
            Map map3 = (Map)TraceUtils.invokeRequestMethod(object, clazz, REQUEST_METHODS[8], null);
            String string6 = (String)map.get("RequestURI");
            String string7 = (String)map.get("QUERYSTRING");
            Hashtable hashtable = (Hashtable)map.get("HEADERS");
            string3 = CustomConfigurationManager.getGroupedURLPattern(string6, string7, map3, hashtable);
            BTMLog.logger.info("[UpdateCPCPattern] - for the GUID : {} - {} & Result BT is {} ", string2, string, string3);
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string;
        }
        BTMLog.logger.info("[UpdateCPCPattern] - for the GUID : {} & Decided Pattern is {} ", (Object)string2, (Object)string3);
        return string3;
    }

    public static boolean isDiscoveryDetailsSent() {
        return discoveryDetailsSent;
    }

    private static void setDiscoveryDetailsSent(boolean bl) {
        discoveryDetailsSent = bl;
    }

    private static long getRequestInvokeCount() {
        return requestInvokeCount;
    }

    private static void setRequestInvokeCount() {
        ++requestInvokeCount;
    }

    private static void addUniqueJvmGuidToResponseHeader(Object object) {
        try {
            if (object != null) {
                Class<?> clazz = object.getClass();
                Method method = clazz.getMethod("setHeader", String.class, String.class);
                method.setAccessible(true);
                method.invoke(object, "UNIQUE_JVM_GUID", PropsManager.getJvmGUID());
                BTMLog.logger.info("Successfully added JVM GUID {} into Response Header for TFT", (Object)PropsManager.getJvmGUID());
            } else {
                BTMLog.logger.warn("ServletResponse Object is null. So not adding JVM GUID to Response Header.");
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("Exception while adding JVM GUID into Response Header {} ", exception);
        }
    }

    private static Object getRequestHeaderValue(Object object, String string) {
        Object object2 = null;
        if (string == null || string.equalsIgnoreCase("None")) {
            return object2;
        }
        try {
            Class<?> clazz;
            Method method;
            if (object != null && (method = (clazz = object.getClass()).getMethod("getHeader", String.class)) != null) {
                method.setAccessible(true);
                Object object3 = method.invoke(object, string);
                if (object3 != null) {
                    object2 = object3;
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[TraceUtils - getRequestHeaderValue] Exception while getting request header {} {} ", (Object)string, (Object)exception);
        }
        return object2;
    }

    public static void getAndSetApacheResponseUniqueJvmGuid(Object object, boolean bl, RequestIdentifier requestIdentifier) {
        String string = null;
        string = bl ? "getFirstHeader" : "getResponseHeader";
        if (object != null) {
            try {
                Class<?> clazz = object.getClass();
                Method method = clazz.getMethod(string, String.class);
                method.setAccessible(true);
                Object object2 = method.invoke(object, "UNIQUE_JVM_GUID");
                Class<?> clazz2 = object2.getClass();
                Method method2 = clazz2.getMethod("getValue", new Class[0]);
                method2.setAccessible(true);
                String string2 = (String)method2.invoke(object2, ARGS);
                requestIdentifier.setResponseUniqueJvmGuid(string2);
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception while fetching JVM GUID from Apache HTTP client : {} ", exception);
            }
        }
    }

    private static void getAndSetResponseUniqueJvmGuid(HttpURLConnection httpURLConnection, RequestIdentifier requestIdentifier, String string) {
        try {
            if (requestIdentifier.isResponseJVMGuidCollected()) {
                return;
            }
            Object object = TraceUtils.getField(httpURLConnection.getClass(), "responses", httpURLConnection);
            Method method = object.getClass().getMethod("findValue", String.class);
            method.setAccessible(true);
            Object object2 = method.invoke(object, "UNIQUE_JVM_GUID");
            if (object2 == null) {
                object2 = string;
            }
            String string2 = object2.toString();
            requestIdentifier.setResponseUniqueJvmGuid(string2);
            requestIdentifier.updateHTTPResponseJVMGuidDetails(string2);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception while fetching JVM GUID from HTTP UrlConnection Object : {} ", exception);
        }
    }

    public static final void setMeasureValue(ArrayList arrayList, String string, String string2, RequestIdentifier requestIdentifier) {
        try {
            Measure measure = MeasureUtil.getMethodArgMeasureByKey(string2, string);
            if (measure != null) {
                int n = measure.getFieldType();
                boolean bl = requestIdentifier.capturedIcUsernameValue();
                boolean bl2 = requestIdentifier.capturedIcBusinessContextValue();
                boolean bl3 = true;
                if (bl && n == 1) {
                    bl3 = false;
                } else if (bl2 && n == 2) {
                    bl3 = false;
                }
                if (bl3) {
                    String string3;
                    ArrayList arrayList2;
                    String string4 = requestIdentifier.getRootMinfo().getRawURL();
                    boolean bl4 = MeasureUtil.isPatternMatched(string4 = MeasureUtil.getRequestUriOnly(string4), arrayList2 = measure.getUrlPatterns());
                    if (bl4 && (string3 = String.valueOf(arrayList.get(0))) != null) {
                        boolean bl5 = measure.isUserNameField();
                        if (bl5) {
                            requestIdentifier.setIcUsername(string3);
                        } else {
                            requestIdentifier.setIcBusinessContext(string3);
                        }
                        BTMLog.logger.debug("[IC_For_APM] Measured value set successfully; [Measure id = {}] ; Value = {} ", (Object)measure.getId(), (Object)string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[IC_For_APM] Exception occured while setting Method Argument Measure values... {} ", exception);
        }
    }

    private static String getRandomString() {
        String string = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        while (stringBuilder.length() < 5) {
            int n = (int)(random.nextFloat() * (float)string.length());
            stringBuilder.append(string.charAt(n));
        }
        return stringBuilder.toString();
    }

    private static String getUTC(Date date) {
        try {
            String string = UTC_DATE_FORMATTER.format(date);
            BTMLog.logger.debug("UTC Date for the Request Time - {} is {} ", (Object)date, (Object)string);
            return string;
        }
        catch (Exception exception) {
            BTMLog.logger.warn("Exception during converting UTC Date from {} {} ", (Object)date, (Object)exception);
            long l = System.currentTimeMillis();
            Date date2 = new Date(l);
            String string = UTC_DATE_FORMATTER.format(date2);
            BTMLog.logger.debug("UTC Date for the Request Time - {} is {} ", (Object)date2, (Object)string);
            return string;
        }
    }

    public static void autoRumInjectionBegin(Object object, String string, String string2) {
        RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
        try {
            if (requestIdentifier != null && requestIdentifier.getAutoRumFirstServlet() == null) {
                String string3 = string + "_" + string2;
                BTMLog.logger.debug("[AUTO-RUM] [injectMethodBegin] Identifying the  FirstServlet to inject RUMScript : {} ", (Object)string3);
                requestIdentifier.setAutoRumFirstServlet(string3, object);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[AUTO-RUM] [injectMethodBegin] Unable to identify the FirstServlet to inject RUMScript due to ", exception);
        }
    }

    public static void autoRumInjectionEnd(RequestIdentifier requestIdentifier, Object object, Object object2, String string, String string2, String string3, String string4, int n) {
        String string5;
        if (string.length() > 0 && RumPropsManager.isRumEnabled() && n != 191 && (RumPropsManager.isRumIncludedUrl(string5 = (String)requestIdentifier.getRootMinfo().getProperties().get("RequestURI")) || !RumPropsManager.isRumExcludedUrl(string5))) {
            TraceUtils.autoInstrumentationEnd(object, object2, string2, string3, string4, string, requestIdentifier);
        }
    }

    private static boolean autoInstrumentationEnd(Object object, Object object2, String string, String string2, String string3, String string4, RequestIdentifier requestIdentifier) {
        BTMLog.logger.debug("[AUTO-RUM][autoInstrumentationEnd] CLASS_NAME : {} \t METHOD_NAME : {} \t DESC: {} ", string, string2, string3);
        try {
            String string5 = string + "_" + string4;
            String string6 = requestIdentifier.getAutoRumFirstServlet();
            BTMLog.logger.debug("[AUTO-RUM][autoInstrumentationEnd] THIS_Servlet : {}  FIRST_Servlet : {} ", (Object)string5, (Object)string6);
            if (!string5.equals(string6)) {
                BTMLog.logger.debug("[AUTO-RUM] [autoInstrumentationEnd]  RETURN : This is not the First Servlet.");
                return false;
            }
            requestIdentifier.setInjectRumScript(true);
            MethodEventProcessor.doRUMInjection(requestIdentifier, false);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[AUTO-RUM][autoInstrumentationEnd]Exception occured {}", (Object)exception.getMessage());
            BTMLog.logger.trace("Exception : {} ", exception);
        }
        return true;
    }

    private static Field[] getRequiredFields(Object object, Object object2) {
        Field[] fieldArray;
        Field field = null;
        Field field2 = null;
        String string = "typeHandlerRegistry";
        String string2 = "configuration";
        try {
            fieldArray = object.getClass();
            try {
                field = fieldArray.getDeclaredField(string);
                if (field != null) {
                    field2 = fieldArray.getDeclaredField(string2);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    Class<?> clazz = object.getClass().getSuperclass();
                    String string3 = clazz.getName();
                    if (clazz != null) {
                        field = clazz.getDeclaredField(string);
                        field2 = clazz.getDeclaredField(string2);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                    BTMLog.logger.warn("[getRequiredFields] - Fields {} or {} are not found in the super class {} ", string, string2, noSuchFieldException2);
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[getRequiredFields] - Field {} not found {} ", (Object)string, (Object)exception);
        }
        fieldArray = new Field[]{field, field2};
        return fieldArray;
    }

    private static boolean isTypeHandlerRegistryContains(Field field, Object object, Object object2) {
        boolean bl = false;
        if (field != null) {
            try {
                field.setAccessible(true);
                Object object3 = field.get(object);
                Class[] classArray = new Class[]{Class.class};
                Object[] objectArray = new Object[]{object2.getClass()};
                Boolean bl2 = (Boolean)TraceUtils.getInvokedObject(object3, object3.getClass(), "hasTypeHandler", classArray, objectArray);
                if (bl2 != null) {
                    bl = bl2;
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("[isTypeHandlerRegistryContains] - Exception due to {} ", exception);
            }
        }
        return bl;
    }

    private static Object getMetaObject(Field field, Object object, Object object2) {
        Object object3 = null;
        try {
            if (field != null) {
                field.setAccessible(true);
                Object object4 = field.get(object);
                BTMLog.logger.debug("[getMetaObject] - configurationObject {} ", object4);
                if (object2 != null) {
                    Class[] classArray = new Class[]{Object.class};
                    Object[] objectArray = new Object[]{object2};
                    object3 = TraceUtils.getInvokedObject(object4, object4.getClass(), "newMetaObject", classArray, objectArray);
                    BTMLog.logger.debug("[getMetaObject] - metaObject {} ", object3);
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[getMetaObject] - Exception due to {} ", exception);
        }
        return object3;
    }

    private static void getBindValues(List list, Object object, Object object2, boolean bl, Object object3) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            BTMLog.logger.debug("[getBindValues] - parameterMappingObj : {} - {}", (Object)i, e);
            Class<?> clazz = null;
            try {
                clazz = e.getClass();
                Object object4 = TraceUtils.getInvokedObject(e, clazz, "getMode");
                if (object4 == null || !object4.toString().startsWith("IN")) continue;
                String string = (String)TraceUtils.getInvokedObject(e, clazz, "getProperty");
                BTMLog.logger.debug("[getBindValues] - propertyName is {}", (Object)string);
                Class<?> clazz2 = object2.getClass();
                Class[] classArray = new Class[]{String.class};
                Object[] objectArray = new Object[]{string};
                Boolean bl2 = (Boolean)TraceUtils.getInvokedObject(object2, clazz2, "hasAdditionalParameter", classArray, objectArray);
                BTMLog.logger.debug("[getBindValues] - hasAdditionalParameter result {} - resultObj.booleanValue() {} ", (Object)bl2, (Object)bl2);
                Object object5 = null;
                if (bl2 != null && bl2.booleanValue()) {
                    object5 = TraceUtils.getInvokedObject(object2, clazz2, "getAdditionalParameter", classArray, objectArray);
                } else if (object == null) {
                    object5 = null;
                } else if (bl) {
                    object5 = object;
                } else if (object3 != null) {
                    object5 = TraceUtils.getInvokedObject(object3, object3.getClass(), "getValue", classArray, objectArray);
                }
                BTMLog.logger.info("[getBindValues] - [{}]:{} - {}", i, string, object5);
                continue;
            }
            catch (Exception exception) {
                BTMLog.logger.warn("[getBindValues] - Excecption due to {} ", exception);
            }
        }
    }

    public static String getSQL(Object object) {
        String string = null;
        if (object != null) {
            try {
                Class<?> clazz = object.getClass();
                Object object2 = TraceUtils.getInvokedObject(object, clazz, "getBoundSql");
                if (object2 != null) {
                    clazz = object2.getClass();
                    string = (String)TraceUtils.getInvokedObject(object2, clazz, "getSql");
                    BTMLog.logger.info("[MyBatis - getSql] - QUERY {} ", (Object)string);
                    List list = (List)TraceUtils.getInvokedObject(object2, clazz, "getParameterMappings");
                    BTMLog.logger.debug("[MyBatis - getParameterMappings] - mappingList {} ", (Object)list);
                    if (list == null || list.isEmpty()) {
                        BTMLog.logger.debug("[MyBatis - getParameterMappings] is null or empty");
                    } else {
                        Object object3 = TraceUtils.getInvokedObject(object2, clazz, "getParameterObject");
                        BTMLog.logger.debug("[MyBatis - getParameterObject] - parameterObject {} & Class is {}", object3, (Object)object3.getClass());
                        Field[] fieldArray = TraceUtils.getRequiredFields(object, object3);
                        if (fieldArray != null && fieldArray.length == 2 && object3 != null) {
                            boolean bl = TraceUtils.isTypeHandlerRegistryContains(fieldArray[0], object, object3);
                            Object object4 = TraceUtils.getMetaObject(fieldArray[1], object, object3);
                            TraceUtils.getBindValues(list, object3, object2, bl, object4);
                        }
                    }
                } else {
                    BTMLog.logger.info("[MyBatis] - boundSqlObj is NULL");
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("[MyBatis] - Exception while getting Query Object {}", exception);
            }
        }
        if (string == null) {
            string = DASH;
        }
        return string;
    }

    private static Object getInvokedObject(Object object, Class<?> clazz, String string) {
        Object object2 = null;
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            method.setAccessible(true);
            object2 = method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[getInvokedObject] - Exception when invoking {} on the {} due to {} ", string, object, exception);
        }
        return object2;
    }

    private static Object getInvokedObject(Object object, Class<?> clazz, String string, Class<?>[] classArray, Object[] objectArray) {
        Object object2 = null;
        try {
            Method method = clazz.getMethod(string, classArray);
            method.setAccessible(true);
            object2 = method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[getInvokedObject] - Exception when invoking {} on the {} due to {} ", string, object, exception);
        }
        return object2;
    }

    static {
        UTC_DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
        ARGS = new Object[0];
        serverName = null;
        discoveryDetailsSent = false;
        requestInvokeCount = 0L;
        REQUEST_METHODS = new String[]{"getRequestURI", "getRemoteAddr", "getQueryString", "getRequestedSessionId", "getContextPath", "getMethod", "getServletContext", "getAttribute", "getParameterMap", "getContentType"};
        APACHE_CXF_REQUEST_METHODS = new String[]{"getName", "getConduitSelector", "getEndpoint", "getEndpointInfo", "getAddress", "getService"};
        SERVER_NAME_METHODS = new String[]{"getServerName", "getServletContext", "getServerInfo", "getServerPort", "getScheme"};
    }
}

